/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.performance.reading;

import java.util.List;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.testing.framework.PerformanceComparisonTestCase;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.models.performance.toplink.Employee;

public class ReadObjectCachevsDatabaseTest
extends PerformanceComparisonTestCase {
    protected List allObjects;
    protected Employee employee;
    protected ReadObjectQuery idQuery;
    protected ReadObjectQuery cacheOnlyNameQuery;
    protected ReadObjectQuery cacheDatabaseNameQuery;

    public ReadObjectCachevsDatabaseTest() {
        this.setDescription("This test compares the performance of cache hits and the various in-memory querying options.");
        this.addCachedReadObjectTest();
        this.addInMemoryReadObjectTest();
        this.addCacheThenDatabaseMissReadObjectTest();
    }

    public void setup() {
        Expression expression = new ExpressionBuilder().get("firstName").equal((Object)"Bob");
        this.employee = (Employee)this.getSession().readObject(Employee.class, expression);
        this.allObjects = this.getSession().readAllObjects(Employee.class);
        this.idQuery = new ReadObjectQuery(Employee.class);
        ExpressionBuilder builder = new ExpressionBuilder();
        this.idQuery.setSelectionCriteria(builder.get("id").equal(this.employee.getId()));
        this.cacheOnlyNameQuery = new ReadObjectQuery(Employee.class);
        builder = new ExpressionBuilder();
        this.cacheOnlyNameQuery.setSelectionCriteria(builder.get("firstName").equal((Object)this.employee.getFirstName()).and(builder.get("lastName").equal((Object)this.employee.getLastName())));
        this.cacheOnlyNameQuery.checkCacheOnly();
        this.cacheDatabaseNameQuery = new ReadObjectQuery(Employee.class);
        builder = new ExpressionBuilder();
        this.cacheDatabaseNameQuery.setSelectionCriteria(builder.get("firstName").equal((Object)this.employee.getFirstName()).and(builder.get("lastName").equal((Object)this.employee.getLastName())));
        this.cacheDatabaseNameQuery.checkCacheThenDatabase();
    }

    public void test() throws Exception {
        this.getSession().getIdentityMapAccessor().removeFromIdentityMap((Object)this.employee);
        this.getSession().executeQuery((DatabaseQuery)this.idQuery);
    }

    public void addCachedReadObjectTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                this.getSession().executeQuery((DatabaseQuery)ReadObjectCachevsDatabaseTest.this.idQuery);
            }
        };
        test.setName("CachedReadObjectTest");
        test.setAllowableDecrease(10000.0);
        this.addTest((TestCase)test);
    }

    public void addInMemoryReadObjectTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                this.getSession().executeQuery((DatabaseQuery)ReadObjectCachevsDatabaseTest.this.cacheOnlyNameQuery);
            }
        };
        test.setName("InMemoryReadObjectTest");
        test.setAllowableDecrease(1000.0);
        this.addTest((TestCase)test);
    }

    public void addCacheThenDatabaseMissReadObjectTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                this.getSession().getIdentityMapAccessor().removeFromIdentityMap((Object)ReadObjectCachevsDatabaseTest.this.employee);
                this.getSession().executeQuery((DatabaseQuery)ReadObjectCachevsDatabaseTest.this.cacheDatabaseNameQuery);
            }
        };
        test.setName("CacheThenDatabaseMissReadObjectTest");
        test.setAllowableDecrease(-40.0);
        this.addTest((TestCase)test);
    }
}

