/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.performance.writing;

import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.PerformanceComparisonTestCase;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.models.performance.Address;

public class InsertBatchUnitOfWorkComparisonTest
extends PerformanceComparisonTestCase {
    public InsertBatchUnitOfWorkComparisonTest() {
        this.setTestRunTime(50000L);
        this.setDescription("Compares the various writing modes for insertion of 10 addresses.");
        this.addParameterizedSQLTest();
        this.addBatchWritingTest();
        this.addParameterizedBatchWritingTest();
        this.addNativeBatchWritingTest();
        this.addBufferedBatchWritingTest();
        this.addParameterizedStatementsTest();
        this.addDynamicStatementsTest();
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        for (int index = 0; index < 10; ++index) {
            Address address = new Address();
            address.setCity("NewCity");
            address.setPostalCode("N5J2N5");
            address.setProvince("ON");
            address.setStreet("1111 Mountain Blvd. Floor 13, suite " + index);
            address.setCountry("Canada");
            uow.registerObject((Object)address);
        }
        uow.commit();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        uow = this.getSession().acquireUnitOfWork();
        uow.executeNonSelectingCall((Call)new SQLCall("Delete from ADDRESS where CITY = 'NewCity'"));
        uow.commit();
    }

    public void addParameterizedSQLTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                this.getSession().getLogin().cacheAllStatements();
                InsertBatchUnitOfWorkComparisonTest.this.test();
                this.getSession().getLogin().dontCacheAllStatements();
            }
        };
        test.setName("ParameterizedSQLInsertBatchTest");
        test.setAllowableDecrease(10.0);
        this.addTest((TestCase)test);
    }

    public void addParameterizedBatchWritingTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                this.getSession().getLogin().cacheAllStatements();
                this.getSession().getLogin().useBatchWriting();
                InsertBatchUnitOfWorkComparisonTest.this.test();
                this.getSession().getLogin().dontCacheAllStatements();
                this.getSession().getLogin().dontUseBatchWriting();
            }
        };
        test.setName("ParameterizedBatchWritingInsertBatchTest");
        test.setAllowableDecrease(25.0);
        this.addTest((TestCase)test);
    }

    public void addNativeBatchWritingTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                this.getSession().getLogin().cacheAllStatements();
                this.getSession().getLogin().useBatchWriting();
                this.getSession().getLogin().getPlatform().setUsesNativeBatchWriting(true);
                InsertBatchUnitOfWorkComparisonTest.this.test();
                this.getSession().getLogin().getPlatform().setUsesNativeBatchWriting(false);
                this.getSession().getLogin().dontCacheAllStatements();
                this.getSession().getLogin().dontUseBatchWriting();
            }

            public void startTest() {
                ((DatabaseAccessor)((AbstractSession)this.getSession()).getAccessor()).clearStatementCache((AbstractSession)this.getSession());
            }

            public void endTest() {
                ((DatabaseAccessor)((AbstractSession)this.getSession()).getAccessor()).clearStatementCache((AbstractSession)this.getSession());
            }
        };
        test.setName("NativeBatchWritingInsertBatchTest");
        test.setAllowableDecrease(25.0);
        this.addTest((TestCase)test);
    }

    public void addBatchWritingTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                this.getSession().getLogin().useBatchWriting();
                this.getSession().getLogin().dontBindAllParameters();
                InsertBatchUnitOfWorkComparisonTest.this.test();
                this.getSession().getLogin().dontUseBatchWriting();
                this.getSession().getLogin().bindAllParameters();
            }
        };
        test.setName("BatchWritingInsertBatchTest");
        test.setAllowableDecrease(-300.0);
        this.addTest((TestCase)test);
    }

    public void addBufferedBatchWritingTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                this.getSession().getLogin().useBatchWriting();
                this.getSession().getLogin().dontUseJDBCBatchWriting();
                this.getSession().getLogin().dontBindAllParameters();
                InsertBatchUnitOfWorkComparisonTest.this.test();
                this.getSession().getLogin().dontUseBatchWriting();
                this.getSession().getLogin().useJDBCBatchWriting();
                this.getSession().getLogin().bindAllParameters();
            }
        };
        test.setName("BufferedBatchWritingInsertBatchTest");
        test.setAllowableDecrease(-300.0);
        this.addTest((TestCase)test);
    }

    public void addParameterizedStatementsTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                DatabaseAccessor.shouldUseDynamicStatements = false;
                this.getSession().getLogin().dontBindAllParameters();
                InsertBatchUnitOfWorkComparisonTest.this.test();
                DatabaseAccessor.shouldUseDynamicStatements = true;
                this.getSession().getLogin().bindAllParameters();
            }
        };
        test.setName("ParameterizedStatementsInsertBatchTest");
        test.setAllowableDecrease(-300.0);
        this.addTest((TestCase)test);
    }

    public void addDynamicStatementsTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                this.getSession().getLogin().dontBindAllParameters();
                InsertBatchUnitOfWorkComparisonTest.this.test();
                this.getSession().getLogin().bindAllParameters();
            }
        };
        test.setName("DynamicStatementsInsertBatchTest");
        test.setAllowableDecrease(-300.0);
        this.addTest((TestCase)test);
    }
}

