/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.performance.writing;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.models.performance.toplink.Employee;
import org.eclipse.persistence.testing.tests.performance.PerformanceTest;

public class UpdateEmployeeUnitOfWorkTest
extends PerformanceTest {
    protected Employee employee;
    protected boolean incrementSalary;

    public UpdateEmployeeUnitOfWorkTest() {
        this.setDescription("This tests the performance of unit of work updates.");
    }

    @Override
    public void setup() {
        super.setup();
        Expression expression = new ExpressionBuilder().get("firstName").equal((Object)"Bob");
        this.employee = (Employee)this.getSession().readObject(Employee.class, expression);
    }

    @Override
    public void test() throws Exception {
        super.test();
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Employee employee = (Employee)uow.readObject((Object)this.employee);
        if (this.incrementSalary) {
            employee.setSalary(employee.getSalary() + 100);
        } else {
            employee.setSalary(employee.getSalary() - 100);
        }
        uow.commit();
    }
}

