/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.optimization;

import org.eclipse.persistence.annotations.BatchFetchType;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.collections.Restaurant;

public class BatchReadingBatchReadExpressionTest
extends TestCase {
    public ReadAllQuery query;
    BatchFetchType batchType;

    public BatchReadingBatchReadExpressionTest(BatchFetchType batchType) {
        this.batchType = batchType;
        this.setName(this.getName() + batchType);
    }

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    public void test() {
        this.query = new ReadAllQuery();
        this.query.setReferenceClass(Restaurant.class);
        this.query.setBatchFetchType(this.batchType);
        ExpressionBuilder restaurant = new ExpressionBuilder();
        Expression batchExpression = restaurant.get("menus").get("owner");
        this.query.addBatchReadAttribute(batchExpression);
        for (int i = 0; i < 3; ++i) {
            this.getSession().executeQuery((DatabaseQuery)this.query);
            this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        }
    }

    public void verify() {
        ForeignReferenceMapping batchMapping = (ForeignReferenceMapping)this.getSession().getDescriptor(Restaurant.class).getMappingForAttributeName("menus");
        ReadAllQuery selectionQuery = (ReadAllQuery)batchMapping.getSelectionQuery();
        if (selectionQuery.getBatchReadAttributeExpressions().size() > 1) {
            throw new TestErrorException("Batch read attribute expressions are leaking memory by increasing the size of the batch read expressions vector each time the query is executed.");
        }
    }
}

