/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.oracle;

import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.mapping.Employee;

public class ChangedHintStringTest
extends TestCase {
    static String FIRST_HINT_STRING = "/*+ ALL_ROWS */";
    static String SECOND_HINT_STRING = "/*+ FIRST_ROWS */";
    DatabaseQuery query;

    public ChangedHintStringTest() {
        this.setName("ChangedHintStringTest");
        this.setDescription("Tests setting a hint, executing, setting a different hint and executing again");
    }

    public void setup() {
        if (!this.getSession().getPlatform().isOracle()) {
            throw new TestWarningException("This test case is only intended for Oracle");
        }
        this.query = new ReadAllQuery(Employee.class);
    }

    public void reset() {
    }

    public void test() {
        for (int i = 1; i < 3; ++i) {
            if (i % 2 != 0) {
                this.query.setHintString(FIRST_HINT_STRING);
            } else {
                this.query.setHintString(SECOND_HINT_STRING);
            }
            this.getSession().executeQuery(this.query);
        }
    }

    public void verify() {
        String sqlString = this.query.getSQLString();
        if (sqlString.indexOf(SECOND_HINT_STRING) == -1) {
            throw new TestErrorException("Wrong or no hint string in SQL");
        }
    }
}

