/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.readonly;

import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.aggregate.AddressDescription;
import org.eclipse.persistence.testing.models.aggregate.Employee;
import org.eclipse.persistence.testing.models.aggregate.PeriodDescription;
import org.eclipse.persistence.testing.models.aggregate.ProjectDescription;

public class ReadOnlyClassAggregateTestCase
extends TestCase {
    Employee employee;

    public void reset() {
        this.getSession().getProject().setDefaultReadOnlyClasses(new Vector());
        this.rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    protected void setup() {
        this.beginTransaction();
        this.employee = new Employee();
        this.employee.setFirstName("Marc");
        this.employee.setLastName("Fullard");
        this.employee.setProjectDescription(ProjectDescription.example1(this.employee));
        this.employee.setAddressDescription(AddressDescription.example4());
    }

    protected void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        uow.removeAllReadOnlyClasses();
        uow.addReadOnlyClass(PeriodDescription.class);
        Employee empClone = (Employee)uow.registerObject((Object)this.employee);
        uow.commit();
    }

    protected void verify() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        ExpressionBuilder expBuilder = new ExpressionBuilder();
        Expression exp = expBuilder.get("firstName").equal((Object)this.employee.getFirstName()).and(expBuilder.get("lastName").equal((Object)this.employee.getLastName()));
        Employee dbEmployee = (Employee)this.getSession().readObject(Employee.class, exp);
        if (dbEmployee.getAddressDescription().getPeriodDescription() != null) {
            throw new TestErrorException("The insert of a non-read-only object with read-only aggregate objects failed.!");
        }
    }
}

