/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.remote;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.testing.tests.remote.Master;
import org.eclipse.persistence.testing.tests.remote.Slave;

public class MasterSlaveProject
extends Project {
    public MasterSlaveProject() {
        this.setName("MasterSlave");
        this.applyLogin();
        this.addDescriptor((ClassDescriptor)this.buildMasterDescriptor());
        this.addDescriptor((ClassDescriptor)this.buildSlaveDescriptor());
    }

    public void applyLogin() {
        DatabaseLogin login = new DatabaseLogin();
        this.setLogin(login);
    }

    public RelationalDescriptor buildMasterDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Master.class);
        descriptor.addTableName("MASTER");
        descriptor.addPrimaryKeyFieldName("MASTER.id");
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.useRemoteSoftCacheWeakIdentityMap();
        descriptor.setRemoteIdentityMapSize(100);
        descriptor.getQueryManager().checkDatabaseForDoesExist();
        DirectToFieldMapping primaryKeyMapping = new DirectToFieldMapping();
        primaryKeyMapping.setAttributeName("primaryKey");
        primaryKeyMapping.setFieldName("MASTER.id");
        descriptor.addMapping((DatabaseMapping)primaryKeyMapping);
        OneToManyMapping slavesMapping = new OneToManyMapping();
        slavesMapping.setAttributeName("slaves");
        slavesMapping.setReferenceClass(Slave.class);
        slavesMapping.useBasicIndirection();
        slavesMapping.addTargetForeignKeyFieldName("SLAVE.mid", "MASTER.id");
        descriptor.addMapping((DatabaseMapping)slavesMapping);
        return descriptor;
    }

    public RelationalDescriptor buildSlaveDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Slave.class);
        descriptor.addTableName("SLAVE");
        descriptor.addPrimaryKeyFieldName("SLAVE.id");
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.useRemoteSoftCacheWeakIdentityMap();
        descriptor.setRemoteIdentityMapSize(100);
        descriptor.getQueryManager().checkDatabaseForDoesExist();
        DirectToFieldMapping MyPrimaryKeyMapping = new DirectToFieldMapping();
        MyPrimaryKeyMapping.setAttributeName("primaryKey");
        MyPrimaryKeyMapping.setFieldName("SLAVE.id");
        descriptor.addMapping((DatabaseMapping)MyPrimaryKeyMapping);
        OneToOneMapping masterMapping = new OneToOneMapping();
        masterMapping.setAttributeName("master");
        masterMapping.setReferenceClass(Master.class);
        masterMapping.dontUseIndirection();
        masterMapping.addForeignKeyFieldName("SLAVE.mid", "MASTER.id");
        descriptor.addMapping((DatabaseMapping)masterMapping);
        return descriptor;
    }
}

