/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.remote;

import java.util.Vector;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.sessions.server.ClientSession;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.remote.RemoteModel;

public class PredefinedQueryFromRemoteSessionTest
extends TestCase {
    public static final String QUERY_NAME = "ServerSessionQuery23679";
    public static final String TEST_NAME = "PredefinedQueryFromRemoteSessionTest";
    protected static ServerSession serverSession;
    protected Vector employees;
    protected static Exception storedException;

    public PredefinedQueryFromRemoteSessionTest() {
        this.setDescription("Tests that named queries defined in ServerSession work in RemoteSession.");
    }

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        serverSession.removeQuery(QUERY_NAME);
    }

    protected void setup() {
        serverSession = ((ClientSession)RemoteModel.getServerSession()).getParent();
    }

    protected void test() {
        Vector employees = new Vector();
        storedException = null;
        ReadAllQuery raq = new ReadAllQuery(Employee.class);
        raq.addAscendingOrdering("firstName");
        serverSession.addQuery(QUERY_NAME, (DatabaseQuery)raq);
        try {
            employees = (Vector)this.getSession().executeQuery(QUERY_NAME);
        }
        catch (Exception e) {
            PredefinedQueryFromRemoteSessionTest.setStoredException((Exception)((Object)new TestErrorException("Error reading vector of Employees in test:PredefinedQueryFromRemoteSessionTest")));
            return;
        }
        if (employees.size() <= 0) {
            PredefinedQueryFromRemoteSessionTest.setStoredException((Exception)((Object)new TestErrorException("No Employees returned in test:PredefinedQueryFromRemoteSessionTest")));
            return;
        }
    }

    protected void verify() throws Exception {
        if (storedException != null) {
            throw storedException;
        }
    }

    protected static void setStoredException(Exception e) {
        if (storedException == null) {
            storedException = e;
        }
    }
}

