/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.security;

import java.lang.reflect.Field;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.exceptions.IntegrityChecker;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.tests.security.TestSecurityManager;
import org.eclipse.persistence.testing.tests.validation.ExceptionTest;

public class ExceptionTestSaveSecurityManager
extends ExceptionTest {
    private SecurityManager orgSecurityManager;
    private IntegrityChecker orgIntegrityChecker;
    private boolean orgDefaultUseDoPrivilegedValue;
    private Class cls;
    private RelationalDescriptor descriptor;

    public ExceptionTestSaveSecurityManager() {
    }

    public ExceptionTestSaveSecurityManager(String description, Class cls) {
        if (cls != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(super.getName());
            sb.append("(");
            sb.append(cls.getSimpleName());
            sb.append(")");
            this.setName(sb.toString());
        }
        this.setDescription(description);
        this.cls = cls;
    }

    protected Class getTestClass() {
        return this.cls;
    }

    protected RelationalDescriptor getTestDescriptor() {
        return this.descriptor;
    }

    protected void setup() {
        this.orgIntegrityChecker = this.getSession().getIntegrityChecker();
        this.getSession().setIntegrityChecker(new IntegrityChecker());
        this.getSession().getIntegrityChecker().dontCatchExceptions();
        this.orgSecurityManager = System.getSecurityManager();
        System.setSecurityManager(new TestSecurityManager());
        this.orgDefaultUseDoPrivilegedValue = this.getOrgDefaultUseDoPrivilegedValue();
        PrivilegedAccessHelper.setDefaultUseDoPrivilegedValue((boolean)true);
        this.descriptor = new RelationalDescriptor();
        this.descriptor.setJavaClass(this.getTestClass());
    }

    @Override
    public void reset() {
        this.getSession().setIntegrityChecker(this.orgIntegrityChecker);
        System.setSecurityManager(this.orgSecurityManager);
        PrivilegedAccessHelper.setDefaultUseDoPrivilegedValue((boolean)this.orgDefaultUseDoPrivilegedValue);
    }

    private boolean getOrgDefaultUseDoPrivilegedValue() {
        Field def = null;
        try {
            def = PrivilegedAccessHelper.getDeclaredField(PrivilegedAccessHelper.class, (String)"defaultUseDoPrivilegedValue", (boolean)true);
            boolean bl = (Boolean)def.get(null);
            return bl;
        }
        catch (Exception e) {
            throw new TestErrorException(e.getMessage());
        }
        finally {
            if (def != null) {
                def.setAccessible(false);
            }
        }
    }
}

