/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.sessioncache;

import org.eclipse.persistence.internal.identitymaps.IdentityMap;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class WriteNewObjectTest
extends TestCase {
    public WriteNewObjectTest() {
        this.setDescription("The test ensures that new objects are put in the session cache");
    }

    protected void setup() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.getAbstractSession().beginTransaction();
    }

    protected void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Employee empInsert = new Employee();
        empInsert.setFirstName("TestPerson");
        empInsert.setFemale();
        empInsert.setLastName("Smith");
        empInsert.setSalary(55555);
        uow.registerObject((Object)empInsert);
        uow.commit();
    }

    protected void verify() {
        IdentityMap im = ((AbstractSession)this.getSession()).getIdentityMapAccessorInstance().getIdentityMap(Employee.class);
        if (im == null || im.getSize() != 1) {
            throw new TestErrorException("Employee should have been put into session cache.");
        }
    }

    public void reset() throws Exception {
        this.getAbstractSession().rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }
}

