/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.tests.unitofwork.Weather;

public class RefreshObjectNoIdentityMapUnitOfWorkTest
extends AutoVerifyTestCase {
    public UnitOfWork uow;
    public Weather objectToBeWritten;
    public Weather uowObject;
    public Weather sessionObject;

    public void setup() {
        this.uow = this.getSession().acquireUnitOfWork();
        this.objectToBeWritten = (Weather)this.getSession().readObject(Weather.class);
        this.uowObject = (Weather)this.uow.registerObject((Object)this.objectToBeWritten);
        this.uowObject.setStormPattern(this.uowObject.getStormPattern() + " and windy");
    }

    public void test() {
        try {
            this.uowObject = (Weather)this.uow.refreshObject((Object)this.uowObject);
            this.uow.commit();
        }
        catch (Exception exp) {
            throw new TestErrorException("An exception was thrown on commit.  Exception is :\n" + exp.toString());
        }
        this.sessionObject = (Weather)this.getSession().refreshObject((Object)this.objectToBeWritten);
    }

    public void verify() {
        if (!this.objectToBeWritten.getStormPattern().equals(this.uowObject.getStormPattern())) {
            throw new TestWarningException("Object refreshed through UnitOfWork returned nulls as its attribute values. Will be fixed in a later release.\n");
        }
        if (!this.objectToBeWritten.getStormPattern().equals(this.sessionObject.getStormPattern())) {
            throw new TestWarningException("Object refreshed through Session returned nulls as its attribute values. Test failed.\n");
        }
        this.uow.release();
    }
}

