/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import java.util.Vector;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.WriteObjectTest;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.EmployeePopulator;
import org.eclipse.persistence.testing.models.employee.domain.LargeProject;
import org.eclipse.persistence.testing.models.employee.domain.Project;
import org.eclipse.persistence.testing.models.employee.domain.SmallProject;

public class UnitOfWorkRevertTest
extends WriteObjectTest {
    public Employee unitOfWorkWorkingCopy;
    public UnitOfWork unitOfWork;

    public UnitOfWorkRevertTest(Employee originalObject) {
        super((Object)originalObject);
    }

    protected void changeInFirstUnitOfWork() {
        this.unitOfWorkWorkingCopy.setProjects(new Vector());
        this.unitOfWorkWorkingCopy.addProject((Project)this.unitOfWork.readObject(SmallProject.class));
        this.unitOfWorkWorkingCopy.addProject((Project)this.unitOfWork.readObject(LargeProject.class));
        this.unitOfWorkWorkingCopy.setResponsibilitiesList(new Vector());
        this.unitOfWorkWorkingCopy.addResponsibility("does not make cafee");
        this.unitOfWorkWorkingCopy.addResponsibility("does not buy donuts");
        this.unitOfWorkWorkingCopy.setAddress(new EmployeePopulator().addressExample10());
        this.unitOfWorkWorkingCopy.setManager((Employee)this.unitOfWork.readObject(Employee.class));
    }

    protected void changeInSecondUnitOfWork() {
        this.unitOfWorkWorkingCopy.setProjects(new Vector());
        this.unitOfWorkWorkingCopy.addResponsibility("eat not buy donuts");
        this.unitOfWorkWorkingCopy.setAddress(new EmployeePopulator().addressExample12());
        this.unitOfWorkWorkingCopy.setManager(null);
    }

    protected void setup() {
        super.setup();
        this.unitOfWork = this.getSession().acquireUnitOfWork();
    }

    protected void test() {
        this.unitOfWork.revertAndResume();
        this.unitOfWorkWorkingCopy = (Employee)this.unitOfWork.registerObject(this.objectToBeWritten);
        this.changeInFirstUnitOfWork();
        if (!this.compareObjects(this.originalObject, this.objectToBeWritten)) {
            throw new TestErrorException("The original object was changed through changing the clone.");
        }
        this.unitOfWork.revertAndResume();
        if (!this.compareObjects(this.objectToBeWritten, this.unitOfWorkWorkingCopy)) {
            throw new TestErrorException("The clone does not match the original after the revert.");
        }
        this.changeInSecondUnitOfWork();
        if (!this.getAbstractSession().compareObjectsDontMatch(this.objectToBeWritten, (Object)this.unitOfWorkWorkingCopy)) {
            throw new TestErrorException("The original object was changed through changing the clone.");
        }
        this.unitOfWork.commitAndResume();
        this.unitOfWork.release();
    }
}

