/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.server.ClientSession;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class UnitOfWorkRollbackConnectionReleaseTest
extends AutoVerifyTestCase {
    Accessor accessor;
    UnitOfWork m_uow;
    Employee m_employee;
    ClientSession m_clientSession;
    boolean m_exceptionCaught;

    public void reset() {
        this.m_clientSession.getIdentityMapAccessor().initializeAllIdentityMaps();
        this.m_clientSession.setWriteConnection(this.accessor);
        this.accessor.rollbackTransaction((AbstractSession)this.getSession());
    }

    public void setup() {
        this.m_exceptionCaught = false;
        this.m_clientSession = (ClientSession)this.getSession();
        this.m_clientSession.getIdentityMapAccessor().initializeAllIdentityMaps();
        this.m_clientSession.beginTransaction();
        this.m_uow = this.m_clientSession.acquireUnitOfWork();
        this.m_employee = (Employee)this.m_uow.readObject(Employee.class);
        this.m_employee.setFirstName("Booyah!");
        this.m_uow.commit();
        this.accessor = this.m_clientSession.getWriteConnection();
        this.m_clientSession.setWriteConnection(null);
    }

    public void test() {
        try {
            this.m_clientSession.rollbackTransaction();
        }
        catch (NullPointerException e) {
            this.m_exceptionCaught = true;
        }
    }

    public void verify() {
        if (this.m_exceptionCaught) {
            throw new TestErrorException("Null pointer exception was caught on rollback");
        }
    }
}

