/*******************************************************************************
 * Copyright (c) 1998, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the 
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0 
 * which accompanies this distribution. 
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at 
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation from Oracle TopLink
 ******************************************************************************/  
package org.eclipse.persistence.testing.models.forceupdate;

import org.eclipse.persistence.tools.schemaframework.*;

/**
 * This class was generated by the TopLink table creator generator.
 * It stores the meta-data (tables) that define the database schema.
 * @see org.eclipse.persistence.sessions.factories.TableCreatorClassGenerator
 */
public class FUVLTableCreator extends TableCreator {

    public FUVLTableCreator() {
        setName("FUVL_TL4.0");

        addTableDefinition(buildEMPLOYEETLICTable());
        addTableDefinition(buildEMPLOYEETLIOTable());
        addTableDefinition(buildEMPLOYEEVLICTable());
        addTableDefinition(buildEMPLOYEEVLIOTable());
        addTableDefinition(buildPHONETLICTable());
        addTableDefinition(buildPHONETLIOTable());
        addTableDefinition(buildPHONEVLICTable());
        addTableDefinition(buildPHONEVLIOTable());
        addTableDefinition(buildADDRESSTLICTable());
        addTableDefinition(buildADDRESSTLIOTable());
        addTableDefinition(buildADDRESSVLICTable());
        addTableDefinition(buildADDRESSVLIOTable());
    }

    public TableDefinition buildADDRESSTLICTable() {
        TableDefinition table = new TableDefinition();
        table.setName("ADDRESSTLIC");

        FieldDefinition fieldADDRESS_ID = new FieldDefinition();
        fieldADDRESS_ID.setName("ADDRESS_ID");
        fieldADDRESS_ID.setTypeName("NUMBER");
        fieldADDRESS_ID.setSize(0);
        fieldADDRESS_ID.setSubSize(0);
        fieldADDRESS_ID.setIsPrimaryKey(true);
        fieldADDRESS_ID.setIsIdentity(true);
        fieldADDRESS_ID.setUnique(false);
        fieldADDRESS_ID.setShouldAllowNull(false);
        table.addField(fieldADDRESS_ID);

        FieldDefinition fieldP_CODE = new FieldDefinition();
        fieldP_CODE.setName("P_CODE");
        fieldP_CODE.setTypeName("VARCHAR2");
        fieldP_CODE.setSize(20);
        fieldP_CODE.setSubSize(0);
        fieldP_CODE.setIsPrimaryKey(false);
        fieldP_CODE.setIsIdentity(false);
        fieldP_CODE.setUnique(false);
        fieldP_CODE.setShouldAllowNull(true);
        table.addField(fieldP_CODE);

        FieldDefinition fieldCITY = new FieldDefinition();
        fieldCITY.setName("CITY");
        fieldCITY.setTypeName("VARCHAR2");
        fieldCITY.setSize(80);
        fieldCITY.setSubSize(0);
        fieldCITY.setIsPrimaryKey(false);
        fieldCITY.setIsIdentity(false);
        fieldCITY.setUnique(false);
        fieldCITY.setShouldAllowNull(true);
        table.addField(fieldCITY);

        FieldDefinition fieldPROVINCE = new FieldDefinition();
        fieldPROVINCE.setName("PROVINCE");
        fieldPROVINCE.setTypeName("VARCHAR2");
        fieldPROVINCE.setSize(80);
        fieldPROVINCE.setSubSize(0);
        fieldPROVINCE.setIsPrimaryKey(false);
        fieldPROVINCE.setIsIdentity(false);
        fieldPROVINCE.setUnique(false);
        fieldPROVINCE.setShouldAllowNull(true);
        table.addField(fieldPROVINCE);

        FieldDefinition fieldSTREET = new FieldDefinition();
        fieldSTREET.setName("STREET");
        fieldSTREET.setTypeName("VARCHAR2");
        fieldSTREET.setSize(80);
        fieldSTREET.setSubSize(0);
        fieldSTREET.setIsPrimaryKey(false);
        fieldSTREET.setIsIdentity(false);
        fieldSTREET.setUnique(false);
        fieldSTREET.setShouldAllowNull(true);
        table.addField(fieldSTREET);

        FieldDefinition fieldCOUNTORY = new FieldDefinition();
        fieldCOUNTORY.setName("COUNTORY");
        fieldCOUNTORY.setTypeName("VARCHAR2");
        fieldCOUNTORY.setSize(80);
        fieldCOUNTORY.setSubSize(0);
        fieldCOUNTORY.setIsPrimaryKey(false);
        fieldCOUNTORY.setIsIdentity(false);
        fieldCOUNTORY.setUnique(false);
        fieldCOUNTORY.setShouldAllowNull(true);
        table.addField(fieldCOUNTORY);

        FieldDefinition fieldVERSION = new FieldDefinition();
        fieldVERSION.setName("VERSION");
        //fieldVERSION.setTypeName("DATE"); because DATE can't be translated to TIMESTAMP in DB2
        fieldVERSION.setTypeName("TIMESTAMP");
        fieldVERSION.setSize(0);
        fieldVERSION.setSubSize(0);
        fieldVERSION.setIsPrimaryKey(false);
        fieldVERSION.setIsIdentity(false);
        fieldVERSION.setUnique(false);
        fieldVERSION.setShouldAllowNull(true);
        table.addField(fieldVERSION);

        return table;
    }

    public TableDefinition buildADDRESSTLIOTable() {
        TableDefinition table = new TableDefinition();
        table.setName("ADDRESSTLIO");

        FieldDefinition fieldADDRESS_ID = new FieldDefinition();
        fieldADDRESS_ID.setName("ADDRESS_ID");
        fieldADDRESS_ID.setTypeName("NUMBER");
        fieldADDRESS_ID.setSize(0);
        fieldADDRESS_ID.setSubSize(0);
        fieldADDRESS_ID.setIsPrimaryKey(true);
        fieldADDRESS_ID.setIsIdentity(true);
        fieldADDRESS_ID.setUnique(false);
        fieldADDRESS_ID.setShouldAllowNull(false);
        table.addField(fieldADDRESS_ID);

        FieldDefinition fieldP_CODE = new FieldDefinition();
        fieldP_CODE.setName("P_CODE");
        fieldP_CODE.setTypeName("VARCHAR2");
        fieldP_CODE.setSize(20);
        fieldP_CODE.setSubSize(0);
        fieldP_CODE.setIsPrimaryKey(false);
        fieldP_CODE.setIsIdentity(false);
        fieldP_CODE.setUnique(false);
        fieldP_CODE.setShouldAllowNull(true);
        table.addField(fieldP_CODE);

        FieldDefinition fieldCITY = new FieldDefinition();
        fieldCITY.setName("CITY");
        fieldCITY.setTypeName("VARCHAR2");
        fieldCITY.setSize(80);
        fieldCITY.setSubSize(0);
        fieldCITY.setIsPrimaryKey(false);
        fieldCITY.setIsIdentity(false);
        fieldCITY.setUnique(false);
        fieldCITY.setShouldAllowNull(true);
        table.addField(fieldCITY);

        FieldDefinition fieldPROVINCE = new FieldDefinition();
        fieldPROVINCE.setName("PROVINCE");
        fieldPROVINCE.setTypeName("VARCHAR2");
        fieldPROVINCE.setSize(80);
        fieldPROVINCE.setSubSize(0);
        fieldPROVINCE.setIsPrimaryKey(false);
        fieldPROVINCE.setIsIdentity(false);
        fieldPROVINCE.setUnique(false);
        fieldPROVINCE.setShouldAllowNull(true);
        table.addField(fieldPROVINCE);

        FieldDefinition fieldSTREET = new FieldDefinition();
        fieldSTREET.setName("STREET");
        fieldSTREET.setTypeName("VARCHAR2");
        fieldSTREET.setSize(80);
        fieldSTREET.setSubSize(0);
        fieldSTREET.setIsPrimaryKey(false);
        fieldSTREET.setIsIdentity(false);
        fieldSTREET.setUnique(false);
        fieldSTREET.setShouldAllowNull(true);
        table.addField(fieldSTREET);

        FieldDefinition fieldCOUNTRY = new FieldDefinition();
        fieldCOUNTRY.setName("COUNTRY");
        fieldCOUNTRY.setTypeName("VARCHAR2");
        fieldCOUNTRY.setSize(80);
        fieldCOUNTRY.setSubSize(0);
        fieldCOUNTRY.setIsPrimaryKey(false);
        fieldCOUNTRY.setIsIdentity(false);
        fieldCOUNTRY.setUnique(false);
        fieldCOUNTRY.setShouldAllowNull(true);
        table.addField(fieldCOUNTRY);

        FieldDefinition fieldVERSION = new FieldDefinition();
        fieldVERSION.setName("VERSION");
        //fieldVERSION.setTypeName("DATE");
        fieldVERSION.setTypeName("TIMESTAMP");
        fieldVERSION.setSize(0);
        fieldVERSION.setSubSize(0);
        fieldVERSION.setIsPrimaryKey(false);
        fieldVERSION.setIsIdentity(false);
        fieldVERSION.setUnique(false);
        fieldVERSION.setShouldAllowNull(true);
        table.addField(fieldVERSION);

        return table;
    }

    public TableDefinition buildADDRESSVLICTable() {
        TableDefinition table = new TableDefinition();
        table.setName("ADDRESSVLIC");

        FieldDefinition fieldADDRESS_ID = new FieldDefinition();
        fieldADDRESS_ID.setName("ADDRESS_ID");
        fieldADDRESS_ID.setTypeName("NUMBER");
        fieldADDRESS_ID.setSize(0);
        fieldADDRESS_ID.setSubSize(0);
        fieldADDRESS_ID.setIsPrimaryKey(true);
        fieldADDRESS_ID.setIsIdentity(true);
        fieldADDRESS_ID.setUnique(false);
        fieldADDRESS_ID.setShouldAllowNull(false);
        table.addField(fieldADDRESS_ID);

        FieldDefinition fieldP_CODE = new FieldDefinition();
        fieldP_CODE.setName("P_CODE");
        fieldP_CODE.setTypeName("VARCHAR2");
        fieldP_CODE.setSize(20);
        fieldP_CODE.setSubSize(0);
        fieldP_CODE.setIsPrimaryKey(false);
        fieldP_CODE.setIsIdentity(false);
        fieldP_CODE.setUnique(false);
        fieldP_CODE.setShouldAllowNull(true);
        table.addField(fieldP_CODE);

        FieldDefinition fieldCITY = new FieldDefinition();
        fieldCITY.setName("CITY");
        fieldCITY.setTypeName("VARCHAR2");
        fieldCITY.setSize(80);
        fieldCITY.setSubSize(0);
        fieldCITY.setIsPrimaryKey(false);
        fieldCITY.setIsIdentity(false);
        fieldCITY.setUnique(false);
        fieldCITY.setShouldAllowNull(true);
        table.addField(fieldCITY);

        FieldDefinition fieldPROVINCE = new FieldDefinition();
        fieldPROVINCE.setName("PROVINCE");
        fieldPROVINCE.setTypeName("VARCHAR2");
        fieldPROVINCE.setSize(80);
        fieldPROVINCE.setSubSize(0);
        fieldPROVINCE.setIsPrimaryKey(false);
        fieldPROVINCE.setIsIdentity(false);
        fieldPROVINCE.setUnique(false);
        fieldPROVINCE.setShouldAllowNull(true);
        table.addField(fieldPROVINCE);

        FieldDefinition fieldSTREET = new FieldDefinition();
        fieldSTREET.setName("STREET");
        fieldSTREET.setTypeName("VARCHAR2");
        fieldSTREET.setSize(80);
        fieldSTREET.setSubSize(0);
        fieldSTREET.setIsPrimaryKey(false);
        fieldSTREET.setIsIdentity(false);
        fieldSTREET.setUnique(false);
        fieldSTREET.setShouldAllowNull(true);
        table.addField(fieldSTREET);

        FieldDefinition fieldCOUNTRY = new FieldDefinition();
        fieldCOUNTRY.setName("COUNTRY");
        fieldCOUNTRY.setTypeName("VARCHAR2");
        fieldCOUNTRY.setSize(80);
        fieldCOUNTRY.setSubSize(0);
        fieldCOUNTRY.setIsPrimaryKey(false);
        fieldCOUNTRY.setIsIdentity(false);
        fieldCOUNTRY.setUnique(false);
        fieldCOUNTRY.setShouldAllowNull(true);
        table.addField(fieldCOUNTRY);

        FieldDefinition fieldVERSION = new FieldDefinition();
        fieldVERSION.setName("VERSION");
        fieldVERSION.setTypeName("NUMBER");
        fieldVERSION.setSize(0);
        fieldVERSION.setSubSize(0);
        fieldVERSION.setIsPrimaryKey(false);
        fieldVERSION.setIsIdentity(false);
        fieldVERSION.setUnique(false);
        fieldVERSION.setShouldAllowNull(true);
        table.addField(fieldVERSION);

        return table;
    }

    public TableDefinition buildADDRESSVLIOTable() {
        TableDefinition table = new TableDefinition();
        table.setName("ADDRESSVLIO");

        FieldDefinition fieldADDRESS_ID = new FieldDefinition();
        fieldADDRESS_ID.setName("ADDRESS_ID");
        fieldADDRESS_ID.setTypeName("NUMBER");
        fieldADDRESS_ID.setSize(0);
        fieldADDRESS_ID.setSubSize(0);
        fieldADDRESS_ID.setIsPrimaryKey(true);
        fieldADDRESS_ID.setIsIdentity(true);
        fieldADDRESS_ID.setUnique(false);
        fieldADDRESS_ID.setShouldAllowNull(false);
        table.addField(fieldADDRESS_ID);

        FieldDefinition fieldP_CODE = new FieldDefinition();
        fieldP_CODE.setName("P_CODE");
        fieldP_CODE.setTypeName("VARCHAR2");
        fieldP_CODE.setSize(20);
        fieldP_CODE.setSubSize(0);
        fieldP_CODE.setIsPrimaryKey(false);
        fieldP_CODE.setIsIdentity(false);
        fieldP_CODE.setUnique(false);
        fieldP_CODE.setShouldAllowNull(true);
        table.addField(fieldP_CODE);

        FieldDefinition fieldCITY = new FieldDefinition();
        fieldCITY.setName("CITY");
        fieldCITY.setTypeName("VARCHAR2");
        fieldCITY.setSize(80);
        fieldCITY.setSubSize(0);
        fieldCITY.setIsPrimaryKey(false);
        fieldCITY.setIsIdentity(false);
        fieldCITY.setUnique(false);
        fieldCITY.setShouldAllowNull(true);
        table.addField(fieldCITY);

        FieldDefinition fieldPROVINCE = new FieldDefinition();
        fieldPROVINCE.setName("PROVINCE");
        fieldPROVINCE.setTypeName("VARCHAR2");
        fieldPROVINCE.setSize(80);
        fieldPROVINCE.setSubSize(0);
        fieldPROVINCE.setIsPrimaryKey(false);
        fieldPROVINCE.setIsIdentity(false);
        fieldPROVINCE.setUnique(false);
        fieldPROVINCE.setShouldAllowNull(true);
        table.addField(fieldPROVINCE);

        FieldDefinition fieldSTREET = new FieldDefinition();
        fieldSTREET.setName("STREET");
        fieldSTREET.setTypeName("VARCHAR2");
        fieldSTREET.setSize(80);
        fieldSTREET.setSubSize(0);
        fieldSTREET.setIsPrimaryKey(false);
        fieldSTREET.setIsIdentity(false);
        fieldSTREET.setUnique(false);
        fieldSTREET.setShouldAllowNull(true);
        table.addField(fieldSTREET);

        FieldDefinition fieldCOUNTRY = new FieldDefinition();
        fieldCOUNTRY.setName("COUNTRY");
        fieldCOUNTRY.setTypeName("VARCHAR2");
        fieldCOUNTRY.setSize(80);
        fieldCOUNTRY.setSubSize(0);
        fieldCOUNTRY.setIsPrimaryKey(false);
        fieldCOUNTRY.setIsIdentity(false);
        fieldCOUNTRY.setUnique(false);
        fieldCOUNTRY.setShouldAllowNull(true);
        table.addField(fieldCOUNTRY);

        FieldDefinition fieldVERSION = new FieldDefinition();
        fieldVERSION.setName("VERSION");
        fieldVERSION.setTypeName("NUMBER");
        fieldVERSION.setSize(0);
        fieldVERSION.setSubSize(0);
        fieldVERSION.setIsPrimaryKey(false);
        fieldVERSION.setIsIdentity(false);
        fieldVERSION.setUnique(false);
        fieldVERSION.setShouldAllowNull(true);
        table.addField(fieldVERSION);

        return table;
    }

    public TableDefinition buildEMPLOYEETLICTable() {
        TableDefinition table = new TableDefinition();
        table.setName("EMPLOYEETLIC");

        FieldDefinition fieldEMP_ID = new FieldDefinition();
        fieldEMP_ID.setName("EMP_ID");
        fieldEMP_ID.setTypeName("NUMBER");
        fieldEMP_ID.setSize(0);
        fieldEMP_ID.setSubSize(0);
        fieldEMP_ID.setIsPrimaryKey(true);
        fieldEMP_ID.setIsIdentity(false);
        fieldEMP_ID.setUnique(false);
        fieldEMP_ID.setShouldAllowNull(false);
        table.addField(fieldEMP_ID);

        FieldDefinition fieldF_NAME = new FieldDefinition();
        fieldF_NAME.setName("F_NAME");
        fieldF_NAME.setTypeName("VARCHAR2");
        fieldF_NAME.setSize(40);
        fieldF_NAME.setSubSize(0);
        fieldF_NAME.setIsPrimaryKey(false);
        fieldF_NAME.setIsIdentity(false);
        fieldF_NAME.setUnique(false);
        fieldF_NAME.setShouldAllowNull(true);
        table.addField(fieldF_NAME);

        FieldDefinition fieldL_NAME = new FieldDefinition();
        fieldL_NAME.setName("L_NAME");
        fieldL_NAME.setTypeName("VARCHAR2");
        fieldL_NAME.setSize(40);
        fieldL_NAME.setSubSize(0);
        fieldL_NAME.setIsPrimaryKey(false);
        fieldL_NAME.setIsIdentity(false);
        fieldL_NAME.setUnique(false);
        fieldL_NAME.setShouldAllowNull(true);
        table.addField(fieldL_NAME);

        FieldDefinition fieldGENDER = new FieldDefinition();
        fieldGENDER.setName("GENDER");
        fieldGENDER.setTypeName("CHAR");
        fieldGENDER.setSize(20);
        fieldGENDER.setSubSize(0);
        fieldGENDER.setIsPrimaryKey(false);
        fieldGENDER.setIsIdentity(false);
        fieldGENDER.setUnique(false);
        fieldGENDER.setShouldAllowNull(true);
        table.addField(fieldGENDER);

        FieldDefinition fieldVERSION = new FieldDefinition();
        fieldVERSION.setName("VERSION");
        //fieldVERSION.setTypeName("DATE");
        fieldVERSION.setTypeName("TIMESTAMP");
        fieldVERSION.setSize(0);
        fieldVERSION.setSubSize(0);
        fieldVERSION.setIsPrimaryKey(false);
        fieldVERSION.setIsIdentity(false);
        fieldVERSION.setUnique(false);
        fieldVERSION.setShouldAllowNull(true);
        table.addField(fieldVERSION);

        FieldDefinition fieldADDR_ID = new FieldDefinition();
        fieldADDR_ID.setName("ADDR_ID");
        fieldADDR_ID.setTypeName("NUMBER");
        fieldADDR_ID.setSize(0);
        fieldADDR_ID.setSubSize(0);
        fieldADDR_ID.setIsPrimaryKey(false);
        fieldADDR_ID.setIsIdentity(false);
        fieldADDR_ID.setUnique(false);
        fieldADDR_ID.setShouldAllowNull(true);
        table.addField(fieldADDR_ID);

        FieldDefinition fieldSALARY = new FieldDefinition();
        fieldSALARY.setName("SALARY");
        fieldSALARY.setTypeName("NUMBER");
        fieldSALARY.setSize(0);
        fieldSALARY.setSubSize(0);
        fieldSALARY.setIsPrimaryKey(false);
        fieldSALARY.setIsIdentity(false);
        fieldSALARY.setUnique(false);
        fieldSALARY.setShouldAllowNull(true);
        table.addField(fieldSALARY);

        return table;
    }

    public TableDefinition buildEMPLOYEETLIOTable() {
        TableDefinition table = new TableDefinition();
        table.setName("EMPLOYEETLIO");

        FieldDefinition fieldEMP_ID = new FieldDefinition();
        fieldEMP_ID.setName("EMP_ID");
        fieldEMP_ID.setTypeName("NUMBER");
        fieldEMP_ID.setSize(0);
        fieldEMP_ID.setSubSize(0);
        fieldEMP_ID.setIsPrimaryKey(true);
        fieldEMP_ID.setIsIdentity(false);
        fieldEMP_ID.setUnique(false);
        fieldEMP_ID.setShouldAllowNull(false);
        table.addField(fieldEMP_ID);

        FieldDefinition fieldF_NAME = new FieldDefinition();
        fieldF_NAME.setName("F_NAME");
        fieldF_NAME.setTypeName("VARCHAR2");
        fieldF_NAME.setSize(40);
        fieldF_NAME.setSubSize(0);
        fieldF_NAME.setIsPrimaryKey(false);
        fieldF_NAME.setIsIdentity(false);
        fieldF_NAME.setUnique(false);
        fieldF_NAME.setShouldAllowNull(true);
        table.addField(fieldF_NAME);

        FieldDefinition fieldL_NAME = new FieldDefinition();
        fieldL_NAME.setName("L_NAME");
        fieldL_NAME.setTypeName("VARCHAR2");
        fieldL_NAME.setSize(40);
        fieldL_NAME.setSubSize(0);
        fieldL_NAME.setIsPrimaryKey(false);
        fieldL_NAME.setIsIdentity(false);
        fieldL_NAME.setUnique(false);
        fieldL_NAME.setShouldAllowNull(true);
        table.addField(fieldL_NAME);

        FieldDefinition fieldGENDER = new FieldDefinition();
        fieldGENDER.setName("GENDER");
        fieldGENDER.setTypeName("CHAR");
        fieldGENDER.setSize(20);
        fieldGENDER.setSubSize(0);
        fieldGENDER.setIsPrimaryKey(false);
        fieldGENDER.setIsIdentity(false);
        fieldGENDER.setUnique(false);
        fieldGENDER.setShouldAllowNull(true);
        table.addField(fieldGENDER);

        FieldDefinition fieldVERSION = new FieldDefinition();
        fieldVERSION.setName("VERSION");
        //fieldVERSION.setTypeName("DATE");
        fieldVERSION.setTypeName("TIMESTAMP");
        fieldVERSION.setSize(0);
        fieldVERSION.setSubSize(0);
        fieldVERSION.setIsPrimaryKey(false);
        fieldVERSION.setIsIdentity(false);
        fieldVERSION.setUnique(false);
        fieldVERSION.setShouldAllowNull(true);
        table.addField(fieldVERSION);

        FieldDefinition fieldADDR_ID = new FieldDefinition();
        fieldADDR_ID.setName("ADDR_ID");
        fieldADDR_ID.setTypeName("NUMBER");
        fieldADDR_ID.setSize(0);
        fieldADDR_ID.setSubSize(0);
        fieldADDR_ID.setIsPrimaryKey(false);
        fieldADDR_ID.setIsIdentity(false);
        fieldADDR_ID.setUnique(false);
        fieldADDR_ID.setShouldAllowNull(true);
        table.addField(fieldADDR_ID);

        FieldDefinition fieldSALARY = new FieldDefinition();
        fieldSALARY.setName("SALARY");
        fieldSALARY.setTypeName("NUMBER");
        fieldSALARY.setSize(0);
        fieldSALARY.setSubSize(0);
        fieldSALARY.setIsPrimaryKey(false);
        fieldSALARY.setIsIdentity(false);
        fieldSALARY.setUnique(false);
        fieldSALARY.setShouldAllowNull(true);
        table.addField(fieldSALARY);

        return table;
    }

    public TableDefinition buildEMPLOYEEVLICTable() {
        TableDefinition table = new TableDefinition();
        table.setName("EMPLOYEEVLIC");

        FieldDefinition fieldEMP_ID = new FieldDefinition();
        fieldEMP_ID.setName("EMP_ID");
        fieldEMP_ID.setTypeName("NUMBER");
        fieldEMP_ID.setSize(0);
        fieldEMP_ID.setSubSize(0);
        fieldEMP_ID.setIsPrimaryKey(true);
        fieldEMP_ID.setIsIdentity(false);
        fieldEMP_ID.setUnique(false);
        fieldEMP_ID.setShouldAllowNull(false);
        table.addField(fieldEMP_ID);

        FieldDefinition fieldF_NAME = new FieldDefinition();
        fieldF_NAME.setName("F_NAME");
        fieldF_NAME.setTypeName("VARCHAR2");
        fieldF_NAME.setSize(40);
        fieldF_NAME.setSubSize(0);
        fieldF_NAME.setIsPrimaryKey(false);
        fieldF_NAME.setIsIdentity(false);
        fieldF_NAME.setUnique(false);
        fieldF_NAME.setShouldAllowNull(true);
        table.addField(fieldF_NAME);

        FieldDefinition fieldL_NAME = new FieldDefinition();
        fieldL_NAME.setName("L_NAME");
        fieldL_NAME.setTypeName("VARCHAR2");
        fieldL_NAME.setSize(40);
        fieldL_NAME.setSubSize(0);
        fieldL_NAME.setIsPrimaryKey(false);
        fieldL_NAME.setIsIdentity(false);
        fieldL_NAME.setUnique(false);
        fieldL_NAME.setShouldAllowNull(true);
        table.addField(fieldL_NAME);

        FieldDefinition fieldGENDER = new FieldDefinition();
        fieldGENDER.setName("GENDER");
        fieldGENDER.setTypeName("CHAR");
        fieldGENDER.setSize(20);
        fieldGENDER.setSubSize(0);
        fieldGENDER.setIsPrimaryKey(false);
        fieldGENDER.setIsIdentity(false);
        fieldGENDER.setUnique(false);
        fieldGENDER.setShouldAllowNull(true);
        table.addField(fieldGENDER);

        FieldDefinition fieldVERSION = new FieldDefinition();
        fieldVERSION.setName("VERSION");
        fieldVERSION.setTypeName("NUMBER");
        fieldVERSION.setSize(0);
        fieldVERSION.setSubSize(0);
        fieldVERSION.setIsPrimaryKey(false);
        fieldVERSION.setIsIdentity(false);
        fieldVERSION.setUnique(false);
        fieldVERSION.setShouldAllowNull(true);
        table.addField(fieldVERSION);

        FieldDefinition fieldADDR_ID = new FieldDefinition();
        fieldADDR_ID.setName("ADDR_ID");
        fieldADDR_ID.setTypeName("NUMBER");
        fieldADDR_ID.setSize(0);
        fieldADDR_ID.setSubSize(0);
        fieldADDR_ID.setIsPrimaryKey(false);
        fieldADDR_ID.setIsIdentity(false);
        fieldADDR_ID.setUnique(false);
        fieldADDR_ID.setShouldAllowNull(true);
        table.addField(fieldADDR_ID);

        FieldDefinition fieldSALARY = new FieldDefinition();
        fieldSALARY.setName("SALARY");
        fieldSALARY.setTypeName("NUMBER");
        fieldSALARY.setSize(0);
        fieldSALARY.setSubSize(0);
        fieldSALARY.setIsPrimaryKey(false);
        fieldSALARY.setIsIdentity(false);
        fieldSALARY.setUnique(false);
        fieldSALARY.setShouldAllowNull(true);
        table.addField(fieldSALARY);

        return table;
    }

    public TableDefinition buildEMPLOYEEVLIOTable() {
        TableDefinition table = new TableDefinition();
        table.setName("EMPLOYEEVLIO");

        FieldDefinition fieldEMP_ID = new FieldDefinition();
        fieldEMP_ID.setName("EMP_ID");
        fieldEMP_ID.setTypeName("NUMBER");
        fieldEMP_ID.setSize(0);
        fieldEMP_ID.setSubSize(0);
        fieldEMP_ID.setIsPrimaryKey(true);
        fieldEMP_ID.setIsIdentity(false);
        fieldEMP_ID.setUnique(false);
        fieldEMP_ID.setShouldAllowNull(false);
        table.addField(fieldEMP_ID);

        FieldDefinition fieldF_NAME = new FieldDefinition();
        fieldF_NAME.setName("F_NAME");
        fieldF_NAME.setTypeName("VARCHAR2");
        fieldF_NAME.setSize(40);
        fieldF_NAME.setSubSize(0);
        fieldF_NAME.setIsPrimaryKey(false);
        fieldF_NAME.setIsIdentity(false);
        fieldF_NAME.setUnique(false);
        fieldF_NAME.setShouldAllowNull(true);
        table.addField(fieldF_NAME);

        FieldDefinition fieldL_NAME = new FieldDefinition();
        fieldL_NAME.setName("L_NAME");
        fieldL_NAME.setTypeName("VARCHAR2");
        fieldL_NAME.setSize(40);
        fieldL_NAME.setSubSize(0);
        fieldL_NAME.setIsPrimaryKey(false);
        fieldL_NAME.setIsIdentity(false);
        fieldL_NAME.setUnique(false);
        fieldL_NAME.setShouldAllowNull(true);
        table.addField(fieldL_NAME);

        FieldDefinition fieldGENDER = new FieldDefinition();
        fieldGENDER.setName("GENDER");
        fieldGENDER.setTypeName("CHAR");
        fieldGENDER.setSize(20);
        fieldGENDER.setSubSize(0);
        fieldGENDER.setIsPrimaryKey(false);
        fieldGENDER.setIsIdentity(false);
        fieldGENDER.setUnique(false);
        fieldGENDER.setShouldAllowNull(true);
        table.addField(fieldGENDER);

        FieldDefinition fieldVERSION = new FieldDefinition();
        fieldVERSION.setName("VERSION");
        fieldVERSION.setTypeName("NUMBER");
        fieldVERSION.setSize(0);
        fieldVERSION.setSubSize(0);
        fieldVERSION.setIsPrimaryKey(false);
        fieldVERSION.setIsIdentity(false);
        fieldVERSION.setUnique(false);
        fieldVERSION.setShouldAllowNull(true);
        table.addField(fieldVERSION);

        FieldDefinition fieldADDR_ID = new FieldDefinition();
        fieldADDR_ID.setName("ADDR_ID");
        fieldADDR_ID.setTypeName("NUMBER");
        fieldADDR_ID.setSize(0);
        fieldADDR_ID.setSubSize(0);
        fieldADDR_ID.setIsPrimaryKey(false);
        fieldADDR_ID.setIsIdentity(false);
        fieldADDR_ID.setUnique(false);
        fieldADDR_ID.setShouldAllowNull(true);
        table.addField(fieldADDR_ID);

        FieldDefinition fieldSALARY = new FieldDefinition();
        fieldSALARY.setName("SALARY");
        fieldSALARY.setTypeName("NUMBER");
        fieldSALARY.setSize(0);
        fieldSALARY.setSubSize(0);
        fieldSALARY.setIsPrimaryKey(false);
        fieldSALARY.setIsIdentity(false);
        fieldSALARY.setUnique(false);
        fieldSALARY.setShouldAllowNull(true);
        table.addField(fieldSALARY);

        return table;
    }

    public TableDefinition buildPHONETLICTable() {
        TableDefinition table = new TableDefinition();
        table.setName("PHONETLIC");

        FieldDefinition fieldEMP_ID = new FieldDefinition();
        fieldEMP_ID.setName("EMP_ID");
        fieldEMP_ID.setTypeName("NUMBER");
        fieldEMP_ID.setSize(0);
        fieldEMP_ID.setSubSize(0);
        fieldEMP_ID.setIsPrimaryKey(true);
        fieldEMP_ID.setIsIdentity(false);
        fieldEMP_ID.setUnique(false);
        fieldEMP_ID.setShouldAllowNull(false);
        table.addField(fieldEMP_ID);

        FieldDefinition fieldTYPE = new FieldDefinition();
        fieldTYPE.setName("TYPE");
        fieldTYPE.setTypeName("VARCHAR2");
        fieldTYPE.setSize(15);
        fieldTYPE.setSubSize(0);
        fieldTYPE.setIsPrimaryKey(true);
        fieldTYPE.setIsIdentity(false);
        fieldTYPE.setUnique(false);
        fieldTYPE.setShouldAllowNull(false);
        table.addField(fieldTYPE);

        FieldDefinition fieldAREA_CODE = new FieldDefinition();
        fieldAREA_CODE.setName("AREA_CODE");
        fieldAREA_CODE.setTypeName("VARCHAR2");
        fieldAREA_CODE.setSize(3);
        fieldAREA_CODE.setSubSize(0);
        fieldAREA_CODE.setIsPrimaryKey(false);
        fieldAREA_CODE.setIsIdentity(false);
        fieldAREA_CODE.setUnique(false);
        fieldAREA_CODE.setShouldAllowNull(true);
        table.addField(fieldAREA_CODE);

        FieldDefinition fieldP_NUMBER = new FieldDefinition();
        fieldP_NUMBER.setName("P_NUMBER");
        fieldP_NUMBER.setTypeName("VARCHAR2");
        fieldP_NUMBER.setSize(7);
        fieldP_NUMBER.setSubSize(0);
        fieldP_NUMBER.setIsPrimaryKey(false);
        fieldP_NUMBER.setIsIdentity(false);
        fieldP_NUMBER.setUnique(false);
        fieldP_NUMBER.setShouldAllowNull(true);
        table.addField(fieldP_NUMBER);

        return table;
    }

    public TableDefinition buildPHONETLIOTable() {
        TableDefinition table = new TableDefinition();
        table.setName("PHONETLIO");

        FieldDefinition fieldEMP_ID = new FieldDefinition();
        fieldEMP_ID.setName("EMP_ID");
        fieldEMP_ID.setTypeName("NUMBER");
        fieldEMP_ID.setSize(0);
        fieldEMP_ID.setSubSize(0);
        fieldEMP_ID.setIsPrimaryKey(true);
        fieldEMP_ID.setIsIdentity(false);
        fieldEMP_ID.setUnique(false);
        fieldEMP_ID.setShouldAllowNull(false);
        table.addField(fieldEMP_ID);

        FieldDefinition fieldTYPE = new FieldDefinition();
        fieldTYPE.setName("TYPE");
        fieldTYPE.setTypeName("VARCHAR2");
        fieldTYPE.setSize(15);
        fieldTYPE.setSubSize(0);
        fieldTYPE.setIsPrimaryKey(true);
        fieldTYPE.setIsIdentity(false);
        fieldTYPE.setUnique(false);
        fieldTYPE.setShouldAllowNull(false);
        table.addField(fieldTYPE);

        FieldDefinition fieldAREA_CODE = new FieldDefinition();
        fieldAREA_CODE.setName("AREA_CODE");
        fieldAREA_CODE.setTypeName("VARCHAR2");
        fieldAREA_CODE.setSize(3);
        fieldAREA_CODE.setSubSize(0);
        fieldAREA_CODE.setIsPrimaryKey(false);
        fieldAREA_CODE.setIsIdentity(false);
        fieldAREA_CODE.setUnique(false);
        fieldAREA_CODE.setShouldAllowNull(true);
        table.addField(fieldAREA_CODE);

        FieldDefinition fieldP_NUMBER = new FieldDefinition();
        fieldP_NUMBER.setName("P_NUMBER");
        fieldP_NUMBER.setTypeName("VARCHAR2");
        fieldP_NUMBER.setSize(7);
        fieldP_NUMBER.setSubSize(0);
        fieldP_NUMBER.setIsPrimaryKey(false);
        fieldP_NUMBER.setIsIdentity(false);
        fieldP_NUMBER.setUnique(false);
        fieldP_NUMBER.setShouldAllowNull(true);
        table.addField(fieldP_NUMBER);

        return table;
    }

    public TableDefinition buildPHONEVLICTable() {
        TableDefinition table = new TableDefinition();
        table.setName("PHONEVLIC");

        FieldDefinition fieldEMP_ID = new FieldDefinition();
        fieldEMP_ID.setName("EMP_ID");
        fieldEMP_ID.setTypeName("NUMBER");
        fieldEMP_ID.setSize(0);
        fieldEMP_ID.setSubSize(0);
        fieldEMP_ID.setIsPrimaryKey(true);
        fieldEMP_ID.setIsIdentity(false);
        fieldEMP_ID.setUnique(false);
        fieldEMP_ID.setShouldAllowNull(false);
        table.addField(fieldEMP_ID);

        FieldDefinition fieldTYPE = new FieldDefinition();
        fieldTYPE.setName("TYPE");
        fieldTYPE.setTypeName("VARCHAR2");
        fieldTYPE.setSize(15);
        fieldTYPE.setSubSize(0);
        fieldTYPE.setIsPrimaryKey(true);
        fieldTYPE.setIsIdentity(false);
        fieldTYPE.setUnique(false);
        fieldTYPE.setShouldAllowNull(false);
        table.addField(fieldTYPE);

        FieldDefinition fieldAREA_CODE = new FieldDefinition();
        fieldAREA_CODE.setName("AREA_CODE");
        fieldAREA_CODE.setTypeName("VARCHAR2");
        fieldAREA_CODE.setSize(3);
        fieldAREA_CODE.setSubSize(0);
        fieldAREA_CODE.setIsPrimaryKey(false);
        fieldAREA_CODE.setIsIdentity(false);
        fieldAREA_CODE.setUnique(false);
        fieldAREA_CODE.setShouldAllowNull(true);
        table.addField(fieldAREA_CODE);

        FieldDefinition fieldP_NUMBER = new FieldDefinition();
        fieldP_NUMBER.setName("P_NUMBER");
        fieldP_NUMBER.setTypeName("VARCHAR2");
        fieldP_NUMBER.setSize(7);
        fieldP_NUMBER.setSubSize(0);
        fieldP_NUMBER.setIsPrimaryKey(false);
        fieldP_NUMBER.setIsIdentity(false);
        fieldP_NUMBER.setUnique(false);
        fieldP_NUMBER.setShouldAllowNull(true);
        table.addField(fieldP_NUMBER);

        return table;
    }

    public TableDefinition buildPHONEVLIOTable() {
        TableDefinition table = new TableDefinition();
        table.setName("PHONEVLIO");

        FieldDefinition fieldEMP_ID = new FieldDefinition();
        fieldEMP_ID.setName("EMP_ID");
        fieldEMP_ID.setTypeName("NUMBER");
        fieldEMP_ID.setSize(0);
        fieldEMP_ID.setSubSize(0);
        fieldEMP_ID.setIsPrimaryKey(true);
        fieldEMP_ID.setIsIdentity(false);
        fieldEMP_ID.setUnique(false);
        fieldEMP_ID.setShouldAllowNull(false);
        table.addField(fieldEMP_ID);

        FieldDefinition fieldTYPE = new FieldDefinition();
        fieldTYPE.setName("TYPE");
        fieldTYPE.setTypeName("VARCHAR2");
        fieldTYPE.setSize(15);
        fieldTYPE.setSubSize(0);
        fieldTYPE.setIsPrimaryKey(true);
        fieldTYPE.setIsIdentity(false);
        fieldTYPE.setUnique(false);
        fieldTYPE.setShouldAllowNull(false);
        table.addField(fieldTYPE);

        FieldDefinition fieldAREA_CODE = new FieldDefinition();
        fieldAREA_CODE.setName("AREA_CODE");
        fieldAREA_CODE.setTypeName("VARCHAR2");
        fieldAREA_CODE.setSize(3);
        fieldAREA_CODE.setSubSize(0);
        fieldAREA_CODE.setIsPrimaryKey(false);
        fieldAREA_CODE.setIsIdentity(false);
        fieldAREA_CODE.setUnique(false);
        fieldAREA_CODE.setShouldAllowNull(true);
        table.addField(fieldAREA_CODE);

        FieldDefinition fieldP_NUMBER = new FieldDefinition();
        fieldP_NUMBER.setName("P_NUMBER");
        fieldP_NUMBER.setTypeName("VARCHAR2");
        fieldP_NUMBER.setSize(7);
        fieldP_NUMBER.setSubSize(0);
        fieldP_NUMBER.setIsPrimaryKey(false);
        fieldP_NUMBER.setIsIdentity(false);
        fieldP_NUMBER.setUnique(false);
        fieldP_NUMBER.setShouldAllowNull(true);
        table.addField(fieldP_NUMBER);

        return table;
    }

}
