/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.internal;

import java.awt.Component;
import java.awt.Dimension;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.eclipse.persistence.tools.workbench.framework.app.AbstractPreferencesNode;
import org.eclipse.persistence.tools.workbench.framework.app.PreferencesNode;
import org.eclipse.persistence.tools.workbench.framework.internal.PreferencesEditorView;
import org.eclipse.persistence.tools.workbench.framework.internal.PreferencesNavigatorView;
import org.eclipse.persistence.tools.workbench.framework.uitools.OSplitPane;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingTools;
import org.eclipse.persistence.tools.workbench.uitools.app.BufferedPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;

final class PreferencesView {
    private Preferences rootPreferences;
    private BufferedPropertyValueModel.Trigger bufferTrigger;
    private JSplitPane splitPane;
    private PreferencesNavigatorView navigatorView;
    private PreferencesEditorView editorView;
    private PropertyValueModel selectedNodeHolder;
    private PreferencesNode emptySelectionNode;

    PreferencesView(AbstractPreferencesNode rootNode, BufferedPropertyValueModel.Trigger bufferTrigger) {
        this.initialize(rootNode, bufferTrigger);
    }

    private void initialize(AbstractPreferencesNode rootNode, BufferedPropertyValueModel.Trigger bufferTrigger) {
        this.rootPreferences = rootNode.getPreferences();
        this.bufferTrigger = bufferTrigger;
        this.emptySelectionNode = new PreferencesEmptySelectionPseudoNode();
        this.selectedNodeHolder = new SimplePropertyValueModel(this.emptySelectionNode);
        this.navigatorView = new PreferencesNavigatorView(rootNode);
        this.navigatorView.addTreeSelectionListener(this.buildTreeSelectionListener());
        this.editorView = new PreferencesEditorView(this.selectedNodeHolder);
        this.splitPane = this.buildSplitPane();
        this.navigatorView.selectFirstChild();
    }

    private TreeSelectionListener buildTreeSelectionListener() {
        return new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                PreferencesView.this.selectedNodeChanged(e.getNewLeadSelectionPath());
            }
        };
    }

    private JSplitPane buildSplitPane() {
        OSplitPane splitPane = new OSplitPane();
        splitPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        splitPane.setDoubleBuffered(false);
        splitPane.setSize(new Dimension(750, 550));
        splitPane.setDividerLocation(0.2);
        SwingTools.setSplitPaneDividerBorder(splitPane, BorderFactory.createEmptyBorder());
        splitPane.setDividerSize(3);
        splitPane.setContinuousLayout(false);
        ((JSplitPane)splitPane).setLeftComponent(this.navigatorView.getComponent());
        ((JSplitPane)splitPane).setRightComponent(this.editorView.getComponent());
        return splitPane;
    }

    Component getComponent() {
        return this.splitPane;
    }

    PreferencesNavigatorView getView() {
        return this.navigatorView;
    }

    Component initialFocusComponent() {
        return this.navigatorView.initialFocusComponent();
    }

    private void selectedNodeChanged(TreePath path) {
        if (path == null) {
            this.selectedNodeHolder.setValue(this.emptySelectionNode);
        } else {
            this.selectedNodeHolder.setValue(path.getLastPathComponent());
        }
    }

    void triggerAccept() {
        this.bufferTrigger.accept();
    }

    void triggerReset() {
        this.bufferTrigger.reset();
    }

    void exportPreferences(File file) {
        BufferedOutputStream stream;
        try {
            stream = new BufferedOutputStream(new FileOutputStream(file), 2048);
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        try {
            this.rootPreferences.exportSubtree(stream);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                ((OutputStream)stream).close();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    void importPreferences(File file) {
        BufferedInputStream stream;
        try {
            stream = new BufferedInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        try {
            Preferences.importPreferences(stream);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                ((InputStream)stream).close();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private static final class PreferencesEmptySelectionPseudoNode
    extends AbstractPreferencesNode {
        PreferencesEmptySelectionPseudoNode() {
            super(null);
        }

        @Override
        protected Component buildPropertiesPage() {
            return new JPanel();
        }

        @Override
        protected String buildDisplayString() {
            return " ";
        }

        @Override
        public String helpTopicId() {
            return "preferences";
        }
    }
}

