/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.uitools;

import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.event.SwingPropertyChangeSupport;

public final class ComponentAligner {
    private boolean autoValidate;
    private PropertyChangeSupport changeSupport;
    private boolean locked;
    private int maximumWidth;
    private PropertyChangeListener propertyChangeListener;
    private Collection wrappers;
    private static final String TEXT_PROPERTY = "text";

    public ComponentAligner() {
        this(true);
    }

    public ComponentAligner(boolean autoValidate) {
        this.initialize(autoValidate);
    }

    public ComponentAligner(Collection components) {
        this();
        this.addAll(components);
    }

    public ComponentAligner(Collection items, boolean autoValidate) {
        this(autoValidate);
        this.addAll(items);
    }

    public void add(ComponentAligner componentAligner) {
        if (componentAligner == this) {
            throw new IllegalArgumentException("Can't add the ComponentAligner to itself");
        }
        Wrapper wrapper = this.buildWrapper(componentAligner);
        wrapper.addPropertyChangeListener(this.propertyChangeListener);
        this.wrappers.add(wrapper);
        if (!componentAligner.wrappers.isEmpty()) {
            this.revalidate();
        }
    }

    public void add(JComponent component) {
        Wrapper wrapper = this.buildWrapper(component);
        wrapper.addPropertyChangeListener(this.propertyChangeListener);
        this.wrappers.add(wrapper);
        this.revalidate();
    }

    public void addAll(Collection items) {
        boolean oldAutoValidate = this.autoValidate;
        this.autoValidate = false;
        for (Object item : items) {
            if (item instanceof ComponentAligner) {
                this.add((ComponentAligner)item);
                continue;
            }
            this.add((JComponent)item);
        }
        this.autoValidate = oldAutoValidate;
        this.revalidate();
    }

    private void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(TEXT_PROPERTY, listener);
    }

    private Wrapper buildWrapper(ComponentAligner componentAligner) {
        return new ComponentAlignerWrapper(componentAligner);
    }

    private Wrapper buildWrapper(JComponent component) {
        return new ComponentWrapper(component);
    }

    private void firePropertyChange(int oldValue, int newValue) {
        if (this.changeSupport != null && oldValue != newValue) {
            this.changeSupport.firePropertyChange(TEXT_PROPERTY, new Integer(oldValue), new Integer(newValue));
        }
    }

    public int getMaximumWidth() {
        return this.maximumWidth;
    }

    private Dimension getPreferredSize() {
        if (this.maximumWidth == -1) {
            this.recalculateWidth();
        }
        return new Dimension(this.maximumWidth, 0);
    }

    private void initialize(boolean autoValidate) {
        this.autoValidate = autoValidate;
        this.maximumWidth = -1;
        this.propertyChangeListener = new PropertyChangeHandler();
        this.wrappers = new Vector();
    }

    private void invalidate(Object source) {
        Wrapper wrapper = this.retrieveWrapper(source);
        if (wrapper.isLocked()) {
            return;
        }
        Dimension size = wrapper.getCachedSize();
        size.width = 0;
        size.height = 0;
        wrapper.setPreferredSize(null);
    }

    public boolean isAutoValidate() {
        return this.autoValidate;
    }

    private void recalculateWidth() {
        int width = -1;
        Iterator iter = this.wrappers();
        while (iter.hasNext()) {
            Wrapper wrapper = (Wrapper)iter.next();
            Dimension size = wrapper.getCachedSize();
            if (size.height == 0) {
                Dimension newSize = wrapper.getPreferredSize();
                size.width = newSize.width;
                size.height = newSize.height;
            }
            width = Math.max(size.width, width);
        }
        this.locked = true;
        this.setMaximumWidth(width);
        this.locked = false;
    }

    public void remove(ComponentAligner componentAligner) {
        Wrapper wrapper = this.retrieveWrapper(componentAligner);
        wrapper.removePropertyChangeListener(this.propertyChangeListener);
        this.wrappers.remove(wrapper);
        this.revalidate();
    }

    public void remove(JComponent component) {
        Wrapper wrapper = this.retrieveWrapper(component);
        wrapper.removePropertyChangeListener(this.propertyChangeListener);
        this.wrappers.remove(wrapper);
        this.revalidate();
    }

    private void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(TEXT_PROPERTY, listener);
        if (!this.changeSupport.hasListeners(TEXT_PROPERTY)) {
            this.changeSupport = null;
        }
    }

    private Wrapper retrieveWrapper(Object source) {
        Iterator iter = this.wrappers();
        while (iter.hasNext()) {
            Wrapper wrapper = (Wrapper)iter.next();
            if (wrapper.getSource() != source) continue;
            return wrapper;
        }
        throw new IllegalArgumentException("Can't retrieve the Wrapper for " + source);
    }

    private void revalidate() {
        if (this.isAutoValidate()) {
            this.revalidatePreferredSize();
        }
    }

    public void revalidatePreferredSize() {
        this.recalculateWidth();
        this.revalidatePreferredSizeImp();
    }

    private void revalidatePreferredSizeImp() {
        Iterator iter = this.wrappers();
        while (iter.hasNext()) {
            Wrapper wrapper = (Wrapper)iter.next();
            Dimension size = wrapper.getCachedSize();
            size = new Dimension(this.maximumWidth, size.height);
            wrapper.setPreferredSize(size);
        }
    }

    public void setAutoValidate(boolean autoValidate) {
        boolean oldAutoValidate = this.isAutoValidate();
        this.autoValidate = autoValidate;
        if (!oldAutoValidate) {
            this.revalidate();
        }
    }

    private void setMaximumWidth(int maximumWidth) {
        int oldMaximumWidth = this.getMaximumWidth();
        this.maximumWidth = maximumWidth;
        this.firePropertyChange(oldMaximumWidth, maximumWidth);
    }

    private Iterator wrappers() {
        return this.wrappers.iterator();
    }

    private static interface Wrapper {
        public void addPropertyChangeListener(PropertyChangeListener var1);

        public Dimension getCachedSize();

        public Dimension getPreferredSize();

        public Object getSource();

        public boolean isLocked();

        public void removePropertyChangeListener(PropertyChangeListener var1);

        public void setPreferredSize(Dimension var1);
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            ComponentAligner.this.invalidate(e.getSource());
            ComponentAligner.this.revalidate();
        }
    }

    private class ComponentWrapper
    implements Wrapper {
        private Dimension cachedSize;
        private final JComponent component;

        private ComponentWrapper(JComponent component) {
            this.component = component;
            this.cachedSize = new Dimension();
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.component.addPropertyChangeListener(ComponentAligner.TEXT_PROPERTY, listener);
        }

        @Override
        public Dimension getCachedSize() {
            return this.cachedSize;
        }

        @Override
        public Dimension getPreferredSize() {
            return this.component.getPreferredSize();
        }

        @Override
        public Object getSource() {
            return this.component;
        }

        @Override
        public boolean isLocked() {
            return false;
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.component.removePropertyChangeListener(ComponentAligner.TEXT_PROPERTY, listener);
        }

        @Override
        public void setPreferredSize(Dimension preferredSize) {
            this.component.setPreferredSize(preferredSize);
        }
    }

    private class ComponentAlignerWrapper
    implements Wrapper {
        private Dimension cachedSize;
        private final ComponentAligner componentAligner;

        private ComponentAlignerWrapper(ComponentAligner componentAligner2) {
            this.componentAligner = componentAligner2;
            this.cachedSize = new Dimension(componentAligner2.maximumWidth, 0);
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.componentAligner.addPropertyChangeListener(listener);
        }

        @Override
        public Dimension getCachedSize() {
            return this.cachedSize;
        }

        @Override
        public Dimension getPreferredSize() {
            return this.componentAligner.getPreferredSize();
        }

        @Override
        public Object getSource() {
            return this.componentAligner;
        }

        @Override
        public boolean isLocked() {
            return this.componentAligner.locked;
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.componentAligner.removePropertyChangeListener(listener);
        }

        @Override
        public void setPreferredSize(Dimension preferredSize) {
            if (preferredSize == null) {
                this.componentAligner.maximumWidth = -1;
            } else if (this.componentAligner.maximumWidth != preferredSize.width) {
                this.componentAligner.maximumWidth = preferredSize.width;
                this.componentAligner.revalidatePreferredSizeImp();
            }
        }
    }
}

