/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.uitools;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.FileChooser;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;

public class FileChooserPanel
extends AbstractPanel {
    private PropertyValueModel filePathHolder;
    private FileHolder fileChooserRootFileHolder;
    private FileFilter fileChooserFileFilter;
    private FileHolder fileChooserDefaultDirectoryHolder;
    private static final long serialVersionUID = 1L;

    public FileChooserPanel(ApplicationContext context, PropertyValueModel filePathHolder, String labelKey) {
        this(context, filePathHolder, labelKey, null, 0, false);
    }

    public FileChooserPanel(ApplicationContext context, PropertyValueModel filePathHolder, String labelKey, boolean topAlignment) {
        this(context, filePathHolder, labelKey, null, 0, topAlignment);
    }

    public FileChooserPanel(ApplicationContext context, PropertyValueModel filePathHolder, String labelKey, String browseButtonKey) {
        this(context, filePathHolder, labelKey, browseButtonKey, 0, false);
    }

    public FileChooserPanel(ApplicationContext context, PropertyValueModel filePathHolder, String labelKey, String browseButtonKey, boolean topAlignment) {
        this(context, filePathHolder, labelKey, browseButtonKey, 0, topAlignment);
    }

    public FileChooserPanel(ApplicationContext context, PropertyValueModel filePathHolder, String labelKey, int fileSelectionMode) {
        this(context, filePathHolder, labelKey, null, fileSelectionMode);
    }

    public FileChooserPanel(ApplicationContext context, PropertyValueModel filePathHolder, String labelKey, int fileSelectionMode, boolean topAlignment) {
        this(context, filePathHolder, labelKey, null, fileSelectionMode, topAlignment);
    }

    public FileChooserPanel(ApplicationContext context, PropertyValueModel filePathHolder, String labelKey, String browseButtonKey, int fileSelectionMode) {
        this(context, filePathHolder, labelKey, null, fileSelectionMode, false);
    }

    public FileChooserPanel(ApplicationContext context, PropertyValueModel filePathHolder, String labelKey, String browseButtonKey, int fileSelectionMode, boolean topAlignment) {
        super(context);
        this.filePathHolder = filePathHolder;
        this.fileChooserRootFileHolder = new SimpleFileHolder();
        this.fileChooserDefaultDirectoryHolder = new SimpleFileHolder();
        this.initialize(labelKey, browseButtonKey, fileSelectionMode, topAlignment);
    }

    private void initialize(String labelKey, String browseButtonKey, int fileSelectionMode, boolean topAlignment) {
        GridBagConstraints constraints = new GridBagConstraints();
        boolean labelVisible = this.labelVisible();
        JLabel fileLabel = this.buildLabel(labelKey);
        fileLabel.setVisible(labelVisible);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = topAlignment ? 2 : 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)fileLabel, constraints);
        this.addAlignLeft(fileLabel);
        JTextField fileTextField = new JTextField(new DocumentAdapter(this.filePathHolder), null, 1);
        constraints.gridx = topAlignment ? 0 : 1;
        constraints.gridy = topAlignment ? 1 : 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(topAlignment ? 1 : 0, topAlignment ? 0 : (labelVisible ? 5 : 0), 0, 0);
        this.add((Component)fileTextField, constraints);
        fileLabel.setLabelFor(fileTextField);
        JButton fileChooserButton = this.buildFileChooserButton(browseButtonKey, fileSelectionMode);
        SwingComponentFactory.updateButtonAccessibleName(fileLabel, fileChooserButton);
        constraints.gridx = topAlignment ? 1 : 2;
        constraints.gridy = topAlignment ? 1 : 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 10;
        constraints.insets = new Insets(topAlignment ? 1 : 0, 5, 0, 0);
        this.add((Component)fileChooserButton, constraints);
        this.addAlignRight(fileChooserButton);
    }

    protected JButton buildFileChooserButton(String browseButtonKey, int fileSelectionMode) {
        String buttonText = browseButtonKey != null ? browseButtonKey : this.browseButtonKey();
        JButton fileChooserButton = this.buildButton(buttonText);
        fileChooserButton.addActionListener(this.buildFileActionListener(fileSelectionMode));
        return fileChooserButton;
    }

    protected String browseButtonKey() {
        return "FILE_CHOOSER_PANEL.BROWSE_BUTTON_TEXT";
    }

    protected boolean labelVisible() {
        return true;
    }

    private ActionListener buildFileActionListener(final int fileSelectionMode) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooserPanel.this.promptForFile(fileSelectionMode);
            }
        };
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        Component[] components = this.getComponents();
        for (int i = 0; i < components.length; ++i) {
            components[i].setEnabled(enabled);
        }
    }

    @Override
    public void requestFocus() {
        this.getComponent(1).requestFocus();
    }

    public void setFileChooserRootFileHolder(FileHolder fileChooserRootFileHolder) {
        if (fileChooserRootFileHolder == null) {
            throw new NullPointerException();
        }
        this.fileChooserRootFileHolder = fileChooserRootFileHolder;
    }

    public void setFileChooserFileFilter(FileFilter fileChooserFileFilter) {
        this.fileChooserFileFilter = fileChooserFileFilter;
    }

    public void setFileChooserDefaultDirectoryHolder(FileHolder fileChooserDefaultDirectoryHolder) {
        if (fileChooserDefaultDirectoryHolder == null) {
            throw new NullPointerException();
        }
        this.fileChooserDefaultDirectoryHolder = fileChooserDefaultDirectoryHolder;
    }

    private String getFilePath() {
        return (String)this.filePathHolder.getValue();
    }

    protected File getFileChooserDefaultDirectory() {
        return this.fileChooserDefaultDirectoryHolder.getFile();
    }

    private void setFileChooserDefaultDirectory(File directory) {
        this.fileChooserDefaultDirectoryHolder.setFile(directory);
    }

    private File getFile() {
        String filePath = this.getFilePath();
        if (filePath == null || filePath.length() == 0) {
            return null;
        }
        return new File(filePath);
    }

    private void setFilePath(String filePath) {
        this.filePathHolder.setValue(filePath);
    }

    void promptForFile(int fileSelectionMode) {
        Window window = SwingUtilities.getWindowAncestor(this);
        File file = this.getFile();
        FileChooser fileChooser = new FileChooser(this.getFileChooserDefaultDirectory(), this.fileChooserRootFileHolder.getFile());
        fileChooser.setFileSelectionMode(fileSelectionMode);
        fileChooser.setSelectedFile(file);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setFileFilter(this.fileChooserFileFilter);
        if (fileChooser.showOpenDialog(window) == 0) {
            this.setFilePath(fileChooser.getSelectedFile().getPath());
            this.setFileChooserDefaultDirectory(fileChooser.getCurrentDirectory());
        }
    }

    public class SimpleFileHolder
    implements FileHolder {
        private File file;

        @Override
        public File getFile() {
            return this.file;
        }

        @Override
        public void setFile(File file) {
            this.file = file;
        }
    }

    public static interface FileHolder {
        public File getFile();

        public void setFile(File var1);
    }
}

