/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.broker;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.CheckList;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.CellRendererAdapter;

final class SessionsListDialog
extends AbstractDialog {
    private final CollectionValueModel itemHolder;
    private final CellRendererAdapter labelDecorator;
    private ObjectListSelectionModel selectionModel;

    SessionsListDialog(WorkbenchContext context, CollectionValueModel itemHolder, ObjectListSelectionModel selectionModel, CellRendererAdapter labelDecorator) {
        super(context, context.getApplicationContext().getResourceRepository().getString("SESSIONS_LIST_DIALOG_TITLE"));
        this.itemHolder = itemHolder;
        this.labelDecorator = labelDecorator;
        this.selectionModel = selectionModel;
    }

    @Override
    protected String helpTopicId() {
        return "dialog.sessions";
    }

    @Override
    protected Component buildMainPanel() {
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel container = new JPanel(new GridBagLayout());
        JLabel sessionsListLabel = new JLabel(this.resourceRepository().getString("SESSIONS_LIST_DIALOG_SESSIONS_LIST"));
        sessionsListLabel.setDisplayedMnemonic(this.resourceRepository().getMnemonic("SESSIONS_LIST_DIALOG_SESSIONS_LIST"));
        sessionsListLabel.setDisplayedMnemonicIndex(this.resourceRepository().getMnemonicIndex("SESSIONS_LIST_DIALOG_SESSIONS_LIST"));
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        container.add((Component)sessionsListLabel, constraints);
        CheckList checkList = new CheckList(this.itemHolder, (ListSelectionModel)this.selectionModel, this.labelDecorator);
        this.installSelectionModelListener();
        Dimension size = checkList.getPreferredSize();
        size.width = Math.max(300, size.width);
        size.height = Math.max(100, size.height);
        checkList.setPreferredSize(size);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(1, 0, 0, 0);
        container.add((Component)checkList, constraints);
        sessionsListLabel.setLabelFor(checkList);
        return container;
    }

    private void installSelectionModelListener() {
        this.selectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                SessionsListDialog.this.getOKAction().setEnabled(SessionsListDialog.this.selectionModel.getSelectedValues().length > 0);
            }
        });
    }

    @Override
    protected void prepareToShow() {
        super.prepareToShow();
        this.getOKAction().setEnabled(false);
    }
}

