/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.pool;

import javax.swing.JOptionPane;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.AbstractApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ConnectionPoolAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ServerSessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.ui.pool.NamedConnectionPoolCreationDialog;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public class AddNewNamedPoolAction
extends AbstractFrameworkAction {
    public AddNewNamedPoolAction(WorkbenchContext context) {
        super(context);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.initializeText("ADD_NAMED_CONNECTION_POOL");
        this.initializeMnemonic("ADD_NAMED_CONNECTION_POOL");
        this.initializeIcon("CONNECTION_POOL");
        this.initializeToolTipText("ADD_NAMED_CONNECTION_POOL.TOOL_TIP");
    }

    @Override
    protected void execute(ApplicationNode selectedNode) {
        ServerSessionAdapter session = (ServerSessionAdapter)selectedNode.getValue();
        SimplePropertyValueModel stringHolder = new SimplePropertyValueModel();
        NamedConnectionPoolCreationDialog dialog = new NamedConnectionPoolCreationDialog(this.getWorkbenchContext(), stringHolder, session.poolNames());
        dialog.show();
        if (dialog.wasConfirmed()) {
            this.navigatorSelectionModel().pushExpansionState();
            ConnectionPoolAdapter newPool = session.addConnectionPoolNamed((String)stringHolder.getValue());
            this.navigatorSelectionModel().popAndRestoreExpansionState();
            ((AbstractApplicationNode)selectedNode.getProjectRoot()).selectDescendantNodeForValue((Node)newPool, this.navigatorSelectionModel());
        }
    }

    @Override
    public void execute() {
        super.execute();
    }

    private void promptUserToTurnOffExternalConnectionPooling() {
        JOptionPane.showMessageDialog(this.getWorkbenchContext().getCurrentWindow(), this.resourceRepository().getString("EXTERNAL_CONNECTION_POOLING_ENABLED_WARNING_MESSAGE"));
    }
}

