/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.session.basic;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DatabaseSessionAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;

abstract class AbstractSessionProjectlPane
extends AbstractSubjectPanel {
    AbstractSessionProjectlPane(ValueModel subjectHolder, WorkbenchContextHolder contextHolder) {
        super(subjectHolder, contextHolder);
    }

    protected abstract JButton buildEditButton();

    private Document buildPrimaryProjectDocumentAdapter() {
        return new DocumentAdapter(this.buildPrimaryProjectNameHolder());
    }

    protected abstract PropertyValueModel buildPrimaryProjectNameHolder();

    protected JTextField buildPrimaryProjectTextField(Document document) {
        JTextField textField = SwingComponentFactory.buildTextField(document);
        textField.setColumns(1);
        return textField;
    }

    private ButtonModel buildUseMultipleProjectsCheckBoxAdapter() {
        return new CheckBoxModelAdapter(this.buildUseMultipleProjectsHolder());
    }

    private PropertyValueModel buildUseMultipleProjectsHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "useAdditionalProjects"){

            @Override
            protected Object getValueFromSubject() {
                DatabaseSessionAdapter session = (DatabaseSessionAdapter)this.subject;
                return session.usesAdditionalProjects();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                DatabaseSessionAdapter session = (DatabaseSessionAdapter)this.subject;
                session.setUseAdditionalProjects(Boolean.TRUE.equals(value));
            }
        };
    }

    @Override
    protected void initializeLayout() {
        GridBagConstraints constraints = new GridBagConstraints();
        JComponent pane = this.buildLabeledComponent("SESSION_PROJECT_PRIMARY_PROJECT_FIELD", this.buildPrimaryProjectTextField(this.buildPrimaryProjectDocumentAdapter()), this.buildEditButton());
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)pane, constraints);
        JCheckBox useMultipleProjectsCheckBox = this.buildCheckBox("SESSION_PROJECT_USE_MULTIPLE_PROJECTS_BUTTON", this.buildUseMultipleProjectsCheckBoxAdapter());
        useMultipleProjectsCheckBox.setMargin(new Insets(0, 0, 0, 0));
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 1.0;
        constraints.fill = 0;
        constraints.anchor = 23;
        constraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)useMultipleProjectsCheckBox, constraints);
    }
}

