/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JWindow;

public final class SplashScreen
extends JWindow
implements Runnable {
    private Thread thread;
    private int timeout;

    public SplashScreen(Frame owner, String copyright, Icon image, int timeout) {
        super(owner);
        this.timeout = timeout;
        this.initialize(copyright, image);
    }

    public SplashScreen(Frame owner, String copyright, Icon image) {
        this(owner, copyright, image, 0);
    }

    public SplashScreen(Frame owner, Icon image) {
        this(owner, "", image);
    }

    private void initialize(String copyright, Icon image) {
        JLabel copyrightLabel = new JLabel(copyright, 2);
        copyrightLabel.setFont(new Font("dialog", 0, 12));
        int copyrightWidth = copyrightLabel.getPreferredSize().width;
        int copyrightHeight = copyrightLabel.getPreferredSize().height;
        JLabel imageLabel = new JLabel(image);
        int imageWidth = image.getIconWidth();
        int imageHeight = image.getIconHeight();
        imageLabel.setBounds(0, 0, imageWidth, imageHeight);
        copyrightLabel.setBounds(10, imageHeight - 26, copyrightWidth, copyrightHeight);
        this.getContentPane().add(copyrightLabel);
        this.getContentPane().add(imageLabel);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int positionX = (screenSize.width - imageWidth) / 2;
        int positionY = (screenSize.height - imageHeight) / 2;
        this.setBounds(positionX, positionY, imageWidth, imageHeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.setVisible(true);
        SplashScreen splashScreen = this;
        synchronized (splashScreen) {
            try {
                this.wait(this.timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.setVisible(false);
        this.dispose();
    }

    public synchronized void start() {
        if (this.thread != null) {
            throw new IllegalStateException("splash screen is already started");
        }
        this.thread = new Thread((Runnable)this, "Splash Screen");
        this.thread.start();
    }

    public synchronized void stop() {
        if (this.thread == null) {
            throw new IllegalStateException("splash screen is not started");
        }
        if (this.thread.isAlive()) {
            this.thread.interrupt();
        }
    }
}

