/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app.swing;

import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeListener;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class ToggleButtonModelAdapter
extends JToggleButton.ToggleButtonModel {
    protected boolean defaultValue;
    protected PropertyValueModel booleanHolder;
    protected PropertyChangeListener booleanChangeListener;

    private ToggleButtonModelAdapter() {
        this.initialize();
    }

    public ToggleButtonModelAdapter(PropertyValueModel booleanHolder, boolean defaultValue) {
        this();
        if (booleanHolder == null) {
            throw new NullPointerException();
        }
        this.booleanHolder = booleanHolder;
        this.defaultValue = defaultValue;
    }

    public ToggleButtonModelAdapter(PropertyValueModel booleanHolder) {
        this(booleanHolder, false);
    }

    protected void initialize() {
        this.booleanChangeListener = this.buildBooleanChangeListener();
    }

    protected PropertyChangeListener buildBooleanChangeListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                ToggleButtonModelAdapter.this.booleanChanged(e);
            }

            public String toString() {
                return "boolean listener";
            }
        };
    }

    @Override
    public void setSelected(boolean b) {
        if (this.isSelected() != b) {
            super.setSelected(b);
            this.booleanHolder.setValue(b);
        }
    }

    @Override
    public void addActionListener(ActionListener l) {
        if (this.hasNoListeners()) {
            this.engageModel();
        }
        super.addActionListener(l);
    }

    @Override
    public void removeActionListener(ActionListener l) {
        super.removeActionListener(l);
        if (this.hasNoListeners()) {
            this.disengageModel();
        }
    }

    @Override
    public void addItemListener(ItemListener l) {
        if (this.hasNoListeners()) {
            this.engageModel();
        }
        super.addItemListener(l);
    }

    @Override
    public void removeItemListener(ItemListener l) {
        super.removeItemListener(l);
        if (this.hasNoListeners()) {
            this.disengageModel();
        }
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        if (this.hasNoListeners()) {
            this.engageModel();
        }
        super.addChangeListener(l);
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        super.removeChangeListener(l);
        if (this.hasNoListeners()) {
            this.disengageModel();
        }
    }

    protected boolean hasNoListeners() {
        return this.listenerList.getListenerCount() == 0;
    }

    protected boolean getDefaultValue() {
        return this.defaultValue;
    }

    protected void setSelected(Boolean value) {
        if (value == null) {
            this.setSelected(this.getDefaultValue());
        } else {
            this.setSelected((boolean)value);
        }
    }

    protected void booleanChanged(PropertyChangeEvent e) {
        this.setSelected((Boolean)e.getNewValue());
    }

    protected void engageModel() {
        this.booleanHolder.addPropertyChangeListener("value", this.booleanChangeListener);
        this.setSelected((Boolean)this.booleanHolder.getValue());
    }

    protected void disengageModel() {
        this.booleanHolder.removePropertyChangeListener("value", this.booleanChangeListener);
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.booleanHolder);
    }
}

