/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.cell;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.eclipse.persistence.tools.workbench.uitools.cell.TableCellEditorAdapter;
import org.eclipse.persistence.tools.workbench.uitools.swing.CachingComboBoxModel;
import org.eclipse.persistence.tools.workbench.uitools.swing.EmptyIcon;
import org.eclipse.persistence.tools.workbench.uitools.swing.NonCachingComboBoxModel;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;

public class ComboBoxTableCellRenderer
implements TableCellEditorAdapter.Renderer {
    private JComboBox comboBox;
    private CachingComboBoxModel model;
    private ListCellRenderer renderer;
    Object value;
    private static int height = -1;
    private boolean fakeFocusFlag;
    protected TableCellEditorAdapter.ImmediateEditListener immediateEditListener;
    private static Color defaultForeground;
    private static Color defaultBackground;
    private static final Border NO_FOCUS_BORDER;
    public static JLabel prototypeLabel;

    private ComboBoxTableCellRenderer() {
        this.initialize();
    }

    public ComboBoxTableCellRenderer(ComboBoxModel model) {
        this(new NonCachingComboBoxModel(model));
    }

    public ComboBoxTableCellRenderer(CachingComboBoxModel model) {
        this();
        this.model = model;
    }

    public ComboBoxTableCellRenderer(ComboBoxModel model, ListCellRenderer renderer) {
        this(new NonCachingComboBoxModel(model), renderer);
    }

    public ComboBoxTableCellRenderer(CachingComboBoxModel model, ListCellRenderer renderer) {
        this(model);
        this.renderer = renderer;
    }

    protected void initialize() {
        if (height == -1) {
            JComboBox<String> comboBox = new JComboBox<String>();
            comboBox.addItem("m");
            height = comboBox.getPreferredSize().height + 2;
            defaultForeground = comboBox.getForeground();
            defaultBackground = comboBox.getBackground();
        }
    }

    protected JComboBox buildComboBox() {
        JComboBox result = new JComboBox(){
            private boolean fakeFocus;

            @Override
            public boolean hasFocus() {
                return this.fakeFocus || super.hasFocus();
            }

            @Override
            public void paint(Graphics g) {
                this.fakeFocus = ComboBoxTableCellRenderer.this.fakeFocusFlag;
                super.paint(g);
                this.fakeFocus = false;
            }

            public void setRenderer(final ListCellRenderer aRenderer) {
                super.setRenderer(new ListCellRenderer(){

                    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                        if (value == prototypeLabel) {
                            return prototypeLabel;
                        }
                        return aRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    }
                });
            }

            @Override
            public int getSelectedIndex() {
                boolean listNotCached;
                boolean bl = listNotCached = !ComboBoxTableCellRenderer.this.listIsCached();
                if (listNotCached) {
                    ComboBoxTableCellRenderer.this.cacheList();
                }
                int index = super.getSelectedIndex();
                if (listNotCached) {
                    ComboBoxTableCellRenderer.this.uncacheList();
                }
                return index;
            }
        };
        result.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        result.addActionListener(this.buildActionListener());
        result.addPopupMenuListener(this.buildPopupMenuListener());
        result.setPrototypeDisplayValue(prototypeLabel);
        this.getListBox(result).setPrototypeCellValue(prototypeLabel);
        return result;
    }

    private JList getListBox(JComboBox result) {
        return (JList)ClassTools.getFieldValue((Object)result.getUI(), (String)"listBox");
    }

    private ActionListener buildActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox comboBox = (JComboBox)e.getSource();
                Object selectedItem = comboBox.getSelectedItem();
                if (ComboBoxTableCellRenderer.this.value != selectedItem) {
                    ComboBoxTableCellRenderer.this.value = comboBox.getSelectedItem();
                    ComboBoxTableCellRenderer.this.immediateEdit();
                }
            }
        };
    }

    void immediateEdit() {
        if (this.immediateEditListener != null) {
            this.immediateEditListener.immediateEdit();
        }
    }

    private PopupMenuListener buildPopupMenuListener() {
        return new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                if (ComboBoxTableCellRenderer.this.listIsCached()) {
                    ComboBoxTableCellRenderer.this.uncacheList();
                }
                ComboBoxTableCellRenderer.this.cacheList();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                if (ComboBoxTableCellRenderer.this.listIsCached()) {
                    ComboBoxTableCellRenderer.this.uncacheList();
                }
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                if (ComboBoxTableCellRenderer.this.listIsCached()) {
                    ComboBoxTableCellRenderer.this.uncacheList();
                }
            }
        };
    }

    private void cacheList() {
        this.model.cacheList();
    }

    private void uncacheList() {
        this.model.uncacheList();
    }

    private boolean listIsCached() {
        return this.model.isCached();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object val, boolean selected, boolean hasFocus, int row, int column) {
        boolean bl = this.fakeFocusFlag = selected || hasFocus;
        if (this.comboBox == null) {
            this.comboBox = this.buildComboBox();
            this.comboBox.setComponentOrientation(table.getComponentOrientation());
            this.comboBox.setModel(this.model);
            if (this.renderer != null) {
                this.comboBox.setRenderer(this.renderer);
            }
            this.comboBox.setFont(table.getFont());
            this.comboBox.setEnabled(table.isEnabled());
            this.comboBox.setBorder(this.border(table, val, selected, hasFocus, row, column));
        }
        this.model.setSelectedItem(val);
        return this.comboBox;
    }

    protected Color foregroundColor(JTable table, Object val, boolean selected, boolean hasFocus, int row, int column) {
        if (selected) {
            if (hasFocus && table.isCellEditable(row, column)) {
                return defaultForeground;
            }
            return table.getSelectionForeground();
        }
        return defaultForeground;
    }

    protected Color backgroundColor(JTable table, Object val, boolean selected, boolean hasFocus, int row, int column) {
        if (selected) {
            if (hasFocus && table.isCellEditable(row, column)) {
                return defaultBackground;
            }
            return table.getSelectionBackground();
        }
        return defaultBackground;
    }

    protected Border border(JTable table, Object val, boolean selected, boolean hasFocus, int row, int column) {
        return hasFocus ? UIManager.getBorder("Table.focusCellHighlightBorder") : NO_FOCUS_BORDER;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setImmediateEditListener(TableCellEditorAdapter.ImmediateEditListener listener) {
        this.immediateEditListener = listener;
    }

    @Override
    public void commit() {
    }

    public int getPreferredHeight() {
        return height;
    }

    static {
        NO_FOCUS_BORDER = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        prototypeLabel = new JLabel("Prototype", new EmptyIcon(16), 10);
    }
}

