/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.project;

import java.io.File;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeDirectCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.sessions.DatasourceLogin;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.factories.ProjectClassGenerator;
import org.eclipse.persistence.sessions.factories.XMLProjectWriter;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.ProjectSubFileComponentContainer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.DescriptorCreationFailureEvent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.DescriptorCreationFailureListener;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.DescriptorStringHolder;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.InterfaceDescriptorCreationException;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWInterfaceDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWAggregateMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.ExternalClassLoadFailureContainer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.ExternalClassLoadFailureEvent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProjectDefaultsPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.relational.MWRelationalProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.xml.MWEisProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.xml.MWOXProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.SPIManager;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClassDescription;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClassNotFoundException;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.Classpath;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.ManifestInterrogator;
import org.eclipse.persistence.tools.workbench.utility.events.ChangeNotifier;
import org.eclipse.persistence.tools.workbench.utility.events.DefaultChangeNotifier;
import org.eclipse.persistence.tools.workbench.utility.io.FileTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.CompositeIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.FilteringIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.string.AffixStrippingPartialStringComparatorEngine;
import org.eclipse.persistence.tools.workbench.utility.string.ExhaustivePartialStringComparatorEngine;
import org.eclipse.persistence.tools.workbench.utility.string.PartialStringComparator;
import org.eclipse.persistence.tools.workbench.utility.string.PartialStringComparatorEngine;

public abstract class MWProject
extends MWModel
implements ProjectSubFileComponentContainer {
    private volatile String name;
    public static final String NAME_PROPERTY = "name";
    private SPIManager spiManager;
    private Collection descriptors;
    public static final String DESCRIPTORS_COLLECTION = "descriptors";
    private MWClassRepository classRepository;
    private MWProjectDefaultsPolicy defaultsPolicy;
    private volatile String deploymentXMLFileName;
    public static final String DEPLOYMENT_XML_FILE_NAME_PROPERTY = "deploymentXMLFileName";
    private volatile String projectSourceClassName;
    public static final String PROJECT_SOURCE_CLASS_NAME_PROPERTY = "projectSourceClassName";
    private volatile String projectSourceDirectoryName;
    public static final String PROJECT_SOURCE_DIRECTORY_NAME_PROPERTY = "projectSourceDirectoryName";
    private volatile String modelSourceDirectoryName;
    public static final String MODEL_SOURCE_DIRECTORY_NAME_PROPERTY = "modelSourceDirectoryName";
    private volatile File saveDirectory;
    public static final String SAVE_DIRECTORY_PROPERTY = "saveDirectory";
    private Collection descriptorNames;
    private static final String DESCRIPTOR_NAMES_COLLECTION = "descriptorNames";
    private String version;
    private volatile boolean legacyProject;
    private ChangeNotifier changeNotifier;
    private Node.Validator validator;
    private volatile boolean validating;
    public static final String VALIDATING_PROPERTY = "validating";
    private volatile boolean usesWeaving;
    public static final String USES_WEAVING_PROPERTY = "usesWeaving";
    public static final String CURRENT_PROJECT_ROOT_ELEMENT_NAME = "project";
    public static final String CURRENT_SCHEMA_VERSION_ELEMENT_NAME = "schema-version";
    public static final String CURRENT_SCHEMA_VERSION = "7.0";
    private static final String SUB_DIRECTORY_NAME = "descriptors";
    public static final String FILE_NAME_EXTENSION = ".mwp";
    private static final ManifestInterrogator MANIFEST_INTERROGATOR = new ManifestInterrogator(MWProject.class, new LocalManifestDefaults());
    protected static final float CLASS_META_DATA_PARTIAL_STRING_AFFIX_THRESHOLD = 0.8f;
    protected static final PartialStringComparatorEngine CLASS_META_DATA_NAME_COMPARATOR_ENGINE = AffixStrippingPartialStringComparatorEngine.forPrefixStripping(AffixStrippingPartialStringComparatorEngine.forSuffixStripping((PartialStringComparatorEngine)new ExhaustivePartialStringComparatorEngine(PartialStringComparator.DEFAULT_COMPARATOR), 0.8f), 0.8f);

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWProject.class);
        descriptor.setDefaultRootElement(CURRENT_PROJECT_ROOT_ELEMENT_NAME);
        InheritancePolicy ip = descriptor.getInheritancePolicy();
        ip.setClassIndicatorFieldName("@type");
        ip.addClassIndicator(MWRelationalProject.class, (Object)"relational");
        ip.addClassIndicator(MWOXProject.class, (Object)"o-x");
        ip.addClassIndicator(MWEisProject.class, (Object)"eis");
        descriptor.addDirectMapping(NAME_PROPERTY, "name/text()");
        ((XMLDirectMapping)descriptor.addDirectMapping("comment", "comment/text()")).setNullValue((Object)"");
        descriptor.addDirectMapping("version", "getProductVersionForTopLink", "setProductVersionForTopLink", "product-version/text()");
        descriptor.addDirectMapping("schemaVersion", "getSchemaVersionForTopLink", "setSchemaVersionForTopLink", "schema-version/text()");
        XMLCompositeObjectMapping repositoryMapping = new XMLCompositeObjectMapping();
        repositoryMapping.setAttributeName("classRepository");
        repositoryMapping.setReferenceClass(MWClassRepository.class);
        repositoryMapping.setXPath("class-repository");
        descriptor.addMapping((DatabaseMapping)repositoryMapping);
        XMLCompositeDirectCollectionMapping descriptorNamesMapping = new XMLCompositeDirectCollectionMapping();
        descriptorNamesMapping.setAttributeName(DESCRIPTOR_NAMES_COLLECTION);
        descriptorNamesMapping.setSetMethodName("setDescriptorNamesForTopLink");
        descriptorNamesMapping.setGetMethodName("getDescriptorNamesForTopLink");
        descriptorNamesMapping.useCollectionClass(HashSet.class);
        descriptorNamesMapping.setXPath("descriptor-names/descriptor-name/text()");
        descriptor.addMapping((DatabaseMapping)descriptorNamesMapping);
        XMLCompositeObjectMapping defaultsPolicyMapping = new XMLCompositeObjectMapping();
        defaultsPolicyMapping.setAttributeName("defaultsPolicy");
        defaultsPolicyMapping.setReferenceClass(MWProjectDefaultsPolicy.class);
        defaultsPolicyMapping.setXPath("defaults-policy");
        descriptor.addMapping((DatabaseMapping)defaultsPolicyMapping);
        XMLDirectMapping deploymentXMLFileNameMapping = new XMLDirectMapping();
        deploymentXMLFileNameMapping.setAttributeName(DEPLOYMENT_XML_FILE_NAME_PROPERTY);
        deploymentXMLFileNameMapping.setSetMethodName("setDeploymentXMLFileNameForTopLink");
        deploymentXMLFileNameMapping.setGetMethodName("getDeploymentXMLFileNameForTopLink");
        deploymentXMLFileNameMapping.setXPath("deployment-xml-file/text()");
        deploymentXMLFileNameMapping.setNullValue((Object)"");
        descriptor.addMapping((DatabaseMapping)deploymentXMLFileNameMapping);
        XMLDirectMapping projectSourceClassNameMapping = new XMLDirectMapping();
        projectSourceClassNameMapping.setAttributeName(PROJECT_SOURCE_CLASS_NAME_PROPERTY);
        projectSourceClassNameMapping.setXPath("project-source/class/text()");
        projectSourceClassNameMapping.setNullValue((Object)"");
        descriptor.addMapping((DatabaseMapping)projectSourceClassNameMapping);
        XMLDirectMapping projectSourceDirectoryNameMapping = new XMLDirectMapping();
        projectSourceDirectoryNameMapping.setAttributeName(PROJECT_SOURCE_DIRECTORY_NAME_PROPERTY);
        projectSourceDirectoryNameMapping.setSetMethodName("setProjectSourceDirectoryNameForTopLink");
        projectSourceDirectoryNameMapping.setGetMethodName("getProjectSourceDirectoryNameForTopLink");
        projectSourceDirectoryNameMapping.setXPath("project-source/directory/text()");
        projectSourceDirectoryNameMapping.setNullValue((Object)"");
        descriptor.addMapping((DatabaseMapping)projectSourceDirectoryNameMapping);
        XMLDirectMapping modelSourceDirectoryNameMapping = new XMLDirectMapping();
        modelSourceDirectoryNameMapping.setAttributeName(MODEL_SOURCE_DIRECTORY_NAME_PROPERTY);
        modelSourceDirectoryNameMapping.setSetMethodName("setModelSourceDirectoryNameForTopLink");
        modelSourceDirectoryNameMapping.setGetMethodName("getModelSourceDirectoryNameForTopLink");
        modelSourceDirectoryNameMapping.setXPath("model-source/directory/text()");
        modelSourceDirectoryNameMapping.setNullValue((Object)"");
        descriptor.addMapping((DatabaseMapping)modelSourceDirectoryNameMapping);
        XMLDirectMapping useWeavingMapping = new XMLDirectMapping();
        useWeavingMapping.setAttributeName(USES_WEAVING_PROPERTY);
        useWeavingMapping.setXPath("use-weaving/text()");
        useWeavingMapping.setNullValue((Object)Boolean.FALSE);
        descriptor.addMapping((DatabaseMapping)useWeavingMapping);
        return descriptor;
    }

    public static XMLDescriptor buildLegacy60Descriptor() {
        XMLDescriptor descriptor = MWModel.legacy60BuildStandardDescriptor();
        descriptor.setJavaClass(MWProject.class);
        descriptor.setDefaultRootElement(CURRENT_PROJECT_ROOT_ELEMENT_NAME);
        InheritancePolicy ip = descriptor.getInheritancePolicy();
        ip.setClassIndicatorFieldName("@type");
        ip.addClassIndicator(MWRelationalProject.class, (Object)"relational");
        ip.addClassIndicator(MWOXProject.class, (Object)"o-x");
        ip.addClassIndicator(MWEisProject.class, (Object)"eis");
        descriptor.addDirectMapping(NAME_PROPERTY, "name/text()");
        ((XMLDirectMapping)descriptor.addDirectMapping("comment", "comment/text()")).setNullValue((Object)"");
        descriptor.addDirectMapping("version", "getProductVersionForTopLink", "setProductVersionForTopLink", "product-version/text()");
        descriptor.addDirectMapping("schemaVersion", "getSchemaVersionForTopLink", "setSchemaVersionForTopLink", "schema-version/text()");
        XMLCompositeObjectMapping repositoryMapping = new XMLCompositeObjectMapping();
        repositoryMapping.setAttributeName("classRepository");
        repositoryMapping.setReferenceClass(MWClassRepository.class);
        repositoryMapping.setXPath("class-repository");
        descriptor.addMapping((DatabaseMapping)repositoryMapping);
        XMLCompositeDirectCollectionMapping descriptorNamesMapping = new XMLCompositeDirectCollectionMapping();
        descriptorNamesMapping.setAttributeName(DESCRIPTOR_NAMES_COLLECTION);
        descriptorNamesMapping.setSetMethodName("setDescriptorNamesForTopLink");
        descriptorNamesMapping.setGetMethodName("getDescriptorNamesForTopLink");
        descriptorNamesMapping.useCollectionClass(HashSet.class);
        descriptorNamesMapping.setXPath("descriptor-names/descriptor-name/text()");
        descriptor.addMapping((DatabaseMapping)descriptorNamesMapping);
        XMLCompositeObjectMapping defaultsPolicyMapping = new XMLCompositeObjectMapping();
        defaultsPolicyMapping.setAttributeName("defaultsPolicy");
        defaultsPolicyMapping.setReferenceClass(MWProjectDefaultsPolicy.class);
        defaultsPolicyMapping.setXPath("defaults-policy");
        descriptor.addMapping((DatabaseMapping)defaultsPolicyMapping);
        XMLDirectMapping deploymentXMLFileNameMapping = new XMLDirectMapping();
        deploymentXMLFileNameMapping.setAttributeName(DEPLOYMENT_XML_FILE_NAME_PROPERTY);
        deploymentXMLFileNameMapping.setSetMethodName("setDeploymentXMLFileNameForTopLink");
        deploymentXMLFileNameMapping.setGetMethodName("getDeploymentXMLFileNameForTopLink");
        deploymentXMLFileNameMapping.setXPath("deployment-xml-file/text()");
        deploymentXMLFileNameMapping.setNullValue((Object)"");
        descriptor.addMapping((DatabaseMapping)deploymentXMLFileNameMapping);
        XMLDirectMapping projectSourceClassNameMapping = new XMLDirectMapping();
        projectSourceClassNameMapping.setAttributeName(PROJECT_SOURCE_CLASS_NAME_PROPERTY);
        projectSourceClassNameMapping.setXPath("project-source/class/text()");
        projectSourceClassNameMapping.setNullValue((Object)"");
        descriptor.addMapping((DatabaseMapping)projectSourceClassNameMapping);
        XMLDirectMapping projectSourceDirectoryNameMapping = new XMLDirectMapping();
        projectSourceDirectoryNameMapping.setAttributeName(PROJECT_SOURCE_DIRECTORY_NAME_PROPERTY);
        projectSourceDirectoryNameMapping.setSetMethodName("setProjectSourceDirectoryNameForTopLink");
        projectSourceDirectoryNameMapping.setGetMethodName("getProjectSourceDirectoryNameForTopLink");
        projectSourceDirectoryNameMapping.setXPath("project-source/directory/text()");
        projectSourceDirectoryNameMapping.setNullValue((Object)"");
        descriptor.addMapping((DatabaseMapping)projectSourceDirectoryNameMapping);
        XMLDirectMapping modelSourceDirectoryNameMapping = new XMLDirectMapping();
        modelSourceDirectoryNameMapping.setAttributeName(MODEL_SOURCE_DIRECTORY_NAME_PROPERTY);
        modelSourceDirectoryNameMapping.setSetMethodName("setModelSourceDirectoryNameForTopLink");
        modelSourceDirectoryNameMapping.setGetMethodName("getModelSourceDirectoryNameForTopLink");
        modelSourceDirectoryNameMapping.setXPath("model-source/directory/text()");
        modelSourceDirectoryNameMapping.setNullValue((Object)"");
        descriptor.addMapping((DatabaseMapping)modelSourceDirectoryNameMapping);
        return descriptor;
    }

    protected MWProject() {
    }

    protected MWProject(String name, SPIManager spiManager) {
        super(null);
        this.name = name;
        this.spiManager = spiManager;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.descriptors = new Vector();
        this.changeNotifier = DefaultChangeNotifier.instance();
        this.validator = NULL_VALIDATOR;
        this.validating = false;
    }

    @Override
    protected void initialize(Node parent) {
        super.initialize(parent);
        this.descriptorNames = new HashSet();
        this.classRepository = new MWClassRepository(this);
        this.defaultsPolicy = this.buildDefaultsPolicy();
        this.deploymentXMLFileName = "";
        this.projectSourceClassName = "";
        this.projectSourceDirectoryName = "";
        this.modelSourceDirectoryName = "";
        this.usesWeaving = false;
    }

    protected abstract MWProjectDefaultsPolicy buildDefaultsPolicy();

    @Override
    protected void checkParent(Node parent) {
        if (parent != null) {
            throw new IllegalArgumentException("An MWProject should not have a parent");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        Collection collection = this.descriptors;
        synchronized (collection) {
            children.addAll(this.descriptors);
        }
        children.add(this.classRepository);
        children.add(this.defaultsPolicy);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String old = this.name;
        this.name = name;
        this.firePropertyChanged(NAME_PROPERTY, old, name);
    }

    public SPIManager getSPIManager() {
        return this.spiManager;
    }

    public Iterator descriptors() {
        return new CloneIterator(this.descriptors){

            @Override
            protected void remove(Object current) {
                MWProject.this.removeDescriptor((MWDescriptor)current);
            }
        };
    }

    private void setDescriptors(Collection descriptors) {
        this.descriptors = descriptors;
    }

    public int descriptorsSize() {
        return this.descriptors.size();
    }

    protected MWDescriptor addDescriptor(MWDescriptor descriptor) {
        descriptor.applyAdvancedPolicyDefaults(this.getDefaultsPolicy());
        this.addItemToCollection(descriptor, this.descriptors, "descriptors");
        return descriptor;
    }

    public MWDescriptor addDescriptorForType(MWClass type) throws InterfaceDescriptorCreationException {
        return this.addDescriptor(this.createDescriptorForType(type));
    }

    protected abstract MWDescriptor createDescriptorForType(MWClass var1) throws InterfaceDescriptorCreationException;

    public void removeDescriptor(MWDescriptor descriptor) {
        this.removeNodeFromCollection(descriptor, this.descriptors, "descriptors");
    }

    public void removeDescriptorForType(MWClass type) {
        MWDescriptor descriptor = this.descriptorForType(type);
        if (descriptor != null) {
            this.removeDescriptor(descriptor);
        }
    }

    public void removeDescriptors(Collection descs) {
        this.removeNodesFromCollection(descs, this.descriptors, "descriptors");
    }

    public void removeDescriptors(Iterator descs) {
        this.removeNodesFromCollection(descs, this.descriptors, "descriptors");
    }

    public void replaceDescriptor(MWDescriptor oldDescriptor, MWDescriptor newDescriptor) {
        this.removeItemFromCollection(oldDescriptor, this.descriptors, "descriptors");
        this.descriptorReplaced(oldDescriptor, newDescriptor);
    }

    public MWClassRepository getClassRepository() {
        return this.classRepository;
    }

    public MWProjectDefaultsPolicy getDefaultsPolicy() {
        return this.defaultsPolicy;
    }

    public String getDeploymentXMLFileName() {
        return this.deploymentXMLFileName;
    }

    public void setDeploymentXMLFileName(String deploymentXMLFileName) {
        if (deploymentXMLFileName == null) {
            throw new NullPointerException();
        }
        String old = this.deploymentXMLFileName;
        this.deploymentXMLFileName = deploymentXMLFileName;
        this.firePropertyChanged(DEPLOYMENT_XML_FILE_NAME_PROPERTY, old, deploymentXMLFileName);
    }

    public String getProjectSourceClassName() {
        return this.projectSourceClassName;
    }

    public void setProjectSourceClassName(String projectSourceClassName) {
        String old = this.projectSourceClassName;
        this.projectSourceClassName = projectSourceClassName;
        this.firePropertyChanged(PROJECT_SOURCE_CLASS_NAME_PROPERTY, old, projectSourceClassName);
    }

    public String getProjectSourceDirectoryName() {
        return this.projectSourceDirectoryName;
    }

    public void setProjectSourceDirectoryName(String projectSourceDirectoryName) {
        if (projectSourceDirectoryName == null) {
            throw new NullPointerException();
        }
        String old = this.projectSourceDirectoryName;
        this.projectSourceDirectoryName = projectSourceDirectoryName;
        this.firePropertyChanged(PROJECT_SOURCE_DIRECTORY_NAME_PROPERTY, old, projectSourceDirectoryName);
    }

    public String getModelSourceDirectoryName() {
        return this.modelSourceDirectoryName;
    }

    public void setModelSourceDirectoryName(String modelSourceDirectoryName) {
        if (modelSourceDirectoryName == null) {
            throw new NullPointerException();
        }
        String old = this.modelSourceDirectoryName;
        this.modelSourceDirectoryName = modelSourceDirectoryName;
        this.firePropertyChanged(MODEL_SOURCE_DIRECTORY_NAME_PROPERTY, old, modelSourceDirectoryName);
    }

    public File getSaveDirectory() {
        return this.saveDirectory;
    }

    public void setSaveDirectory(File saveDirectory) {
        File old = this.saveDirectory;
        this.saveDirectory = saveDirectory;
        this.firePropertyChanged(SAVE_DIRECTORY_PROPERTY, old, saveDirectory);
        if (this.attributeValueHasChanged(old, saveDirectory)) {
            this.markEntireBranchDirty();
        }
    }

    public boolean isLegacyProject() {
        return this.legacyProject;
    }

    public void setIsLegacyProject(boolean legacyProject) {
        this.legacyProject = legacyProject;
    }

    @Override
    public ChangeNotifier getChangeNotifier() {
        return this.changeNotifier;
    }

    @Override
    public void setChangeNotifier(ChangeNotifier changeNotifier) {
        this.changeNotifier = changeNotifier;
    }

    @Override
    public Node.Validator getValidator() {
        return this.validator;
    }

    @Override
    public void setValidator(Node.Validator validator) {
        this.validator = validator;
    }

    public final boolean isValidating() {
        return this.validating;
    }

    private void setIsValidating(boolean validating) {
        boolean old = this.validating;
        this.validating = validating;
        this.firePropertyChanged(VALIDATING_PROPERTY, old, validating);
    }

    public Iterator mappingDescriptors() {
        return new FilteringIterator(this.descriptors()){

            @Override
            protected boolean accept(Object next) {
                return next instanceof MWMappingDescriptor;
            }
        };
    }

    public Iterator interfaceDescriptorsThatImplement(MWMappingDescriptor descriptor) {
        return NullIterator.instance();
    }

    public Iterator descriptorsInPackage(final String packageName) {
        return new FilteringIterator(this.descriptors()){

            @Override
            protected boolean accept(Object next) {
                return ((MWDescriptor)next).packageName().equals(packageName);
            }
        };
    }

    public ExternalClassLoadFailureContainer addDescriptorsForExternalClassDescriptions(Iterator externalClassDescriptions, DescriptorCreationFailureListener listener) {
        ExternalClassLoadFailureContainer failures = new ExternalClassLoadFailureContainer();
        while (externalClassDescriptions.hasNext()) {
            ExternalClassDescription exClassDescription = (ExternalClassDescription)externalClassDescriptions.next();
            try {
                this.classRepository.refreshTypeFor(exClassDescription);
            }
            catch (ExternalClassNotFoundException ex) {
                failures.externalClassLoadFailure(new ExternalClassLoadFailureEvent(this, exClassDescription.getName(), ex));
                continue;
            }
            MWClass type = this.typeNamed(exClassDescription.getName());
            MWDescriptor descriptor = this.descriptorForType(type);
            if (descriptor != null) continue;
            try {
                descriptor = this.addDescriptorForType(type);
            }
            catch (InterfaceDescriptorCreationException ex) {
                listener.descriptorCreationFailure(new DescriptorCreationFailureEvent(this, type.getName(), "DESCRIPTOR_CREATION_ERROR_MESSAGE"));
            }
        }
        return failures;
    }

    public Iterator activeDescriptors() {
        return new FilteringIterator(this.descriptors()){

            @Override
            public boolean accept(Object next) {
                return ((MWDescriptor)next).isActive();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MWDescriptor descriptorForType(MWClass type) {
        Collection collection = this.descriptors;
        synchronized (collection) {
            for (MWDescriptor descriptor : this.descriptors) {
                if (descriptor.getMWClass() != type) continue;
                return descriptor;
            }
        }
        return null;
    }

    public MWDescriptor descriptorForTypeNamed(String typeName) {
        return this.descriptorForType(this.typeNamed(typeName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MWDescriptor descriptorNamed(String descriptorName) {
        Collection collection = this.descriptors;
        synchronized (collection) {
            for (MWDescriptor descriptor : this.descriptors) {
                if (!descriptor.getName().equals(descriptorName)) continue;
                return descriptor;
            }
        }
        return null;
    }

    public void implementorsChangedFor(MWInterfaceDescriptor descriptor) {
        Iterator stream = this.mappingDescriptors();
        while (stream.hasNext()) {
            ((MWMappingDescriptor)stream.next()).implementorsChangedFor(descriptor);
        }
    }

    public MWProject getDescriptorRepository() {
        return this;
    }

    public Iterator allWriteableMappings() {
        return new FilteringIterator(this.allMappings()){

            @Override
            protected boolean accept(Object next) {
                return !((MWMapping)next).isReadOnly();
            }
        };
    }

    public Iterator allMappings() {
        return new CompositeIterator(new TransformationIterator(this.activeDescriptors()){

            @Override
            protected Object transform(Object next) {
                return ((MWDescriptor)next).mappings();
            }
        });
    }

    public DescriptorStringHolder[] descriptorStringHolders() {
        return DescriptorStringHolder.buildHolders(this.descriptors);
    }

    public void exportDeploymentXML() {
        File file = this.deploymentXMLFile();
        file.getParentFile().mkdirs();
        XMLProjectWriter.write((String)file.getAbsolutePath(), (Project)this.buildRuntimeProject());
    }

    public File deploymentXMLFile() {
        File file = new File(this.deploymentXMLFileName);
        return FileTools.convertToAbsoluteFile(file, this.getSaveDirectory());
    }

    public void exportProjectSource() {
        File projectSourceFile = this.projectSourceFile();
        projectSourceFile.getParentFile().mkdirs();
        ProjectClassGenerator generator = new ProjectClassGenerator();
        generator.setProject(this.buildRuntimeProject());
        generator.setClassName(this.projectSourceClassName);
        generator.setPackageName(this.projectSourcePackageName());
        generator.setOutputFileName(projectSourceFile.getAbsolutePath());
        generator.generate();
    }

    public File projectSourceFile() {
        return new File(this.absoluteProjectSourceDirectory(), Classpath.convertToJavaFileName(this.projectSourceClassName));
    }

    public File absoluteProjectSourceDirectory() {
        File dir = new File(this.projectSourceDirectoryName);
        return FileTools.convertToAbsoluteFile(dir, this.getSaveDirectory());
    }

    public String projectSourcePackageName() {
        return ClassTools.packageNameForClassNamed(this.projectSourceClassName);
    }

    public File absoluteModelSourceDirectory() {
        File dir = new File(this.modelSourceDirectoryName);
        return FileTools.convertToAbsoluteFile(dir, this.getSaveDirectory());
    }

    public abstract boolean canAutomapDescriptors();

    public void automap(Collection automapDescriptors) {
        Iterator stream = automapDescriptors.iterator();
        while (stream.hasNext()) {
            ((MWDescriptor)stream.next()).automapInheritanceHierarchy(automapDescriptors);
        }
        this.matchClassesAndMetaData(automapDescriptors);
        for (MWDescriptor descriptor : automapDescriptors) {
            descriptor.automap();
        }
    }

    protected void matchClassesAndMetaData(Collection automapDescriptors) {
    }

    protected DescriptorStringHolder[] buildMetaDataDescriptorStringHolders(Collection automapDescriptors) {
        ArrayList<MWDescriptor> descs = new ArrayList<MWDescriptor>(automapDescriptors.size());
        for (MWDescriptor descriptor : automapDescriptors) {
            if (!descriptor.autoMapRequiresMetaData()) continue;
            descs.add(descriptor);
        }
        return DescriptorStringHolder.buildHolders(descs);
    }

    public Project buildRuntimeProject() {
        Project project = new Project();
        project.setName(this.getName());
        project.setLogin((Login)this.buildRuntimeLogin());
        Iterator stream = CollectionTools.sortedSet(this.activeDescriptors()).iterator();
        while (stream.hasNext()) {
            project.addDescriptor(((MWDescriptor)stream.next()).buildRuntimeDescriptor());
        }
        this.defaultsPolicy.adjustRuntimeProject(project);
        return project;
    }

    protected abstract DatasourceLogin buildRuntimeLogin();

    @Override
    public void nodeRenamed(Node node) {
        super.nodeRenamed(node);
        if (this.descriptors.contains(node)) {
            this.fireCollectionChanged(DESCRIPTOR_NAMES_COLLECTION);
        }
    }

    public abstract MWModel getMetaDataRepository();

    public ProjectSubFileComponentContainer getMetaDataSubComponentContainer() {
        return (ProjectSubFileComponentContainer)((Object)this.getMetaDataRepository());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator packageNames() {
        HashSet<String> packageNames = new HashSet<String>();
        Collection collection = this.descriptors;
        synchronized (collection) {
            Iterator stream = this.descriptors.iterator();
            while (stream.hasNext()) {
                packageNames.add(((MWDescriptor)stream.next()).packageName());
            }
        }
        return packageNames.iterator();
    }

    public void recalculateAggregatePathsToColumn(MWMappingDescriptor descriptor) {
    }

    public void recalculateAggregatePathsToColumn(MWMappingDescriptor descriptor, MWAggregateMapping currentMapping) {
    }

    public File saveFile() {
        File dir = this.getSaveDirectory();
        return dir == null ? null : new File(dir, FileTools.FILE_NAME_ENCODER.encode(this.getName()) + FILE_NAME_EXTENSION);
    }

    public void notifyExpressionsToRecalculateQueryables() {
    }

    public void hierarchyChanged(MWClass type) {
        Iterator stream = this.mappingDescriptors();
        while (stream.hasNext()) {
            ((MWMappingDescriptor)stream.next()).hierarchyChanged(type);
        }
    }

    @Override
    protected void addTransientAspectNamesTo(Set transientAspectNames) {
        super.addTransientAspectNamesTo(transientAspectNames);
        transientAspectNames.add(VALIDATING_PROPERTY);
    }

    @Override
    protected void addInsignificantAspectNamesTo(Set insignificantAspectNames) {
        super.addInsignificantAspectNamesTo(insignificantAspectNames);
        insignificantAspectNames.add(VALIDATING_PROPERTY);
    }

    @Override
    public void validateBranch() {
        this.setIsValidating(true);
        super.validateBranch();
        this.setIsValidating(false);
    }

    @Override
    public Iterator projectSubFileComponents() {
        return this.descriptors();
    }

    @Override
    public void setProjectSubFileComponents(Collection subComponents) {
        this.setDescriptors(subComponents);
    }

    @Override
    public Iterator originalProjectSubFileComponentNames() {
        return this.descriptorNames.iterator();
    }

    @Override
    public void setOriginalProjectSubFileComponentNames(Collection originalSubComponentNames) {
        this.descriptorNames = originalSubComponentNames;
    }

    @Override
    public boolean hasChangedMainProjectSaveFile() {
        if (this.isDirty()) {
            return true;
        }
        Iterator stream = this.children();
        while (stream.hasNext()) {
            if (!this.childHasChangedTheSaveFile(stream.next())) continue;
            return true;
        }
        return false;
    }

    private boolean childHasChangedTheSaveFile(Object child) {
        if (this.descriptors.contains(child)) {
            return false;
        }
        if (child instanceof ProjectSubFileComponentContainer) {
            return ((ProjectSubFileComponentContainer)child).hasChangedMainProjectSaveFile();
        }
        return ((Node)child).isDirtyBranch();
    }

    private String getProductVersionForTopLink() {
        return MANIFEST_INTERROGATOR.getVersionNumber();
    }

    public void setProductVersionForTopLink(String productVersion) {
        this.version = productVersion;
    }

    private String getSchemaVersionForTopLink() {
        return CURRENT_SCHEMA_VERSION;
    }

    private void setSchemaVersionForTopLink(String schemaVersion) {
    }

    private String getDeploymentXMLFileNameForTopLink() {
        return this.deploymentXMLFileName.replace('\\', '/');
    }

    private void setDeploymentXMLFileNameForTopLink(String deploymentXMLFileName) {
        this.deploymentXMLFileName = new File(deploymentXMLFileName).getPath();
    }

    private String getProjectSourceDirectoryNameForTopLink() {
        return this.projectSourceDirectoryName.replace('\\', '/');
    }

    private void setProjectSourceDirectoryNameForTopLink(String projectSourceDirectoryName) {
        this.projectSourceDirectoryName = new File(projectSourceDirectoryName).getPath();
    }

    private String getModelSourceDirectoryNameForTopLink() {
        return this.modelSourceDirectoryName.replace('\\', '/');
    }

    private void setModelSourceDirectoryNameForTopLink(String modelSourceDirectoryName) {
        this.modelSourceDirectoryName = new File(modelSourceDirectoryName).getPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getDescriptorNamesForTopLink() {
        ArrayList<String> names = new ArrayList<String>(this.descriptors.size());
        Collection collection = this.descriptors;
        synchronized (collection) {
            Iterator stream = this.descriptors.iterator();
            while (stream.hasNext()) {
                names.add(((MWDescriptor)stream.next()).getName());
            }
        }
        return CollectionTools.sort(names, (Comparator)Collator.getInstance());
    }

    private void setDescriptorNamesForTopLink(Collection descriptorNames) {
        this.descriptorNames = descriptorNames;
    }

    @Override
    public void postProjectBuild() {
        this.setChildBackpointers();
        this.resolveInternalReferences();
        super.postProjectBuild();
        this.buildBasicTypes();
        if (this.version != null) {
            this.markEntireBranchClean();
        }
    }

    protected void resolveInternalReferences() {
        this.resolveHandles();
    }

    private void resolveHandles() {
        this.resolveClassHandles();
        this.resolveMetadataHandles();
        this.resolveColumnHandles();
        this.resolveReferenceHandles();
        this.resolveDescriptorHandles();
        this.resolveMethodHandles();
    }

    private void setSaveDirectoryForIOManager(File saveDirectory) {
        this.saveDirectory = saveDirectory;
    }

    private void setSPIManagerForIOManager(SPIManager spiManager) {
        this.spiManager = spiManager;
    }

    @Override
    public String displayString() {
        return this.getName();
    }

    @Override
    public void toString(StringBuffer sb) {
        sb.append(this.getName());
    }

    public boolean usesWeaving() {
        return this.usesWeaving;
    }

    public void setUsesWeaving(boolean newValue) {
        boolean oldValue = this.usesWeaving;
        this.usesWeaving = newValue;
        this.firePropertyChanged(USES_WEAVING_PROPERTY, oldValue, newValue);
    }

    private static class LocalManifestDefaults
    implements ManifestInterrogator.Defaults {
        private LocalManifestDefaults() {
        }

        @Override
        public String defaultSpecificationTitle() {
            return "EclipseLink";
        }

        @Override
        public String defaultSpecificationVendor() {
            return "Eclipse";
        }

        @Override
        public String defaultReleaseDesignation() {
            return "Version 1.0.0";
        }

        @Override
        public String defaultLibraryDesignation() {
            return "Workbench";
        }

        @Override
        public String defaultSpecificationVersion() {
            return "1.0.0";
        }

        @Override
        public String defaultImplementationVersion() {
            return this.defaultSpecificationVersion();
        }
    }
}

