/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.iterators;

import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;

public class SingleElementListIterator
implements ListIterator {
    private Object element;
    private Object next;
    private static final Object END = new Object();

    public SingleElementListIterator(Object element) {
        this.element = element;
        this.next = element;
    }

    @Override
    public boolean hasNext() {
        return this.next == this.element;
    }

    @Override
    public Object next() {
        if (this.next == END) {
            throw new NoSuchElementException();
        }
        this.next = END;
        return this.element;
    }

    @Override
    public int nextIndex() {
        return this.next == this.element ? 0 : 1;
    }

    @Override
    public boolean hasPrevious() {
        return this.next == END;
    }

    public Object previous() {
        if (this.next == this.element) {
            throw new NoSuchElementException();
        }
        this.next = this.element;
        return this.element;
    }

    @Override
    public int previousIndex() {
        return this.next == END ? 0 : -1;
    }

    public void add(Object o) {
        throw new UnsupportedOperationException();
    }

    public void set(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return ClassTools.shortClassNameForObject(this) + '(' + this.element + ')';
    }
}

