/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.mappings;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.identitymaps.CacheId;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.oxm.ConversionManager;
import org.eclipse.persistence.internal.oxm.Reference;
import org.eclipse.persistence.internal.oxm.ReferenceResolver;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.mappings.ObjectReferenceMapping;
import org.eclipse.persistence.internal.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.AggregateMapping;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLUnionField;
import org.eclipse.persistence.oxm.mappings.XMLInverseReferenceMapping;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.record.DOMRecord;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.queries.ObjectBuildingQuery;

public class XMLObjectReferenceMapping
extends AggregateMapping
implements ObjectReferenceMapping<AbstractSession, AttributeAccessor, ContainerPolicy, ClassDescriptor, DatabaseField, UnmarshalRecord, XMLField, XMLRecord>,
XMLMapping {
    protected HashMap sourceToTargetKeyFieldAssociations = new HashMap();
    protected Vector sourceToTargetKeys = new Vector();
    private boolean isWriteOnly;
    private XMLInverseReferenceMapping inverseReferenceMapping;

    @Override
    public void addSourceToTargetKeyFieldAssociation(String srcXPath, String tgtXPath) {
        XMLField srcFld = new XMLField(srcXPath);
        this.sourceToTargetKeys.add(srcFld);
        if (tgtXPath == null) {
            this.sourceToTargetKeyFieldAssociations.put(srcFld, null);
        } else {
            this.sourceToTargetKeyFieldAssociations.put(srcFld, new XMLField(tgtXPath));
        }
    }

    public void addSourceToTargetKeyFieldAssociation(XMLField srcField, XMLField tgtField) {
        this.sourceToTargetKeys.add(srcField);
        this.sourceToTargetKeyFieldAssociations.put(srcField, tgtField);
    }

    @Override
    public Object buildFieldValue(Object targetObject, XMLField xmlFld, AbstractSession session) {
        if (targetObject == null || this.getReferenceClass() == null) {
            return null;
        }
        ClassDescriptor descriptor = this.referenceDescriptor;
        if (descriptor == null) {
            descriptor = session.getClassDescriptor(targetObject);
        }
        ObjectBuilder objectBuilder = descriptor.getObjectBuilder();
        Object primaryKey = objectBuilder.extractPrimaryKeyFromObject(targetObject, session);
        int idx = 0;
        if (this.referenceClass != null && ClassConstants.OBJECT != this.getReferenceClass() && (idx = descriptor.getPrimaryKeyFields().indexOf(this.getSourceToTargetKeyFieldAssociations().get(xmlFld))) == -1) {
            return null;
        }
        if (primaryKey instanceof CacheId) {
            return ((CacheId)primaryKey).getPrimaryKey()[idx];
        }
        return primaryKey;
    }

    @Override
    public void buildReference(UnmarshalRecord record, XMLField xmlField, Object object, AbstractSession session) {
        ReferenceResolver resolver = record.getReferenceResolver();
        if (resolver == null) {
            return;
        }
        Object srcObject = record.getCurrentObject();
        Reference reference = resolver.getReference(this, srcObject);
        if (this.referenceClass == null || ClassConstants.OBJECT == this.referenceClass) {
            CacheId primaryKeys;
            if (reference == null) {
                primaryKeys = new CacheId(new Object[1]);
                reference = new Reference(this, srcObject, this.referenceClass, primaryKeys);
                resolver.addReference(reference);
                record.reference(reference);
            } else {
                primaryKeys = (CacheId)reference.getPrimaryKey();
            }
            primaryKeys.set(0, object);
        } else {
            CacheId primaryKeys;
            List pkFieldNames = this.referenceDescriptor.getPrimaryKeyFieldNames();
            if (reference == null) {
                primaryKeys = new CacheId(new Object[((Vector)pkFieldNames).size()]);
                reference = new Reference(this, srcObject, this.referenceClass, primaryKeys);
                resolver.addReference(reference);
                record.reference(reference);
            } else {
                primaryKeys = (CacheId)reference.getPrimaryKey();
            }
            XMLField tgtFld = (XMLField)this.getSourceToTargetKeyFieldAssociations().get(xmlField);
            int idx = ((Vector)pkFieldNames).indexOf(tgtFld.getQualifiedName());
            Object value = session.getDatasourcePlatform().getConversionManager().convertObject(object, this.referenceDescriptor.getTypedField(tgtFld).getType());
            if (value != null) {
                primaryKeys.set(idx, value);
            }
        }
    }

    @Override
    public void cascadePerformRemoveIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
        Object objectReferenced = this.getRealAttributeValueFromObject(object, uow);
        if (objectReferenced == null) {
            return;
        }
        if (!visitedObjects.containsKey(objectReferenced)) {
            visitedObjects.put(objectReferenced, objectReferenced);
            ObjectBuilder builder = this.getReferenceDescriptor(objectReferenced.getClass(), (AbstractSession)uow).getObjectBuilder();
            builder.cascadePerformRemove(objectReferenced, uow, visitedObjects);
        }
    }

    @Override
    public void cascadeRegisterNewIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
        Object objectReferenced = this.getRealAttributeValueFromObject(object, uow);
        if (objectReferenced == null) {
            return;
        }
        if (!visitedObjects.containsKey(objectReferenced)) {
            visitedObjects.put(objectReferenced, objectReferenced);
            ObjectBuilder builder = this.getReferenceDescriptor(objectReferenced.getClass(), (AbstractSession)uow).getObjectBuilder();
            builder.cascadeRegisterNewForCreate(objectReferenced, uow, visitedObjects);
        }
    }

    @Override
    public Vector getFields() {
        return this.sourceToTargetKeys;
    }

    protected QName getSchemaType(XMLField xmlField, Object value, AbstractSession session) {
        QName schemaType = null;
        if (xmlField.isTypedTextField()) {
            ConversionManager conversionManager = (ConversionManager)((Object)session.getDatasourcePlatform().getConversionManager());
            schemaType = xmlField.getXMLType(value.getClass(), conversionManager);
        } else {
            if (xmlField.isUnionField()) {
                return this.getSingleValueToWriteForUnion((XMLUnionField)xmlField, value, session);
            }
            if (xmlField.getSchemaType() != null) {
                schemaType = xmlField.getSchemaType();
            }
        }
        return schemaType;
    }

    protected QName getSingleValueToWriteForUnion(XMLUnionField xmlField, Object value, AbstractSession session) {
        ArrayList schemaTypes = xmlField.getSchemaTypes();
        QName schemaType = null;
        int i = 0;
        while (i < schemaTypes.size()) {
            block4: {
                QName nextQName = (QName)xmlField.getSchemaTypes().get(i);
                try {
                    if (nextQName != null) {
                        ConversionManager conversionManager = (ConversionManager)((Object)session.getDatasourcePlatform().getConversionManager());
                        Class javaClass = xmlField.getJavaClass(nextQName, conversionManager);
                        conversionManager.convertObject(value, javaClass, nextQName);
                        schemaType = nextQName;
                        break;
                    }
                }
                catch (ConversionException conversionException) {
                    if (i != schemaTypes.size() - 1) break block4;
                    schemaType = nextQName;
                }
            }
            ++i;
        }
        return schemaType;
    }

    @Override
    public HashMap getSourceToTargetKeyFieldAssociations() {
        return this.sourceToTargetKeyFieldAssociations;
    }

    protected String getValueToWrite(QName schemaType, Object value, AbstractSession session) {
        return (String)((XMLConversionManager)session.getDatasourcePlatform().getConversionManager()).convertObject(value, ClassConstants.STRING, schemaType);
    }

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        if (this.referenceClass == null && this.referenceClassName != null) {
            this.setReferenceClass(session.getDatasourcePlatform().getConversionManager().convertClassNameToClass(this.referenceClassName));
        }
        if (this.referenceClass != null && this.referenceClass != ClassConstants.OBJECT) {
            super.initialize(session);
        }
        XMLDescriptor descriptor = (XMLDescriptor)this.getDescriptor();
        XMLDescriptor targetDescriptor = (XMLDescriptor)this.getReferenceDescriptor();
        int index = 0;
        while (index < this.sourceToTargetKeys.size()) {
            XMLField sourceField = (XMLField)this.sourceToTargetKeys.get(index);
            XMLField targetField = (XMLField)this.sourceToTargetKeyFieldAssociations.remove(sourceField);
            sourceField = (XMLField)descriptor.buildField(sourceField);
            this.sourceToTargetKeys.set(index, sourceField);
            if (targetField != null) {
                if (targetDescriptor == null) {
                    throw DescriptorException.referenceClassNotSpecified(this);
                }
                List<DatabaseField> pkFields = targetDescriptor.getPrimaryKeyFields();
                int i = 0;
                while (i < pkFields.size()) {
                    XMLField nextPKField = (XMLField)pkFields.get(i);
                    if (targetField.equals(nextPKField)) {
                        targetField = (XMLField)targetDescriptor.buildField(nextPKField);
                        sourceField.setSchemaType(targetField.getSchemaType());
                        break;
                    }
                    ++i;
                }
            }
            this.sourceToTargetKeyFieldAssociations.put(sourceField, targetField);
            ++index;
        }
        if (this.inverseReferenceMapping != null && this.inverseReferenceMapping.getAttributeAccessor() != null) {
            ((AttributeAccessor)this.inverseReferenceMapping.getAttributeAccessor()).initializeAttributes(this.referenceClass);
        }
    }

    @Override
    public void preInitialize(AbstractSession session) throws DescriptorException {
        ((AttributeAccessor)this.getAttributeAccessor()).setIsWriteOnly(this.isWriteOnly());
        ((AttributeAccessor)this.getAttributeAccessor()).setIsReadOnly(this.isReadOnly());
        super.preInitialize(session);
    }

    @Override
    public boolean isXMLMapping() {
        return true;
    }

    @Override
    public Object readFromRowIntoObject(AbstractRecord databaseRow, JoinedAttributeManager joinManager, Object targetObject, CacheKey parentCacheKey, ObjectBuildingQuery sourceQuery, AbstractSession executionSession, boolean isTargetProtected) throws DatabaseException {
        CacheId primaryKeys;
        ClassDescriptor descriptor = sourceQuery.getSession().getClassDescriptor(this.referenceClass);
        List pkFieldNames = null;
        if (descriptor == null) {
            primaryKeys = new CacheId(new Object[1]);
        } else {
            pkFieldNames = descriptor.getPrimaryKeyFieldNames();
            primaryKeys = new CacheId(new Object[((Vector)pkFieldNames).size()]);
        }
        for (XMLField keyFld : this.sourceToTargetKeys) {
            Object value;
            XMLField tgtFld = (XMLField)this.getSourceToTargetKeyFieldAssociations().get(keyFld);
            int idx = 0;
            if (tgtFld == null) {
                value = databaseRow.get(keyFld);
            } else {
                idx = ((Vector)pkFieldNames).indexOf(tgtFld.getXPath());
                if (idx == -1) continue;
                value = executionSession.getDatasourcePlatform().getConversionManager().convertObject(databaseRow.get(keyFld), descriptor.getTypedField(tgtFld).getType());
            }
            if (value == null) continue;
            primaryKeys.set(idx, value);
        }
        ReferenceResolver resolver = ((DOMRecord)databaseRow).getReferenceResolver();
        if (resolver != null) {
            resolver.addReference(new Reference(this, targetObject, this.referenceClass, primaryKeys));
        }
        return null;
    }

    public void setField(DatabaseField field) {
    }

    public void setSourceToTargetKeyFieldAssociations(HashMap sourceToTargetKeyFieldAssociations) {
        this.sourceToTargetKeyFieldAssociations = sourceToTargetKeyFieldAssociations;
    }

    @Override
    public void writeFromObjectIntoRow(Object object, AbstractRecord row, AbstractSession session, DatabaseMapping.WriteType writeType) {
        Object targetObject = this.getAttributeValueFromObject(object);
        this.writeSingleValue(targetObject, object, (XMLRecord)row, session);
    }

    @Override
    public void writeSingleValue(Object value, Object parent, XMLRecord row, AbstractSession session) {
        for (XMLField xmlField : this.getFields()) {
            Object fieldValue = this.buildFieldValue(value, xmlField, session);
            if (fieldValue == null) continue;
            QName schemaType = this.getSchemaType(xmlField, fieldValue, session);
            String stringValue = this.getValueToWrite(schemaType, fieldValue, session);
            row.put(xmlField, (Object)stringValue);
        }
    }

    @Override
    public void setIsWriteOnly(boolean b) {
        this.isWriteOnly = b;
    }

    @Override
    public boolean isWriteOnly() {
        return this.isWriteOnly;
    }

    @Override
    public void setAttributeValueInObject(Object object, Object value) throws DescriptorException {
        if (this.isWriteOnly()) {
            return;
        }
        super.setAttributeValueInObject(object, value);
    }

    @Override
    public XMLInverseReferenceMapping getInverseReferenceMapping() {
        return this.inverseReferenceMapping;
    }

    void setInverseReferenceMapping(XMLInverseReferenceMapping inverseReferenceMapping) {
        this.inverseReferenceMapping = inverseReferenceMapping;
    }

    @Override
    public boolean isObjectReferenceMapping() {
        return true;
    }
}

