/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.optimizer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.eclipse.persistence.internal.libraries.asm.ClassReader;
import org.eclipse.persistence.internal.libraries.asm.ClassWriter;
import org.eclipse.persistence.internal.libraries.asm.Handle;
import org.eclipse.persistence.internal.libraries.asm.Type;
import org.eclipse.persistence.internal.libraries.asm.commons.Remapper;
import org.eclipse.persistence.internal.libraries.asm.commons.SimpleRemapper;
import org.eclipse.persistence.internal.libraries.asm.optimizer.ClassConstantsCollector;
import org.eclipse.persistence.internal.libraries.asm.optimizer.ClassOptimizer;
import org.eclipse.persistence.internal.libraries.asm.optimizer.Constant;
import org.eclipse.persistence.internal.libraries.asm.optimizer.ConstantPool;

public class Shrinker {
    static final HashMap<String, String> MAPPING = new HashMap();

    public static void main(String[] stringArray) throws IOException {
        Properties properties = new Properties();
        int n = stringArray.length - 1;
        for (int i = 0; i < n - 1; ++i) {
            properties.load(new FileInputStream(stringArray[i]));
        }
        for (Map.Entry<Object, Object> object2 : properties.entrySet()) {
            MAPPING.put((String)object2.getKey(), (String)object2.getValue());
        }
        final HashSet<String> hashSet = new HashSet<String>(MAPPING.keySet());
        File file = new File(stringArray[n - 1]);
        File file2 = new File(stringArray[n]);
        Shrinker.optimize(file, file2, new SimpleRemapper(MAPPING){

            @Override
            public String map(String string) {
                String string2 = super.map(string);
                if (string2 != null) {
                    hashSet.remove(string);
                }
                return string2;
            }
        });
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string.endsWith("/remove")) continue;
            System.out.println("INFO: unused mapping " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void optimize(File file, File file2, Remapper remapper) throws IOException {
        block9: {
            block8: {
                if (!file.isDirectory()) break block8;
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    Shrinker.optimize(fileArray[i], file2, remapper);
                }
                break block9;
            }
            if (!file.getName().endsWith(".class")) break block9;
            ConstantPool constantPool = new ConstantPool();
            ClassReader classReader = new ClassReader(new FileInputStream(file));
            ClassWriter classWriter = new ClassWriter(1);
            ClassConstantsCollector classConstantsCollector = new ClassConstantsCollector(classWriter, constantPool);
            ClassOptimizer classOptimizer = new ClassOptimizer(classConstantsCollector, remapper);
            classReader.accept(classOptimizer, 2);
            TreeSet<Constant> treeSet = new TreeSet<Constant>(new ConstantComparator());
            treeSet.addAll(constantPool.values());
            classReader = new ClassReader(classWriter.toByteArray());
            classWriter = new ClassWriter(0);
            for (Constant object2 : treeSet) {
                object2.write(classWriter);
            }
            classReader.accept(classWriter, 2);
            if (MAPPING.get(classReader.getClassName() + "/remove") != null) {
                return;
            }
            String string = remapper.mapType(classReader.getClassName());
            File file3 = new File(file2, string + ".class");
            if (!file3.exists() || file3.lastModified() < file.lastModified()) {
                if (!file3.getParentFile().exists() && !file3.getParentFile().mkdirs()) {
                    throw new IOException("Cannot create directory " + file3.getParentFile());
                }
                try (FileOutputStream fileOutputStream = new FileOutputStream(file3);){
                    ((OutputStream)fileOutputStream).write(classWriter.toByteArray());
                }
            }
        }
    }

    static class ConstantComparator
    implements Comparator<Constant> {
        ConstantComparator() {
        }

        @Override
        public int compare(Constant constant, Constant constant2) {
            int n = ConstantComparator.getSort(constant) - ConstantComparator.getSort(constant2);
            if (n == 0) {
                switch (constant.type) {
                    case 'I': {
                        return Integer.valueOf(constant.intVal).compareTo(constant2.intVal);
                    }
                    case 'J': {
                        return Long.valueOf(constant.longVal).compareTo(constant2.longVal);
                    }
                    case 'F': {
                        return Float.valueOf(constant.floatVal).compareTo(Float.valueOf(constant2.floatVal));
                    }
                    case 'D': {
                        return Double.valueOf(constant.doubleVal).compareTo(constant2.doubleVal);
                    }
                    case 'C': 
                    case 'S': 
                    case 's': 
                    case 't': {
                        return constant.strVal1.compareTo(constant2.strVal1);
                    }
                    case 'T': {
                        n = constant.strVal1.compareTo(constant2.strVal1);
                        if (n != 0) break;
                        n = constant.strVal2.compareTo(constant2.strVal2);
                        break;
                    }
                    case 'y': {
                        Handle handle;
                        Handle handle2;
                        n = constant.strVal1.compareTo(constant2.strVal1);
                        if (n != 0 || (n = constant.strVal2.compareTo(constant2.strVal2)) != 0 || (n = ConstantComparator.compareHandle(handle2 = (Handle)constant.objVal3, handle = (Handle)constant2.objVal3)) != 0) break;
                        n = ConstantComparator.compareObjects(constant.objVals, constant2.objVals);
                        break;
                    }
                    default: {
                        n = constant.strVal1.compareTo(constant2.strVal1);
                        if (n != 0 || (n = constant.strVal2.compareTo(constant2.strVal2)) != 0) break;
                        n = ((String)constant.objVal3).compareTo((String)constant2.objVal3);
                    }
                }
            }
            return n;
        }

        private static int compareHandle(Handle handle, Handle handle2) {
            int n = handle.getTag() - handle2.getTag();
            if (n == 0 && (n = handle.getOwner().compareTo(handle2.getOwner())) == 0 && (n = handle.getName().compareTo(handle2.getName())) == 0) {
                n = handle.getDesc().compareTo(handle2.getDesc());
            }
            return n;
        }

        private static int compareType(Type type, Type type2) {
            return type.getDescriptor().compareTo(type2.getDescriptor());
        }

        private static int compareObjects(Object[] objectArray, Object[] objectArray2) {
            int n = objectArray.length;
            int n2 = n - objectArray2.length;
            if (n2 == 0) {
                for (int i = 0; i < n; ++i) {
                    Object object = objectArray[i];
                    Object object2 = objectArray2[i];
                    n2 = object.getClass().getName().compareTo(object2.getClass().getName());
                    if (n2 == 0) {
                        n2 = object instanceof Type ? ConstantComparator.compareType((Type)object, (Type)object2) : (object instanceof Handle ? ConstantComparator.compareHandle((Handle)object, (Handle)object2) : ((Comparable)object).compareTo(object2));
                    }
                    if (n2 == 0) continue;
                    return n2;
                }
            }
            return 0;
        }

        private static int getSort(Constant constant) {
            switch (constant.type) {
                case 'I': {
                    return 0;
                }
                case 'J': {
                    return 1;
                }
                case 'F': {
                    return 2;
                }
                case 'D': {
                    return 3;
                }
                case 's': {
                    return 4;
                }
                case 'S': {
                    return 5;
                }
                case 'C': {
                    return 6;
                }
                case 'T': {
                    return 7;
                }
                case 'G': {
                    return 8;
                }
                case 'M': {
                    return 9;
                }
                case 'N': {
                    return 10;
                }
                case 'y': {
                    return 11;
                }
                case 't': {
                    return 12;
                }
            }
            return 100 + constant.type - 104;
        }
    }
}

