/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.framework;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import junit.framework.Test;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.factories.SessionManager;
import org.eclipse.persistence.testing.framework.TestCollection;
import org.eclipse.persistence.testing.framework.TestExecutor;
import org.eclipse.persistence.testing.framework.TestProblemException;
import org.eclipse.persistence.testing.framework.TestResultsSummary;
import org.eclipse.persistence.testing.framework.TestSystem;

public class TestModel
extends TestCollection {
    private Vector requiredSystems = new Vector();
    private Vector forcedRequiredSystems = new Vector();
    private Vector originalTests = new Vector();
    private boolean isSetup = false;
    private Login login;
    private SessionLog sessionLog;
    private static Boolean shouldResetSystemAfterEachTestModel;

    public static boolean shouldResetSystemAfterEachTestModel() {
        if (shouldResetSystemAfterEachTestModel == null) {
            String systemProperty = System.getProperty("org.eclipse.persistence.testing.reset-system");
            shouldResetSystemAfterEachTestModel = systemProperty == null ? Boolean.TRUE : (systemProperty.equals("false") ? Boolean.FALSE : Boolean.TRUE);
        }
        return shouldResetSystemAfterEachTestModel;
    }

    public static void setShouldResetSystemAfterEachTestModel(boolean value) {
        shouldResetSystemAfterEachTestModel = value ? Boolean.TRUE : Boolean.FALSE;
    }

    public final void addForcedRequiredSystem(TestSystem requiredSystem) {
        this.getForcedRequiredSystems().addElement(requiredSystem);
    }

    public void addForcedRequiredSystems() {
    }

    public final void addRequiredSystem(TestSystem requiredSystem) {
        this.getRequiredSystems().addElement(requiredSystem);
    }

    public void addRequiredSystems() {
    }

    @Override
    public void addTests() {
    }

    @Override
    public void addSRGTests() {
    }

    public Vector buildForcedRequiredSystems() {
        Vector constructedSystems = (Vector)this.getForcedRequiredSystems().clone();
        this.addForcedRequiredSystems();
        Vector allSystems = this.getForcedRequiredSystems();
        this.setForcedRequiredSystems(constructedSystems);
        return allSystems;
    }

    public Vector buildRequiredSystems() {
        Vector constructedSystems = (Vector)this.getRequiredSystems().clone();
        this.addRequiredSystems();
        Vector allSystems = this.getRequiredSystems();
        this.setRequiredSystems(constructedSystems);
        return allSystems;
    }

    private void configure() throws Exception {
        TestSystem system;
        Vector systems = this.buildRequiredSystems();
        Enumeration enumtr = systems.elements();
        while (enumtr.hasMoreElements()) {
            system = (TestSystem)enumtr.nextElement();
            if (TestModel.shouldResetSystemAfterEachTestModel()) {
                this.getExecutor().forceConfigureSystem(system);
                continue;
            }
            this.getExecutor().configureSystem(system);
        }
        systems = this.buildForcedRequiredSystems();
        enumtr = systems.elements();
        while (enumtr.hasMoreElements()) {
            system = (TestSystem)enumtr.nextElement();
            this.getExecutor().forceConfigureSystem(system);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(TestExecutor executor) throws Throwable {
        this.setSummary(new TestResultsSummary(this));
        this.setExecutor(executor);
        long startTime = System.currentTimeMillis();
        try {
            this.setupEntity();
            this.setFinishedTests(new Vector());
            try {
                Enumeration tests = this.getTests().elements();
                while (tests.hasMoreElements()) {
                    Test test = (Test)tests.nextElement();
                    if (TestExecutor.getDefaultJUnitTestResult() == null || !TestExecutor.getDefaultJUnitTestResult().shouldStop()) {
                        executor.execute(test);
                        this.getFinishedTests().addElement(test);
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable exception) {
                try {
                    this.resetEntity();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw exception;
            }
            this.resetEntity();
        }
        finally {
            long endTime = System.currentTimeMillis();
            this.getSummary().setTotalTime(endTime - startTime);
        }
    }

    public Vector getForcedRequiredSystems() {
        return this.forcedRequiredSystems;
    }

    protected Vector getOriginalTests() {
        return this.originalTests;
    }

    public Vector getRequiredSystems() {
        return this.requiredSystems;
    }

    public boolean isSetup() {
        return this.isSetup;
    }

    @Override
    protected void logFootNote(Writer log) {
        try {
            log.write(Helper.cr() + this.getIndentationString() + "RESULTS OF TEST MODEL: " + this.getName() + Helper.cr());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    protected void logRegressionHeadNote(Writer log) {
        try {
            log.write(Helper.cr() + this.getIndentationString() + "TEST MODEL NAME: " + this.getName() + Helper.cr());
            log.write(this.getIndentationString() + "MODEL DESCRIPTION: " + this.getDescription() + Helper.cr());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    protected void logHeadNote(Writer log) {
        try {
            log.write(Helper.cr() + this.getIndentationString() + "VERSION: " + DatabaseLogin.getVersion());
            log.write(Helper.cr() + this.getIndentationString() + "TEST MODEL NAME: " + this.getName() + Helper.cr());
            log.write(this.getIndentationString() + "MODEL DESCRIPTION: " + this.getDescription() + Helper.cr());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void reset() {
    }

    @Override
    public void resetEntity() {
        if (this.isSetup()) {
            this.setTests(this.getOriginalTests());
            this.setIsSetup(false);
        }
        if (this.getSummary().didSetupWarn()) {
            return;
        }
        this.reset();
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        if (TestModel.shouldResetSystemAfterEachTestModel()) {
            this.getExecutor().setConfiguredSystems(new Vector());
            if (this.getSession().isDatabaseSession()) {
                try {
                    this.getDatabaseSession().logout();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.login == null) {
                this.login = this.getSession().getDatasourceLogin();
                this.sessionLog = this.getSession().getSessionLog();
            }
            if (this.login.getClass() != this.getSession().getDatasourceLogin().getClass()) {
                System.out.println("Login changed by test model:" + this);
            }
            if (this.sessionLog.getLevel() != this.getSession().getSessionLog().getLevel()) {
                System.out.println("Log level changed by test model:" + this);
            }
            if (this.login instanceof DatabaseLogin) {
                DatabaseLogin login = (DatabaseLogin)this.login;
                if (login.shouldBindAllParameters() != this.getSession().getLogin().shouldBindAllParameters()) {
                    System.out.println("Binding changed by test model:" + this);
                }
                if (login.shouldCacheAllStatements() != this.getSession().getLogin().shouldCacheAllStatements()) {
                    System.out.println("Statement caching changed by test model:" + this);
                }
                if (login.shouldUseBatchWriting() != this.getSession().getLogin().shouldUseBatchWriting()) {
                    System.out.println("Batch writing changed by test model:" + this);
                }
                if (login.shouldUseJDBCBatchWriting() != this.getSession().getLogin().shouldUseJDBCBatchWriting()) {
                    System.out.println("JDBC batch writing changed by test model:" + this);
                }
                if (login.shouldUseNativeSQL() != this.getSession().getLogin().shouldUseNativeSQL()) {
                    System.out.println("Native SQL changed by test model:" + this);
                }
                if (login.getTableQualifier() != this.getSession().getLogin().getTableQualifier()) {
                    System.out.println("Table qualifier changed by test model:" + this);
                }
            }
            DatabaseSession session = new Project(this.login).createDatabaseSession();
            session.setSessionLog(this.sessionLog);
            this.getExecutor().setSession((Session)session);
            if (!ConversionManager.getDefaultManager().shouldUseClassLoaderFromCurrentThread()) {
                System.out.println("ConversionManager corrupted by test model:" + this);
            }
            ConversionManager.setDefaultManager(null);
            this.getSession().getDatasourceLogin().getDatasourcePlatform().setConversionManager(null);
            SessionManager.getManager().setSessions(new ConcurrentHashMap());
            this.getDatabaseSession().login();
        }
        this.setIsSetup(false);
    }

    public void setForcedRequiredSystems(Vector systems) {
        this.forcedRequiredSystems = systems;
    }

    protected void setIsSetup(boolean isSetup) {
        this.isSetup = isSetup;
    }

    protected void setOriginalTests(Vector originalTests) {
        this.originalTests = originalTests;
    }

    public void setRequiredSystems(Vector systems) {
        this.requiredSystems = systems;
    }

    public void setup() {
    }

    @Override
    public void setupEntity() throws Throwable {
        block12: {
            if (this.isSetup()) {
                return;
            }
            if (this.getSession() != null) {
                if (this.getSession().getDatasourcePlatform().isPostgreSQL()) {
                    this.getSession().getPlatform().setShouldForceFieldNamesToUpperCase(true);
                }
                this.login = this.getSession().getDatasourceLogin().clone();
                this.sessionLog = (SessionLog)this.getSession().getSessionLog().clone();
            }
            try {
                this.setOriginalTests((Vector)this.getTests().clone());
                this.configure();
                this.setup();
                if (this.isSRG) {
                    this.addSRGTests();
                } else {
                    this.addTests();
                }
                if (this.getAbstractSession() == null || !this.getAbstractSession().isInTransaction()) break block12;
                try {
                    for (int count = 0; this.getAbstractSession().isInTransaction() && count < 10; ++count) {
                        this.getAbstractSession().rollbackTransaction();
                    }
                }
                catch (Throwable count) {
                    // empty catch block
                }
                TestProblemException exception = new TestProblemException(this + " is a faulty test, transaction was left open and must always be closed.");
                throw exception;
            }
            catch (Throwable exception) {
                this.getSummary().setSetupException(exception);
                try {
                    this.resetEntity();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw exception;
            }
        }
        this.setIsSetup(true);
    }

    @Override
    public int testCount() {
        if (this.isSetup() || !this.getTests().isEmpty()) {
            return super.testCount();
        }
        return this.getFinishedTests().size();
    }

    @Override
    public Enumeration tests() {
        if (this.isSetup() || !this.getTests().isEmpty()) {
            return super.tests();
        }
        return this.getFinishedTests().elements();
    }

    @Override
    public Test testAt(int index) {
        if (this.isSetup() || !this.getTests().isEmpty()) {
            return super.testAt(index);
        }
        return (Test)this.getFinishedTests().elementAt(index);
    }
}

