/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.interfaces;

import java.sql.Timestamp;
import java.util.Vector;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestSystem;
import org.eclipse.persistence.testing.models.interfaces.Commercial;
import org.eclipse.persistence.testing.models.interfaces.Network;
import org.eclipse.persistence.testing.models.interfaces.Program;
import org.eclipse.persistence.testing.models.interfaces.Show;
import org.eclipse.persistence.testing.models.interfaces.TVSchedule;
import org.eclipse.persistence.tools.schemaframework.DatabaseObjectDefinition;
import org.eclipse.persistence.tools.schemaframework.PopulationManager;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public class InterfaceWithTablesSystem
extends TestSystem {
    public void addDescriptors(DatabaseSession session) {
        Vector<RelationalDescriptor> descriptors = new Vector<RelationalDescriptor>();
        descriptors.addElement(this.showDescriptor());
        descriptors.addElement(this.programDescriptor());
        descriptors.addElement(this.networkDescriptor());
        descriptors.addElement(this.scheduleDescriptor());
        descriptors.addElement(this.commercialDescriptor());
        session.addDescriptors(descriptors);
    }

    public RelationalDescriptor commercialDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Commercial.class);
        descriptor.getInheritancePolicy().setParentClass(Program.class);
        return descriptor;
    }

    public void createTables(DatabaseSession session) {
        SchemaManager schemaManager = new SchemaManager(session);
        schemaManager.replaceObject((DatabaseObjectDefinition)this.programTable());
        schemaManager.replaceObject((DatabaseObjectDefinition)this.networkTable());
        schemaManager.replaceObject((DatabaseObjectDefinition)this.scheduleTable());
        schemaManager.replaceObject((DatabaseObjectDefinition)this.scheduleProgramTable());
        schemaManager.createSequences();
    }

    public RelationalDescriptor networkDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Network.class);
        descriptor.setTableName("TV_NET");
        descriptor.setPrimaryKeyFieldName("NAME");
        descriptor.addDirectMapping("name", "NAME");
        return descriptor;
    }

    public TableDefinition networkTable() {
        TableDefinition table = new TableDefinition();
        table.setName("TV_NET");
        table.addPrimaryKeyField("NAME", String.class, 20);
        return table;
    }

    public void populate(DatabaseSession session) {
        PopulationManager manager = PopulationManager.getDefaultManager();
        TVSchedule schedule = new TVSchedule();
        schedule.broadcastor = new Network();
        ((Network)schedule.broadcastor).name = "NBC";
        Commercial eatYourWeaties = new Commercial();
        eatYourWeaties.setName("Eat Your Weaties");
        eatYourWeaties.setDescription("Mikey says that he likes it.");
        eatYourWeaties.setDuration(new Float(0.5));
        Show zena = new Show();
        zena.setName("Zena");
        zena.setDescription("Zena the worrier princess");
        zena.setDuration(new Float(20.0f));
        schedule.segments.addElement(eatYourWeaties);
        schedule.segments.addElement(zena);
        UnitOfWork uow = session.acquireUnitOfWork();
        uow.registerObject((Object)schedule);
        uow.commit();
        manager.registerObject((Object)schedule, "example1");
        manager.registerObject((Object)schedule.broadcastor, "example1");
        manager.registerObject((Object)eatYourWeaties, "example1");
        manager.registerObject((Object)zena, "example2");
    }

    public RelationalDescriptor programDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Program.class);
        descriptor.setTableName("TV_PROG");
        descriptor.setPrimaryKeyFieldName("NAME");
        descriptor.getInheritancePolicy().setClassIndicatorFieldName("PG_TYPE");
        descriptor.getInheritancePolicy().addClassIndicator(Show.class, (Object)"S");
        descriptor.getInheritancePolicy().addClassIndicator(Commercial.class, (Object)"C");
        descriptor.addDirectMapping("name", "getName", "setName", "NAME");
        descriptor.addDirectMapping("description", "getDescription", "setDescription", "DESCRIP");
        DirectToFieldMapping durationMapping = new DirectToFieldMapping();
        durationMapping.setAttributeName("duration");
        durationMapping.setGetMethodName("getDuration");
        durationMapping.setSetMethodName("setDuration");
        durationMapping.setFieldName("DUR");
        durationMapping.setAttributeClassification(Float.class);
        descriptor.addMapping((DatabaseMapping)durationMapping);
        return descriptor;
    }

    public TableDefinition programTable() {
        TableDefinition table = new TableDefinition();
        table.setName("TV_PROG");
        table.addPrimaryKeyField("NAME", String.class, 20);
        table.addField("PG_TYPE", Character.class);
        table.addField("DESCRIP", String.class, 200);
        table.addField("DUR", Double.class);
        return table;
    }

    public RelationalDescriptor scheduleDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(TVSchedule.class);
        descriptor.setTableName("TV_SCED");
        descriptor.setPrimaryKeyFieldName("ID");
        descriptor.setSequenceNumberName("SCED_SEQ");
        descriptor.setSequenceNumberFieldName("ID");
        descriptor.addDirectMapping("timeSpot", "TM_SPOT");
        descriptor.addDirectMapping("id", "ID");
        OneToOneMapping broadcastorMapping = new OneToOneMapping();
        broadcastorMapping.setAttributeName("broadcastor");
        broadcastorMapping.setReferenceClass(Network.class);
        broadcastorMapping.setForeignKeyFieldName("NET_NAME");
        broadcastorMapping.dontUseIndirection();
        descriptor.addMapping((DatabaseMapping)broadcastorMapping);
        ManyToManyMapping segmentsMapping = new ManyToManyMapping();
        segmentsMapping.setAttributeName("segments");
        segmentsMapping.setReferenceClass(Program.class);
        segmentsMapping.setRelationTableName("TV_SCPG");
        segmentsMapping.setSourceRelationKeyFieldName("SC_ID");
        segmentsMapping.setTargetRelationKeyFieldName("PG_NAME");
        segmentsMapping.dontUseIndirection();
        descriptor.addMapping((DatabaseMapping)segmentsMapping);
        return descriptor;
    }

    public TableDefinition scheduleProgramTable() {
        TableDefinition table = new TableDefinition();
        table.setName("TV_SCPG");
        table.addField("SC_ID", Double.class);
        table.addField("PG_NAME", String.class, 20);
        return table;
    }

    public TableDefinition scheduleTable() {
        TableDefinition table = new TableDefinition();
        table.setName("TV_SCED");
        table.addField("ID", Double.class);
        table.addField("TM_SPOT", Timestamp.class);
        table.addField("NET_NAME", String.class, 20);
        table.addForeignKeyConstraint("TV_SCED_TV_NET", "NET_NAME", "NAME", "TV_NET");
        return table;
    }

    public RelationalDescriptor showDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Show.class);
        descriptor.getInheritancePolicy().setParentClass(Program.class);
        return descriptor;
    }
}

