/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.aggregate;

import java.util.Vector;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.aggregate.Address;
import org.eclipse.persistence.testing.models.aggregate.Employee;

public class AggregateWithOneToOneRelationshipTest
extends AutoVerifyTestCase {
    public AggregateWithOneToOneRelationshipTest() {
        this.setDescription("Test that an Aggregate with a 1:1 relationship with batch reading enabled works.");
    }

    public void setup() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    public void test() {
        Employee example1 = Employee.example1();
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        ExpressionBuilder builder = query.getExpressionBuilder();
        Expression expression = builder.get("firstName").equal((Object)example1.getFirstName());
        query.setSelectionCriteria(expression);
        try {
            Vector employees = (Vector)this.getSession().executeQuery((DatabaseQuery)query);
            for (Employee employee : employees) {
                Address addressFromDB = (Address)employee.getAddressDescription().getAddress().getValue();
                AggregateWithOneToOneRelationshipTest.assertNotNull((Object)addressFromDB);
            }
        }
        catch (QueryException qe) {
            if (qe.getErrorCode() == 6015) {
                throw new TestErrorException("Aggregate with a 1:1 relationship and batch reading failed: " + qe.getMessage(), (Throwable)qe);
            }
            throw qe;
        }
    }

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }
}

