/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.collections;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.WriteObjectTest;
import org.eclipse.persistence.testing.models.collections.Menu;
import org.eclipse.persistence.testing.models.collections.Restaurant;

public class OTMHashtableObjectUpdateTest
extends WriteObjectTest {
    public OTMHashtableObjectUpdateTest() {
    }

    public OTMHashtableObjectUpdateTest(Object originalObject) {
        super(originalObject);
    }

    protected void setup() {
        this.beginTransaction();
    }

    protected void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.originalObject = this.getSession().readObject(Restaurant.class, new ExpressionBuilder().anyOf("menus").get("type").equalsIgnoreCase("dinner"));
        Restaurant rest = (Restaurant)uow.registerObject(this.originalObject);
        Hashtable menus = (Hashtable)rest.getMenus();
        Enumeration enumtr = menus.elements();
        while (enumtr.hasMoreElements()) {
            Menu menu = (Menu)enumtr.nextElement();
            if (!menu.getType().equalsIgnoreCase("Dinner")) continue;
            menus.remove(menu.getType());
            menu.setType("Breakfast");
            menus.put(menu.getType(), menu);
        }
        uow.commit();
    }

    protected void verify() {
        Restaurant rest = (Restaurant)this.originalObject;
        Hashtable menus = (Hashtable)rest.getMenus();
        Enumeration enumtr = menus.keys();
        while (enumtr.hasMoreElements()) {
            Object menuKey = enumtr.nextElement();
            if (!menuKey.toString().equalsIgnoreCase("Dinner")) continue;
            throw new TestErrorException(" Key of Hashtable is not updated ---> Not Fix Yet");
        }
    }
}

