/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.collections.map;

import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.collections.map.AggregateAggregateMapHolder;
import org.eclipse.persistence.testing.models.collections.map.AggregateMapKey;
import org.eclipse.persistence.testing.tests.collections.map.TestReadAggregateAggregateMapMapping;

public class TestUpdateAggregateAggregateMapMapping
extends TestReadAggregateAggregateMapMapping {
    @Override
    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.holders = uow.readAllObjects(AggregateAggregateMapHolder.class, this.holderExp);
        AggregateAggregateMapHolder holder = (AggregateAggregateMapHolder)this.holders.get(0);
        AggregateMapKey key = new AggregateMapKey();
        key.setKey(11);
        holder.removeAggregateToAggregateMapItem(key);
        AggregateMapKey mapValue = new AggregateMapKey();
        mapValue.setKey(3);
        key = new AggregateMapKey();
        key.setKey(33);
        holder.addAggregateToAggregateMapItem(key, mapValue);
        uow.commit();
        Object holderForComparison = uow.readObject((Object)holder);
        if (!this.compareObjects(holder, holderForComparison)) {
            throw new TestErrorException("Objects do not match after write");
        }
    }

    @Override
    public void verify() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        Object initialHolder = this.holders.get(0);
        this.holders = this.getSession().readAllObjects(AggregateAggregateMapHolder.class, this.holderExp);
        AggregateAggregateMapHolder holder = (AggregateAggregateMapHolder)this.holders.get(0);
        if (!this.compareObjects(holder, initialHolder)) {
            throw new TestErrorException("Objects do not match reinitialize");
        }
        AggregateMapKey key = new AggregateMapKey();
        key.setKey(11);
        if (holder.getAggregateToAggregateMap().containsKey(key)) {
            throw new TestErrorException("Item that was removed is still present in map.");
        }
        key = new AggregateMapKey();
        key.setKey(33);
        AggregateMapKey value = (AggregateMapKey)holder.getAggregateToAggregateMap().get(key);
        if (value.getKey() != 3) {
            throw new TestErrorException("Item was not correctly added to map");
        }
    }
}

