/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.dynamic.simple;

import java.util.Calendar;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.dynamic.DynamicHelper;
import org.eclipse.persistence.dynamic.DynamicType;
import org.eclipse.persistence.dynamic.DynamicTypeBuilder;
import org.eclipse.persistence.exceptions.DynamicException;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.dynamic.DynamicTypeImpl;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.IdentityMapAccessor;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.tests.dynamic.DynamicTestingHelper;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class SimpleTypeTestSuite {
    static DatabaseSession session = null;
    static DynamicHelper dynamicHelper = null;

    @BeforeClass
    public static void setUp() {
        session = DynamicTestingHelper.createSession();
        dynamicHelper = new DynamicHelper(session);
        DynamicClassLoader dcl = dynamicHelper.getDynamicClassLoader();
        Class javaType = dcl.createDynamicClass("simple.Simple");
        DynamicTypeBuilder typeBuilder = new DynamicTypeBuilder(javaType, null, new String[]{"SIMPLE_TYPE"});
        typeBuilder.setPrimaryKeyFields(new String[]{"SID"});
        typeBuilder.addDirectMapping("id", Integer.TYPE, "SID");
        typeBuilder.addDirectMapping("value1", String.class, "VAL_1");
        typeBuilder.addDirectMapping("value2", Boolean.TYPE, "VAL_2");
        typeBuilder.addDirectMapping("value3", Calendar.class, "VAL_3");
        typeBuilder.addDirectMapping("value4", Character.class, "VAL_4");
        dynamicHelper.addTypes(true, false, new DynamicType[]{typeBuilder.getType()});
    }

    @AfterClass
    public static void tearDown() {
        session.executeNonSelectingSQL("DROP TABLE SIMPLE_TYPE");
        session.logout();
        session = null;
        dynamicHelper = null;
    }

    @Test(expected=DynamicException.class)
    public void invalidDirectMappingSet_id() throws Exception {
        DynamicType type = dynamicHelper.getType("Simple");
        DynamicEntity entity = type.newDynamicEntity();
        entity.set("id", (Object)1L);
    }

    @Test
    public void verifyConfig() throws Exception {
        ClassDescriptor descriptor = session.getClassDescriptorForAlias("Simple");
        Assert.assertNotNull((String)"No descriptor found for alias='Simple'", (Object)descriptor);
        DynamicTypeImpl simpleType = (DynamicTypeImpl)dynamicHelper.getType("Simple");
        Assert.assertNotNull((String)"'Simple' EntityType not found", (Object)simpleType);
        Assert.assertEquals((long)(1 + descriptor.getPrimaryKeyFields().size()), (long)simpleType.getMappingsRequiringInitialization().size());
        Assert.assertEquals((Object)descriptor, (Object)simpleType.getDescriptor());
    }

    @Test
    public void find() {
        this.createSimpleInstance((Session)session, 1);
        DynamicEntity simpleInstance = this.find(dynamicHelper, (Session)session, 1);
        Assert.assertNotNull((String)"Could not find simple instance with id = 1", (Object)simpleInstance);
        simpleInstance = this.find(dynamicHelper, (Session)session, new Integer(1));
        Assert.assertNotNull((String)"Could not find simple instance with id = Integer(1)", (Object)simpleInstance);
    }

    @Test
    public void simpleInstance_CRUD() {
        IdentityMapAccessor cache = session.getIdentityMapAccessor();
        DynamicEntity simpleInstance = this.createSimpleInstance((Session)session, 1);
        Assert.assertNotNull((Object)simpleInstance);
        Assert.assertTrue((boolean)cache.containsObjectInIdentityMap((Object)simpleInstance));
        cache.initializeAllIdentityMaps();
        Assert.assertFalse((boolean)cache.containsObjectInIdentityMap((Object)simpleInstance));
    }

    @Test
    public void verifyDefaultValuesFromEntityType() throws Exception {
        DynamicType type = dynamicHelper.getType("Simple");
        Assert.assertNotNull((Object)type);
        DynamicEntity simpleInstance = type.newDynamicEntity();
        this.assertDefaultValues(simpleInstance);
    }

    @Test
    public void verifyDefaultValuesFromDescriptor() throws Exception {
        DynamicType simpleType = dynamicHelper.getType("Simple");
        Assert.assertNotNull((Object)simpleType);
        DynamicEntity simpleInstance = (DynamicEntity)simpleType.getDescriptor().getObjectBuilder().buildNewInstance();
        this.assertDefaultValues(simpleInstance);
    }

    protected void assertDefaultValues(DynamicEntity simpleInstance) {
        Assert.assertNotNull((Object)simpleInstance);
        Assert.assertEquals((String)"id not default value", (long)0L, (long)((Integer)simpleInstance.get("id")).intValue());
        Assert.assertFalse((String)"value1 set on new instance", (boolean)simpleInstance.isSet("value1"));
        Assert.assertEquals((String)"value2 not default value on new instance", (Object)false, (Object)((Boolean)simpleInstance.get("value2")));
        Assert.assertFalse((String)"value3 set on new instance", (boolean)simpleInstance.isSet("value3"));
        Assert.assertFalse((String)"value4 set on new instance", (boolean)simpleInstance.isSet("value4"));
    }

    public DynamicEntity createSimpleInstance(Session session, int id) {
        DynamicType simpleEntityType = dynamicHelper.getType("Simple");
        Assert.assertNotNull((Object)simpleEntityType);
        DynamicEntity simpleInstance = simpleEntityType.newDynamicEntity();
        simpleInstance.set("id", (Object)id);
        simpleInstance.set("value2", (Object)true);
        ReportQuery countQuery = dynamicHelper.newReportQuery("Simple", new ExpressionBuilder());
        countQuery.addCount();
        countQuery.setShouldReturnSingleValue(true);
        Assert.assertEquals((long)0L, (long)((Number)session.executeQuery((DatabaseQuery)countQuery)).intValue());
        UnitOfWork uow = session.acquireUnitOfWork();
        uow.registerNewObject((Object)simpleInstance);
        uow.commit();
        Assert.assertEquals((long)1L, (long)((Number)session.executeQuery((DatabaseQuery)countQuery)).intValue());
        DynamicEntity foundEntity = this.find(dynamicHelper, session, 1);
        Assert.assertNotNull((Object)foundEntity);
        Assert.assertEquals((Object[])((Object[])simpleInstance.get("id")), (Object[])((Object[])foundEntity.get("id")));
        Assert.assertEquals((Object[])((Object[])simpleInstance.get("value1")), (Object[])((Object[])foundEntity.get("value1")));
        Assert.assertEquals((Object[])((Object[])simpleInstance.get("value2")), (Object[])((Object[])foundEntity.get("value2")));
        session.release();
        return simpleInstance;
    }

    protected DynamicEntity find(DynamicHelper helper, Session session, Object id) {
        ReadObjectQuery findQuery = helper.newReadObjectQuery("Simple");
        findQuery.setSelectionCriteria(findQuery.getExpressionBuilder().get("id").equal(id));
        return (DynamicEntity)session.executeQuery((DatabaseQuery)findQuery);
    }

    @Before
    @After
    public void clearSimpleTypeInstances() {
        session.executeNonSelectingSQL("DELETE FROM SIMPLE_TYPE");
        session.getIdentityMapAccessor().initializeAllIdentityMaps();
    }
}

