/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.events;

import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.events.Address;
import org.eclipse.persistence.testing.models.events.EmailAccount;
import org.eclipse.persistence.testing.models.events.Phone;
import org.eclipse.persistence.testing.tests.events.EventHookTestCase;

public class CloneAndMergeEventHookTest
extends EventHookTestCase {
    @Override
    public void setup() {
        super.setup();
        this.getDatabaseSession().writeObject((Object)this.getEmailAccount());
        this.getDatabaseSession().writeObject((Object)this.getPhoneNumber());
        this.getDatabaseSession().writeObject((Object)this.getAddress());
    }

    protected void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        EmailAccount emailAccountCopy = (EmailAccount)uow.readObject((Object)this.getEmailAccount());
        emailAccountCopy.setHostName("localHost");
        Phone phoneNumberCopy = (Phone)uow.readObject((Object)this.getPhoneNumber());
        phoneNumberCopy.phoneNo = "555-5555";
        Address addressCopy = (Address)uow.readObject((Object)this.getAddress());
        addressCopy.address = "No Where";
        uow.commit();
        if (!emailAccountCopy.postCloneExecuted) {
            throw new TestErrorException("Event hook failed. The post clone method on " + emailAccountCopy + " failed to execute.");
        }
        if (!phoneNumberCopy.postCloneExecuted) {
            throw new TestErrorException("Event hook failed. The post clone method on " + phoneNumberCopy + " failed to execute.");
        }
        if (!this.getEmailAccount().postMergeExecuted) {
            throw new TestErrorException("Event hook failed. The post clone method on " + this.getEmailAccount() + " failed to execute.");
        }
        if (!this.getPhoneNumber().postMergeExecuted) {
            throw new TestErrorException("Event hook failed. The post clone method on " + this.getPhoneNumber() + " failed to execute.");
        }
        if (!this.getAddressListener().postMergeExecuted) {
            throw new TestErrorException("Event hook failed. The post clone method on " + this.getAddressListener() + " failed to execute.");
        }
    }
}

