/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.feature;

import org.eclipse.persistence.exceptions.IntegrityException;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.tests.feature.EmployeeProjectForIntegrityChecker;

public class ShouldThroughIntegrityCheckerTest
extends AutoVerifyTestCase {
    public ShouldThroughIntegrityCheckerTest() {
        this.setDescription("Test for catching all the Descriptor Exceptions");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() {
        EmployeeProjectForIntegrityChecker project = new EmployeeProjectForIntegrityChecker();
        project.setDatasourceLogin(this.getSession().getDatasourceLogin());
        DatabaseSession session = new Project(this.getSession().getDatasourceLogin()).createDatabaseSession();
        session.setSessionLog(this.getSession().getSessionLog());
        boolean caughtError = false;
        try {
            session.login();
            session.addDescriptors((Project)project);
        }
        catch (IntegrityException integrityException) {
            if (integrityException.getIntegrityChecker().getCaughtExceptions().size() != 15) {
                throw new TestErrorException("" + integrityException.getIntegrityChecker().getCaughtExceptions().size() + "  Not equal to the Number of Exceptions to the excepted 15.");
            }
            caughtError = true;
        }
        finally {
            session.logout();
        }
        if (!caughtError) {
            throw new TestErrorException("Test is Failed, no error thrown");
        }
    }
}

