/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.identitymaps;

import java.math.BigDecimal;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.identitymaps.WeakIdentityMap;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.InsertObjectQuery;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class InsertWeakIdentityMapTest
extends TestCase {
    protected Class originalIdentityMapClass;
    protected int originalIdentityMapSize;
    protected int identityMapSize = 10;

    public InsertWeakIdentityMapTest() {
        this.setDescription("Test if there is any memory leak in InsertObjectQuery with WeakIdentityMap.");
    }

    protected WeakIdentityMap getIdentityMap() {
        return (WeakIdentityMap)this.getAbstractSession().getIdentityMapAccessorInstance().getIdentityMap(Employee.class);
    }

    public void reset() {
        this.getSession().getDescriptor(Employee.class).setIdentityMapClass(this.originalIdentityMapClass);
        this.getSession().getDescriptor(Employee.class).setIdentityMapSize(this.originalIdentityMapSize);
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    public void setup() {
        this.originalIdentityMapClass = this.getSession().getDescriptor(Employee.class).getIdentityMapClass();
        this.originalIdentityMapSize = this.getSession().getDescriptor(Employee.class).getIdentityMapSize();
        this.getSession().getDescriptor(Employee.class).setIdentityMapClass(WeakIdentityMap.class);
        this.getSession().getDescriptor(Employee.class).setIdentityMapSize(this.identityMapSize);
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    public void test() {
        for (int index = 0; index < this.identityMapSize * 2; ++index) {
            Employee obj = new Employee();
            InsertObjectQuery query = new InsertObjectQuery((Object)obj);
            this.getAbstractSession().beginTransaction();
            this.getSession().executeQuery((DatabaseQuery)query);
            this.getAbstractSession().rollbackTransaction();
            System.gc();
        }
        System.gc();
    }

    public void verify() {
        for (int loops = 0; loops < 10; ++loops) {
            Vector<BigDecimal> vector = new Vector<BigDecimal>(50000);
            for (int i = 0; i < 50000; ++i) {
                vector.add(new BigDecimal(i));
            }
            System.gc();
            System.runFinalization();
        }
        int maxSize = this.identityMapSize + 2;
        if (this.getIdentityMap().getSize() > maxSize) {
            throw new TestErrorException("Weak identity map " + this.getIdentityMap() + " contains " + this.getIdentityMap().getSize() + " objects.  The specified maximum size for this cache was " + maxSize + ".");
        }
        Map cache = this.getIdentityMap().getCacheKeys();
        for (CacheKey key : cache.values()) {
            if (key.getObject() == null) continue;
            throw new TestErrorException("A WeakCacheKey with a non-empty WeakReference was found. The garbage collection did not clear the cache as expected.");
        }
    }
}

