/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation;

import java.util.Date;
import java.util.GregorianCalendar;
import org.eclipse.persistence.descriptors.invalidation.CacheInvalidationPolicy;
import org.eclipse.persistence.descriptors.invalidation.DailyCacheInvalidationPolicy;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation.CacheExpiryTest;

public class DailyCacheExpiryTest
extends CacheExpiryTest {
    protected long millisUntilExpiry = 0L;
    protected long readTimeAdjustment = 0L;
    protected Employee employee = null;
    protected boolean shouldExpire = false;
    protected String initialFirstName = null;

    public DailyCacheExpiryTest(long millisUntilExpiry, long readTimeAdjustment, boolean shouldExpire) {
        this.setDescription("Test a daily cache expiry policy with various different expiry times.");
        this.millisUntilExpiry = millisUntilExpiry;
        this.shouldExpire = shouldExpire;
        this.readTimeAdjustment = readTimeAdjustment;
    }

    @Override
    public void setup() {
        super.setup();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(new Date(System.currentTimeMillis() + this.millisUntilExpiry));
        DailyCacheInvalidationPolicy policy = new DailyCacheInvalidationPolicy(calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14));
        this.getSession().getDescriptor(Employee.class).setCacheInvalidationPolicy((CacheInvalidationPolicy)policy);
    }

    public void test() {
        this.employee = (Employee)this.getSession().readObject(Employee.class);
        this.initialFirstName = this.employee.getFirstName();
        CacheKey key = ((AbstractSession)this.getSession()).getIdentityMapAccessorInstance().getCacheKeyForObject((Object)this.employee);
        key.setReadTime(key.getReadTime() + this.readTimeAdjustment);
        Employee empFromCache = (Employee)key.getObject();
        empFromCache.setFirstName(empFromCache.getFirstName() + "-mutated");
        this.employee = (Employee)this.getSession().readObject(Employee.class);
    }

    public void verify() {
        if (this.shouldExpire && !this.employee.getFirstName().equals(this.initialFirstName) || !this.shouldExpire && this.employee.getFirstName().equals(this.initialFirstName)) {
            throw new TestErrorException("Daily Cache Expiry failed with expiry time different from current time by " + this.millisUntilExpiry + " millis.");
        }
    }
}

