/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.proxyindirection;

import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.tests.proxyindirection.Address;
import org.eclipse.persistence.testing.tests.proxyindirection.Employee;

public class UOWRegisterProxyObjectTest
extends AutoVerifyTestCase {
    public UOWRegisterProxyObjectTest() {
        this.setDescription("Tests registering a proxy object with a UnitOfWork using Proxy Indirection.");
    }

    public void reset() {
        this.getAbstractSession().rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void setup() {
        this.getAbstractSession().beginTransaction();
    }

    public void test() {
        Employee emp = (Employee)this.getSession().readObject(Employee.class, new ExpressionBuilder().get("firstName").like("%Angie%"));
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Address aClone = (Address)uow.registerObject((Object)emp.getAddress());
        aClone.setStreet("706-171 Elm St.");
        aClone.setCity("Toronto");
        uow.commit();
    }

    public void verify() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        Employee emp = (Employee)this.getSession().readObject(Employee.class, new ExpressionBuilder().get("firstName").equal((Object)"Angie"));
        Address address = emp.getAddress();
        if (!address.getStreet().equals("706-171 Elm St.") || !address.getCity().equals("Toronto")) {
            throw new TestErrorException("Proxy object address update did not work properly.\n" + address);
        }
    }
}

