/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import java.util.Vector;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.sessions.Record;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.LargeProject;
import org.eclipse.persistence.testing.models.employee.domain.Project;
import org.eclipse.persistence.testing.tests.queries.OrderingTest;

public class OrderingMutipleTableTest
extends OrderingTest {
    @Override
    protected void setup() {
        this.customSQLRows = this.getSession().executeSelectingCall((Call)new SQLCall("SELECT t1.PROJ_NAME FROM PROJECT t1, LPROJECT t2 WHERE t1.PROJ_ID = t2.PROJ_ID ORDER BY t2.BUDGET"));
    }

    @Override
    public void test() {
        this.orderedQueryObjects = this.executeOrderingQuery(LargeProject.class, "budget");
    }

    protected Vector executeOrderingQuery(Class class1, String orderField) {
        ReadAllQuery query = new ReadAllQuery();
        query.addAscendingOrdering(orderField);
        query.setReferenceClass(class1);
        return (Vector)this.getSession().executeQuery((DatabaseQuery)query);
    }

    @Override
    protected void verify() {
        for (int i = 0; i < this.orderedQueryObjects.size(); ++i) {
            Record row = (Record)this.customSQLRows.elementAt(i);
            Project project = (Project)this.orderedQueryObjects.elementAt(i);
            String name = (String)row.get((Object)"PROJ_NAME");
            if (project.getName().equals(name)) continue;
            throw new TestErrorException("The ordering test failed.  The results are not in the right order");
        }
    }
}

