/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.sessioncache;

import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class ReadObjectAlreadyInSessionCacheTest
extends TestCase {
    private Employee objectInCache;
    private int newSalary;

    public ReadObjectAlreadyInSessionCacheTest() {
        this.setDescription("The test that change are merged into the object in the session cache");
    }

    protected void setup() {
        this.checkNoWaitSupported();
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.objectInCache = (Employee)this.getSession().readObject(Employee.class);
        this.getAbstractSession().beginTransaction();
    }

    protected void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        ReadObjectQuery query = new ReadObjectQuery((Object)this.objectInCache);
        query.setLockMode((short)2);
        Employee emp = (Employee)uow.executeQuery((DatabaseQuery)query);
        this.newSalary = emp.getSalary() + 1;
        emp.setSalary(this.newSalary);
        uow.commit();
    }

    protected void verify() {
        Employee verifyObject = (Employee)this.getSession().readObject((Object)this.objectInCache);
        int salary = verifyObject.getSalary();
        if (salary != this.newSalary) {
            throw new TestErrorException("Changes were not merged into Session Cache");
        }
    }

    public void reset() throws Exception {
        this.getAbstractSession().rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }
}

