/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork.changeflag;

import junit.framework.Test;
import org.eclipse.persistence.descriptors.changetracking.AttributeChangeTrackingPolicy;
import org.eclipse.persistence.descriptors.changetracking.DeferredChangeDetectionPolicy;
import org.eclipse.persistence.descriptors.changetracking.ObjectChangePolicy;
import org.eclipse.persistence.descriptors.changetracking.ObjectChangeTrackingPolicy;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.EmploymentPeriod;
import org.eclipse.persistence.testing.models.employee.domain.LargeProject;
import org.eclipse.persistence.testing.models.employee.domain.PhoneNumber;
import org.eclipse.persistence.testing.models.employee.domain.Project;
import org.eclipse.persistence.testing.models.employee.domain.SmallProject;
import org.eclipse.persistence.testing.tests.unitofwork.DeepMergeCloneSerializedObjectReferenceChangesTest;
import org.eclipse.persistence.testing.tests.unitofwork.DeepMergeCloneSerializedTest;
import org.eclipse.persistence.testing.tests.unitofwork.MultipleUnitOfWorkTest;
import org.eclipse.persistence.testing.tests.unitofwork.UnitOfWorkCommitResumeOnFailureNoFailureTest;
import org.eclipse.persistence.testing.tests.unitofwork.UnitOfWorkResumeOnFailureTest;
import org.eclipse.persistence.testing.tests.unitofwork.UnitOfWorkResumeTest;
import org.eclipse.persistence.testing.tests.unitofwork.UnitOfWorkRevertTest;
import org.eclipse.persistence.testing.tests.unitofwork.changeflag.ChangeFlagTest;
import org.eclipse.persistence.testing.tests.unitofwork.changeflag.EmployeeChangeFlagBasicTestModel;
import org.eclipse.persistence.testing.tests.unitofwork.changeflag.NestedUOWWithAttributeChangeTrackingTest;
import org.eclipse.persistence.testing.tests.writing.ComplexUpdateTest;
import org.eclipse.persistence.testing.tests.writing.UpdateChangeNothingTest;
import org.eclipse.persistence.testing.tests.writing.UpdateChangeObjectTest;
import org.eclipse.persistence.testing.tests.writing.UpdateChangeValueTest;
import org.eclipse.persistence.testing.tests.writing.UpdateToNullTest;
import org.eclipse.persistence.tools.schemaframework.PopulationManager;

public class EmployeeHybridChangeTrackingTestModel
extends EmployeeChangeFlagBasicTestModel {
    public EmployeeHybridChangeTrackingTestModel() {
        this.setDescription("This model tests reading/writing/deleting using the employee demo with Hybrid ChangeTracking policies.");
    }

    @Override
    public void setup() {
        this.employeeChangePolicy = this.getSession().getDescriptor(Employee.class).getObjectChangePolicy();
        this.getSession().getDescriptor(Employee.class).setObjectChangePolicy((ObjectChangePolicy)new AttributeChangeTrackingPolicy());
        this.addressChangePolicy = this.getSession().getDescriptor(Address.class).getObjectChangePolicy();
        this.getSession().getDescriptor(Address.class).setObjectChangePolicy((ObjectChangePolicy)new ObjectChangeTrackingPolicy());
        this.projectChangePolicy = this.getSession().getDescriptor(Project.class).getObjectChangePolicy();
        this.getSession().getDescriptor(Project.class).setObjectChangePolicy((ObjectChangePolicy)new AttributeChangeTrackingPolicy());
        this.smallProjectChangePolicy = this.getSession().getDescriptor(SmallProject.class).getObjectChangePolicy();
        this.getSession().getDescriptor(SmallProject.class).setObjectChangePolicy((ObjectChangePolicy)new ObjectChangeTrackingPolicy());
        this.largeProjectChangePolicy = this.getSession().getDescriptor(LargeProject.class).getObjectChangePolicy();
        this.getSession().getDescriptor(LargeProject.class).setObjectChangePolicy((ObjectChangePolicy)new DeferredChangeDetectionPolicy());
        this.employmentPeriodChangePolicy = this.getSession().getDescriptor(EmploymentPeriod.class).getObjectChangePolicy();
        this.getSession().getDescriptor(EmploymentPeriod.class).setObjectChangePolicy((ObjectChangePolicy)new ObjectChangeTrackingPolicy());
        this.getSession().getDescriptor(Employee.class).getMappingForAttributeName("period").getReferenceDescriptor().setObjectChangePolicy((ObjectChangePolicy)new ObjectChangeTrackingPolicy());
        this.phoneNumberChangePolicy = this.getSession().getDescriptor(PhoneNumber.class).getObjectChangePolicy();
        this.getSession().getDescriptor(PhoneNumber.class).setObjectChangePolicy((ObjectChangePolicy)new DeferredChangeDetectionPolicy());
    }

    @Override
    public void reset() {
        this.getSession().getDescriptor(Employee.class).setObjectChangePolicy(this.employeeChangePolicy);
        this.getSession().getDescriptor(Address.class).setObjectChangePolicy(this.addressChangePolicy);
        this.getSession().getDescriptor(Project.class).setObjectChangePolicy(this.projectChangePolicy);
        this.getSession().getDescriptor(SmallProject.class).setObjectChangePolicy(this.smallProjectChangePolicy);
        this.getSession().getDescriptor(LargeProject.class).setObjectChangePolicy(this.largeProjectChangePolicy);
        this.getSession().getDescriptor(EmploymentPeriod.class).setObjectChangePolicy(this.employmentPeriodChangePolicy);
        this.getSession().getDescriptor(PhoneNumber.class).setObjectChangePolicy(this.phoneNumberChangePolicy);
    }

    @Override
    public TestSuite getUnitOfWorkTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("Unit Of Work Update Test Suite");
        suite.setDescription("This suite tests change flags for updates using UnitOfWork");
        PopulationManager manager = PopulationManager.getDefaultManager();
        Employee employee = (Employee)manager.getObject(Employee.class, "0001");
        ComplexUpdateTest test = new UpdateToNullTest(employee);
        test.usesUnitOfWork = true;
        suite.addTest((Test)test);
        test = new UpdateChangeValueTest(employee);
        test.usesUnitOfWork = true;
        suite.addTest((Test)test);
        test = new UpdateChangeNothingTest(employee);
        test.usesUnitOfWork = true;
        suite.addTest((Test)test);
        test = new UpdateChangeObjectTest(employee);
        test.usesUnitOfWork = true;
        suite.addTest((Test)test);
        suite.addTest((Test)new MultipleUnitOfWorkTest(employee));
        suite.addTest((Test)new UnitOfWorkResumeTest(employee));
        suite.addTest((Test)new UnitOfWorkResumeOnFailureTest(employee));
        suite.addTest((Test)new UnitOfWorkCommitResumeOnFailureNoFailureTest(employee));
        suite.addTest((Test)new UnitOfWorkRevertTest(employee));
        suite.addTest((Test)new ChangeFlagTest());
        suite.addTest((Test)new NestedUOWWithAttributeChangeTrackingTest(employee));
        suite.addTest((Test)new DeepMergeCloneSerializedTest());
        suite.addTest((Test)new DeepMergeCloneSerializedObjectReferenceChangesTest());
        return suite;
    }
}

