/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.validation;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.validation.EmployeeWithProblems;
import org.eclipse.persistence.testing.tests.validation.ExceptionTestSaveDescriptor;

public class ReferenceDescriptorIsNotAggregateTest
extends ExceptionTestSaveDescriptor {
    public ReferenceDescriptorIsNotAggregateTest() {
        this.setDescription("This tests Reference Descriptor Is Not Aggregate (TL-ERROR 77) ");
    }

    @Override
    protected void setup() {
        this.expectedException = DescriptorException.referenceDescriptorIsNotAggregate(null, null);
        super.setup();
    }

    public void test() {
        try {
            ((DatabaseSession)this.getSession()).addDescriptor((ClassDescriptor)this.buildEmployeeDescriptor());
            ((DatabaseSession)this.getSession()).addDescriptor((ClassDescriptor)this.buildEmploymentPeriodDescriptor());
        }
        catch (EclipseLinkException exception) {
            this.caughtException = exception;
        }
    }

    public RelationalDescriptor buildEmployeeDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(EmployeeWithProblems.class);
        descriptor.addTableName("EMPLOYEE");
        descriptor.addTableName("SALARY");
        descriptor.addPrimaryKeyFieldName("EMPLOYEE.EMP_ID");
        descriptor.useFullIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.useRemoteFullIdentityMap();
        descriptor.setRemoteIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("EMP_ID");
        descriptor.setSequenceNumberName("EMP_SEQ");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("EMPLOYEE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        AggregateObjectMapping periodMapping = new AggregateObjectMapping();
        periodMapping.setAttributeName("period");
        periodMapping.setReferenceClass(Employee.class);
        periodMapping.setIsNullAllowed(true);
        descriptor.addMapping((DatabaseMapping)periodMapping);
        return descriptor;
    }

    public RelationalDescriptor buildEmploymentPeriodDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Employee.class);
        descriptor.addTableName("EMPLOYEE");
        descriptor.addPrimaryKeyFieldName("EMPLOYEE.EMP_ID");
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("EMPLOYEE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        return descriptor;
    }
}

