/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.advanced;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestException;
import org.eclipse.persistence.testing.models.jpa.advanced.Address;
import org.eclipse.persistence.testing.models.jpa.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.advanced.ModelExamples;
import org.eclipse.persistence.testing.models.jpa.advanced.PhoneNumber;
import org.eclipse.persistence.testing.models.jpa.advanced.PhoneNumberPK;
import org.eclipse.persistence.testing.models.jpa.advanced.Project;
import org.eclipse.persistence.testing.tests.jpa.EntityContainerTestBase;

public class EMRemoveAndCommitTests
extends EntityContainerTestBase {
    protected boolean reset = false;
    public Integer[] empIDs = new Integer[3];
    public Integer[] projIDs = new Integer[2];
    public Integer[] addrIDs = new Integer[1];
    public ArrayList<PhoneNumberPK> phoneIDs = new ArrayList();

    public EMRemoveAndCommitTests() {
        this.setDescription("Test remove and commit in EntityManager");
    }

    @Override
    public void setup() {
        super.setup();
        this.reset = true;
        Employee empClone1 = ModelExamples.employeeExample1();
        empClone1.setAddress(ModelExamples.addressExample1());
        empClone1.addPhoneNumber(ModelExamples.phoneExample1());
        empClone1.addPhoneNumber(ModelExamples.phoneExample9());
        Employee empClone2 = ModelExamples.employeeExample2();
        empClone2.setAddress(ModelExamples.addressExample2());
        empClone2.addPhoneNumber(ModelExamples.phoneExample2());
        empClone2.addPhoneNumber(ModelExamples.phoneExample8());
        Employee empClone3 = ModelExamples.employeeExample3();
        empClone3.setAddress(ModelExamples.addressExample3());
        empClone3.addPhoneNumber(ModelExamples.phoneExample3());
        empClone3.addPhoneNumber(ModelExamples.phoneExample7());
        empClone1.addManagedEmployee(empClone2);
        empClone1.addManagedEmployee(empClone3);
        Project projClone1 = ModelExamples.projectExample1();
        Project projClone2 = ModelExamples.projectExample2();
        projClone1.setTeamLeader(empClone1);
        projClone1.addTeamMember(empClone1);
        projClone1.addTeamMember(empClone2);
        projClone1.addTeamMember(empClone3);
        empClone1.addProject(projClone1);
        empClone2.addProject(projClone1);
        empClone3.addProject(projClone1);
        Address addrClone = ModelExamples.addressExample4();
        try {
            this.beginTransaction();
            this.getEntityManager().persist((Object)empClone1);
            this.getEntityManager().persist((Object)empClone2);
            this.getEntityManager().persist((Object)empClone3);
            this.getEntityManager().persist((Object)projClone1);
            this.getEntityManager().persist((Object)projClone2);
            this.getEntityManager().persist((Object)addrClone);
            this.commitTransaction();
        }
        catch (Exception ex) {
            this.rollbackTransaction();
            throw new TestException("Unable to setup Test" + ex);
        }
        ((EntityManagerImpl)this.getEntityManager()).getActiveSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.empIDs[0] = empClone1.getId();
        this.empIDs[1] = empClone2.getId();
        this.empIDs[2] = empClone3.getId();
        this.projIDs[0] = projClone1.getId();
        this.projIDs[1] = projClone2.getId();
        this.addrIDs[0] = addrClone.getID();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    @Override
    public void reset() {
        if (this.reset) {
            this.phoneIDs.clear();
            this.reset = false;
        }
        super.reset();
    }

    public void test() {
        try {
            this.beginTransaction();
            Employee employee = (Employee)this.getEntityManager().find(Employee.class, (Object)this.empIDs[1]);
            ArrayList projects = new ArrayList(employee.getProjects());
            for (Project project : projects) {
                if (project.getTeamLeader() == employee) {
                    project.setTeamLeader(null);
                }
                employee.getProjects().remove(project);
            }
            ArrayList managedEmps = new ArrayList(employee.getManagedEmployees());
            for (Employee report : managedEmps) {
                if (report.getManager() == employee) {
                    report.setManager(null);
                }
                employee.getManagedEmployees().remove(report);
            }
            Iterator phones = employee.getPhoneNumbers().iterator();
            while (phones.hasNext()) {
                this.phoneIDs.add(((PhoneNumber)phones.next()).buildPK());
            }
            this.getEntityManager().remove((Object)employee);
            Address address = (Address)this.getEntityManager().find(Address.class, (Object)this.addrIDs[0]);
            this.getEntityManager().remove((Object)address);
            this.commitTransaction();
        }
        catch (Exception ex) {
            this.rollbackTransaction();
            throw new TestErrorException("Exception thrown during assignment of employee to a project" + ex);
        }
    }

    public void verify() {
        PhoneNumber phone;
        Employee employee = (Employee)this.getEntityManager().find(Employee.class, (Object)this.empIDs[1]);
        if (employee != null) {
            throw new TestErrorException("Employee ID :" + this.empIDs[1] + " Was not Deleted");
        }
        Iterator<PhoneNumberPK> ids = this.phoneIDs.iterator();
        while (ids.hasNext()) {
            phone = (PhoneNumber)this.getEntityManager().find(PhoneNumber.class, (Object)ids.next());
            if (phone == null) continue;
            throw new TestErrorException("Employee ID :" + this.empIDs[1] + " Related Phones were not deleted");
        }
        ((JpaEntityManager)this.getEntityManager()).getActiveSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        employee = (Employee)this.getEntityManager().find(Employee.class, (Object)this.empIDs[1]);
        if (employee != null) {
            throw new TestErrorException("Employee ID :" + this.empIDs[1] + " Was not Deleted on Database");
        }
        ids = this.phoneIDs.iterator();
        while (ids.hasNext()) {
            phone = (PhoneNumber)this.getEntityManager().find(PhoneNumber.class, (Object)ids.next());
            if (phone == null) continue;
            throw new TestErrorException("Employee ID :" + this.empIDs[1] + " Related Phones were not deleted on Database");
        }
        Address address = (Address)this.getEntityManager().find(Address.class, (Object)this.addrIDs[0]);
        if (address != null) {
            throw new TestErrorException("Address ID :" + this.addrIDs[0] + " Was not Deleted on Database");
        }
    }
}

