/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.advanced;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;

public class InvalidNamedQueryTest
extends JUnitTestCase {
    public InvalidNamedQueryTest() {
    }

    public InvalidNamedQueryTest(String s) {
        super(s);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(InvalidNamedQueryTest.class);
        return suite;
    }

    public void testInvalidNamedQuery() {
        try {
            EntityManager em = InvalidNamedQueryTest.createEntityManager((String)"invalid-named-query");
            InvalidNamedQueryTest.fail((String)"Shouldn't have got here!");
        }
        catch (PersistenceException persistenceException) {
            // empty catch block
        }
    }

    public void testEmCreateWithInvalidNamedQuery() {
        try (EntityManager em = null;){
            em = InvalidNamedQueryTest.createEntityManager((String)"invalid-named-query-tolerate");
            InvalidNamedQueryTest.assertNotNull((Object)em);
        }
    }

    public void testEmCreateWithInvalidNamedQueryValidationOnly() {
        try (EntityManager em = null;){
            em = InvalidNamedQueryTest.createEntityManager((String)"invalid-named-query-validation-only");
            InvalidNamedQueryTest.assertNull((Object)em);
        }
    }

    public void testQueryCreateInvalidNamedQuery() {
        try (EntityManager em = null;){
            em = InvalidNamedQueryTest.createEntityManager((String)"invalid-named-query-tolerate");
            InvalidNamedQueryTest.assertNotNull((Object)em);
            try {
                em.createNamedQuery("non-existant-entity");
                InvalidNamedQueryTest.fail();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                em.createNamedQuery("non-existant-entity");
                InvalidNamedQueryTest.fail();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }
}

