/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.fieldaccess.advanced;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityNotFoundException;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import javax.persistence.OptimisticLockException;
import javax.persistence.Persistence;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import javax.persistence.RollbackException;
import javax.persistence.TransactionRequiredException;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.EJBQueryImpl;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.jpa.JpaQuery;
import org.eclipse.persistence.logging.SessionLogEntry;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.sequencing.NativeSequence;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.ExternalTransactionController;
import org.eclipse.persistence.sessions.server.ReadConnectionPool;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCaseHelper;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.Address;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.AdvancedTableCreator;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.Buyer;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.Customizer;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.Department;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.EmploymentPeriod;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.Equipment;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.EquipmentCode;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.FormerEmployment;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.GoldBuyer;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.Golfer;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.GolferPK;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.LargeProject;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.Man;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.PartnerLink;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.PhoneNumber;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.PlatinumBuyer;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.Project;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.SmallProject;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.SuperLargeProject;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.Vegetable;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.VegetablePK;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.Woman;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.WorldRank;
import org.eclipse.persistence.tools.schemaframework.SequenceObjectDefinition;
import org.eclipse.persistence.transaction.AbstractSynchronizationListener;
import org.eclipse.persistence.transaction.AbstractTransactionController;

public class EntityManagerTLRJUnitTestSuite
extends JUnitTestCase {
    public EntityManagerTLRJUnitTestSuite() {
    }

    public EntityManagerTLRJUnitTestSuite(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("EntityManagerTLRJUnitTestSuite (fieldaccess)");
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testSetup"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testWeaving"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testClearEntityManagerWithoutPersistenceContext"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testUpdateAllProjects"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testUpdateUsingTempStorage"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testSequenceObjectDefinition"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testFindDeleteAllPersist"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testExtendedPersistenceContext"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testRemoveFlushFind"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testRemoveFlushPersistContains"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testTransactionRequired"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testSubString"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testFlushModeOnUpdateQuery"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testContainsRemoved"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testRefreshRemoved"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testRefreshNotManaged"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testDoubleMerge"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testDescriptorNamedQueryForMultipleQueries"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testDescriptorNamedQuery"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testClearEntityManagerWithoutPersistenceContextSimulateJTA"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testMultipleEntityManagerFactories"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testOneToManyDefaultJoinTableName"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testClosedEmShouldThrowException"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testRollbackOnlyOnException"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testUpdateAllProjectsWithNullTeamLeader"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testUpdateAllLargeProjectsWithNullTeamLeader"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testUpdateAllSmallProjectsWithNullTeamLeader"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testUpdateAllProjectsWithName"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testUpdateAllLargeProjectsWithName"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testUpdateAllSmallProjectsWithName"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testUpdateAllLargeProjects"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testUpdateAllSmallProjects"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testUpdateUsingTempStorageWithParameter"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testDeleteAllLargeProjectsWithNullTeamLeader"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testDeleteAllSmallProjectsWithNullTeamLeader"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testDeleteAllProjectsWithNullTeamLeader"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testDeleteAllPhonesWithNullOwner"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testSetFieldForPropertyAccessWithNewEM"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testSetFieldForPropertyAccessWithRefresh"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testSetFieldForPropertyAccess"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testInitializeFieldForPropertyAccess"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testCascadePersistToNonEntitySubclass"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testCascadeMergeManaged"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testCascadeMergeDetached"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testPrimaryKeyUpdateSameValue"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testRemoveNull"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testContainsNull"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testPersistNull"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testMergeNull"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testMergeRemovedObject"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testMergeDetachedObject"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testSerializedLazy"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testCloneable"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testLeftJoinOneToOneQuery"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testNullifyAddressIn"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testQueryOnClosedEM"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testIncorrectBatchQueryHint"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testFetchQueryHint"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testBatchQueryHint"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testQueryHints"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testParallelMultipleFactories"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testMultipleFactories"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testPersistenceProperties"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testBeginTransactionCloseCommitTransaction"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testBeginTransactionClose"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testClose"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testPersistOnNonEntity"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testWRITELock"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testReadTransactionIsolation_OriginalInCache_UpdateAll_Refresh_Flush"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testReadTransactionIsolation_OriginalInCache_UpdateAll_Refresh"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testReadTransactionIsolation_OriginalInCache_UpdateAll_Flush"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testReadTransactionIsolation_OriginalInCache_UpdateAll"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testReadTransactionIsolation_OriginalInCache_CustomUpdate_Refresh_Flush"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testReadTransactionIsolation_OriginalInCache_CustomUpdate_Refresh"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testReadTransactionIsolation_OriginalInCache_CustomUpdate_Flush"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testReadTransactionIsolation_OriginalInCache_CustomUpdate"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testReadTransactionIsolation_UpdateAll_Refresh_Flush"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testReadTransactionIsolation_UpdateAll_Refresh"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testReadTransactionIsolation_UpdateAll_Flush"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testReadTransactionIsolation_UpdateAll"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testReadTransactionIsolation_CustomUpdate_Refresh_Flush"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testReadTransactionIsolation_CustomUpdate_Refresh"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testReadTransactionIsolation_CustomUpdate_Flush"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testReadTransactionIsolation_CustomUpdate"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testClearInTransaction"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testClearWithFlush"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testClear"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testCheckVersionOnMerge"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testFindWithNullPk"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testFindWithWrongTypePk"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testPersistManagedNoException"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testPersistManagedException"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testPersistRemoved"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testREADLock"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testIgnoreRemovedObjectsOnDatabaseSync"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testIdentityOutsideTransaction"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testIdentityInsideTransaction"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testDatabaseSyncNewObject"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testSetRollbackOnly"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testFlushModeEmCommitQueryAuto"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testFlushModeEmCommit"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testFlushModeEmCommitQueryCommit"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testFlushModeEmAutoQueryAuto"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testFlushModeEmAuto"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testFlushModeEmAutoQueryCommit"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testCacheUsage"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testSuperclassFieldInSubclass"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testCopyingAddress"));
        suite.addTest((Test)new EntityManagerTLRJUnitTestSuite("testSequencePreallocationUsingCallbackTest"));
        return suite;
    }

    public void testSetup() {
        new AdvancedTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession((String)"fieldaccess"));
        if (EntityManagerTLRJUnitTestSuite.getServerSession((String)"fieldaccess").getPlatform().isPostgreSQL()) {
            EntityManagerTLRJUnitTestSuite.getServerSession().getLogin().setShouldForceFieldNamesToUpperCase(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRefreshNotManaged() {
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        Employee emp = new Employee();
        emp.setFirstName("testRefreshNotManaged");
        try {
            em.refresh((Object)emp);
            EntityManagerTLRJUnitTestSuite.fail((String)"entityManager.refresh(notManagedObject) didn't throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            EntityManagerTLRJUnitTestSuite.fail((String)("entityManager.refresh(notManagedObject) threw a wrong exception: " + exception.getMessage()));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    public void testRefreshRemoved() {
        Employee emp;
        String firstName = "testRefreshRemoved";
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        List result = em.createQuery("SELECT OBJECT(e) FROM Employee e WHERE e.firstName = '" + firstName + "'").getResultList();
        if (!result.isEmpty()) {
            emp = (Employee)result.get(0);
        } else {
            emp = new Employee();
            emp.setFirstName(firstName);
            try {
                this.beginTransaction(em);
                em.persist((Object)emp);
                this.commitTransaction(em);
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                throw ex;
            }
        }
        try {
            this.beginTransaction(em);
            emp = (Employee)em.find(Employee.class, (Object)emp.getId());
            if (EntityManagerTLRJUnitTestSuite.getServerSession((String)"fieldaccess").getPlatform().isSymfoware()) {
                em.createNativeQuery("DELETE FROM CMP3_FA_EMPLOYEE WHERE F_NAME = '" + firstName + "'").executeUpdate();
            } else {
                em.createQuery("DELETE FROM Employee e WHERE e.firstName = '" + firstName + "'").executeUpdate();
            }
            em.refresh((Object)emp);
            EntityManagerTLRJUnitTestSuite.fail((String)"entityManager.refresh(removedObject) didn't throw exception");
        }
        catch (EntityNotFoundException entityNotFoundException) {
            this.rollbackTransaction(em);
        }
        catch (Exception exception) {
            this.rollbackTransaction(em);
            EntityManagerTLRJUnitTestSuite.fail((String)("entityManager.refresh(removedObject) threw a wrong exception: " + exception.getMessage()));
        }
    }

    public void testCacheUsage() {
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        Employee emp = new Employee();
        emp.setFirstName("Mark");
        try {
            this.beginTransaction(em);
            em.persist((Object)emp);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw ex;
        }
        EntityManagerTLRJUnitTestSuite.clearCache((String)"fieldaccess");
        em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        List result = em.createQuery("SELECT OBJECT(e) FROM Employee e").getResultList();
        this.commitTransaction(em);
        Object obj = EntityManagerTLRJUnitTestSuite.getServerSession((String)"fieldaccess").getIdentityMapAccessor().getFromIdentityMap(result.get(0));
        EntityManagerTLRJUnitTestSuite.assertTrue((String)"Failed to load the object into the shared cache when there were no changes in the UOW", (obj != null ? 1 : 0) != 0);
        try {
            this.beginTransaction(em);
            emp = (Employee)em.find(Employee.class, (Object)emp.getId());
            em.remove((Object)emp);
            this.commitTransaction(em);
        }
        catch (RuntimeException exception) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw exception;
        }
    }

    public void testContainsRemoved() {
        Employee emp;
        String firstName = "testContainsRemoved";
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        List result = em.createQuery("SELECT OBJECT(e) FROM Employee e WHERE e.firstName = '" + firstName + "'").getResultList();
        if (!result.isEmpty()) {
            emp = (Employee)result.get(0);
        } else {
            emp = new Employee();
            emp.setFirstName(firstName);
            try {
                this.beginTransaction(em);
                em.persist((Object)emp);
                this.commitTransaction(em);
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                throw ex;
            }
        }
        boolean containsRemoved = true;
        try {
            this.beginTransaction(em);
            emp = (Employee)em.find(Employee.class, (Object)emp.getId());
            em.remove((Object)emp);
            containsRemoved = em.contains((Object)emp);
            this.commitTransaction(em);
        }
        catch (RuntimeException t) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw t;
        }
        EntityManagerTLRJUnitTestSuite.assertFalse((String)"entityManager.contains(removedObject)==true ", (boolean)containsRemoved);
    }

    public void testFlushModeEmAutoQueryCommit() {
        this.internalTestFlushMode(FlushModeType.AUTO, FlushModeType.COMMIT);
    }

    public void testFlushModeEmAuto() {
        this.internalTestFlushMode(FlushModeType.AUTO, null);
    }

    public void testFlushModeEmAutoQueryAuto() {
        this.internalTestFlushMode(FlushModeType.AUTO, FlushModeType.AUTO);
    }

    public void testFlushModeEmCommitQueryCommit() {
        this.internalTestFlushMode(FlushModeType.COMMIT, FlushModeType.COMMIT);
    }

    public void testFlushModeEmCommit() {
        this.internalTestFlushMode(FlushModeType.COMMIT, null);
    }

    public void testFlushModeEmCommitQueryAuto() {
        this.internalTestFlushMode(FlushModeType.COMMIT, FlushModeType.AUTO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalTestFlushMode(FlushModeType emFlushMode, FlushModeType queryFlushMode) {
        boolean shouldHaveFlushed;
        String firstName = "testFlushMode";
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            Query q = em.createQuery("SELECT e FROM Employee e WHERE e.firstName = '" + firstName + "'");
            for (Object oldData : q.getResultList()) {
                em.remove(oldData);
            }
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw ex;
        }
        EntityManagerTLRJUnitTestSuite.clearCache((String)"fieldaccess");
        FlushModeType emFlushModeOriginal = em.getFlushMode();
        Employee emp = new Employee();
        emp.setFirstName(firstName);
        boolean flushed = true;
        Employee result = null;
        try {
            this.beginTransaction(em);
            Query query = em.createQuery("SELECT OBJECT(e) FROM Employee e WHERE e.firstName like '" + firstName + "'");
            if (queryFlushMode != null) {
                query.setFlushMode(queryFlushMode);
            }
            emFlushModeOriginal = em.getFlushMode();
            em.setFlushMode(emFlushMode);
            em.persist((Object)emp);
            result = (Employee)query.getSingleResult();
            result.toString();
        }
        catch (NoResultException ex) {
            flushed = false;
        }
        finally {
            this.rollbackTransaction(em);
            em.setFlushMode(emFlushModeOriginal);
        }
        if (queryFlushMode != null) {
            shouldHaveFlushed = queryFlushMode == FlushModeType.AUTO;
        } else {
            boolean bl = shouldHaveFlushed = emFlushMode == FlushModeType.AUTO;
        }
        if (shouldHaveFlushed != flushed) {
            if (flushed) {
                EntityManagerTLRJUnitTestSuite.fail((String)"Flushed to database");
            } else {
                EntityManagerTLRJUnitTestSuite.fail((String)"Failed to flush to database");
            }
        }
    }

    public void testFlushModeOnUpdateQuery() {
        String firstName = "testFlushModeOnUpdateQuery";
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        Employee emp = new Employee();
        emp.setFirstName(firstName);
        try {
            try {
                this.beginTransaction(em);
                Query readQuery = em.createQuery("SELECT OBJECT(e) FROM Employee e WHERE e.phoneNumbers IS EMPTY and e.firstName like '" + firstName + "'");
                Query updateQuery = null;
                updateQuery = EntityManagerTLRJUnitTestSuite.getServerSession((String)"fieldaccess").getPlatform().isSymfoware() ? em.createNativeQuery("UPDATE CMP3_FA_EMPLOYEE SET VERSION = (VERSION + 1) WHERE F_NAME LIKE '" + firstName + "' AND EMP_ID in (SELECT EMP_ID FROM CMP3_FA_SALARY)") : em.createQuery("UPDATE Employee e set e.salary = 100 where e.firstName like '" + firstName + "'");
                updateQuery.setFlushMode(FlushModeType.AUTO);
                em.persist((Object)emp);
                updateQuery.executeUpdate();
                if (EntityManagerTLRJUnitTestSuite.getServerSession((String)"fieldaccess").getPlatform().isSymfoware()) {
                    updateQuery = em.createNativeQuery("UPDATE CMP3_FA_SALARY SET SALARY = 100 WHERE EMP_ID IN (SELECT EMP_ID FROM CMP3_FA_EMPLOYEE WHERE F_NAME LIKE '" + firstName + "')");
                    updateQuery.setFlushMode(FlushModeType.AUTO);
                    updateQuery.executeUpdate();
                }
                Employee result = (Employee)readQuery.getSingleResult();
                result.toString();
            }
            catch (EntityNotFoundException ex) {
                this.rollbackTransaction(em);
                EntityManagerTLRJUnitTestSuite.fail((String)"Failed to flush to database");
            }
            em.refresh((Object)emp);
            EntityManagerTLRJUnitTestSuite.assertTrue((String)"Failed to flush to Database", (emp.getSalary() == 100 ? 1 : 0) != 0);
            em.remove((Object)emp);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetRollbackOnly() {
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        Employee emp = null;
        Employee emp2 = null;
        try {
            emp = new Employee();
            emp.setFirstName("Bob");
            emp.setLastName("Fisher");
            em.persist((Object)emp);
            emp2 = new Employee();
            emp2.setFirstName("Anthony");
            emp2.setLastName("Walace");
            em.persist((Object)emp2);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        EntityManagerTLRJUnitTestSuite.clearCache((String)"fieldaccess");
        em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        List result = em.createQuery("SELECT e FROM Employee e where e.id = " + emp.getId() + " or e.id = " + emp2.getId()).getResultList();
        emp = (Employee)result.get(0);
        emp.toString();
        emp2 = (Employee)result.get(1);
        String newName = "" + System.currentTimeMillis();
        emp2.setFirstName(newName);
        em.flush();
        emp2.setLastName("Whatever");
        emp2.setVersion(Integer.valueOf(0));
        try {
            em.flush();
        }
        catch (Exception ex) {
            em.clear();
            try {
                String eName = (String)em.createQuery("SELECT e.firstName FROM Employee e where e.id = " + emp2.getId()).getSingleResult();
                EntityManagerTLRJUnitTestSuite.assertTrue((String)"Failed to keep txn open for set RollbackOnly", (boolean)eName.equals(newName));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            if (EntityManagerTLRJUnitTestSuite.isOnServer()) {
                EntityManagerTLRJUnitTestSuite.assertTrue((String)"Failed to mark txn rollback only", (!this.isTransactionActive(em) ? 1 : 0) != 0);
            } else {
                EntityManagerTLRJUnitTestSuite.assertTrue((String)"Failed to mark txn rollback only", (boolean)em.getTransaction().getRollbackOnly());
            }
        }
        finally {
            try {
                this.commitTransaction(em);
            }
            catch (RollbackException ex) {
                return;
            }
            catch (RuntimeException ex) {
                if (ex.getCause() instanceof javax.transaction.RollbackException) {
                    return;
                }
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                throw ex;
            }
        }
        EntityManagerTLRJUnitTestSuite.fail((String)"Failed to throw rollback exception");
    }

    public void testSubString() {
        if (JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
            EntityManagerTLRJUnitTestSuite.getServerSession().logMessage("Test testSubString skipped for this platform, Symfoware doesn't allow dynamic parameter as first argument of SUBSTRING.");
            return;
        }
        String firstName = "testSubString";
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        List result = em.createQuery("SELECT OBJECT(e) FROM Employee e WHERE e.firstName = '" + firstName + "'").getResultList();
        if (!result.isEmpty()) {
            Employee emp = (Employee)result.get(0);
        } else {
            Employee emp = new Employee();
            emp.setFirstName(firstName);
            try {
                this.beginTransaction(em);
                em.persist((Object)emp);
                this.commitTransaction(em);
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                throw ex;
            }
        }
        int firstIndex = 1;
        int lastIndex = firstName.length();
        List employees = em.createQuery("SELECT object(e) FROM Employee e where e.firstName = substring(:p1, :p2, :p3)").setParameter("p1", (Object)firstName).setParameter("p2", (Object)new Integer(firstIndex)).setParameter("p3", (Object)new Integer(lastIndex)).getResultList();
        try {
            this.beginTransaction(em);
            em.createQuery("DELETE FROM Employee e WHERE e.firstName = '" + firstName + "'").executeUpdate();
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw ex;
        }
        EntityManagerTLRJUnitTestSuite.assertFalse((String)"employees.isEmpty()==true ", (boolean)employees.isEmpty());
    }

    public void testDatabaseSyncNewObject() {
        block2: {
            EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
            this.beginTransaction(em);
            try {
                LargeProject project = new LargeProject();
                em.persist((Object)project);
                project.setName("Blah");
                project.setTeamLeader(new Employee());
                project.getTeamLeader().addProject((Project)project);
                em.flush();
            }
            catch (RuntimeException ex) {
                this.rollbackTransaction(em);
                if (!(ex instanceof IllegalStateException)) break block2;
                return;
            }
        }
        EntityManagerTLRJUnitTestSuite.fail((String)"Failed to throw illegal argument when finding unregistered new object cascading on database sync");
    }

    public void testTransactionRequired() {
        String firstName = "testTransactionRequired";
        Employee emp = new Employee();
        emp.setFirstName(firstName);
        String noException = "";
        String wrongException = "";
        try {
            EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess").flush();
            noException = noException + " flush;";
        }
        catch (TransactionRequiredException transactionRequiredException) {
        }
        catch (RuntimeException ex) {
            wrongException = wrongException + " flush: " + ex.getMessage() + ";";
        }
        String errorMsg = "";
        if (noException.length() > 0) {
            errorMsg = "No exception thrown: " + noException;
        }
        if (wrongException.length() > 0) {
            if (errorMsg.length() > 0) {
                errorMsg = errorMsg + " ";
            }
            errorMsg = errorMsg + "Wrong exception thrown: " + wrongException;
        }
        if (errorMsg.length() > 0) {
            EntityManagerTLRJUnitTestSuite.fail((String)errorMsg);
        }
    }

    public void testIdentityInsideTransaction() {
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        Query query = em.createQuery("SELECT e FROM PhoneNumber e");
        List phoneNumbers = query.getResultList();
        for (PhoneNumber phoneNumber : phoneNumbers) {
            Employee emp = phoneNumber.getOwner();
            Collection numbers = emp.getPhoneNumbers();
            EntityManagerTLRJUnitTestSuite.assertTrue((boolean)numbers.contains(phoneNumber));
        }
        this.commitTransaction(em);
        this.closeEntityManager(em);
    }

    public void testIdentityOutsideTransaction() {
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        Query query = em.createQuery("SELECT e FROM PhoneNumber e");
        List phoneNumbers = query.getResultList();
        for (PhoneNumber phoneNumber : phoneNumbers) {
            Employee emp = phoneNumber.getOwner();
            Collection numbers = emp.getPhoneNumbers();
            EntityManagerTLRJUnitTestSuite.assertTrue((boolean)numbers.contains(phoneNumber));
        }
        this.closeEntityManager(em);
    }

    public void testIgnoreRemovedObjectsOnDatabaseSync() {
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        Query phoneQuery = em.createQuery("Select p from PhoneNumber p where p.owner.lastName like 'Dow%'");
        Query empQuery = em.createQuery("Select e FROM Employee e where e.lastName like 'Dow%'");
        try {
            Employee emp = new Employee();
            emp.setLastName("Dowder");
            PhoneNumber phone = new PhoneNumber("work", "613", "5555555");
            emp.addPhoneNumber(phone);
            phone = new PhoneNumber("home", "613", "4444444");
            emp.addPhoneNumber(phone);
            Address address = new Address("SomeStreet", "somecity", "province", "country", "postalcode");
            emp.setAddress(address);
            em.persist((Object)emp);
            em.flush();
            emp = new Employee();
            emp.setLastName("Dows");
            phone = new PhoneNumber("work", "613", "2222222");
            emp.addPhoneNumber(phone);
            phone = new PhoneNumber("home", "613", "1111111");
            emp.addPhoneNumber(phone);
            address = new Address("street1", "city1", "province1", "country1", "postalcode1");
            emp.setAddress(address);
            em.persist((Object)emp);
            em.flush();
            List emps = empQuery.getResultList();
            List phones = phoneQuery.getResultList();
            Iterator iterator = phones.iterator();
            while (iterator.hasNext()) {
                em.remove(iterator.next());
            }
            em.flush();
            iterator = emps.iterator();
            while (iterator.hasNext()) {
                em.remove(iterator.next());
            }
        }
        catch (RuntimeException ex) {
            this.rollbackTransaction(em);
            throw ex;
        }
        try {
            em.flush();
        }
        catch (IllegalStateException ex) {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
            em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
            this.beginTransaction(em);
            try {
                phoneQuery = em.createQuery("Select p from PhoneNumber p where p.owner.lastName like 'Dow%'");
                empQuery = em.createQuery("Select e FROM Employee e where e.lastName like 'Dow%'");
                List emps = empQuery.getResultList();
                List phones = phoneQuery.getResultList();
                Iterator iterator = phones.iterator();
                while (iterator.hasNext()) {
                    em.remove(iterator.next());
                }
                iterator = emps.iterator();
                while (iterator.hasNext()) {
                    em.remove(iterator.next());
                }
                this.commitTransaction(em);
            }
            catch (RuntimeException re) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                throw re;
            }
            EntityManagerTLRJUnitTestSuite.fail((String)"Failed to ignore the removedobject when cascading on database sync");
        }
        this.commitTransaction(em);
    }

    public void testREADLock() {
        if (EntityManagerTLRJUnitTestSuite.isOnServer()) {
            return;
        }
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        Employee employee = null;
        try {
            employee = new Employee();
            employee.setFirstName("Mark");
            employee.setLastName("Madsen");
            em.persist((Object)employee);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        EntityManager em2 = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        RuntimeException optimisticLockException = null;
        this.beginTransaction(em);
        try {
            employee = (Employee)em.find(Employee.class, (Object)employee.getId());
            em.lock((Object)employee, LockModeType.READ);
            em2.getTransaction().begin();
            try {
                Employee employee2 = (Employee)em2.find(Employee.class, (Object)employee.getId());
                employee2.setFirstName("Michael");
                em2.getTransaction().commit();
                em2.close();
            }
            catch (RuntimeException ex) {
                em2.getTransaction().rollback();
                em2.close();
                throw ex;
            }
            try {
                em.flush();
            }
            catch (RuntimeException exception) {
                if (exception instanceof OptimisticLockException) {
                    optimisticLockException = exception;
                }
                throw exception;
            }
            this.rollbackTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        this.beginTransaction(em);
        try {
            employee = (Employee)em.find(Employee.class, (Object)employee.getId());
            em.remove((Object)employee);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        if (optimisticLockException == null) {
            EntityManagerTLRJUnitTestSuite.fail((String)"Proper exception not thrown when EntityManager.lock(object, READ) is used.");
        }
    }

    public void testPersistRemoved() {
        String firstName = "testPesistRemoved";
        Employee emp = new Employee();
        emp.setFirstName(firstName);
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            Query q = em.createQuery("SELECT e FROM Employee e WHERE e.firstName = '" + firstName + "'");
            for (Object oldData : q.getResultList()) {
                em.remove(oldData);
            }
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        String errorMsg = "";
        for (int i = 0; i < 32; ++i) {
            boolean doTransaction;
            int j = i;
            boolean doRollback = j % 2 == 0;
            boolean doThirdFlush = (j /= 2) % 2 == 0;
            boolean doSecondFlush = (j /= 2) % 2 == 0;
            boolean doFirstFlush = (j /= 2) % 2 == 0;
            boolean bl = doTransaction = (j /= 2) % 2 == 0;
            if (doTransaction && doFirstFlush) continue;
            String msg = "";
            if (doTransaction) {
                msg = "Transaction ";
            }
            if (doFirstFlush) {
                msg = msg + "firstFlush ";
            }
            if (doSecondFlush) {
                msg = msg + "secondFlush ";
            }
            if (doThirdFlush) {
                msg = msg + "thirdFlush ";
            }
            if (doRollback) {
                msg = msg + "RolledBack ";
            }
            String localErrorMsg = msg;
            boolean exceptionWasThrown = false;
            Integer empId = null;
            this.beginTransaction(em);
            try {
                emp = new Employee();
                emp.setFirstName(firstName);
                em.persist((Object)emp);
                if (doTransaction) {
                    this.commitTransaction(em);
                    empId = emp.getId();
                    this.beginTransaction(em);
                } else if (doFirstFlush) {
                    em.flush();
                }
                if (doTransaction) {
                    emp = (Employee)em.find(Employee.class, (Object)empId);
                }
                em.remove((Object)emp);
                if (doSecondFlush) {
                    em.flush();
                }
                em.persist((Object)emp);
                if (doThirdFlush) {
                    em.flush();
                }
            }
            catch (RuntimeException ex) {
                this.rollbackTransaction(em);
                localErrorMsg = localErrorMsg + " " + ex.getMessage() + ";";
                exceptionWasThrown = true;
            }
            boolean employeeShouldExist = doTransaction || !doRollback;
            boolean employeeExists = false;
            try {
                if (!exceptionWasThrown) {
                    List resultList;
                    Employee employeeReadFromCache;
                    if (doRollback) {
                        this.rollbackTransaction(em);
                    } else {
                        this.commitTransaction(em);
                    }
                    if (doTransaction && (employeeReadFromCache = (Employee)em.find(Employee.class, (Object)empId)) == null) {
                        localErrorMsg = localErrorMsg + " employeeReadFromCache == null;";
                    }
                    boolean bl2 = employeeExists = (resultList = em.createQuery("SELECT OBJECT(e) FROM Employee e WHERE e.firstName = '" + firstName + "'").getResultList()).size() > 0;
                    if (employeeShouldExist) {
                        if (resultList.size() > 1) {
                            localErrorMsg = localErrorMsg + " resultList.size() > 1";
                        }
                        if (!employeeExists) {
                            localErrorMsg = localErrorMsg + " employeeReadFromDB == null;";
                        }
                    } else if (resultList.size() > 0) {
                        localErrorMsg = localErrorMsg + " employeeReadFromDB != null;";
                    }
                }
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                throw ex;
            }
            if (employeeExists || exceptionWasThrown) {
                em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
                this.beginTransaction(em);
                try {
                    Query q = em.createQuery("SELECT e FROM Employee e WHERE e.firstName = '" + firstName + "'");
                    for (Object oldData : q.getResultList()) {
                        em.remove(oldData);
                    }
                    this.commitTransaction(em);
                }
                catch (RuntimeException ex) {
                    this.rollbackTransaction(em);
                    throw ex;
                }
            }
            if (msg.equals(localErrorMsg)) continue;
            errorMsg = errorMsg + "i=" + Integer.toString(i) + ": " + localErrorMsg + " ";
        }
        if (errorMsg.length() > 0) {
            EntityManagerTLRJUnitTestSuite.fail((String)errorMsg);
        }
    }

    public void testPersistManagedException() {
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        Employee emp = new Employee();
        emp.setFirstName("PersistManagedException");
        em.persist((Object)emp);
        em.flush();
        Integer id = emp.getId();
        emp = new Employee();
        emp.setId(id);
        boolean caughtException = false;
        try {
            em.persist((Object)emp);
        }
        catch (EntityExistsException e) {
            caughtException = true;
        }
        this.rollbackTransaction(em);
        EntityManagerTLRJUnitTestSuite.assertTrue((String)"EntityExistsException was not thrown for an existing Employee.", (boolean)caughtException);
    }

    public void testPersistManagedNoException() {
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        Employee emp = new Employee();
        em.persist((Object)emp);
        em.flush();
        Integer id = emp.getId();
        Address address = new Address();
        emp.setAddress(address);
        boolean caughtException = false;
        try {
            em.persist((Object)emp);
        }
        catch (EntityExistsException e) {
            caughtException = true;
        }
        emp = (Employee)em.find(Employee.class, (Object)id);
        em.remove((Object)emp);
        this.commitTransaction(em);
        EntityManagerTLRJUnitTestSuite.assertFalse((String)"EntityExistsException was thrown for a registered Employee.", (boolean)caughtException);
    }

    public void testRemoveFlushPersistContains() {
        String firstName = "testRemoveFlushPersistContains";
        Employee emp = new Employee();
        emp.setFirstName(firstName);
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            Query q = em.createQuery("SELECT e FROM Employee e WHERE e.firstName = '" + firstName + "'");
            for (Object oldData : q.getResultList()) {
                em.remove(oldData);
            }
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        this.beginTransaction(em);
        try {
            em.persist((Object)emp);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        boolean contains = false;
        this.beginTransaction(em);
        try {
            emp = (Employee)em.find(Employee.class, (Object)emp.getId());
            em.remove((Object)emp);
            em.flush();
            em.persist((Object)emp);
            contains = em.contains((Object)emp);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        this.beginTransaction(em);
        try {
            emp = (Employee)em.find(Employee.class, (Object)emp.getId());
            em.remove((Object)emp);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        EntityManagerTLRJUnitTestSuite.assertTrue((String)"contains==false", (boolean)contains);
    }

    public void testRemoveFlushFind() {
        String firstName = "testRemoveFlushFind";
        Employee emp = new Employee();
        emp.setFirstName(firstName);
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            Query q = em.createQuery("SELECT e FROM Employee e WHERE e.firstName = '" + firstName + "'");
            for (Object oldData : q.getResultList()) {
                em.remove(oldData);
            }
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        this.beginTransaction(em);
        try {
            em.persist((Object)emp);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        boolean foundAfterFlush = true;
        boolean foundBeforeFlush = true;
        this.beginTransaction(em);
        try {
            emp = (Employee)em.find(Employee.class, (Object)emp.getId());
            em.remove((Object)emp);
            Employee empFound = (Employee)em.find(Employee.class, (Object)emp.getId());
            foundBeforeFlush = empFound != null;
            em.flush();
            empFound = (Employee)em.find(Employee.class, (Object)emp.getId());
            foundAfterFlush = empFound != null;
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        this.beginTransaction(em);
        try {
            Query q = em.createQuery("SELECT e FROM Employee e WHERE e.firstName = '" + firstName + "'");
            for (Object oldData : q.getResultList()) {
                em.remove(oldData);
            }
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        EntityManagerTLRJUnitTestSuite.assertFalse((String)"removed object found", (boolean)foundBeforeFlush);
        EntityManagerTLRJUnitTestSuite.assertFalse((String)"removed object found after flush", (boolean)foundAfterFlush);
    }

    public void testFindWithWrongTypePk() {
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        try {
            em.find(Employee.class, (Object)"1");
        }
        catch (IllegalArgumentException ilEx) {
            return;
        }
        catch (Exception ex) {
            EntityManagerTLRJUnitTestSuite.fail((String)("Wrong exception thrown: " + ex.getMessage()));
            return;
        }
        finally {
            this.closeEntityManager(em);
        }
        EntityManagerTLRJUnitTestSuite.fail((String)"No exception thrown");
    }

    public void testFindWithNullPk() {
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        try {
            em.find(Employee.class, null);
        }
        catch (IllegalArgumentException iae) {
            return;
        }
        catch (Exception e) {
            EntityManagerTLRJUnitTestSuite.fail((String)("Wrong exception type thrown: " + e.getClass()));
        }
        finally {
            this.closeEntityManager(em);
        }
        EntityManagerTLRJUnitTestSuite.fail((String)"No exception thrown when null PK used in find operation.");
    }

    public void testCheckVersionOnMerge() {
        Employee employee = new Employee();
        employee.setFirstName("Marc");
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            em.persist((Object)employee);
            this.commitTransaction(em);
            em.clear();
            this.beginTransaction(em);
            Employee empClone = (Employee)em.find(Employee.class, (Object)employee.getId());
            empClone.setFirstName("Guy");
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            EntityManagerTLRJUnitTestSuite.fail((String)("Exception caught during test setup " + ex));
        }
        try {
            this.beginTransaction(em);
            em.merge((Object)employee);
            this.commitTransaction(em);
        }
        catch (OptimisticLockException e) {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
            return;
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            EntityManagerTLRJUnitTestSuite.fail((String)("Wrong exception thrown: " + ex.getMessage()));
        }
        EntityManagerTLRJUnitTestSuite.fail((String)"No exception thrown");
    }

    public void testClear() {
        Employee employee = new Employee();
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            em.persist((Object)employee);
            this.commitTransaction(em);
            em.clear();
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        boolean cleared = !em.contains((Object)employee);
        this.closeEntityManager(em);
        EntityManagerTLRJUnitTestSuite.assertTrue((String)"EntityManager not properly cleared", (boolean)cleared);
    }

    public void testClearWithFlush() {
        boolean updated;
        boolean cleared;
        Employee emp;
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            emp = new Employee();
            emp.setFirstName("Douglas");
            emp.setLastName("McRae");
            em.persist((Object)emp);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        EntityManagerTLRJUnitTestSuite.clearCache((String)"fieldaccess");
        em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        emp = null;
        String originalName = "";
        boolean reset = false;
        try {
            Query query = em.createQuery("Select e FROM Employee e where e.firstName is not null");
            emp = (Employee)query.getResultList().get(0);
            originalName = emp.getFirstName();
            emp.setFirstName("Bobster");
            em.flush();
            em.clear();
            this.commitTransaction(em);
            cleared = !em.contains((Object)emp);
            emp = (Employee)em.find(Employee.class, (Object)emp.getId());
            updated = emp.getFirstName().equals("Bobster");
            this.closeEntityManager(em);
        }
        catch (RuntimeException exception) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw exception;
        }
        finally {
            em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
            this.beginTransaction(em);
            emp = (Employee)em.find(Employee.class, (Object)emp.getId());
            emp.setFirstName(originalName);
            this.commitTransaction(em);
            emp = (Employee)em.find(Employee.class, (Object)emp.getId());
            reset = emp.getFirstName().equals(originalName);
            this.closeEntityManager(em);
        }
        EntityManagerTLRJUnitTestSuite.assertTrue((String)"EntityManager not properly cleared", (boolean)cleared);
        EntityManagerTLRJUnitTestSuite.assertTrue((String)"flushed data not merged", (boolean)updated);
        EntityManagerTLRJUnitTestSuite.assertTrue((String)"unable to reset", (boolean)reset);
    }

    public void testClearInTransaction() {
        Employee emp;
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            emp = new Employee();
            emp.setFirstName("Tommy");
            emp.setLastName("Marsh");
            em.persist((Object)emp);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        EntityManagerTLRJUnitTestSuite.clearCache((String)"fieldaccess");
        em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        emp = null;
        String originalName = "";
        try {
            Query query = em.createQuery("Select e FROM Employee e where e.firstName is not null");
            emp = (Employee)query.getResultList().get(0);
            originalName = emp.getFirstName();
            emp.setFirstName("Bobster");
            em.clear();
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        boolean cleared = !em.contains((Object)emp);
        emp = (Employee)em.find(Employee.class, (Object)emp.getId());
        this.closeEntityManager(em);
        EntityManagerTLRJUnitTestSuite.assertTrue((String)"EntityManager not properly cleared", (boolean)cleared);
        EntityManagerTLRJUnitTestSuite.assertTrue((String)"Employee was updated although EM was cleared", (boolean)emp.getFirstName().equals(originalName));
    }

    public void testExtendedPersistenceContext() {
        if (EntityManagerTLRJUnitTestSuite.isOnServer()) {
            return;
        }
        String firstName = "testExtendedPersistenceContext";
        int originalSalary = 0;
        Employee empNew = new Employee();
        empNew.setFirstName(firstName);
        empNew.setLastName("new");
        empNew.setSalary(originalSalary);
        Employee empToBeRemoved = new Employee();
        empToBeRemoved.setFirstName(firstName);
        empToBeRemoved.setLastName("toBeRemoved");
        empToBeRemoved.setSalary(originalSalary);
        Employee empToBeRefreshed = new Employee();
        empToBeRefreshed.setFirstName(firstName);
        empToBeRefreshed.setLastName("toBeRefreshed");
        empToBeRefreshed.setSalary(originalSalary);
        Employee empToBeMerged = new Employee();
        empToBeMerged.setFirstName(firstName);
        empToBeMerged.setLastName("toBeMerged");
        empToBeMerged.setSalary(originalSalary);
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            Query q = em.createQuery("SELECT e FROM Employee e WHERE e.firstName = '" + firstName + "'");
            for (Object oldData : q.getResultList()) {
                em.remove(oldData);
            }
            this.commitTransaction(em);
            this.beginTransaction(em);
            em.persist((Object)empToBeRemoved);
            em.persist((Object)empToBeRefreshed);
            em.persist((Object)empToBeMerged);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        this.closeEntityManager(em);
        EntityManagerTLRJUnitTestSuite.clearCache((String)"fieldaccess");
        em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        try {
            Employee empToBeRefreshedFound3;
            Employee empToBeRemovedFound3;
            Employee empToBeRefreshedFound2;
            Employee empToBeRemovedFound2;
            Employee empToBeRefreshedFound;
            Employee empToBeRemovedFound;
            em.persist((Object)empNew);
            Employee empToBeRemovedExtended = (Employee)em.find(Employee.class, (Object)empToBeRemoved.getId());
            em.remove((Object)empToBeRemovedExtended);
            Employee empToBeRefreshedExtended = (Employee)em.find(Employee.class, (Object)empToBeRefreshed.getId());
            int newSalary = 100;
            this.beginTransaction(em);
            empToBeRefreshed = (Employee)em.find(Employee.class, (Object)empToBeRefreshed.getId());
            empToBeRefreshed.setSalary(newSalary);
            this.commitTransaction(em);
            em.refresh((Object)empToBeRefreshedExtended);
            Employee empToBeMergedExtended = (Employee)em.find(Employee.class, (Object)empToBeMerged.getId());
            empToBeMerged.setSalary(newSalary);
            em.merge((Object)empToBeMerged);
            this.beginTransaction(em);
            this.commitTransaction(em);
            if (!em.contains((Object)empNew)) {
                EntityManagerTLRJUnitTestSuite.fail((String)"empNew gone from extended PersistenceContext after transaction committed");
            }
            if (em.contains((Object)empToBeRemovedExtended)) {
                EntityManagerTLRJUnitTestSuite.fail((String)"empToBeRemovedExtended still in extended PersistenceContext after transaction committed");
            }
            if (!em.contains((Object)empToBeRefreshedExtended)) {
                EntityManagerTLRJUnitTestSuite.fail((String)"empToBeRefreshedExtended gone from extended PersistenceContext after transaction committed");
            } else if (empToBeRefreshedExtended.getSalary() != newSalary) {
                EntityManagerTLRJUnitTestSuite.fail((String)"empToBeRefreshedExtended still has the original salary after transaction committed");
            }
            if (!em.contains((Object)empToBeMergedExtended)) {
                EntityManagerTLRJUnitTestSuite.fail((String)"empToBeMergedExtended gone from extended PersistenceContext after transaction committed");
            } else if (empToBeMergedExtended.getSalary() != newSalary) {
                EntityManagerTLRJUnitTestSuite.fail((String)"empToBeMergedExtended still has the original salary after transaction committed");
            }
            EntityManagerTLRJUnitTestSuite.clearCache((String)"fieldaccess");
            Employee empNewFound = (Employee)em.find(Employee.class, (Object)empNew.getId());
            if (empNewFound == null) {
                EntityManagerTLRJUnitTestSuite.fail((String)"empNew not in the db after transaction committed");
            }
            if ((empToBeRemovedFound = (Employee)em.find(Employee.class, (Object)empToBeRemoved.getId())) != null) {
                EntityManagerTLRJUnitTestSuite.fail((String)"empToBeRemoved is still in the db after transaction committed");
            }
            if ((empToBeRefreshedFound = (Employee)em.find(Employee.class, (Object)empToBeRefreshed.getId())) == null) {
                EntityManagerTLRJUnitTestSuite.fail((String)"empToBeRefreshed not in the db after transaction committed");
            } else if (empToBeRefreshedFound.getSalary() != newSalary) {
                EntityManagerTLRJUnitTestSuite.fail((String)"empToBeRefreshed still has the original salary in the db after transaction committed");
            }
            Employee empToBeMergedFound = (Employee)em.find(Employee.class, (Object)empToBeMerged.getId());
            if (empToBeMergedFound == null) {
                EntityManagerTLRJUnitTestSuite.fail((String)"empToBeMerged not in the db after transaction committed");
            } else if (empToBeMergedFound.getSalary() != newSalary) {
                EntityManagerTLRJUnitTestSuite.fail((String)"empToBeMerged still has the original salary in the db after transaction committed");
            }
            em.persist((Object)empToBeRemoved);
            em.remove((Object)empNew);
            this.beginTransaction(em);
            empToBeRefreshed = (Employee)em.find(Employee.class, (Object)empToBeRefreshed.getId());
            empToBeRefreshed.setSalary(originalSalary);
            this.commitTransaction(em);
            em.refresh((Object)empToBeRefreshedExtended);
            empToBeMergedFound.setSalary(originalSalary);
            em.merge((Object)empToBeMergedFound);
            this.beginTransaction(em);
            this.commitTransaction(em);
            if (em.contains((Object)empNew)) {
                EntityManagerTLRJUnitTestSuite.fail((String)"empNew not gone from extended PersistenceContext after the second transaction committed");
            }
            if (!em.contains((Object)empToBeRemoved)) {
                EntityManagerTLRJUnitTestSuite.fail((String)"empToBeRemoved is not in extended PersistenceContext after the second transaction committed");
            }
            if (!em.contains((Object)empToBeRefreshedExtended)) {
                EntityManagerTLRJUnitTestSuite.fail((String)"empToBeRefreshedExtended gone from extended PersistenceContext after the second transaction committed");
            } else if (empToBeRefreshedExtended.getSalary() != originalSalary) {
                EntityManagerTLRJUnitTestSuite.fail((String)"empToBeRefreshedExtended still doesn't have the original salary after the second transaction committed");
            }
            if (!em.contains((Object)empToBeMergedExtended)) {
                EntityManagerTLRJUnitTestSuite.fail((String)"empToBeMergedExtended gone from extended PersistenceContext after the second transaction committed");
            } else if (empToBeMergedExtended.getSalary() != originalSalary) {
                EntityManagerTLRJUnitTestSuite.fail((String)"empToBeMergedExtended doesn't have the original salary after the second transaction committed");
            }
            EntityManagerTLRJUnitTestSuite.clearCache((String)"fieldaccess");
            Employee empNewFound2 = (Employee)em.find(Employee.class, (Object)empNew.getId());
            if (empNewFound2 != null) {
                EntityManagerTLRJUnitTestSuite.fail((String)"empNew still in the db after the second transaction committed");
            }
            if ((empToBeRemovedFound2 = (Employee)em.find(Employee.class, (Object)empToBeRemoved.getId())) == null) {
                EntityManagerTLRJUnitTestSuite.fail((String)"empToBeRemoved is not in the db after the second transaction committed");
            }
            if ((empToBeRefreshedFound2 = (Employee)em.find(Employee.class, (Object)empToBeRefreshed.getId())) == null) {
                EntityManagerTLRJUnitTestSuite.fail((String)"empToBeRefreshed not in the db after the second transaction committed");
            } else if (empToBeRefreshedFound2.getSalary() != originalSalary) {
                EntityManagerTLRJUnitTestSuite.fail((String)"empToBeRefreshed doesn't have the original salary in the db after the second transaction committed");
            }
            Employee empToBeMergedFound2 = (Employee)em.find(Employee.class, (Object)empToBeMerged.getId());
            if (empToBeMergedFound2 == null) {
                EntityManagerTLRJUnitTestSuite.fail((String)"empToBeMerged not in the db after the second transaction committed");
            } else if (empToBeMergedFound2.getSalary() != originalSalary) {
                EntityManagerTLRJUnitTestSuite.fail((String)"empToBeMerged doesn't have the original salary in the db after the second transaction committed");
            }
            this.beginTransaction(em);
            em.persist((Object)empNew);
            em.remove((Object)empToBeRemoved);
            em2.getTransaction().begin();
            try (EntityManager em2 = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");){
                empToBeRefreshed = (Employee)em2.find(Employee.class, (Object)empToBeRefreshed.getId());
                empToBeRefreshed.setSalary(newSalary);
                em2.getTransaction().commit();
            }
            em.refresh((Object)empToBeRefreshedExtended);
            empToBeMergedFound2.setSalary(newSalary);
            em.merge((Object)empToBeMergedFound2);
            em.flush();
            this.rollbackTransaction(em);
            if (em.contains((Object)empNew)) {
                EntityManagerTLRJUnitTestSuite.fail((String)"empNew is still in extended PersistenceContext after the third transaction rolled back");
            }
            if (em.contains((Object)empToBeRemoved)) {
                EntityManagerTLRJUnitTestSuite.fail((String)"empToBeRemoved is still in extended PersistenceContext after the third transaction rolled back");
            }
            if (em.contains((Object)empToBeRefreshedExtended)) {
                EntityManagerTLRJUnitTestSuite.fail((String)"empToBeRefreshedExtended is still in extended PersistenceContext after the third transaction rolled back");
            } else if (empToBeRefreshedExtended.getSalary() != newSalary) {
                EntityManagerTLRJUnitTestSuite.fail((String)"empToBeRefreshedExtended still has the original salary after third transaction rolled back");
            }
            if (em.contains((Object)empToBeMergedExtended)) {
                EntityManagerTLRJUnitTestSuite.fail((String)"empToBeMergedExtended is still in extended PersistenceContext after the third transaction rolled back");
            } else if (empToBeMergedExtended.getSalary() != newSalary) {
                EntityManagerTLRJUnitTestSuite.fail((String)"empToBeMergedExtended still has the original salary after third transaction rolled back");
            }
            EntityManagerTLRJUnitTestSuite.clearCache((String)"fieldaccess");
            Employee empNewFound3 = (Employee)em.find(Employee.class, (Object)empNew.getId());
            if (empNewFound3 != null) {
                EntityManagerTLRJUnitTestSuite.fail((String)"empNew is in the db after the third transaction rolled back");
            }
            if ((empToBeRemovedFound3 = (Employee)em.find(Employee.class, (Object)empToBeRemoved.getId())) == null) {
                EntityManagerTLRJUnitTestSuite.fail((String)"empToBeRemoved not in the db after the third transaction rolled back");
            }
            if ((empToBeRefreshedFound3 = (Employee)em.find(Employee.class, (Object)empToBeRefreshed.getId())) == null) {
                EntityManagerTLRJUnitTestSuite.fail((String)"empToBeRefreshed not in the db after the third transaction rolled back");
            } else if (empToBeRefreshedFound3.getSalary() != newSalary) {
                EntityManagerTLRJUnitTestSuite.fail((String)"empToBeRefreshed has the original salary in the db after the third transaction rolled back");
            }
            Employee empToBeMergedFound3 = (Employee)em.find(Employee.class, (Object)empToBeMerged.getId());
            if (empToBeMergedFound3 == null) {
                EntityManagerTLRJUnitTestSuite.fail((String)"empToBeMerged not in the db after the third transaction rolled back");
            } else if (empToBeMergedFound3.getSalary() != originalSalary) {
                EntityManagerTLRJUnitTestSuite.fail((String)"empToBeMerged still doesn't have the original salary in the db after the third transaction rolled back");
            }
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw ex;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testReadTransactionIsolation_CustomUpdate() {
        this.internalTestReadTransactionIsolation(false, false, false, false);
    }

    public void testReadTransactionIsolation_CustomUpdate_Flush() {
        this.internalTestReadTransactionIsolation(false, false, false, true);
    }

    public void testReadTransactionIsolation_CustomUpdate_Refresh() {
        this.internalTestReadTransactionIsolation(false, false, true, false);
    }

    public void testReadTransactionIsolation_CustomUpdate_Refresh_Flush() {
        this.internalTestReadTransactionIsolation(false, false, true, true);
    }

    public void testReadTransactionIsolation_UpdateAll() {
        this.internalTestReadTransactionIsolation(false, true, false, false);
    }

    public void testReadTransactionIsolation_UpdateAll_Flush() {
        this.internalTestReadTransactionIsolation(false, true, false, true);
    }

    public void testReadTransactionIsolation_UpdateAll_Refresh() {
        this.internalTestReadTransactionIsolation(false, true, true, false);
    }

    public void testReadTransactionIsolation_UpdateAll_Refresh_Flush() {
        this.internalTestReadTransactionIsolation(false, true, true, true);
    }

    public void testReadTransactionIsolation_OriginalInCache_CustomUpdate() {
        this.internalTestReadTransactionIsolation(true, false, false, false);
    }

    public void testReadTransactionIsolation_OriginalInCache_CustomUpdate_Flush() {
        this.internalTestReadTransactionIsolation(true, false, false, true);
    }

    public void testReadTransactionIsolation_OriginalInCache_CustomUpdate_Refresh() {
        this.internalTestReadTransactionIsolation(true, false, true, false);
    }

    public void testReadTransactionIsolation_OriginalInCache_CustomUpdate_Refresh_Flush() {
        this.internalTestReadTransactionIsolation(true, false, true, true);
    }

    public void testReadTransactionIsolation_OriginalInCache_UpdateAll() {
        this.internalTestReadTransactionIsolation(true, true, false, false);
    }

    public void testReadTransactionIsolation_OriginalInCache_UpdateAll_Flush() {
        this.internalTestReadTransactionIsolation(true, true, false, true);
    }

    public void testReadTransactionIsolation_OriginalInCache_UpdateAll_Refresh() {
        this.internalTestReadTransactionIsolation(true, true, true, false);
    }

    public void testReadTransactionIsolation_OriginalInCache_UpdateAll_Refresh_Flush() {
        this.internalTestReadTransactionIsolation(true, true, true, true);
    }

    protected void internalTestReadTransactionIsolation(boolean shouldOriginalBeInParentCache, boolean shouldUpdateAll, boolean shouldRefresh, boolean shouldFlush) {
        if (shouldUpdateAll && JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
            EntityManagerTLRJUnitTestSuite.getServerSession().logMessage("A testReadTransactionIsolation test skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        String firstName = "testReadTransactionIsolation";
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            Query q = em.createQuery("SELECT e FROM Employee e WHERE e.firstName = '" + firstName + "'");
            for (Object oldData : q.getResultList()) {
                em.remove(oldData);
            }
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        EntityManagerTLRJUnitTestSuite.clearCache((String)"fieldaccess");
        em.clear();
        String lastNameOriginal = "Original";
        int salaryOriginal = 0;
        Employee employee = new Employee();
        employee.setFirstName(firstName);
        employee.setLastName(lastNameOriginal);
        employee.setSalary(salaryOriginal);
        this.beginTransaction(em);
        try {
            em.persist((Object)employee);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        if (!shouldOriginalBeInParentCache) {
            EntityManagerTLRJUnitTestSuite.clearCache((String)"fieldaccess");
        }
        em.clear();
        Employee employeeUOW = null;
        int salaryNew = 100;
        String lastNameNew = "New";
        this.beginTransaction(em);
        Query selectQuery = em.createQuery("SELECT OBJECT(e) FROM Employee e WHERE e.firstName = '" + firstName + "'");
        try {
            if (shouldRefresh) {
                String lastNameAlternative = "Alternative";
                int salaryAlternative = 50;
                employeeUOW = (Employee)selectQuery.getSingleResult();
                employeeUOW.setLastName(lastNameAlternative);
                employeeUOW.setSalary(salaryAlternative);
            }
            int nUpdated = shouldUpdateAll ? em.createQuery("UPDATE Employee e set e.lastName = '" + lastNameNew + "' where e.firstName like '" + firstName + "'").setFlushMode(FlushModeType.AUTO).executeUpdate() : em.createNativeQuery("UPDATE CMP3_FA_EMPLOYEE SET L_NAME = '" + lastNameNew + "', VERSION = VERSION + 1 WHERE F_NAME LIKE '" + firstName + "'").setFlushMode(FlushModeType.AUTO).executeUpdate();
            EntityManagerTLRJUnitTestSuite.assertTrue((String)("nUpdated==" + nUpdated + "; 1 was expected"), (nUpdated == 1 ? 1 : 0) != 0);
            if (shouldFlush) {
                selectQuery.setFlushMode(FlushModeType.AUTO);
            } else {
                selectQuery.setFlushMode(FlushModeType.COMMIT);
            }
            if (shouldRefresh) {
                selectQuery.setHint("eclipselink.refresh", (Object)Boolean.TRUE);
                employeeUOW = (Employee)selectQuery.getSingleResult();
                selectQuery.setHint("eclipselink.refresh", (Object)Boolean.FALSE);
            } else {
                employeeUOW = (Employee)selectQuery.getSingleResult();
            }
            EntityManagerTLRJUnitTestSuite.assertTrue((String)("employeeUOW.getLastName()==" + employeeUOW.getLastName() + "; " + lastNameNew + " was expected"), (boolean)employeeUOW.getLastName().equals(lastNameNew));
            employeeUOW.setSalary(salaryNew);
            employeeUOW = (Employee)selectQuery.getSingleResult();
            EntityManagerTLRJUnitTestSuite.assertTrue((String)("employeeUOW.getSalary()==" + employeeUOW.getSalary() + "; " + salaryNew + " was expected"), (employeeUOW.getSalary() == salaryNew ? 1 : 0) != 0);
            this.commitTransaction(em);
        }
        catch (Throwable ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            if (Error.class.isAssignableFrom(ex.getClass())) {
                throw (Error)ex;
            }
            throw (RuntimeException)ex;
        }
        Employee employeeFoundAfterTransaction = (Employee)em.find(Employee.class, (Object)employeeUOW.getId());
        EntityManagerTLRJUnitTestSuite.assertTrue((String)("employeeFoundAfterTransaction().getLastName()==" + employeeFoundAfterTransaction.getLastName() + "; " + lastNameNew + " was expected"), (boolean)employeeFoundAfterTransaction.getLastName().equals(lastNameNew));
        EntityManagerTLRJUnitTestSuite.assertTrue((String)("employeeFoundAfterTransaction().getSalary()==" + employeeFoundAfterTransaction.getSalary() + "; " + salaryNew + " was expected"), (employeeFoundAfterTransaction.getSalary() == salaryNew ? 1 : 0) != 0);
        this.beginTransaction(em);
        try {
            Query q = em.createQuery("SELECT e FROM Employee e WHERE e.firstName = '" + firstName + "'");
            for (Object oldData : q.getResultList()) {
                em.remove(oldData);
            }
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        EntityManagerTLRJUnitTestSuite.clearCache((String)"fieldaccess");
        this.closeEntityManager(em);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFindDeleteAllPersist() {
        if (JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
            EntityManagerTLRJUnitTestSuite.getServerSession().logMessage("Test testFindDeleteAllPersist skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        String firstName = "testFindDeleteAllPersist";
        Employee empWithAddress = new Employee();
        empWithAddress.setFirstName(firstName);
        empWithAddress.setLastName("WithAddress");
        empWithAddress.setAddress(new Address());
        Employee empWithoutAddress = new Employee();
        empWithoutAddress.setFirstName(firstName);
        empWithoutAddress.setLastName("WithoutAddress");
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            em.createQuery("DELETE FROM Employee e WHERE e.firstName = '" + firstName + "'").executeUpdate();
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        this.beginTransaction(em);
        try {
            em.persist((Object)empWithAddress);
            em.persist((Object)empWithoutAddress);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        EntityManagerTLRJUnitTestSuite.clearCache((String)"fieldaccess");
        em.clear();
        this.beginTransaction(em);
        try {
            Employee empWithAddressFound = (Employee)em.find(Employee.class, (Object)empWithAddress.getId());
            empWithAddressFound.toString();
            Employee empWithoutAddressFound = (Employee)em.find(Employee.class, (Object)empWithoutAddress.getId());
            empWithoutAddressFound.toString();
            int nDeleted = em.createQuery("DELETE FROM Employee e WHERE e.firstName = '" + firstName + "' and e.address IS NULL").executeUpdate();
            EntityManagerTLRJUnitTestSuite.assertTrue((nDeleted > 0 ? 1 : 0) != 0);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        em.clear();
        this.beginTransaction(em);
        try {
            Employee newEmpWithoutAddress = new Employee();
            newEmpWithoutAddress.setFirstName(firstName);
            newEmpWithoutAddress.setLastName("newWithoutAddress");
            newEmpWithoutAddress.setId(empWithoutAddress.getId());
            em.persist((Object)newEmpWithoutAddress);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        this.beginTransaction(em);
        try {
            Employee newEmpWithAddress = new Employee();
            newEmpWithAddress.setFirstName(firstName);
            newEmpWithAddress.setLastName("newWithAddress");
            newEmpWithAddress.setId(empWithAddress.getId());
            em.persist((Object)newEmpWithAddress);
            EntityManagerTLRJUnitTestSuite.fail((String)"EntityExistsException was expected");
        }
        catch (EntityExistsException entityExistsException) {
        }
        finally {
            this.rollbackTransaction(em);
        }
        this.beginTransaction(em);
        em.createQuery("DELETE FROM Employee e WHERE e.firstName = '" + firstName + "'").executeUpdate();
        this.commitTransaction(em);
    }

    public void testWRITELock() {
        if (EntityManagerTLRJUnitTestSuite.isOnServer()) {
            return;
        }
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        Employee employee = new Employee();
        employee.setFirstName("Mark");
        employee.setLastName("Madsen");
        this.beginTransaction(em);
        try {
            em.persist((Object)employee);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        EntityManager em2 = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        RollbackException optimisticLockException = null;
        this.beginTransaction(em);
        try {
            employee = (Employee)em.find(Employee.class, (Object)employee.getId());
            em.lock((Object)employee, LockModeType.WRITE);
            em2.getTransaction().begin();
            try {
                Employee employee2 = (Employee)em2.find(Employee.class, (Object)employee.getId());
                employee2.setFirstName("Michael");
                em2.getTransaction().commit();
            }
            catch (RuntimeException ex) {
                em2.getTransaction().rollback();
                em2.close();
                throw ex;
            }
            this.commitTransaction(em);
        }
        catch (RollbackException exception) {
            if (exception.getCause() instanceof OptimisticLockException) {
                optimisticLockException = exception;
            }
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        this.beginTransaction(em);
        try {
            employee = (Employee)em.find(Employee.class, (Object)employee.getId());
            em.remove((Object)employee);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        if (optimisticLockException == null) {
            EntityManagerTLRJUnitTestSuite.fail((String)"Proper exception not thrown when EntityManager.lock(object, WRITE) is used.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPersistOnNonEntity() {
        boolean testPass = false;
        Object nonEntity = new Object();
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            em.persist(nonEntity);
        }
        catch (IllegalArgumentException e) {
            testPass = true;
        }
        finally {
            this.rollbackTransaction(em);
        }
        Assert.assertTrue((boolean)testPass);
    }

    public void testClose() {
        if (EntityManagerTLRJUnitTestSuite.isOnServer()) {
            return;
        }
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        if (!em.isOpen()) {
            EntityManagerTLRJUnitTestSuite.fail((String)"Created EntityManager is not open");
        }
        this.closeEntityManager(em);
        if (em.isOpen()) {
            EntityManagerTLRJUnitTestSuite.fail((String)"Closed EntityManager is still open");
        }
    }

    public void testBeginTransactionClose() throws Throwable {
        if (EntityManagerTLRJUnitTestSuite.isOnServer()) {
            return;
        }
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            this.closeEntityManager(em);
            if (em.isOpen()) {
                EntityManagerTLRJUnitTestSuite.fail((String)"Closed EntityManager is still open before transaction complete");
            }
        }
        catch (Throwable exception) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            if (em.isOpen()) {
                this.closeEntityManager(em);
            }
            throw exception;
        }
        this.rollbackTransaction(em);
        if (em.isOpen()) {
            EntityManagerTLRJUnitTestSuite.fail((String)"Closed EntityManager is still open after transaction rollback");
        }
    }

    public void testBeginTransactionCloseCommitTransaction() throws Throwable {
        if (EntityManagerTLRJUnitTestSuite.isOnServer()) {
            return;
        }
        String firstName = "testBeginTrCloseCommitTr";
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        Query q = em.createQuery("SELECT e FROM Employee e WHERE e.firstName = '" + firstName + "'");
        for (Object oldData : q.getResultList()) {
            em.remove(oldData);
        }
        this.commitTransaction(em);
        Employee employee = new Employee();
        employee.setFirstName(firstName);
        this.beginTransaction(em);
        try {
            em.persist((Object)employee);
            this.closeEntityManager(em);
            if (em.isOpen()) {
                EntityManagerTLRJUnitTestSuite.fail((String)"Closed EntityManager is still open before transaction complete");
            }
        }
        catch (Throwable exception) {
            this.rollbackTransaction(em);
            if (em.isOpen()) {
                this.closeEntityManager(em);
            }
            throw exception;
        }
        this.commitTransaction(em);
        if (em.isOpen()) {
            EntityManagerTLRJUnitTestSuite.fail((String)"Closed EntityManager is still open after transaction commit");
        }
        em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        RuntimeException exception = null;
        try {
            Employee persistedEmployee = (Employee)em.createQuery("SELECT OBJECT(e) FROM Employee e WHERE e.firstName = '" + firstName + "'").getSingleResult();
            persistedEmployee.toString();
            this.beginTransaction(em);
            em.remove((Object)persistedEmployee);
            this.commitTransaction(em);
        }
        catch (RuntimeException runtimeException) {
            exception = runtimeException;
        }
        if (exception != null) {
            if (exception instanceof EntityNotFoundException) {
                EntityManagerTLRJUnitTestSuite.fail((String)"object has not been persisted");
            } else {
                throw exception;
            }
        }
    }

    public void testPersistenceProperties() {
        int numAddressCalls;
        int numEmployeeCalls;
        int numProjectCalls;
        int numSessionCalls;
        Class addressCacheType;
        Class employeeCacheType;
        Class defaultCacheType;
        int addressCacheSize;
        int employeeCacheSize;
        int defaultCacheSize;
        int readMax;
        int readMin;
        int writeMax;
        int writeMin;
        if (EntityManagerTLRJUnitTestSuite.isOnServer()) {
            return;
        }
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        ServerSession ss = ((EntityManagerImpl)em.getDelegate()).getServerSession();
        boolean isReadShared = ss.getReadConnectionPool() instanceof ReadConnectionPool;
        if (isReadShared != Boolean.parseBoolean((String)JUnitTestCaseHelper.propertiesMap.get("eclipselink.jdbc.read-connections.shared"))) {
            EntityManagerTLRJUnitTestSuite.fail((String)"isReadShared is wrong");
        }
        if ((writeMin = ss.getDefaultConnectionPool().getMinNumberOfConnections()) != Integer.parseInt((String)JUnitTestCaseHelper.propertiesMap.get("eclipselink.jdbc.write-connections.min"))) {
            EntityManagerTLRJUnitTestSuite.fail((String)"writeMin is wrong");
        }
        if ((writeMax = ss.getDefaultConnectionPool().getMaxNumberOfConnections()) != Integer.parseInt((String)JUnitTestCaseHelper.propertiesMap.get("eclipselink.jdbc.write-connections.max"))) {
            EntityManagerTLRJUnitTestSuite.fail((String)"writeMax is wrong");
        }
        if ((readMin = ss.getReadConnectionPool().getMinNumberOfConnections()) != Integer.parseInt((String)JUnitTestCaseHelper.propertiesMap.get("eclipselink.jdbc.read-connections.min"))) {
            EntityManagerTLRJUnitTestSuite.fail((String)"readMin is wrong");
        }
        if ((readMax = ss.getReadConnectionPool().getMaxNumberOfConnections()) != Integer.parseInt((String)JUnitTestCaseHelper.propertiesMap.get("eclipselink.jdbc.read-connections.max"))) {
            EntityManagerTLRJUnitTestSuite.fail((String)"readMax is wrong");
        }
        if ((defaultCacheSize = ss.getDescriptor(Project.class).getIdentityMapSize()) != 500) {
            EntityManagerTLRJUnitTestSuite.fail((String)"defaultCacheSize is wrong");
        }
        if ((employeeCacheSize = ss.getDescriptor(Employee.class).getIdentityMapSize()) != 550) {
            EntityManagerTLRJUnitTestSuite.fail((String)"employeeCacheSize is wrong");
        }
        if ((addressCacheSize = ss.getDescriptor(Address.class).getIdentityMapSize()) != 555) {
            EntityManagerTLRJUnitTestSuite.fail((String)"addressCacheSize is wrong");
        }
        if (!Helper.getShortClassName((Class)(defaultCacheType = ss.getDescriptor(Project.class).getIdentityMapClass())).equals("FullIdentityMap")) {
            EntityManagerTLRJUnitTestSuite.fail((String)"defaultCacheType is wrong");
        }
        if (!Helper.getShortClassName((Class)(employeeCacheType = ss.getDescriptor(Employee.class).getIdentityMapClass())).equals("WeakIdentityMap")) {
            EntityManagerTLRJUnitTestSuite.fail((String)"employeeCacheType is wrong");
        }
        if (!Helper.getShortClassName((Class)(addressCacheType = ss.getDescriptor(Address.class).getIdentityMapClass())).equals("HardCacheWeakIdentityMap")) {
            EntityManagerTLRJUnitTestSuite.fail((String)"addressCacheType is wrong");
        }
        if ((numSessionCalls = Customizer.getNumberOfCallsForSession((String)ss.getName())) == 0) {
            EntityManagerTLRJUnitTestSuite.fail((String)"session customizer hasn't been called");
        }
        if ((numProjectCalls = Customizer.getNumberOfCallsForClass((String)Project.class.getName())) > 0) {
            EntityManagerTLRJUnitTestSuite.fail((String)"Project customizer has been called");
        }
        if ((numEmployeeCalls = Customizer.getNumberOfCallsForClass((String)Employee.class.getName())) == 0) {
            EntityManagerTLRJUnitTestSuite.fail((String)"Employee customizer hasn't been called");
        }
        if ((numAddressCalls = Customizer.getNumberOfCallsForClass((String)Address.class.getName())) == 0) {
            EntityManagerTLRJUnitTestSuite.fail((String)"Address customizer hasn't been called");
        }
        this.closeEntityManager(em);
    }

    public void testMultipleFactories() {
        EntityManagerTLRJUnitTestSuite.getEntityManagerFactory((String)"fieldaccess");
        this.closeEntityManagerFactory();
        boolean isOpen = EntityManagerTLRJUnitTestSuite.getEntityManagerFactory((String)"fieldaccess").isOpen();
        if (!isOpen) {
            EntityManagerTLRJUnitTestSuite.fail((String)"Close factory 1; open factory 2 - it's not open");
        } else {
            EntityManagerTLRJUnitTestSuite.getEntityManagerFactory((String)"fieldaccess").createEntityManager().close();
        }
    }

    public void testParallelMultipleFactories() {
        EntityManagerFactory factory3;
        if (EntityManagerTLRJUnitTestSuite.isOnServer()) {
            return;
        }
        EntityManagerFactory factory1 = Persistence.createEntityManagerFactory((String)"fieldaccess", (Map)JUnitTestCaseHelper.getDatabaseProperties());
        factory1.createEntityManager();
        EntityManagerFactory factory2 = Persistence.createEntityManagerFactory((String)"fieldaccess", (Map)JUnitTestCaseHelper.getDatabaseProperties());
        factory2.createEntityManager();
        factory1.close();
        if (factory1.isOpen()) {
            EntityManagerTLRJUnitTestSuite.fail((String)"after factory1.close() factory1 is not closed");
        }
        if (!factory2.isOpen()) {
            EntityManagerTLRJUnitTestSuite.fail((String)"after factory1.close() factory2 is closed");
        }
        factory2.close();
        if (factory2.isOpen()) {
            EntityManagerTLRJUnitTestSuite.fail((String)"after factory2.close() factory2 is not closed");
        }
        if (!(factory3 = Persistence.createEntityManagerFactory((String)"fieldaccess", (Map)JUnitTestCaseHelper.getDatabaseProperties())).isOpen()) {
            EntityManagerTLRJUnitTestSuite.fail((String)"factory3 is closed");
        }
        factory3.createEntityManager();
        factory3.close();
        if (factory3.isOpen()) {
            EntityManagerTLRJUnitTestSuite.fail((String)"after factory3.close() factory3 is open");
        }
    }

    public void testQueryHints() {
        EntityManager em = EntityManagerTLRJUnitTestSuite.getEntityManagerFactory((String)"fieldaccess").createEntityManager();
        Query query = em.createQuery("SELECT OBJECT(e) FROM Employee e WHERE e.firstName = 'testQueryHints'");
        ObjectLevelReadQuery olrQuery = (ObjectLevelReadQuery)((EJBQueryImpl)query).getDatabaseQuery();
        EntityManagerTLRJUnitTestSuite.assertTrue((boolean)olrQuery.shouldIgnoreBindAllParameters());
        query.setHint("eclipselink.jdbc.bind-parameters", (Object)true);
        olrQuery = (ObjectLevelReadQuery)((EJBQueryImpl)query).getDatabaseQuery();
        EntityManagerTLRJUnitTestSuite.assertTrue((String)"Binding not set.", (boolean)olrQuery.shouldBindAllParameters());
        query.setHint("eclipselink.jdbc.bind-parameters", (Object)"");
        EntityManagerTLRJUnitTestSuite.assertTrue((String)"Binding not set.", (boolean)olrQuery.shouldIgnoreBindAllParameters());
        query.setHint("eclipselink.jdbc.bind-parameters", (Object)"false");
        EntityManagerTLRJUnitTestSuite.assertFalse((String)"Binding not set.", (boolean)olrQuery.shouldBindAllParameters());
        query.setHint("eclipselink.jdbc.bind-parameters", (Object)"");
        EntityManagerTLRJUnitTestSuite.assertTrue((String)"Binding not set.", (boolean)olrQuery.shouldIgnoreBindAllParameters());
        query.setHint("eclipselink.cache-usage", (Object)"DoNotCheckCache");
        EntityManagerTLRJUnitTestSuite.assertTrue((String)"Cache usage not set.", (olrQuery.getCacheUsage() == 0 ? 1 : 0) != 0);
        query.setHint("eclipselink.cache-usage", (Object)"CheckCacheOnly");
        EntityManagerTLRJUnitTestSuite.assertTrue((String)"Cache usage not set.", (boolean)olrQuery.shouldCheckCacheOnly());
        query.setHint("eclipselink.cache-usage", (Object)"ConformResultsInUnitOfWork");
        EntityManagerTLRJUnitTestSuite.assertTrue((String)"Cache usage not set.", (boolean)olrQuery.shouldConformResultsInUnitOfWork());
        query.setHint("eclipselink.cache-usage", (Object)"");
        EntityManagerTLRJUnitTestSuite.assertTrue((String)"Cache usage not set.", (boolean)olrQuery.shouldCheckDescriptorForCacheUsage());
        query.setHint("eclipselink.pessimistic-lock", (Object)"Lock");
        EntityManagerTLRJUnitTestSuite.assertTrue((String)"Lock not set.", (olrQuery.getLockMode() == 1 ? 1 : 0) != 0);
        query.setHint("eclipselink.pessimistic-lock", (Object)"NoLock");
        EntityManagerTLRJUnitTestSuite.assertTrue((String)"Lock not set.", (olrQuery.getLockMode() == 0 ? 1 : 0) != 0);
        query.setHint("eclipselink.pessimistic-lock", (Object)"LockNoWait");
        EntityManagerTLRJUnitTestSuite.assertTrue((String)"Lock not set.", (olrQuery.getLockMode() == 2 ? 1 : 0) != 0);
        query.setHint("eclipselink.pessimistic-lock", (Object)"");
        EntityManagerTLRJUnitTestSuite.assertTrue((String)"Lock not set.", (olrQuery.getLockMode() == 0 ? 1 : 0) != 0);
        query.setHint("eclipselink.refresh", (Object)false);
        EntityManagerTLRJUnitTestSuite.assertFalse((String)"Refresh not set.", (boolean)olrQuery.shouldRefreshIdentityMapResult());
        query.setHint("eclipselink.refresh", (Object)true);
        EntityManagerTLRJUnitTestSuite.assertTrue((String)"Refresh not set.", (boolean)olrQuery.shouldRefreshIdentityMapResult());
        EntityManagerTLRJUnitTestSuite.assertTrue((String)"CascadeByMapping not set.", (boolean)olrQuery.shouldCascadeByMapping());
        query.setHint("eclipselink.refresh", (Object)"false");
        EntityManagerTLRJUnitTestSuite.assertFalse((String)"Refresh not set.", (boolean)olrQuery.shouldRefreshIdentityMapResult());
        query.setHint("eclipselink.refresh", (Object)Boolean.TRUE);
        EntityManagerTLRJUnitTestSuite.assertTrue((String)"Refresh not set.", (boolean)olrQuery.shouldRefreshIdentityMapResult());
        EntityManagerTLRJUnitTestSuite.assertTrue((String)"CascadeByMapping not set.", (boolean)olrQuery.shouldCascadeByMapping());
        query.setHint("eclipselink.refresh", (Object)"");
        EntityManagerTLRJUnitTestSuite.assertFalse((String)"Refresh not set.", (boolean)olrQuery.shouldRefreshIdentityMapResult());
        query.setHint("eclipselink.read-only", (Object)"false");
        EntityManagerTLRJUnitTestSuite.assertFalse((String)"Read-only not set.", (boolean)olrQuery.isReadOnly());
        query.setHint("eclipselink.read-only", (Object)Boolean.TRUE);
        EntityManagerTLRJUnitTestSuite.assertTrue((String)"Read-only not set.", (boolean)olrQuery.isReadOnly());
        query.setHint("eclipselink.read-only", (Object)Boolean.FALSE);
        EntityManagerTLRJUnitTestSuite.assertFalse((String)"Read-only not set.", (boolean)olrQuery.isReadOnly());
        query.setHint("eclipselink.jdbc.timeout", (Object)new Integer(100));
        EntityManagerTLRJUnitTestSuite.assertTrue((String)"Timeout not set.", (olrQuery.getQueryTimeout() == 100 ? 1 : 0) != 0);
        query.setHint("eclipselink.jdbc.fetch-size", (Object)new Integer(101));
        EntityManagerTLRJUnitTestSuite.assertTrue((String)"Fetch-size not set.", (olrQuery.getFetchSize() == 101 ? 1 : 0) != 0);
        query.setHint("eclipselink.jdbc.max-rows", (Object)new Integer(103));
        EntityManagerTLRJUnitTestSuite.assertTrue((String)"Max-rows not set.", (olrQuery.getMaxRows() == 103 ? 1 : 0) != 0);
        query.setHint("eclipselink.refresh.cascade", (Object)"NoCascading");
        EntityManagerTLRJUnitTestSuite.assertTrue((olrQuery.getCascadePolicy() == 1 ? 1 : 0) != 0);
        query.setHint("eclipselink.refresh.cascade", (Object)"CascadeByMapping");
        EntityManagerTLRJUnitTestSuite.assertTrue((olrQuery.getCascadePolicy() == 6 ? 1 : 0) != 0);
        query.setHint("eclipselink.refresh.cascade", (Object)"CascadeAllParts");
        EntityManagerTLRJUnitTestSuite.assertTrue((olrQuery.getCascadePolicy() == 3 ? 1 : 0) != 0);
        query.setHint("eclipselink.refresh.cascade", (Object)"CascadePrivateParts");
        EntityManagerTLRJUnitTestSuite.assertTrue((olrQuery.getCascadePolicy() == 2 ? 1 : 0) != 0);
        query.setHint("eclipselink.refresh.cascade", (Object)"");
        EntityManagerTLRJUnitTestSuite.assertTrue((olrQuery.getCascadePolicy() == 6 ? 1 : 0) != 0);
        query.setHint("eclipselink.result-collection-type", ArrayList.class);
        EntityManagerTLRJUnitTestSuite.assertTrue((String)"ArrayList not set.", (boolean)((ReadAllQuery)olrQuery).getContainerPolicy().getContainerClassName().equals(ArrayList.class.getName()));
        query.setHint("eclipselink.result-collection-type", (Object)"java.util.Vector");
        EntityManagerTLRJUnitTestSuite.assertTrue((String)"Vector not set.", (boolean)((ReadAllQuery)olrQuery).getContainerPolicy().getContainerClassName().equals(Vector.class.getName()));
        this.closeEntityManager(em);
    }

    public void testQueryTimeOut() {
        EntityManager em = EntityManagerTLRJUnitTestSuite.getEntityManagerFactory((String)"fieldaccess").createEntityManager();
        Query query = em.createQuery("SELECT d FROM Department d");
        ObjectLevelReadQuery olrQuery = (ObjectLevelReadQuery)((EJBQueryImpl)query).getDatabaseQuery();
        EntityManagerTLRJUnitTestSuite.assertTrue((String)"Timeout overriden or not set in persistence.xml", (olrQuery.getQueryTimeout() == 100 ? 1 : 0) != 0);
        query.setHint("eclipselink.jdbc.timeout", (Object)500);
        olrQuery = (ObjectLevelReadQuery)((EJBQueryImpl)query).getDatabaseQuery();
        EntityManagerTLRJUnitTestSuite.assertTrue((olrQuery.getQueryTimeout() == 500 ? 1 : 0) != 0);
        this.closeEntityManager(em);
    }

    public void testBatchQueryHint() {
        int id1 = 0;
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        Employee manager = new Employee();
        manager.setFirstName("Marvin");
        manager.setLastName("Malone");
        PhoneNumber number = new PhoneNumber("cell", "613", "888-8888");
        manager.addPhoneNumber(number);
        number = new PhoneNumber("home", "613", "888-8880");
        manager.addPhoneNumber(number);
        em.persist((Object)manager);
        id1 = manager.getId();
        Employee emp = new Employee();
        emp.setFirstName("Melvin");
        emp.setLastName("Malone");
        emp.setManager(manager);
        manager.addManagedEmployee(emp);
        number = new PhoneNumber("cell", "613", "888-9888");
        emp.addPhoneNumber(number);
        number = new PhoneNumber("home", "613", "888-0880");
        emp.addPhoneNumber(number);
        em.persist((Object)emp);
        emp = new Employee();
        emp.setFirstName("David");
        emp.setLastName("Malone");
        emp.setManager(manager);
        manager.addManagedEmployee(emp);
        number = new PhoneNumber("cell", "613", "888-9988");
        emp.addPhoneNumber(number);
        number = new PhoneNumber("home", "613", "888-0980");
        emp.addPhoneNumber(number);
        em.persist((Object)emp);
        this.commitTransaction(em);
        em.clear();
        JpaQuery query = (JpaQuery)EntityManagerTLRJUnitTestSuite.getEntityManagerFactory((String)"fieldaccess").createEntityManager().createQuery("SELECT e FROM Employee e WHERE e.lastName = 'Malone' order by e.firstName");
        query.setHint("eclipselink.batch", (Object)"e.phoneNumbers");
        query.setHint("eclipselink.batch", (Object)"e.manager.phoneNumbers");
        ReadAllQuery raq = (ReadAllQuery)query.getDatabaseQuery();
        List expressions = raq.getBatchReadAttributeExpressions();
        EntityManagerTLRJUnitTestSuite.assertTrue((expressions.size() == 2 ? 1 : 0) != 0);
        Expression exp = (Expression)expressions.get(0);
        EntityManagerTLRJUnitTestSuite.assertTrue((boolean)exp.isQueryKeyExpression());
        EntityManagerTLRJUnitTestSuite.assertTrue((boolean)exp.getName().equals("phoneNumbers"));
        exp = (Expression)expressions.get(1);
        EntityManagerTLRJUnitTestSuite.assertTrue((boolean)exp.isQueryKeyExpression());
        EntityManagerTLRJUnitTestSuite.assertTrue((boolean)exp.getName().equals("phoneNumbers"));
        List resultList = query.getResultList();
        emp = (Employee)resultList.get(0);
        emp.getPhoneNumbers().hashCode();
        emp.getManager().getPhoneNumbers().hashCode();
        emp = (Employee)resultList.get(1);
        emp.getPhoneNumbers().hashCode();
        this.beginTransaction(em);
        emp = (Employee)em.find(Employee.class, (Object)id1);
        Iterator it = emp.getManagedEmployees().iterator();
        while (it.hasNext()) {
            Employee managedEmp = (Employee)it.next();
            it.remove();
            managedEmp.setManager(null);
            em.remove((Object)managedEmp);
        }
        em.remove((Object)emp);
        this.commitTransaction(em);
    }

    public void testFetchQueryHint() {
        int id1 = 0;
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        Employee manager = new Employee();
        manager.setFirstName("Marvin");
        manager.setLastName("Malone");
        PhoneNumber number = new PhoneNumber("cell", "613", "888-8888");
        manager.addPhoneNumber(number);
        number = new PhoneNumber("home", "613", "888-8880");
        manager.addPhoneNumber(number);
        em.persist((Object)manager);
        id1 = manager.getId();
        Employee emp = new Employee();
        emp.setFirstName("Melvin");
        emp.setLastName("Malone");
        emp.setManager(manager);
        manager.addManagedEmployee(emp);
        number = new PhoneNumber("cell", "613", "888-9888");
        emp.addPhoneNumber(number);
        number = new PhoneNumber("home", "613", "888-0880");
        emp.addPhoneNumber(number);
        em.persist((Object)emp);
        emp = new Employee();
        emp.setFirstName("David");
        emp.setLastName("Malone");
        emp.setManager(manager);
        manager.addManagedEmployee(emp);
        number = new PhoneNumber("cell", "613", "888-9988");
        emp.addPhoneNumber(number);
        number = new PhoneNumber("home", "613", "888-0980");
        emp.addPhoneNumber(number);
        em.persist((Object)emp);
        this.commitTransaction(em);
        em.clear();
        JpaQuery query = (JpaQuery)EntityManagerTLRJUnitTestSuite.getEntityManagerFactory((String)"fieldaccess").createEntityManager().createQuery("SELECT e FROM Employee e WHERE e.lastName = 'Malone' order by e.firstName");
        query.setHint("eclipselink.join-fetch", (Object)"e.manager");
        ReadAllQuery raq = (ReadAllQuery)query.getDatabaseQuery();
        List expressions = raq.getJoinedAttributeExpressions();
        EntityManagerTLRJUnitTestSuite.assertTrue((expressions.size() == 1 ? 1 : 0) != 0);
        Expression exp = (Expression)expressions.get(0);
        EntityManagerTLRJUnitTestSuite.assertTrue((boolean)exp.getName().equals("manager"));
        query.setHint("eclipselink.join-fetch", (Object)"e.manager.phoneNumbers");
        EntityManagerTLRJUnitTestSuite.assertTrue((expressions.size() == 2 ? 1 : 0) != 0);
        List resultList = query.getResultList();
        emp = (Employee)resultList.get(0);
        this.beginTransaction(em);
        emp = (Employee)em.find(Employee.class, (Object)id1);
        Iterator it = emp.getManagedEmployees().iterator();
        while (it.hasNext()) {
            Employee managedEmp = (Employee)it.next();
            it.remove();
            managedEmp.setManager(null);
            em.remove((Object)managedEmp);
        }
        em.remove((Object)emp);
        this.commitTransaction(em);
    }

    public void testIncorrectBatchQueryHint() {
        Query query;
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        QueryException exception = null;
        try {
            query = em.createQuery("SELECT e FROM Employee e WHERE e.lastName = 'Malone' order by e.firstName");
            query.setHint("eclipselink.batch", (Object)"e");
            query.getResultList();
        }
        catch (QueryException exc) {
            exception = exc;
        }
        EntityManagerTLRJUnitTestSuite.assertNotNull((String)"No exception was thrown on an incorrect BATCH query hint.", (Object)((Object)exception));
        EntityManagerTLRJUnitTestSuite.assertTrue((String)"Incorrect Exception thrown", (exception.getErrorCode() == 6144 ? 1 : 0) != 0);
        exception = null;
        try {
            query = em.createQuery("SELECT e FROM Employee e WHERE e.lastName = 'Malone' order by e.firstName");
            query.setHint("eclipselink.batch", (Object)"e.abcdef");
            query.getResultList();
        }
        catch (QueryException exc) {
            exception = exc;
        }
        EntityManagerTLRJUnitTestSuite.assertNotNull((String)"No exception was thrown on an incorrect BATCH query hint.", (Object)((Object)exception));
        EntityManagerTLRJUnitTestSuite.assertTrue((String)"Incorrect Exception thrown", (exception.getErrorCode() == 6143 ? 1 : 0) != 0);
        exception = null;
        try {
            query = em.createQuery("SELECT e FROM Employee e WHERE e.lastName = 'Malone' order by e.firstName");
            query.setHint("eclipselink.batch", (Object)"e.firstName");
            query.getResultList();
        }
        catch (QueryException exc) {
            exception = exc;
        }
        EntityManagerTLRJUnitTestSuite.assertNotNull((String)"No exception was thrown when an incorrect relationship was navigated in a BATCH query hint.", (Object)((Object)exception));
        EntityManagerTLRJUnitTestSuite.assertTrue((String)"Incorrect Exception thrown", (exception.getErrorCode() == 6142 ? 1 : 0) != 0);
        exception = null;
        try {
            query = em.createQuery("SELECT e FROM Employee e WHERE e.lastName = 'Malone' order by e.firstName");
            query.setHint("eclipselink.join-fetch", (Object)"e");
            query.getResultList();
        }
        catch (QueryException exc) {
            exception = exc;
        }
        EntityManagerTLRJUnitTestSuite.assertNotNull((String)"No exception was thrown on an incorrect FETCH query hint.", (Object)((Object)exception));
        EntityManagerTLRJUnitTestSuite.assertTrue((String)"Incorrect Exception thrown", (exception.getErrorCode() == 6144 ? 1 : 0) != 0);
        exception = null;
        try {
            query = em.createQuery("SELECT e FROM Employee e WHERE e.lastName = 'Malone' order by e.firstName");
            query.setHint("eclipselink.join-fetch", (Object)"e.abcdef");
            query.getResultList();
        }
        catch (QueryException exc) {
            exception = exc;
        }
        EntityManagerTLRJUnitTestSuite.assertNotNull((String)"No exception was thrown on an incorrect FETCH query hint.", (Object)((Object)exception));
        EntityManagerTLRJUnitTestSuite.assertTrue((String)"Incorrect Exception thrown", (exception.getErrorCode() == 6143 ? 1 : 0) != 0);
        exception = null;
        try {
            query = em.createQuery("SELECT e FROM Employee e WHERE e.lastName = 'Malone' order by e.firstName");
            query.setHint("eclipselink.join-fetch", (Object)"e.firstName");
            query.getResultList();
        }
        catch (QueryException exc) {
            exception = exc;
        }
        EntityManagerTLRJUnitTestSuite.assertNotNull((String)"No exception was thrown when an incorrect relationship was navigated in a FETCH query hint.", (Object)((Object)exception));
        EntityManagerTLRJUnitTestSuite.assertTrue((String)"Incorrect Exception thrown", (exception.getErrorCode() == 6142 ? 1 : 0) != 0);
    }

    public void testQueryOnClosedEM() {
        if (EntityManagerTLRJUnitTestSuite.isOnServer()) {
            return;
        }
        boolean exceptionWasThrown = false;
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        Query q = em.createQuery("SELECT e FROM Employee e ");
        this.closeEntityManager(em);
        if (em.isOpen()) {
            EntityManagerTLRJUnitTestSuite.fail((String)"Closed EntityManager is still open");
        }
        try {
            q.getResultList();
        }
        catch (IllegalStateException e) {
            exceptionWasThrown = true;
        }
        if (!exceptionWasThrown) {
            EntityManagerTLRJUnitTestSuite.fail((String)"Query on Closed EntityManager did not throw an exception");
        }
    }

    public void testNullifyAddressIn() {
        if (JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
            EntityManagerTLRJUnitTestSuite.getServerSession().logMessage("Test testNullifyAddressIn skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            em.createQuery("UPDATE Employee e SET e.address = null WHERE e.address.country IN ('Canada', 'US')").executeUpdate();
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    public void testLeftJoinOneToOneQuery() {
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        List results = em.createQuery("SELECT a FROM Employee e LEFT JOIN e.address a").getResultList();
        results.toString();
        this.closeEntityManager(em);
    }

    public void testSerializedLazy() {
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        Employee emp = new Employee();
        emp.setFirstName("Owen");
        emp.setLastName("Hargreaves");
        emp.setId(Integer.valueOf(40));
        Address address = new Address();
        address.setCity("Munich");
        emp.setAddress(address);
        em.persist((Object)emp);
        em.flush();
        this.commitTransaction(em);
        this.closeEntityManager(em);
        EntityManagerTLRJUnitTestSuite.clearCache((String)"fieldaccess");
        em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        String ejbqlString = "SELECT e FROM Employee e WHERE e.firstName = 'Owen' and e.lastName = 'Hargreaves'";
        List result = em.createQuery(ejbqlString).getResultList();
        emp = (Employee)result.get(0);
        ValidationException exception = null;
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            ObjectOutputStream stream = new ObjectOutputStream(byteStream);
            stream.writeObject(emp);
            stream.flush();
            byte[] arr = byteStream.toByteArray();
            ByteArrayInputStream inByteStream = new ByteArrayInputStream(arr);
            ObjectInputStream inObjStream = new ObjectInputStream(inByteStream);
            emp = (Employee)inObjStream.readObject();
            emp.getAddress();
        }
        catch (ValidationException e) {
            if (e.getErrorCode() == 7242) {
                exception = e;
            } else {
                EntityManagerTLRJUnitTestSuite.fail((String)("An unexpected exception was thrown while testing serialization of ValueHolders: " + e.toString()));
            }
        }
        catch (Exception e) {
            EntityManagerTLRJUnitTestSuite.fail((String)("An unexpected exception was thrown while testing serialization of ValueHolders: " + e.toString()));
        }
        if (this.isWeavingEnabled()) {
            EntityManagerTLRJUnitTestSuite.assertNotNull((String)("The correct exception was not thrown while traversing an uninstantiated lazy relationship on a serialized object: " + (Object)((Object)exception)), (Object)((Object)exception));
        }
        this.beginTransaction(em);
        emp = (Employee)em.find(Employee.class, (Object)emp.getId());
        em.remove((Object)emp);
        this.commitTransaction(em);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSequenceObjectDefinition() {
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        ServerSession ss = EntityManagerTLRJUnitTestSuite.getServerSession((String)"fieldaccess");
        if (!ss.getLogin().getPlatform().supportsSequenceObjects()) {
            this.closeEntityManager(em);
            return;
        }
        String seqName = "testSequenceObjectsDefinition";
        try {
            this.internalTestSequenceObjectDefinition(10, 1, seqName, em, ss);
            this.internalTestSequenceObjectDefinition(10, 5, seqName + "1", em, ss);
            this.internalTestSequenceObjectDefinition(10, 15, seqName + "2", em, ss);
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalTestSequenceObjectDefinition(int preallocationSize, int startValue, String seqName, EntityManager em, ServerSession ss) {
        NativeSequence sequence = new NativeSequence(seqName, preallocationSize, startValue, false);
        sequence.onConnect((Platform)ss.getPlatform());
        SequenceObjectDefinition def = new SequenceObjectDefinition((Sequence)sequence);
        try {
            String createStr = def.buildCreationWriter((AbstractSession)ss, (Writer)new StringWriter()).toString();
            this.beginTransaction(em);
            em.createNativeQuery(createStr).executeUpdate();
            this.commitTransaction(em);
            Vector seqValues = sequence.getGeneratedVector(null, (AbstractSession)ss);
            int firstSequenceValue = ((Number)seqValues.elementAt(0)).intValue();
            if (firstSequenceValue != startValue) {
                EntityManagerTLRJUnitTestSuite.fail((String)(seqName + " sequence with preallocationSize = " + preallocationSize + " and startValue = " + startValue + " produced wrong firstSequenceValue =" + firstSequenceValue));
            }
        }
        finally {
            sequence.onDisconnect((Platform)ss.getPlatform());
            if (JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
                return;
            }
            String dropStr = def.buildDeletionWriter((AbstractSession)ss, (Writer)new StringWriter()).toString();
            this.beginTransaction(em);
            em.createNativeQuery(dropStr).executeUpdate();
            this.commitTransaction(em);
        }
    }

    public void testMergeDetachedObject() {
        Department detachedDepartment;
        EntityManagerTLRJUnitTestSuite.clearCache((String)"fieldaccess");
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        Query query = em.createNamedQuery("findAllSQLDepartments");
        List departments = query.getResultList();
        if (departments.isEmpty()) {
            this.beginTransaction(em);
            detachedDepartment = new Department();
            detachedDepartment.setName("Department X");
            em.persist((Object)detachedDepartment);
            this.commitTransaction(em);
        } else {
            detachedDepartment = (Department)departments.iterator().next();
        }
        this.closeEntityManager(em);
        EntityManagerTLRJUnitTestSuite.clearCache((String)"fieldaccess");
        em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        Employee emp = new Employee();
        emp.setFirstName("Crazy");
        emp.setLastName("Kid");
        emp.setId(Integer.valueOf(41));
        emp.setDepartment(detachedDepartment);
        em.persist((Object)emp);
        try {
            this.commitTransaction(em);
            em.createNamedQuery("findAllSQLDepartments").getResultList();
        }
        catch (RuntimeException e) {
            EntityManagerTLRJUnitTestSuite.getServerSession((String)"fieldaccess").log(new SessionLogEntry((AbstractSession)EntityManagerTLRJUnitTestSuite.getServerSession((String)"fieldaccess"), 6, "transaction", (Throwable)e));
        }
        this.closeEntityManager(em);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMergeRemovedObject() {
        Employee emp = new Employee();
        emp.setFirstName("testMergeRemovedObjectEmployee");
        emp.setId(Integer.valueOf(42));
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            em.persist((Object)emp);
            this.commitTransaction(em);
        }
        catch (RuntimeException re) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw re;
        }
        this.beginTransaction(em);
        em.remove(em.find(Employee.class, (Object)emp.getId()));
        try {
            em.merge((Object)emp);
            EntityManagerTLRJUnitTestSuite.fail((String)"No exception thrown when merging a removed entity is attempted.");
        }
        catch (IllegalArgumentException re) {
        }
        catch (Exception e) {
            EntityManagerTLRJUnitTestSuite.fail((String)("Wrong exception type thrown: " + e.getClass()));
        }
        finally {
            this.rollbackTransaction(em);
            this.beginTransaction(em);
            em.remove(em.find(Employee.class, (Object)emp.getId()));
            this.commitTransaction(em);
            this.closeEntityManager(em);
        }
    }

    public void testMergeNull() {
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            em.merge(null);
        }
        catch (IllegalArgumentException iae) {
            return;
        }
        catch (Exception e) {
            EntityManagerTLRJUnitTestSuite.fail((String)("Wrong exception type thrown: " + e.getClass()));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
        EntityManagerTLRJUnitTestSuite.fail((String)"No exception thrown when entityManager.merge(null) attempted.");
    }

    public void testPersistNull() {
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            em.persist(null);
        }
        catch (IllegalArgumentException iae) {
            return;
        }
        catch (Exception e) {
            EntityManagerTLRJUnitTestSuite.fail((String)("Wrong exception type thrown: " + e.getClass()));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
        EntityManagerTLRJUnitTestSuite.fail((String)"No exception thrown when entityManager.persist(null) attempted.");
    }

    public void testContainsNull() {
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            em.contains(null);
        }
        catch (IllegalArgumentException iae) {
            return;
        }
        catch (Exception e) {
            EntityManagerTLRJUnitTestSuite.fail((String)("Wrong exception type thrown: " + e.getClass()));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
        EntityManagerTLRJUnitTestSuite.fail((String)"No exception thrown when entityManager.contains(null) attempted.");
    }

    public void testRemoveNull() {
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            em.remove(null);
        }
        catch (IllegalArgumentException iae) {
            return;
        }
        catch (Exception e) {
            EntityManagerTLRJUnitTestSuite.fail((String)("Wrong exception type thrown: " + e.getClass()));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
        EntityManagerTLRJUnitTestSuite.fail((String)"No exception thrown when entityManager.remove(null) attempted.");
    }

    public void testPrimaryKeyUpdate() {
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        Employee emp = new Employee();
        emp.setFirstName("Groucho");
        emp.setLastName("Marx");
        em.persist((Object)emp);
        Integer id = emp.getId();
        this.commitTransaction(em);
        this.beginTransaction(em);
        emp = (Employee)em.merge((Object)emp);
        emp.setId(Integer.valueOf(id + 1));
        try {
            this.commitTransaction(em);
        }
        catch (Exception exception) {
            Throwable persistenceException;
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            for (persistenceException = exception; persistenceException != null && !(persistenceException instanceof ValidationException); persistenceException = persistenceException.getCause()) {
            }
            if (persistenceException instanceof ValidationException) {
                ValidationException ve = (ValidationException)persistenceException;
                if (ve.getErrorCode() == 7251) {
                    return;
                }
                AssertionFailedError failure = new AssertionFailedError("Wrong error code for ValidationException: " + ve.getErrorCode());
                failure.initCause((Throwable)ve);
                throw failure;
            }
            AssertionFailedError failure = new AssertionFailedError("ValiationException expected, thrown: " + exception);
            failure.initCause((Throwable)exception);
            throw failure;
        }
        finally {
            this.closeEntityManager(em);
        }
        EntityManagerTLRJUnitTestSuite.fail((String)"No exception thrown when primary key update attempted.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPrimaryKeyUpdateSameValue() {
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        Employee emp = new Employee();
        emp.setFirstName("Harpo");
        emp.setLastName("Marx");
        em.persist((Object)emp);
        Integer id = emp.getId();
        this.commitTransaction(em);
        this.beginTransaction(em);
        emp.setId(id);
        try {
            this.commitTransaction(em);
        }
        catch (Exception e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            EntityManagerTLRJUnitTestSuite.fail((String)("Unexpected exception thrown: " + e.getClass()));
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testPrimaryKeyUpdatePKFK() {
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        Employee emp = new Employee();
        emp.setFirstName("Groucho");
        emp.setLastName("Marx");
        em.persist((Object)emp);
        Employee emp2 = new Employee();
        emp2.setFirstName("Harpo");
        emp2.setLastName("Marx");
        em.persist((Object)emp2);
        PhoneNumber phone = new PhoneNumber("home", "415", "0007");
        phone.setOwner(emp);
        em.persist((Object)phone);
        this.commitTransaction(em);
        this.beginTransaction(em);
        phone = (PhoneNumber)em.merge((Object)phone);
        emp2 = (Employee)em.merge((Object)emp2);
        phone.setOwner(emp2);
        try {
            this.commitTransaction(em);
        }
        catch (Exception exception) {
            Throwable persistenceException;
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            for (persistenceException = exception; persistenceException != null && !(persistenceException instanceof ValidationException); persistenceException = persistenceException.getCause()) {
            }
            if (persistenceException instanceof ValidationException) {
                ValidationException ve = (ValidationException)persistenceException;
                if (ve.getErrorCode() == 7251) {
                    return;
                }
                AssertionFailedError failure = new AssertionFailedError("Wrong error code for ValidationException: " + ve.getErrorCode());
                failure.initCause((Throwable)ve);
                throw failure;
            }
            AssertionFailedError failure = new AssertionFailedError("ValiationException expected, thrown: " + exception);
            failure.initCause((Throwable)exception);
            throw failure;
        }
        finally {
            this.closeEntityManager(em);
        }
        EntityManagerTLRJUnitTestSuite.fail((String)"No exception thrown when primary key update attempted.");
    }

    public void testCascadeMergeDetached() {
        Project p1 = new Project();
        p1.setName("Project1");
        Project p2 = new Project();
        p1.setName("Project2");
        Employee e1 = new Employee();
        e1.setFirstName("Employee1");
        Employee e2 = new Employee();
        e2.setFirstName("Employee2");
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            em.persist((Object)p1);
            em.persist((Object)p2);
            em.persist((Object)e1);
            em.persist((Object)e2);
            this.commitTransaction(em);
        }
        catch (RuntimeException re) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw re;
        }
        this.closeEntityManager(em);
        p1.setTeamLeader(e1);
        e1.addManagedEmployee(e2);
        e2.addProject(p2);
        p2.addTeamMember(e2);
        em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            Project mp1 = (Project)em.merge((Object)p1);
            EntityManagerTLRJUnitTestSuite.assertTrue((boolean)em.contains((Object)mp1));
            EntityManagerTLRJUnitTestSuite.assertTrue((String)"Managed instance and detached instance must not be same", (mp1 != p1 ? 1 : 0) != 0);
            Employee me1 = mp1.getTeamLeader();
            EntityManagerTLRJUnitTestSuite.assertTrue((String)"Cascade merge failed", (boolean)em.contains((Object)me1));
            EntityManagerTLRJUnitTestSuite.assertTrue((String)"Managed instance and detached instance must not be same", (me1 != e1 ? 1 : 0) != 0);
            Employee me2 = (Employee)me1.getManagedEmployees().iterator().next();
            EntityManagerTLRJUnitTestSuite.assertTrue((String)"Cascade merge failed", (boolean)em.contains((Object)me2));
            EntityManagerTLRJUnitTestSuite.assertTrue((String)"Managed instance and detached instance must not be same", (me2 != e2 ? 1 : 0) != 0);
            Project mp2 = (Project)me2.getProjects().iterator().next();
            EntityManagerTLRJUnitTestSuite.assertTrue((String)"Cascade merge failed", (boolean)em.contains((Object)mp2));
            EntityManagerTLRJUnitTestSuite.assertTrue((String)"Managed instance and detached instance must not be same", (mp2 != p2 ? 1 : 0) != 0);
            this.commitTransaction(em);
        }
        catch (RuntimeException re) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw re;
        }
        this.closeEntityManager(em);
    }

    public void testCascadeMergeManaged() {
        Project p1 = new Project();
        p1.setName("Project1");
        Project p2 = new Project();
        p1.setName("Project2");
        Employee e1 = new Employee();
        e1.setFirstName("Employee1");
        Employee e2 = new Employee();
        e2.setFirstName("Employee2");
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            em.persist((Object)p1);
            em.persist((Object)p2);
            em.persist((Object)e1);
            em.persist((Object)e2);
            this.commitTransaction(em);
        }
        catch (RuntimeException re) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw re;
        }
        this.closeEntityManager(em);
        em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            Project mp1 = (Project)em.merge((Object)p1);
            EntityManagerTLRJUnitTestSuite.assertTrue((boolean)em.contains((Object)mp1));
            EntityManagerTLRJUnitTestSuite.assertTrue((String)"Managed instance and detached instance must not be same", (mp1 != p1 ? 1 : 0) != 0);
            mp1.setTeamLeader(e1);
            mp1 = (Project)em.merge((Object)mp1);
            Employee me1 = mp1.getTeamLeader();
            EntityManagerTLRJUnitTestSuite.assertTrue((String)"Cascade merge failed", (boolean)em.contains((Object)me1));
            EntityManagerTLRJUnitTestSuite.assertTrue((String)"Managed instance and detached instance must not be same", (me1 != e1 ? 1 : 0) != 0);
            me1.addManagedEmployee(e2);
            me1 = (Employee)em.merge((Object)me1);
            Employee me2 = (Employee)me1.getManagedEmployees().iterator().next();
            EntityManagerTLRJUnitTestSuite.assertTrue((String)"Cascade merge failed", (boolean)em.contains((Object)me2));
            EntityManagerTLRJUnitTestSuite.assertTrue((String)"Managed instance and detached instance must not be same", (me2 != e2 ? 1 : 0) != 0);
            me2.addProject(p2);
            p2.addTeamMember(me2);
            me2 = (Employee)em.merge((Object)me2);
            Project mp2 = (Project)me2.getProjects().iterator().next();
            EntityManagerTLRJUnitTestSuite.assertTrue((String)"Cascade merge failed", (boolean)em.contains((Object)mp2));
            EntityManagerTLRJUnitTestSuite.assertTrue((String)"Managed instance and detached instance must not be same", (mp2 != p2 ? 1 : 0) != 0);
            this.commitTransaction(em);
        }
        catch (RuntimeException re) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw re;
        }
        this.closeEntityManager(em);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCascadePersistToNonEntitySubclass() {
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        InheritancePolicy ip = EntityManagerTLRJUnitTestSuite.getServerSession((String)"fieldaccess").getDescriptor(Project.class).getInheritancePolicy();
        boolean describesNonPersistentSubclasses = ip.getDescribesNonPersistentSubclasses();
        ip.setDescribesNonPersistentSubclasses(true);
        this.beginTransaction(em);
        Employee emp = new Employee();
        emp.setFirstName("Albert");
        emp.setLastName("Einstein");
        SuperLargeProject s1 = new SuperLargeProject("Super 1");
        ArrayList<SuperLargeProject> projects = new ArrayList<SuperLargeProject>();
        projects.add(s1);
        emp.setProjects(projects);
        em.persist((Object)emp);
        try {
            this.commitTransaction(em);
        }
        catch (Exception e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            EntityManagerTLRJUnitTestSuite.fail((String)("Persist operation was not cascaded to related non-entity, thrown: " + e));
        }
        finally {
            ip.setDescribesNonPersistentSubclasses(describesNonPersistentSubclasses);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInitializeFieldForPropertyAccess() {
        Employee employee = new Employee();
        employee.setFirstName("Andy");
        employee.setLastName("Dufresne");
        Address address = new Address();
        address.setCity("Shawshank");
        employee.setAddressField(address);
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        em.persist((Object)employee);
        try {
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        int id = employee.getId();
        EntityManagerTLRJUnitTestSuite.clearCache((String)"fieldaccess");
        em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            employee = (Employee)em.find(Employee.class, (Object)new Integer(id));
            address = employee.getAddress();
            EntityManagerTLRJUnitTestSuite.assertTrue((String)"The address was not persisted.", (employee.getAddress() != null ? 1 : 0) != 0);
            EntityManagerTLRJUnitTestSuite.assertTrue((String)"The address was not correctly persisted.", (boolean)employee.getAddress().getCity().equals("Shawshank"));
        }
        finally {
            employee.setAddress(null);
            em.remove((Object)address);
            em.remove((Object)employee);
            this.commitTransaction(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetFieldForPropertyAccess() {
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        Employee employee = new Employee();
        employee.setFirstName("Andy");
        employee.setLastName("Dufresne");
        Address address = new Address();
        address.setCity("Shawshank");
        employee.setAddress(address);
        this.beginTransaction(em);
        em.persist((Object)employee);
        this.commitTransaction(em);
        int id = employee.getId();
        int addressId = address.getId();
        this.beginTransaction(em);
        employee = (Employee)em.find(Employee.class, (Object)new Integer(id));
        employee.getAddress();
        address = new Address();
        address.setCity("Metropolis");
        employee.setAddressField(address);
        try {
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        EntityManagerTLRJUnitTestSuite.clearCache((String)"fieldaccess");
        em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            employee = (Employee)em.find(Employee.class, (Object)new Integer(id));
            address = employee.getAddress();
            EntityManagerTLRJUnitTestSuite.assertTrue((String)"The address was not persisted.", (employee.getAddress() != null ? 1 : 0) != 0);
            EntityManagerTLRJUnitTestSuite.assertTrue((String)"The address was not correctly persisted.", (boolean)employee.getAddress().getCity().equals("Metropolis"));
        }
        finally {
            Address initialAddress = (Address)em.find(Address.class, (Object)new Integer(addressId));
            employee.setAddress(null);
            employee.setManager((Employee)null);
            em.remove((Object)address);
            em.remove((Object)employee);
            em.remove((Object)initialAddress);
            this.commitTransaction(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetFieldForPropertyAccessWithRefresh() {
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        Employee employee = new Employee();
        employee.setFirstName("Andy");
        employee.setLastName("Dufresne");
        Address address = new Address();
        address.setCity("Shawshank");
        employee.setAddress(address);
        this.beginTransaction(em);
        em.persist((Object)employee);
        this.commitTransaction(em);
        int id = employee.getId();
        int addressId = address.getId();
        this.beginTransaction(em);
        employee = (Employee)em.getReference(Employee.class, (Object)employee.getId());
        em.refresh((Object)employee);
        employee.getAddress();
        address = new Address();
        address.setCity("Metropolis");
        employee.setAddressField(address);
        try {
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        EntityManagerTLRJUnitTestSuite.clearCache((String)"fieldaccess");
        em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            employee = (Employee)em.find(Employee.class, (Object)new Integer(id));
            address = employee.getAddress();
            EntityManagerTLRJUnitTestSuite.assertTrue((String)"The address was not persisted.", (employee.getAddress() != null ? 1 : 0) != 0);
            EntityManagerTLRJUnitTestSuite.assertTrue((String)"The address was not correctly persisted.", (boolean)employee.getAddress().getCity().equals("Metropolis"));
        }
        finally {
            Address initialAddress = (Address)em.find(Address.class, (Object)new Integer(addressId));
            employee.setAddress(null);
            employee.setManager((Employee)null);
            em.remove((Object)address);
            em.remove((Object)employee);
            em.remove((Object)initialAddress);
            this.commitTransaction(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetFieldForPropertyAccessWithNewEM() {
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        Employee employee = new Employee();
        employee.setFirstName("Andy");
        employee.setLastName("Dufresne");
        Address address = new Address();
        address.setCity("Shawshank");
        employee.setAddress(address);
        this.beginTransaction(em);
        em.persist((Object)employee);
        this.commitTransaction(em);
        int id = employee.getId();
        int addressId = address.getId();
        em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        employee = (Employee)em.find(Employee.class, (Object)new Integer(id));
        employee.getAddress();
        address = new Address();
        address.setCity("Metropolis");
        employee.setAddressField(address);
        try {
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        EntityManagerTLRJUnitTestSuite.clearCache((String)"fieldaccess");
        em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            employee = (Employee)em.find(Employee.class, (Object)new Integer(id));
            address = employee.getAddress();
            EntityManagerTLRJUnitTestSuite.assertTrue((String)"The address was not persisted.", (employee.getAddress() != null ? 1 : 0) != 0);
            EntityManagerTLRJUnitTestSuite.assertTrue((String)"The address was not correctly persisted.", (boolean)employee.getAddress().getCity().equals("Metropolis"));
        }
        finally {
            Address initialAddress = (Address)em.find(Address.class, (Object)new Integer(addressId));
            employee.setAddress(null);
            employee.setManager((Employee)null);
            em.remove((Object)address);
            em.remove((Object)employee);
            em.remove((Object)initialAddress);
            this.commitTransaction(em);
        }
    }

    public void testDeleteAllPhonesWithNullOwner() {
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            em.createQuery("DELETE FROM PhoneNumber ph WHERE ph.owner IS NULL").executeUpdate();
        }
        catch (Exception e) {
            EntityManagerTLRJUnitTestSuite.fail((String)("Exception thrown: " + e.getClass()));
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    public void testDeleteAllProjectsWithNullTeamLeader() {
        if (JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
            EntityManagerTLRJUnitTestSuite.getServerSession().logMessage("Test testDeleteAllProjectsWithNullTeamLeader skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        this.internalDeleteAllProjectsWithNullTeamLeader("Project");
    }

    public void testDeleteAllSmallProjectsWithNullTeamLeader() {
        this.internalDeleteAllProjectsWithNullTeamLeader("SmallProject");
    }

    public void testDeleteAllLargeProjectsWithNullTeamLeader() {
        if (JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
            EntityManagerTLRJUnitTestSuite.getServerSession().logMessage("Test testDeleteAllLargeProjectsWithNullTeamLeader skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        this.internalDeleteAllProjectsWithNullTeamLeader("LargeProject");
    }

    protected void internalDeleteAllProjectsWithNullTeamLeader(String className) {
        String name = "testDeleteAllProjectsWithNull";
        SmallProject sp = new SmallProject();
        sp.setName(name);
        LargeProject lp = new LargeProject();
        lp.setName(name);
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            em.createQuery("DELETE FROM " + className + " p WHERE p.name = '" + name + "'").executeUpdate();
            em.persist((Object)sp);
            em.persist((Object)lp);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw ex;
        }
        finally {
            this.closeEntityManager(em);
        }
        em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            em.createQuery("DELETE FROM " + className + " p WHERE p.name = '" + name + "' AND p.teamLeader IS NULL").executeUpdate();
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        finally {
            this.closeEntityManager(em);
        }
        String error = null;
        em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        List result = em.createQuery("SELECT OBJECT(p) FROM Project p WHERE p.name = '" + name + "'").getResultList();
        if (result.isEmpty()) {
            if (!className.equals("Project")) {
                error = "Target Class " + className + ": no objects left";
            }
        } else if (result.size() > 1) {
            error = "Target Class " + className + ": too many objects left: " + result.size();
        } else {
            Project p = (Project)result.get(0);
            if (p.getClass().getName().endsWith(className)) {
                error = "Target Class " + className + ": object of wrong type left: " + p.getClass().getName();
            }
        }
        try {
            this.beginTransaction(em);
            em.createQuery("DELETE FROM " + className + " p WHERE p.name = '" + name + "'").executeUpdate();
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw ex;
        }
        finally {
            this.closeEntityManager(em);
        }
        if (error != null) {
            EntityManagerTLRJUnitTestSuite.fail((String)error);
        }
    }

    public void testUpdateUsingTempStorage() {
        this.internalUpdateUsingTempStorage(false);
    }

    public void testUpdateUsingTempStorageWithParameter() {
        this.internalUpdateUsingTempStorage(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalUpdateUsingTempStorage(boolean useParameter) {
        if (JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
            EntityManagerTLRJUnitTestSuite.getServerSession().logMessage("Test testUpdateUsingTempStorage* skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        String firstName = "testUpdateUsingTempStorage";
        int n = 3;
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            em.createQuery("DELETE FROM Employee e WHERE e.firstName = '" + firstName + "'").executeUpdate();
            em.createQuery("DELETE FROM Address a WHERE a.country = '" + firstName + "'").executeUpdate();
            for (int i = 1; i <= n; ++i) {
                Employee emp = new Employee();
                emp.setFirstName(firstName);
                emp.setLastName(Integer.toString(i));
                emp.setSalary(i * 100);
                emp.setRoomNumber(i);
                Address address = new Address();
                address.setCountry(firstName);
                address.setCity(Integer.toString(i));
                emp.setAddress(address);
                em.persist((Object)emp);
            }
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw ex;
        }
        finally {
            this.closeEntityManager(em);
        }
        em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        int nUpdated = 0;
        try {
            nUpdated = useParameter ? em.createQuery("UPDATE Employee e set e.salary = e.roomNumber, e.roomNumber = e.salary, e.address = :address where e.firstName = '" + firstName + "'").setParameter("address", null).executeUpdate() : em.createQuery("UPDATE Employee e set e.salary = e.roomNumber, e.roomNumber = e.salary, e.address = null where e.firstName = '" + firstName + "'").executeUpdate();
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
        String error = null;
        em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        List result = em.createQuery("SELECT OBJECT(e) FROM Employee e WHERE e.firstName = '" + firstName + "'").getResultList();
        this.closeEntityManager(em);
        int nReadBack = result.size();
        if (n != nUpdated) {
            error = "n = " + n + ", but nUpdated =" + nUpdated + ";";
        }
        if (n != nReadBack) {
            error = " n = " + n + ", but nReadBack =" + nReadBack + ";";
        }
        for (int i = 0; i < nReadBack; ++i) {
            Employee emp = (Employee)result.get(i);
            if (emp.getAddress() != null) {
                error = " Employee " + emp.getLastName() + " still has address;";
            }
            int ind = Integer.valueOf(emp.getLastName());
            if (emp.getSalary() != ind) {
                error = " Employee " + emp.getLastName() + " has wrong salary " + emp.getSalary() + ";";
            }
            if (emp.getRoomNumber() == ind * 100) continue;
            error = " Employee " + emp.getLastName() + " has wrong roomNumber " + emp.getRoomNumber() + ";";
        }
        em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            em.createQuery("DELETE FROM Employee e WHERE e.firstName = '" + firstName + "'").executeUpdate();
            em.createQuery("DELETE FROM Address a WHERE a.country = '" + firstName + "'").executeUpdate();
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw ex;
        }
        finally {
            this.closeEntityManager(em);
        }
        if (error != null) {
            EntityManagerTLRJUnitTestSuite.fail((String)error);
        }
    }

    protected void createProjectsWithName(String name, Employee teamLeader) {
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            SmallProject sp = new SmallProject();
            sp.setName(name);
            LargeProject lp = new LargeProject();
            lp.setName(name);
            em.persist((Object)sp);
            em.persist((Object)lp);
            if (teamLeader != null) {
                SmallProject sp2 = new SmallProject();
                sp2.setName(name);
                sp2.setTeamLeader(teamLeader);
                LargeProject lp2 = new LargeProject();
                lp2.setName(name);
                lp2.setTeamLeader(teamLeader);
                em.persist((Object)sp2);
                em.persist((Object)lp2);
            }
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw ex;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    protected void deleteProjectsWithName(String name) {
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            em.createQuery("DELETE FROM Project p WHERE p.name = '" + name + "'").executeUpdate();
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw ex;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testUpdateAllSmallProjects() {
        this.internalTestUpdateAllProjects(SmallProject.class);
    }

    public void testUpdateAllLargeProjects() {
        this.internalTestUpdateAllProjects(LargeProject.class);
    }

    public void testUpdateAllProjects() {
        this.internalTestUpdateAllProjects(Project.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void internalTestUpdateAllProjects(Class cls) {
        List projects;
        EntityManager em;
        if (JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
            EntityManagerTLRJUnitTestSuite.getServerSession().logMessage("Test testUpdateAll*Projects skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        String className = Helper.getShortClassName((Class)cls);
        String name = "testUpdateAllProjects";
        String newName = "testUpdateAllProjectsNEW";
        HashMap<Integer, String> map = null;
        boolean ok = false;
        try {
            this.createProjectsWithName(name, null);
            em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
            projects = em.createQuery("SELECT OBJECT(p) FROM Project p").getResultList();
            map = new HashMap<Integer, String>(projects.size());
            for (int i = 0; i < projects.size(); ++i) {
                Project p = (Project)projects.get(i);
                map.put(p.getId(), p.getName());
            }
            this.beginTransaction(em);
            try {
                em.createQuery("UPDATE " + className + " p set p.name = '" + newName + "'").executeUpdate();
                this.commitTransaction(em);
            }
            catch (RuntimeException ex) {
                if (!this.isTransactionActive(em)) throw ex;
                this.rollbackTransaction(em);
                throw ex;
            }
            finally {
                this.closeEntityManager(em);
            }
            em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
            String errorMsg = "";
            projects = em.createQuery("SELECT OBJECT(p) FROM Project p").getResultList();
            for (int i = 0; i < projects.size(); ++i) {
                Project p = (Project)projects.get(i);
                String readName = p.getName();
                if (cls.isInstance(p)) {
                    if (newName.equals(readName)) continue;
                    errorMsg = errorMsg + "haven't updated name: " + p + "; ";
                    continue;
                }
                if (!newName.equals(readName)) continue;
                errorMsg = errorMsg + "have updated name: " + p + "; ";
            }
            this.closeEntityManager(em);
            if (errorMsg.length() > 0) {
                EntityManagerTLRJUnitTestSuite.fail((String)errorMsg);
                return;
            }
            ok = true;
            return;
        }
        finally {
            block30: {
                try {
                    if (map != null) {
                        em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
                        this.beginTransaction(em);
                        projects = em.createQuery("SELECT OBJECT(p) FROM Project p").getResultList();
                        try {
                            for (int i = 0; i < projects.size(); ++i) {
                                Project p = (Project)projects.get(i);
                                String oldName = (String)map.get(((Project)projects.get(i)).getId());
                                p.setName(oldName);
                            }
                            this.commitTransaction(em);
                        }
                        catch (RuntimeException ex) {
                            if (!this.isTransactionActive(em)) throw ex;
                            this.rollbackTransaction(em);
                            throw ex;
                        }
                        finally {
                            this.closeEntityManager(em);
                        }
                    }
                    this.deleteProjectsWithName(name);
                }
                catch (RuntimeException ex) {
                    if (!ok) break block30;
                    throw ex;
                }
            }
        }
    }

    public void testUpdateAllSmallProjectsWithName() {
        this.internalTestUpdateAllProjectsWithName(SmallProject.class);
    }

    public void testUpdateAllLargeProjectsWithName() {
        this.internalTestUpdateAllProjectsWithName(LargeProject.class);
    }

    public void testUpdateAllProjectsWithName() {
        this.internalTestUpdateAllProjectsWithName(Project.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalTestUpdateAllProjectsWithName(Class cls) {
        if (JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
            EntityManagerTLRJUnitTestSuite.getServerSession().logMessage("Test testUpdateAll*ProjectsWithName skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        String className = Helper.getShortClassName((Class)cls);
        String name = "testUpdateAllProjects";
        String newName = "testUpdateAllProjectsNEW";
        boolean ok = false;
        try {
            this.deleteProjectsWithName(name);
            this.deleteProjectsWithName(newName);
            this.createProjectsWithName(name, null);
            EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
            this.beginTransaction(em);
            try {
                em.createQuery("UPDATE " + className + " p set p.name = '" + newName + "' WHERE p.name = '" + name + "'").executeUpdate();
                this.commitTransaction(em);
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                throw ex;
            }
            finally {
                this.closeEntityManager(em);
            }
            em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
            String errorMsg = "";
            List projects = em.createQuery("SELECT OBJECT(p) FROM Project p WHERE p.name = '" + newName + "' OR p.name = '" + name + "'").getResultList();
            for (int i = 0; i < projects.size(); ++i) {
                Project p = (Project)projects.get(i);
                String readName = p.getName();
                if (cls.isInstance(p)) {
                    if (readName.equals(newName)) continue;
                    errorMsg = errorMsg + "haven't updated name: " + p + "; ";
                    continue;
                }
                if (!readName.equals(newName)) continue;
                errorMsg = errorMsg + "have updated name: " + p + "; ";
            }
            this.closeEntityManager(em);
            if (errorMsg.length() > 0) {
                EntityManagerTLRJUnitTestSuite.fail((String)errorMsg);
            } else {
                ok = true;
            }
        }
        finally {
            block20: {
                try {
                    this.deleteProjectsWithName(name);
                    this.deleteProjectsWithName(newName);
                }
                catch (RuntimeException ex) {
                    if (!ok) break block20;
                    throw ex;
                }
            }
        }
    }

    public void testUpdateAllSmallProjectsWithNullTeamLeader() {
        this.internalTestUpdateAllProjectsWithNullTeamLeader(SmallProject.class);
    }

    public void testUpdateAllLargeProjectsWithNullTeamLeader() {
        this.internalTestUpdateAllProjectsWithNullTeamLeader(LargeProject.class);
    }

    public void testUpdateAllProjectsWithNullTeamLeader() {
        this.internalTestUpdateAllProjectsWithNullTeamLeader(Project.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void internalTestUpdateAllProjectsWithNullTeamLeader(Class cls) {
        EntityManager em;
        if (JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
            EntityManagerTLRJUnitTestSuite.getServerSession().logMessage("Test testUpdateAll*ProjectsWithNullTeamLeader skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
        }
        String className = Helper.getShortClassName((Class)cls);
        String name = "testUpdateAllProjects";
        String newName = "testUpdateAllProjectsNEW";
        Employee empTemp = null;
        boolean ok = false;
        try {
            this.deleteProjectsWithName(name);
            this.deleteProjectsWithName(newName);
            em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
            Employee emp = null;
            List employees = em.createQuery("SELECT OBJECT(e) FROM Employee e").getResultList();
            if (employees.size() > 0) {
                emp = (Employee)employees.get(0);
            } else {
                this.beginTransaction(em);
                try {
                    emp = new Employee();
                    emp.setFirstName(name);
                    emp.setLastName("TeamLeader");
                    em.persist((Object)emp);
                    this.commitTransaction(em);
                    empTemp = emp;
                }
                catch (RuntimeException ex) {
                    if (this.isTransactionActive(em)) {
                        this.rollbackTransaction(em);
                    }
                    this.closeEntityManager(em);
                    throw ex;
                }
            }
            this.closeEntityManager(em);
            this.createProjectsWithName(name, emp);
            em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
            this.beginTransaction(em);
            try {
                em.createQuery("UPDATE " + className + " p set p.name = '" + newName + "' WHERE p.name = '" + name + "' AND p.teamLeader IS NULL").executeUpdate();
                this.commitTransaction(em);
            }
            catch (RuntimeException ex) {
                if (!this.isTransactionActive(em)) throw ex;
                this.rollbackTransaction(em);
                throw ex;
            }
            finally {
                this.closeEntityManager(em);
            }
            em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
            String errorMsg = "";
            List projects = em.createQuery("SELECT OBJECT(p) FROM Project p WHERE p.name = '" + newName + "' OR p.name = '" + name + "'").getResultList();
            for (int i = 0; i < projects.size(); ++i) {
                Project p = (Project)projects.get(i);
                String readName = p.getName();
                if (cls.isInstance(p) && p.getTeamLeader() == null) {
                    if (readName.equals(newName)) continue;
                    errorMsg = errorMsg + "haven't updated name: " + p + "; ";
                    continue;
                }
                if (!readName.equals(newName)) continue;
                errorMsg = errorMsg + "have updated name: " + p + "; ";
            }
            this.closeEntityManager(em);
            if (errorMsg.length() > 0) {
                EntityManagerTLRJUnitTestSuite.fail((String)errorMsg);
                return;
            }
            ok = true;
            return;
        }
        finally {
            block31: {
                try {
                    this.deleteProjectsWithName(name);
                    this.deleteProjectsWithName(newName);
                    if (empTemp == null) break block31;
                    em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
                    this.beginTransaction(em);
                    try {
                        em.createQuery("DELETE FROM Employee e WHERE e.id = '" + empTemp.getId() + "'").executeUpdate();
                        this.commitTransaction(em);
                    }
                    catch (RuntimeException ex) {
                        if (!this.isTransactionActive(em)) throw ex;
                        this.rollbackTransaction(em);
                        throw ex;
                    }
                    finally {
                        this.closeEntityManager(em);
                    }
                }
                catch (RuntimeException ex) {
                    if (!ok) break block31;
                    throw ex;
                }
            }
        }
    }

    public void testRollbackOnlyOnException() {
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            Employee emp = (Employee)em.find(Employee.class, (Object)"");
            emp.toString();
            EntityManagerTLRJUnitTestSuite.fail((String)"IllegalArgumentException has not been thrown");
        }
        catch (IllegalArgumentException ex) {
            if (EntityManagerTLRJUnitTestSuite.isOnServer()) {
                EntityManagerTLRJUnitTestSuite.assertTrue((String)"Transaction is not roll back only", (boolean)this.getRollbackOnly(em));
            } else {
                EntityManagerTLRJUnitTestSuite.assertTrue((String)"Transaction is not roll back only", (boolean)em.getTransaction().getRollbackOnly());
            }
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    public void testClosedEmShouldThrowException() {
        if (EntityManagerTLRJUnitTestSuite.isOnServer()) {
            return;
        }
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.closeEntityManager(em);
        String errorMsg = "";
        try {
            em.clear();
            errorMsg = errorMsg + "; em.clear() didn't throw exception";
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (RuntimeException ex) {
            errorMsg = errorMsg + "; em.clear() threw wrong exception: " + ex.getMessage();
        }
        try {
            this.closeEntityManager(em);
            errorMsg = errorMsg + "; closeEntityManager(em) didn't throw exception";
        }
        catch (IllegalStateException ex) {
        }
        catch (RuntimeException ex) {
            errorMsg = errorMsg + "; closeEntityManager(em) threw wrong exception: " + ex.getMessage();
        }
        try {
            em.contains(null);
            errorMsg = errorMsg + "; em.contains() didn't throw exception";
        }
        catch (IllegalStateException ex) {
        }
        catch (RuntimeException ex) {
            errorMsg = errorMsg + "; em.contains threw() wrong exception: " + ex.getMessage();
        }
        try {
            em.getDelegate();
            errorMsg = errorMsg + "; em.getDelegate() didn't throw exception";
        }
        catch (IllegalStateException ex) {
        }
        catch (RuntimeException ex) {
            errorMsg = errorMsg + "; em.getDelegate() threw wrong exception: " + ex.getMessage();
        }
        try {
            em.getReference(Employee.class, (Object)new Integer(1));
            errorMsg = errorMsg + "; em.getReference() didn't throw exception";
        }
        catch (IllegalStateException ex) {
        }
        catch (RuntimeException ex) {
            errorMsg = errorMsg + "; em.getReference() threw wrong exception: " + ex.getMessage();
        }
        try {
            em.joinTransaction();
            errorMsg = errorMsg + "; em.joinTransaction() didn't throw exception";
        }
        catch (IllegalStateException ex) {
        }
        catch (RuntimeException ex) {
            errorMsg = errorMsg + "; em.joinTransaction() threw wrong exception: " + ex.getMessage();
        }
        try {
            em.lock(null, null);
            errorMsg = errorMsg + "; em.lock() didn't throw exception";
        }
        catch (IllegalStateException ex) {
        }
        catch (RuntimeException ex) {
            errorMsg = errorMsg + "; em.lock() threw wrong exception: " + ex.getMessage();
        }
        if (errorMsg.length() > 0) {
            EntityManagerTLRJUnitTestSuite.fail((String)errorMsg);
        }
    }

    public void testOneToManyDefaultJoinTableName() {
        Department dept = new Department();
        Employee manager = new Employee();
        dept.addManager(manager);
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            em.persist((Object)dept);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    public void testMultipleEntityManagerFactories() {
        if (EntityManagerTLRJUnitTestSuite.isOnServer()) {
            return;
        }
        this.closeEntityManagerFactory();
        EntityManagerFactory factory1 = EntityManagerTLRJUnitTestSuite.getEntityManagerFactory((String)"fieldaccess");
        EntityManagerFactory factory2 = Persistence.createEntityManagerFactory((String)"fieldaccess", (Map)JUnitTestCaseHelper.getDatabaseProperties());
        factory2.createEntityManager();
        factory2.close();
        try {
            factory1.createEntityManager();
        }
        catch (PersistenceException ex) {
            EntityManagerTLRJUnitTestSuite.fail((String)("factory1.createEM threw exception: " + ex.getMessage()));
            factory1.close();
        }
    }

    public void testClearEntityManagerWithoutPersistenceContext() {
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        try {
            em.clear();
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testClearEntityManagerWithoutPersistenceContextSimulateJTA() {
        ServerSession ss = EntityManagerTLRJUnitTestSuite.getServerSession((String)"fieldaccess");
        boolean hasExternalTransactionController = ss.hasExternalTransactionController();
        if (!hasExternalTransactionController) {
            ss.setExternalTransactionController((ExternalTransactionController)new DummyExternalTransactionController());
        }
        try {
            this.testClearEntityManagerWithoutPersistenceContext();
        }
        finally {
            if (!hasExternalTransactionController) {
                ss.setExternalTransactionController(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDescriptorNamedQuery() {
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression exp = builder.get("firstName").equal(builder.getParameter("fName"));
        exp = exp.and(builder.get("lastName").equal(builder.getParameter("lName")));
        query.setSelectionCriteria(exp);
        query.addArgument("fName", String.class);
        query.addArgument("lName", String.class);
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        ServerSession session = EntityManagerTLRJUnitTestSuite.getServerSession((String)"fieldaccess");
        ClassDescriptor descriptor = session.getDescriptor(Employee.class);
        descriptor.getQueryManager().addQuery("findByFNameLName", (DatabaseQuery)query);
        this.beginTransaction(em);
        try {
            Employee emp = new Employee();
            emp.setFirstName("Melvin");
            emp.setLastName("Malone");
            em.persist((Object)emp);
            em.flush();
            Query ejbQuery = ((JpaEntityManager)em.getDelegate()).createDescriptorNamedQuery("findByFNameLName", Employee.class);
            List results = ejbQuery.setParameter("fName", (Object)"Melvin").setParameter("lName", (Object)"Malone").getResultList();
            EntityManagerTLRJUnitTestSuite.assertTrue((results.size() == 1 ? 1 : 0) != 0);
            emp = (Employee)results.get(0);
            EntityManagerTLRJUnitTestSuite.assertTrue((boolean)emp.getFirstName().equals("Melvin"));
            EntityManagerTLRJUnitTestSuite.assertTrue((boolean)emp.getLastName().equals("Malone"));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
        descriptor.getQueryManager().removeQuery("findByFNameLName");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDescriptorNamedQueryForMultipleQueries() {
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression exp = builder.get("firstName").equal(builder.getParameter("fName"));
        exp = exp.and(builder.get("lastName").equal(builder.getParameter("lName")));
        query.setSelectionCriteria(exp);
        query.addArgument("fName", String.class);
        query.addArgument("lName", String.class);
        ReadAllQuery query2 = new ReadAllQuery(Employee.class);
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        ServerSession session = EntityManagerTLRJUnitTestSuite.getServerSession((String)"fieldaccess");
        ClassDescriptor descriptor = session.getDescriptor(Employee.class);
        descriptor.getQueryManager().addQuery("findEmployees", (DatabaseQuery)query);
        descriptor.getQueryManager().addQuery("findEmployees", (DatabaseQuery)query2);
        this.beginTransaction(em);
        try {
            Employee emp = new Employee();
            emp.setFirstName("Melvin");
            emp.setLastName("Malone");
            em.persist((Object)emp);
            em.flush();
            Vector<Class<String>> args = new Vector<Class<String>>(2);
            args.addElement(String.class);
            args.addElement(String.class);
            Query ejbQuery = ((JpaEntityManager)em.getDelegate()).createDescriptorNamedQuery("findEmployees", Employee.class, args);
            List results = ejbQuery.setParameter("fName", (Object)"Melvin").setParameter("lName", (Object)"Malone").getResultList();
            EntityManagerTLRJUnitTestSuite.assertTrue((results.size() == 1 ? 1 : 0) != 0);
            emp = (Employee)results.get(0);
            EntityManagerTLRJUnitTestSuite.assertTrue((boolean)emp.getFirstName().equals("Melvin"));
            EntityManagerTLRJUnitTestSuite.assertTrue((boolean)emp.getLastName().equals("Malone"));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
        descriptor.getQueryManager().removeQuery("findEmployees");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDoubleMerge() {
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        Employee employee = new Employee();
        employee.setId(Integer.valueOf(44));
        employee.setVersion(Integer.valueOf(0));
        employee.setFirstName("Alfie");
        Employee employee2 = new Employee();
        employee2.setId(Integer.valueOf(44));
        employee2.setVersion(Integer.valueOf(0));
        employee2.setFirstName("Phillip");
        try {
            this.beginTransaction(em);
            em.merge((Object)employee);
            em.merge((Object)employee2);
            em.flush();
        }
        catch (PersistenceException e) {
            EntityManagerTLRJUnitTestSuite.fail((String)"A double merge of an object with the same key, caused two inserts instead of one.");
        }
        finally {
            this.rollbackTransaction(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCloneable() {
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            Employee employee = new Employee();
            employee.setFirstName("Owen");
            employee.setLastName("Hargreaves");
            employee.getAddress();
            Employee clone = employee.clone();
            Address address = new Address();
            address.setCity("Munich");
            clone.setAddress(address);
            clone.getAddress();
            em.persist((Object)clone);
            if (employee.getAddress() == clone.getAddress()) {
                EntityManagerTLRJUnitTestSuite.fail((String)"Changing clone address changed original.");
            }
            this.commitTransaction(em);
            EntityManagerTLRJUnitTestSuite.clearCache((String)"fieldaccess");
            this.closeEntityManager(em);
            em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
            this.beginTransaction(em);
            employee = (Employee)em.find(Employee.class, (Object)clone.getId());
            clone = employee.clone();
            address = new Address();
            address.setCity("Not Munich");
            clone.setAddress(address);
            clone.getAddress();
            if (employee.getAddress() == clone.getAddress()) {
                EntityManagerTLRJUnitTestSuite.fail((String)"Changing clone address changed original.");
            }
            if (employee.getAddress() == null) {
                EntityManagerTLRJUnitTestSuite.fail((String)"Changing clone address reset original to null.");
            }
            if (clone.getAddress() != address) {
                EntityManagerTLRJUnitTestSuite.fail((String)"Changing clone did not work.");
            }
            em.remove((Object)employee);
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    public void testCopyingAddress() {
        Address address = new Address();
        address.setCity("Ottawa");
        Address copy = address.copy();
        if (!address.getCity().equals("Ottawa") || !copy.getCity().equals("Ottawa")) {
            EntityManagerTLRJUnitTestSuite.fail((String)"Copy method did not work.");
        }
        address = new Address();
        address.setCity("Ottawa");
        Address.TransferAddress transfer = address.transferCopy();
        if (!address.getCity().equals("Ottawa") || !transfer.city.equals("Ottawa")) {
            EntityManagerTLRJUnitTestSuite.fail((String)"Transfer method did not work.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSuperclassFieldInSubclass() {
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            Employee employee = new Employee();
            LargeProject project = new LargeProject();
            project.setTeamLeader(employee);
            em.persist((Object)employee);
            em.persist((Object)project);
            this.commitTransaction(em);
            this.closeEntityManager(em);
            em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
            this.beginTransaction(em);
            employee = (Employee)em.find(Employee.class, (Object)employee.getId());
            project = (LargeProject)em.find(LargeProject.class, (Object)project.getId());
            if (project.getTeamLeader() != employee) {
                EntityManagerTLRJUnitTestSuite.fail((String)("Get team leader did not work, team is: " + project.getTeamLeader() + " but should be:" + employee));
            }
            em.remove((Object)employee);
            em.remove((Object)project);
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    public void testWeaving() {
        if (this.isWeavingEnabled()) {
            this.internalTestWeaving(new Employee(), true, true);
            this.internalTestWeaving(new FormerEmployment(), true, false);
            this.internalTestWeaving(new Address(), true, false);
            this.internalTestWeaving(new PhoneNumber(), true, false);
            this.internalTestWeaving(new EmploymentPeriod(), true, false);
            this.internalTestWeaving(new Buyer(), false, false);
            this.internalTestWeaving(new GoldBuyer(), false, false);
            this.internalTestWeaving(new PlatinumBuyer(), false, false);
            this.internalTestWeaving(new Department(), true, false);
            this.internalTestWeaving(new Golfer(), true, false);
            this.internalTestWeaving(new GolferPK(), true, false);
            this.internalTestWeaving(new SmallProject(), true, false);
            this.internalTestWeaving(new LargeProject(), true, false);
            this.internalTestWeaving(new Man(), true, false);
            this.internalTestWeaving(new Woman(), true, false);
            this.internalTestWeaving(new Vegetable(), false, false);
            this.internalTestWeaving(new VegetablePK(), false, false);
            this.internalTestWeaving(new WorldRank(), true, false);
            this.internalTestWeaving(new Equipment(), true, false);
            this.internalTestWeaving(new EquipmentCode(), true, false);
            this.internalTestWeaving(new PartnerLink(), true, false);
        }
    }

    public void internalTestWeaving(Object object, boolean changeTracking, boolean indirection) {
        ClassDescriptor descriptor;
        if (!(object instanceof PersistenceWeaved)) {
            EntityManagerTLRJUnitTestSuite.fail((String)("Object not weaved:" + object));
        }
        if (indirection && !(object instanceof PersistenceWeavedLazy)) {
            EntityManagerTLRJUnitTestSuite.fail((String)("Object not weaved for indirection:" + object));
        }
        if (changeTracking && !(object instanceof ChangeTracker)) {
            EntityManagerTLRJUnitTestSuite.fail((String)("Object not weaved for ChangeTracker:" + object));
        }
        if (!(descriptor = EntityManagerTLRJUnitTestSuite.getServerSession((String)"fieldaccess").getDescriptor(object)).isAggregateDescriptor()) {
            if (changeTracking != descriptor.getObjectChangePolicy().isAttributeChangeTrackingPolicy()) {
                EntityManagerTLRJUnitTestSuite.fail((String)("Descriptor not set to use change tracking policy correctly:" + object));
            }
            if (!(object instanceof PersistenceEntity)) {
                EntityManagerTLRJUnitTestSuite.fail((String)("Object not weaved for PersistenceEntity:" + object));
            }
            if (!(object instanceof FetchGroupTracker)) {
                EntityManagerTLRJUnitTestSuite.fail((String)("Object not weaved for FetchGroupTracker:" + object));
            }
        }
    }

    public void testSequencePreallocationUsingCallbackTest() {
        ServerSession ss = EntityManagerTLRJUnitTestSuite.getServerSession((String)"fieldaccess");
        String seqName = ss.getDescriptor(Employee.class).getSequenceNumberName();
        Sequence sequence = EntityManagerTLRJUnitTestSuite.getServerSession().getLogin().getSequence(seqName);
        if (sequence.getPreallocationSize() < 2) {
            EntityManagerTLRJUnitTestSuite.fail((String)"setup failure: the test requires sequence preallocation size greater than 1");
        }
        if (sequence.shouldAcquireValueAfterInsert()) {
            EntityManagerTLRJUnitTestSuite.fail((String)"setup failure: the test requires sequence that acquires value before insert, like TableSequence");
        }
        if (!sequence.shouldUseTransaction()) {
            EntityManagerTLRJUnitTestSuite.fail((String)"setup failure: the test requires sequence that uses transaction, like TableSequence");
        }
        EntityManagerTLRJUnitTestSuite.getServerSession().getSequencingControl().initializePreallocated(seqName);
        EntityManager em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        Employee emp1 = new Employee();
        emp1.setFirstName("testSequencePreallocation");
        emp1.setLastName("1");
        em.persist((Object)emp1);
        int assignedSequenceNumber = emp1.getId();
        this.commitTransaction(em);
        em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        Employee emp2 = new Employee();
        emp2.setFirstName("testSequencePreallocation");
        emp2.setLastName("2");
        em.persist((Object)emp2);
        int nextSequenceNumber = emp2.getId();
        this.rollbackTransaction(em);
        em = EntityManagerTLRJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        emp1 = (Employee)em.find(Employee.class, (Object)assignedSequenceNumber);
        em.remove((Object)emp1);
        this.commitTransaction(em);
        if (assignedSequenceNumber + 1 != nextSequenceNumber) {
            EntityManagerTLRJUnitTestSuite.fail((String)("Transaction that assigned sequence number committed, assignedSequenceNumber = " + assignedSequenceNumber + ", but nextSequenceNumber = " + nextSequenceNumber + "(" + Integer.toString(assignedSequenceNumber + 1) + " was expected)"));
        }
    }

    static class DummyExternalTransactionController
    extends AbstractTransactionController {
        DummyExternalTransactionController() {
        }

        public boolean isRolledBack_impl(Object status) {
            return false;
        }

        protected void registerSynchronization_impl(AbstractSynchronizationListener listener, Object txn) throws Exception {
        }

        protected Object getTransaction_impl() throws Exception {
            return null;
        }

        protected Object getTransactionKey_impl(Object transaction) throws Exception {
            return null;
        }

        protected Object getTransactionStatus_impl() throws Exception {
            return null;
        }

        protected void beginTransaction_impl() throws Exception {
        }

        protected void commitTransaction_impl() throws Exception {
        }

        protected void rollbackTransaction_impl() throws Exception {
        }

        protected void markTransactionForRollback_impl() throws Exception {
        }

        protected boolean canBeginTransaction_impl(Object status) {
            return false;
        }

        protected boolean canCommitTransaction_impl(Object status) {
            return false;
        }

        protected boolean canRollbackTransaction_impl(Object status) {
            return false;
        }

        protected boolean canIssueSQLToDatabase_impl(Object status) {
            return false;
        }

        protected boolean canMergeUnitOfWork_impl(Object status) {
            return false;
        }

        protected String statusToString_impl(Object status) {
            return "";
        }
    }
}

