/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.fieldaccess.relationships;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.jpa.EJBQueryImpl;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.MapContainerPolicy;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.QuerySQLTracker;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.relationships.Customer;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.relationships.Customer2;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.relationships.Item;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.relationships.Order;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.relationships.RelationshipsExamples;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.relationships.RelationshipsTableManager;

public class RelationshipModelJUnitTestSuite
extends JUnitTestCase {
    public RelationshipModelJUnitTestSuite() {
    }

    public RelationshipModelJUnitTestSuite(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("RelationshipModelJUnitTestSuite (field access)");
        suite.addTest((Test)new RelationshipModelJUnitTestSuite("testSetup"));
        suite.addTest((Test)new RelationshipModelJUnitTestSuite("testPersistCustomer"));
        suite.addTest((Test)new RelationshipModelJUnitTestSuite("testUpdateCustomer"));
        suite.addTest((Test)new RelationshipModelJUnitTestSuite("testReadCustomer"));
        suite.addTest((Test)new RelationshipModelJUnitTestSuite("testDeleteCustomer"));
        suite.addTest((Test)new RelationshipModelJUnitTestSuite("testExecuteUpdateTest"));
        suite.addTest((Test)new RelationshipModelJUnitTestSuite("testGetResultCollectionTest"));
        suite.addTest((Test)new RelationshipModelJUnitTestSuite("testGetResultListTest"));
        suite.addTest((Test)new RelationshipModelJUnitTestSuite("testGetSingleResultTest"));
        suite.addTest((Test)new RelationshipModelJUnitTestSuite("testNamedQueryDoesNotExistTest"));
        suite.addTest((Test)new RelationshipModelJUnitTestSuite("testNamedQueryDoesNotExistTest"));
        suite.addTest((Test)new RelationshipModelJUnitTestSuite("testRemoveReference"));
        return suite;
    }

    public void testSetup() {
        new RelationshipsTableManager().replaceTables((DatabaseSession)JUnitTestCase.getServerSession((String)"fieldaccess"));
        RelationshipModelJUnitTestSuite.clearCache((String)"fieldaccess");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExecuteUpdateTest() {
        EntityManager em = RelationshipModelJUnitTestSuite.createEntityManager((String)"fieldaccess");
        Integer[] cusIDs = new Integer[2];
        String nameChange1 = "New Name1";
        String nameChange2 = "New Name2";
        String nameChange3 = "New Name3";
        IllegalStateException expectedException = null;
        Exception expectedException2 = null;
        try {
            Customer cusClone1 = RelationshipsExamples.customerExample1();
            this.beginTransaction(em);
            em.persist((Object)cusClone1);
            this.commitTransaction(em);
            em.clear();
            RelationshipModelJUnitTestSuite.clearCache((String)"fieldaccess");
            cusIDs[0] = cusClone1.getCustomerId();
            this.beginTransaction(em);
            Customer cus = (Customer)em.find(Customer.class, (Object)cusIDs[0]);
            Query query = em.createQuery("UPDATE FieldAccessCustomer customer SET customer.name = '" + nameChange1 + "' WHERE customer.customerId = " + cusIDs[0]);
            query.executeUpdate();
            em.clear();
            RelationshipModelJUnitTestSuite.clearCache((String)"fieldaccess");
            cus = (Customer)em.find(Customer.class, (Object)cusIDs[0]);
            String returnedName1 = cus.getName();
            Query query2 = em.createQuery("UPDATE FieldAccessCustomer customer SET customer.name = :name WHERE customer.customerId = " + cusIDs[0]);
            query2.setParameter("name", (Object)nameChange2);
            query2.executeUpdate();
            em.clear();
            RelationshipModelJUnitTestSuite.clearCache((String)"fieldaccess");
            cus = (Customer)em.find(Customer.class, (Object)cusIDs[0]);
            String returnedName2 = cus.getName();
            Query query3 = em.createQuery("UPDATE FieldAccessCustomer customer SET customer.name = :name WHERE customer.customerId = :id");
            query3.setParameter("name", (Object)nameChange3);
            query3.setParameter("id", (Object)cusIDs[0]);
            query3.executeUpdate();
            em.clear();
            RelationshipModelJUnitTestSuite.clearCache((String)"fieldaccess");
            cus = (Customer)em.find(Customer.class, (Object)cusIDs[0]);
            String returnedName3 = cus.getName();
            try {
                Query query4 = em.createNamedQuery("findAllCustomersFieldAccess");
                query4.executeUpdate();
            }
            catch (IllegalStateException expected) {
                expectedException = expected;
            }
            expectedException2 = null;
            try {
                this.commitTransaction(em);
                expectedException2 = null;
            }
            catch (Exception ex) {
                expectedException2 = ex;
            }
            if (returnedName1 == null || !returnedName1.equals(nameChange1)) {
                RelationshipModelJUnitTestSuite.fail((String)("Customer name did not get updated correctly should be:" + nameChange1 + " is :" + returnedName1));
            }
            if (returnedName2 == null || !returnedName2.equals(nameChange2)) {
                RelationshipModelJUnitTestSuite.fail((String)("Customer name did not get updated correctly should be:" + nameChange2 + " is :" + returnedName2));
            }
            if (returnedName3 == null || !returnedName3.equals(nameChange3)) {
                RelationshipModelJUnitTestSuite.fail((String)("Customer name did not get updated correctly should be:" + nameChange3 + " is :" + returnedName3));
            }
            if (expectedException == null) {
                RelationshipModelJUnitTestSuite.fail((String)"excuteUpdate did not result in an exception on findAllCustomersFieldAccess named ReadAllQuery");
            }
            if (expectedException2 == null) {
                RelationshipModelJUnitTestSuite.fail((String)"commit did not throw expected RollbackException");
            }
            this.beginTransaction(em);
            Customer cus1 = (Customer)em.find(Customer.class, (Object)cusIDs[0]);
            em.remove((Object)cus1);
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetResultCollectionTest() {
        QueryException expectedException1 = null;
        String ejbql1 = "SELECT OBJECT(thecust) FROM FieldAccessCustomer thecust WHERE thecust.customerId = :id";
        Integer[] cusIDs = new Integer[3];
        Customer cusClone1 = RelationshipsExamples.customerExample1();
        Customer cusClone2 = RelationshipsExamples.customerExample2();
        EntityManager em = RelationshipModelJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        em.persist((Object)cusClone1);
        em.persist((Object)cusClone2);
        this.commitTransaction(em);
        em.clear();
        RelationshipModelJUnitTestSuite.clearCache((String)"fieldaccess");
        cusIDs[0] = cusClone1.getCustomerId();
        cusIDs[1] = cusClone2.getCustomerId();
        try {
            this.beginTransaction(em);
            EntityManagerImpl entityManagerImpl = (EntityManagerImpl)em.getDelegate();
            EJBQueryImpl query1 = (EJBQueryImpl)entityManagerImpl.createNamedQuery("findAllCustomersFieldAccess");
            Collection returnedCustomers1 = query1.getResultCollection();
            EJBQueryImpl query2 = (EJBQueryImpl)entityManagerImpl.createQuery(ejbql1);
            query2.setParameter("id", (Object)new Integer(-10));
            Collection returnedCustomers2 = query2.getResultCollection();
            EJBQueryImpl query3 = (EJBQueryImpl)entityManagerImpl.createQuery(ejbql1);
            ReadAllQuery readAllQuery = new ReadAllQuery(Customer.class);
            MapContainerPolicy mapContainerPolicy = new MapContainerPolicy();
            mapContainerPolicy.setContainerClass(HashMap.class);
            mapContainerPolicy.setKeyName("hashCode");
            readAllQuery.setContainerPolicy((ContainerPolicy)mapContainerPolicy);
            query3.setDatabaseQuery((DatabaseQuery)readAllQuery);
            try {
                query3.getResultCollection();
            }
            catch (PersistenceException exc) {
                expectedException1 = (QueryException)exc.getCause();
                this.rollbackTransaction(em);
                this.beginTransaction(em);
            }
            entityManagerImpl = (EntityManagerImpl)em.getDelegate();
            EJBQueryImpl query4 = (EJBQueryImpl)entityManagerImpl.createQuery(ejbql1);
            query4.setParameter("id", (Object)new Integer(-10));
            ReadObjectQuery readObjectQuery2 = new ReadObjectQuery(Customer.class);
            readObjectQuery2.setEJBQLString(ejbql1);
            query4.setDatabaseQuery((DatabaseQuery)readObjectQuery2);
            query4.getResultCollection();
            this.commitTransaction(em);
            if (returnedCustomers1 == null || returnedCustomers1.size() < 2) {
                RelationshipModelJUnitTestSuite.fail((String)"Not all customers were returned from findAllCustomers query ");
            }
            if (returnedCustomers2 == null || returnedCustomers2.size() != 0) {
                RelationshipModelJUnitTestSuite.fail((String)"Customer from ReadObjectQuery was not returned using getResultCollection");
            }
            if (expectedException1 == null || expectedException1.getErrorCode() != 6123) {
                RelationshipModelJUnitTestSuite.fail((String)"getResultCollection on query returning a hashtable did not throw expected INVALID_CONTAINER_CLASS QueryException");
            }
            this.beginTransaction(em);
            Customer cus1 = (Customer)em.find(Customer.class, (Object)cusIDs[0]);
            em.remove((Object)cus1);
            Customer cus2 = (Customer)em.find(Customer.class, (Object)cusIDs[1]);
            em.remove((Object)cus2);
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetResultListTest() {
        QueryException expectedException1 = null;
        String ejbql1 = "SELECT OBJECT(thecust) FROM FieldAccessCustomer thecust WHERE thecust.customerId = :id";
        Integer[] cusIDs = new Integer[3];
        Customer cusClone1 = RelationshipsExamples.customerExample1();
        Customer cusClone2 = RelationshipsExamples.customerExample2();
        EntityManager em = RelationshipModelJUnitTestSuite.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        em.persist((Object)cusClone1);
        em.persist((Object)cusClone2);
        this.commitTransaction(em);
        em.clear();
        RelationshipModelJUnitTestSuite.clearCache((String)"fieldaccess");
        cusIDs[0] = cusClone1.getCustomerId();
        cusIDs[1] = cusClone2.getCustomerId();
        try {
            this.beginTransaction(em);
            EntityManagerImpl entityManagerImpl = (EntityManagerImpl)em.getDelegate();
            Query query1 = em.createNamedQuery("findAllCustomersFieldAccess");
            List returnedCustomers1 = query1.getResultList();
            Query query2 = em.createQuery(ejbql1);
            query2.setParameter("id", (Object)new Integer(-10));
            List returnedCustomers2 = query2.getResultList();
            EJBQueryImpl query3 = (EJBQueryImpl)entityManagerImpl.createQuery(ejbql1);
            ReadAllQuery readAllQuery = new ReadAllQuery(Customer.class);
            MapContainerPolicy mapContainerPolicy = new MapContainerPolicy();
            mapContainerPolicy.setContainerClass(HashMap.class);
            mapContainerPolicy.setKeyName("hashCode");
            readAllQuery.setContainerPolicy((ContainerPolicy)mapContainerPolicy);
            query3.setDatabaseQuery((DatabaseQuery)readAllQuery);
            try {
                query3.getResultList();
            }
            catch (PersistenceException exc) {
                expectedException1 = (QueryException)exc.getCause();
                this.rollbackTransaction(em);
                this.beginTransaction(em);
            }
            entityManagerImpl = (EntityManagerImpl)em.getDelegate();
            EJBQueryImpl query4 = (EJBQueryImpl)entityManagerImpl.createQuery(ejbql1);
            query4.setParameter("id", (Object)new Integer(-10));
            ReadObjectQuery readObjectQuery2 = new ReadObjectQuery(Customer.class);
            readObjectQuery2.setEJBQLString(ejbql1);
            query4.setDatabaseQuery((DatabaseQuery)readObjectQuery2);
            query4.getResultList();
            this.commitTransaction(em);
            if (returnedCustomers1 == null || returnedCustomers1.size() < 2) {
                RelationshipModelJUnitTestSuite.fail((String)"Not all customers were returned from findAllCustomers query ");
            }
            if (returnedCustomers2 == null || returnedCustomers2.size() != 0) {
                RelationshipModelJUnitTestSuite.fail((String)"Customer from ReadObjectQuery was not returned using getResultCollection");
            }
            if (expectedException1 == null || expectedException1.getErrorCode() != 6123) {
                RelationshipModelJUnitTestSuite.fail((String)"getResultCollection on query returning a hashtable did not throw expected INVALID_CONTAINER_CLASS QueryException");
            }
            this.beginTransaction(em);
            Customer cus1 = (Customer)em.find(Customer.class, (Object)cusIDs[0]);
            em.remove((Object)cus1);
            Customer cus2 = (Customer)em.find(Customer.class, (Object)cusIDs[1]);
            em.remove((Object)cus2);
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetSingleResultTest() {
        Customer returnedCustomer2 = null;
        NonUniqueResultException expectedException1 = null;
        NoResultException expectedException2 = null;
        String searchString = "notAnItemName";
        Integer[] cusIDs = new Integer[3];
        Customer cusClone1 = RelationshipsExamples.customerExample1();
        Customer cusClone2 = RelationshipsExamples.customerExample2();
        EntityManager em = RelationshipModelJUnitTestSuite.createEntityManager((String)"fieldaccess");
        try {
            Customer returnedCustomer1;
            this.beginTransaction(em);
            em.persist((Object)cusClone1);
            em.persist((Object)cusClone2);
            this.commitTransaction(em);
            RelationshipModelJUnitTestSuite.clearCache((String)"fieldaccess");
            cusIDs[0] = cusClone1.getCustomerId();
            cusIDs[1] = cusClone2.getCustomerId();
            this.beginTransaction(em);
            try {
                returnedCustomer1 = (Customer)em.createNamedQuery("findAllCustomersFieldAccess").getSingleResult();
            }
            catch (NonUniqueResultException exceptionExpected1) {
                expectedException1 = exceptionExpected1;
            }
            try {
                Query query1 = em.createNamedQuery("findAllFieldAccessItemsByName");
                Item item = (Item)query1.setParameter(1, (Object)searchString).getSingleResult();
                item.toString();
            }
            catch (NoResultException exceptionExpected2) {
                expectedException2 = exceptionExpected2;
            }
            EJBQueryImpl query2 = (EJBQueryImpl)em.createNamedQuery("findAllCustomersFieldAccess");
            ReadAllQuery readAllQuery = new ReadAllQuery(Customer.class);
            MapContainerPolicy mapContainerPolicy = new MapContainerPolicy();
            mapContainerPolicy.setContainerClass(HashMap.class);
            mapContainerPolicy.setKeyName("hashCode");
            readAllQuery.setContainerPolicy((ContainerPolicy)mapContainerPolicy);
            query2.setDatabaseQuery((DatabaseQuery)readAllQuery);
            Map result = (Map)query2.getSingleResult();
            result.toString();
            Query query3 = em.createQuery("SELECT OBJECT(thecust) FROM FieldAccessCustomer thecust WHERE thecust.customerId = :id");
            returnedCustomer1 = (Customer)query3.setParameter("id", (Object)cusIDs[0]).getSingleResult();
            EJBQueryImpl query4 = (EJBQueryImpl)em.createQuery("SELECT OBJECT(thecust) FROM FieldAccessCustomer thecust WHERE thecust.customerId = :id");
            query4.setParameter("id", (Object)cusIDs[0]);
            ReadObjectQuery readObjectQuery = new ReadObjectQuery(Customer.class);
            readObjectQuery.setEJBQLString("SELECT OBJECT(thecust) FROM FieldAccessCustomer thecust WHERE thecust.customerId = :id");
            query4.setDatabaseQuery((DatabaseQuery)readObjectQuery);
            returnedCustomer2 = (Customer)query4.getSingleResult();
            this.commitTransaction(em);
            this.beginTransaction(em);
            Customer cus1 = (Customer)em.find(Customer.class, (Object)cusIDs[0]);
            em.remove((Object)cus1);
            Customer cus2 = (Customer)em.find(Customer.class, (Object)cusIDs[1]);
            em.remove((Object)cus2);
            this.commitTransaction(em);
            if (expectedException1 == null) {
                RelationshipModelJUnitTestSuite.fail((String)"getSingelResult on query returning multiple values did not throw a NonUniqueResultException");
            }
            if (expectedException2 == null) {
                RelationshipModelJUnitTestSuite.fail((String)"getSingelResult on query returning multiple values did not throw an NoResultException");
            }
            if (returnedCustomer1 == null || !returnedCustomer1.getCustomerId().equals(cusIDs[0])) {
                RelationshipModelJUnitTestSuite.fail((String)("Incorrect Single Customer returned, found: " + returnedCustomer1));
            }
            if (returnedCustomer2 == null || !returnedCustomer2.getCustomerId().equals(cusIDs[0])) {
                RelationshipModelJUnitTestSuite.fail((String)("Incorrect Single Customer returned, found: " + returnedCustomer2));
            }
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
        }
    }

    public void testNamedQueryDoesNotExistTest() {
        Exception m_exception = null;
        EntityManager em = RelationshipModelJUnitTestSuite.createEntityManager((String)"fieldaccess");
        boolean m_npeCaught = false;
        boolean m_illegalArgumentExceptionCaught = false;
        try {
            em.createNamedQuery("doesNotExist").getResultList();
        }
        catch (NullPointerException e) {
            m_npeCaught = true;
        }
        catch (IllegalArgumentException e) {
            m_illegalArgumentExceptionCaught = true;
        }
        catch (Exception e) {
            m_exception = e;
        }
        if (m_npeCaught) {
            RelationshipModelJUnitTestSuite.fail((String)"A null pointer exception caught on the query.");
        } else if (!m_illegalArgumentExceptionCaught) {
            if (m_exception != null) {
                RelationshipModelJUnitTestSuite.fail((String)("Expected IllegalArgumentException, caught: " + m_exception));
            } else {
                RelationshipModelJUnitTestSuite.fail((String)"No exception was caught on a named query that does not exist.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNamedQueryWithArgumentsTest() {
        Integer[] cusIDs = new Integer[3];
        Integer[] orderIDs = new Integer[3];
        Integer[] itemIDs = new Integer[3];
        Exception exception = null;
        List list = null;
        Customer cusClone1 = RelationshipsExamples.customerExample1();
        Item item1 = RelationshipsExamples.itemExample1();
        Order order1 = RelationshipsExamples.orderExample1();
        order1.setCustomer(cusClone1);
        order1.setItem(item1);
        EntityManager em = RelationshipModelJUnitTestSuite.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            em.persist((Object)cusClone1);
            em.persist((Object)order1);
            this.commitTransaction(em);
            cusIDs[0] = cusClone1.getCustomerId();
            orderIDs[0] = order1.getOrderId();
            itemIDs[0] = item1.getItemId();
            RelationshipModelJUnitTestSuite.clearCache((String)"fieldaccess");
            try {
                ServerSession ss = RelationshipModelJUnitTestSuite.getServerSession((String)"fieldaccess");
                Vector<Integer> vec = new Vector<Integer>();
                vec.add(itemIDs[0]);
                list = (List)ss.executeQuery("findAllFieldAccessOrdersByItem", vec);
            }
            catch (Exception ex) {
                exception = ex;
            }
            this.beginTransaction(em);
            Customer cus1 = (Customer)em.find(Customer.class, (Object)cusIDs[0]);
            em.remove((Object)cus1);
            Order ord1 = (Order)em.find(Order.class, (Object)orderIDs[0]);
            em.remove((Object)ord1);
            Item it1 = (Item)em.find(Item.class, (Object)itemIDs[0]);
            em.remove((Object)it1);
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
        }
        if (exception != null) {
            RelationshipModelJUnitTestSuite.fail((String)("An exception is thrown: " + exception));
        }
        if (list.size() != 1) {
            RelationshipModelJUnitTestSuite.fail((String)("One order is expected but " + list.size() + " was returned"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPersistCustomer() {
        Customer customer = RelationshipsExamples.customerExample4();
        Item item1 = RelationshipsExamples.itemExample1();
        Order order1 = RelationshipsExamples.orderExample1();
        customer.addOrder(order1);
        order1.setItem(item1);
        Item item2 = RelationshipsExamples.itemExample2();
        Order order2 = RelationshipsExamples.orderExample2();
        customer.addOrder(order2);
        order2.setItem(item2);
        Item item3 = RelationshipsExamples.itemExample3();
        Order order3 = RelationshipsExamples.orderExample3();
        customer.addOrder(order3);
        order3.setItem(item3);
        EntityManager em = RelationshipModelJUnitTestSuite.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            em.persist((Object)customer);
            this.commitTransaction(em);
            this.beginTransaction(em);
            this.verifyObjectInEntityManager(customer, "fieldaccess");
            this.verifyObjectInEntityManager(order1, "fieldaccess");
            this.verifyObjectInEntityManager(order2, "fieldaccess");
            this.verifyObjectInEntityManager(item1, "fieldaccess");
            this.verifyObjectInEntityManager(item2, "fieldaccess");
            this.commitTransaction(em);
            RelationshipModelJUnitTestSuite.clearCache((String)"fieldaccess");
            this.beginTransaction(em);
            this.verifyObjectInEntityManager(customer, "fieldaccess");
            this.verifyObjectInEntityManager(order1, "fieldaccess");
            this.verifyObjectInEntityManager(order2, "fieldaccess");
            this.verifyObjectInEntityManager(item1, "fieldaccess");
            this.verifyObjectInEntityManager(item2, "fieldaccess");
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateCustomer() {
        Customer customer = RelationshipsExamples.customerExample4();
        EntityManager em = RelationshipModelJUnitTestSuite.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            em.persist((Object)customer);
            this.commitTransaction(em);
            this.closeEntityManager(em);
            RelationshipModelJUnitTestSuite.clearCache((String)"fieldaccess");
            em = RelationshipModelJUnitTestSuite.createEntityManager((String)"fieldaccess");
            this.beginTransaction(em);
            customer = (Customer)em.find(Customer.class, (Object)customer.getCustomerId());
            Item item1 = RelationshipsExamples.itemExample1();
            Order order1 = RelationshipsExamples.orderExample1();
            customer.addOrder(order1);
            order1.setItem(item1);
            em.flush();
            Item item2 = RelationshipsExamples.itemExample2();
            Order order2 = RelationshipsExamples.orderExample2();
            customer.addOrder(order2);
            order2.setItem(item2);
            Item item3 = RelationshipsExamples.itemExample3();
            Order order3 = RelationshipsExamples.orderExample3();
            customer.addOrder(order3);
            order3.setItem(item3);
            RelationshipModelJUnitTestSuite.getServerSession((String)"fieldaccess").copy((Object)customer);
            this.commitTransaction(em);
            this.beginTransaction(em);
            this.verifyObjectInEntityManager(customer, "fieldaccess");
            this.verifyObjectInEntityManager(order1, "fieldaccess");
            this.verifyObjectInEntityManager(item1, "fieldaccess");
            this.verifyObjectInEntityManager(order2, "fieldaccess");
            this.verifyObjectInEntityManager(item2, "fieldaccess");
            this.verifyObjectInEntityManager(order3, "fieldaccess");
            this.verifyObjectInEntityManager(item3, "fieldaccess");
            this.commitTransaction(em);
            RelationshipModelJUnitTestSuite.clearCache((String)"fieldaccess");
            this.beginTransaction(em);
            this.verifyObjectInEntityManager(customer, "fieldaccess");
            this.verifyObjectInEntityManager(order1, "fieldaccess");
            this.verifyObjectInEntityManager(item1, "fieldaccess");
            this.verifyObjectInEntityManager(order2, "fieldaccess");
            this.verifyObjectInEntityManager(item2, "fieldaccess");
            this.verifyObjectInEntityManager(order3, "fieldaccess");
            this.verifyObjectInEntityManager(item3, "fieldaccess");
            this.commitTransaction(em);
            RelationshipModelJUnitTestSuite.clearCache((String)"fieldaccess");
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteCustomer() {
        Customer customer = RelationshipsExamples.customerExample4();
        EntityManager em = RelationshipModelJUnitTestSuite.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            Item item1 = RelationshipsExamples.itemExample1();
            Order order1 = RelationshipsExamples.orderExample1();
            customer.addOrder(order1);
            order1.setItem(item1);
            Item item2 = RelationshipsExamples.itemExample2();
            Order order2 = RelationshipsExamples.orderExample2();
            customer.addOrder(order2);
            order2.setItem(item2);
            Item item3 = RelationshipsExamples.itemExample3();
            Order order3 = RelationshipsExamples.orderExample3();
            customer.addOrder(order3);
            order3.setItem(item3);
            em.persist((Object)customer);
            this.commitTransaction(em);
            this.closeEntityManager(em);
            RelationshipModelJUnitTestSuite.clearCache((String)"fieldaccess");
            em = RelationshipModelJUnitTestSuite.createEntityManager((String)"fieldaccess");
            this.beginTransaction(em);
            customer = (Customer)em.find(Customer.class, (Object)customer.getCustomerId());
            em.remove((Object)customer);
            this.commitTransaction(em);
            this.beginTransaction(em);
            this.verifyDelete(customer, "fieldaccess");
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReadCustomer() {
        Customer customer = RelationshipsExamples.customerExample4();
        EntityManager em = RelationshipModelJUnitTestSuite.createEntityManager((String)"fieldaccess");
        QuerySQLTracker counter = null;
        try {
            this.beginTransaction(em);
            Item item1 = RelationshipsExamples.itemExample1();
            Order order1 = RelationshipsExamples.orderExample1();
            customer.addOrder(order1);
            order1.setItem(item1);
            Item item2 = RelationshipsExamples.itemExample2();
            Order order2 = RelationshipsExamples.orderExample2();
            customer.addOrder(order2);
            order2.setItem(item2);
            Item item3 = RelationshipsExamples.itemExample3();
            Order order3 = RelationshipsExamples.orderExample3();
            customer.addOrder(order3);
            order3.setItem(item3);
            em.persist((Object)customer);
            this.commitTransaction(em);
            this.closeEntityManager(em);
            RelationshipModelJUnitTestSuite.clearCache((String)"fieldaccess");
            em = RelationshipModelJUnitTestSuite.createEntityManager((String)"fieldaccess");
            this.beginTransaction(em);
            counter = new QuerySQLTracker((Session)RelationshipModelJUnitTestSuite.getServerSession((String)"fieldaccess"));
            customer = (Customer)em.find(Customer.class, (Object)customer.getCustomerId());
            for (Order order : customer.getOrders()) {
                order.getCustomer();
            }
            if (RelationshipModelJUnitTestSuite.isWeavingEnabled((String)"fieldaccess") && counter.getSqlStatements().size() > 2) {
                RelationshipModelJUnitTestSuite.fail((String)("Should have been 2 queries but was: " + counter.getSqlStatements().size()));
            }
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            if (counter != null) {
                counter.remove();
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveReference() {
        EntityManager em = RelationshipModelJUnitTestSuite.createEntityManager((String)"fieldaccess");
        try {
            this.beginTransaction(em);
            Customer2 customer = new Customer2();
            em.persist((Object)customer);
            int id = customer.getCustomerId();
            this.commitTransaction(em);
            this.closeEntityManager(em);
            RelationshipModelJUnitTestSuite.clearCache((String)"fieldaccess");
            em = RelationshipModelJUnitTestSuite.createEntityManager((String)"fieldaccess");
            this.beginTransaction(em);
            Customer2 customerReference = (Customer2)em.getReference(Customer2.class, (Object)id);
            em.remove((Object)customerReference);
            this.commitTransaction(em);
            RelationshipModelJUnitTestSuite.assertNull((String)"Customer was not removed", (Object)em.find(Customer2.class, (Object)id));
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }
}

