/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.oracleddl.metadata;

import org.eclipse.persistence.tools.oracleddl.metadata.ArgumentTypeDirection;
import org.eclipse.persistence.tools.oracleddl.metadata.CompositeDatabaseType;
import org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType;
import org.eclipse.persistence.tools.oracleddl.metadata.DatabaseTypeTestableBase;
import org.eclipse.persistence.tools.oracleddl.metadata.visit.DatabaseTypeVisitable;
import org.eclipse.persistence.tools.oracleddl.metadata.visit.DatabaseTypeVisitor;

public class ArgumentType
extends DatabaseTypeTestableBase
implements CompositeDatabaseType,
DatabaseTypeVisitable {
    protected String argumentName;
    protected DatabaseType enclosedType;
    protected ArgumentTypeDirection direction;
    protected boolean optional = false;

    public ArgumentType(String argumentName) {
        this.argumentName = argumentName;
    }

    public String getArgumentName() {
        return this.argumentName;
    }

    @Override
    public void setTypeName(String typeName) {
        this.argumentName = typeName;
    }

    @Override
    public DatabaseType getEnclosedType() {
        return this.enclosedType;
    }

    @Override
    public void setEnclosedType(DatabaseType enclosedType) {
        this.enclosedType = enclosedType;
    }

    public ArgumentTypeDirection getDirection() {
        return this.direction;
    }

    public void setDirection(ArgumentTypeDirection direction) {
        this.direction = direction;
    }

    @Override
    public boolean isResolved() {
        if (this.enclosedType == null) {
            return false;
        }
        return this.enclosedType.isResolved();
    }

    @Override
    public boolean isComposite() {
        if (this.enclosedType == null) {
            return false;
        }
        return this.enclosedType.isComposite();
    }

    @Override
    public boolean isArgumentType() {
        return true;
    }

    @Override
    public String getTypeName() {
        if (this.enclosedType == null) {
            return null;
        }
        return this.enclosedType.getTypeName();
    }

    public boolean optional() {
        return this.optional;
    }

    public void setOptional() {
        this.optional = true;
    }

    public void unsetOptional() {
        this.optional = false;
    }

    @Override
    public String shortName() {
        StringBuilder sb = new StringBuilder();
        if (this.argumentName != null) {
            sb.append(this.argumentName);
        } else if (this.direction == ArgumentTypeDirection.RETURN) {
            sb.append((Object)ArgumentTypeDirection.RETURN);
        }
        sb.append(" ");
        if (this.direction != ArgumentTypeDirection.RETURN) {
            sb.append(this.direction != null ? this.direction.toString() : "<NULL>");
            sb.append(" ");
        }
        if (this.enclosedType == null) {
            sb.append("<null/>");
        } else {
            sb.append(this.enclosedType.shortName());
        }
        return sb.toString();
    }

    @Override
    public boolean isObjectTableType() {
        if (this.enclosedType == null) {
            return false;
        }
        return this.enclosedType.isObjectTableType();
    }

    @Override
    public boolean isObjectType() {
        if (this.enclosedType == null) {
            return false;
        }
        return this.enclosedType.isObjectType();
    }

    @Override
    public boolean isPLSQLCollectionType() {
        if (this.enclosedType == null) {
            return false;
        }
        return this.enclosedType.isPLSQLCollectionType();
    }

    @Override
    public boolean isPLSQLCursorType() {
        if (this.enclosedType == null) {
            return false;
        }
        return this.enclosedType.isPLSQLCursorType();
    }

    @Override
    public boolean isPLSQLRecordType() {
        if (this.enclosedType == null) {
            return false;
        }
        return this.enclosedType.isPLSQLRecordType();
    }

    @Override
    public boolean isPLSQLSubType() {
        if (this.enclosedType == null) {
            return false;
        }
        return this.enclosedType.isPLSQLSubType();
    }

    @Override
    public boolean isTableType() {
        if (this.enclosedType == null) {
            return false;
        }
        return this.enclosedType.isTableType();
    }

    @Override
    public boolean isDbTableType() {
        if (this.enclosedType == null) {
            return false;
        }
        return this.enclosedType.isDbTableType();
    }

    @Override
    public boolean isVArrayType() {
        if (this.enclosedType == null) {
            return false;
        }
        return this.enclosedType.isVArrayType();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.shortName());
        if (this.optional) {
            sb.append(" (opt)");
        }
        return sb.toString();
    }

    @Override
    public void accept(DatabaseTypeVisitor visitor) {
        visitor.visit(this);
    }
}

