/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm;

import org.eclipse.persistence.internal.libraries.asm.AnnotationVisitor;
import org.eclipse.persistence.internal.libraries.asm.AnnotationWriter;
import org.eclipse.persistence.internal.libraries.asm.Attribute;
import org.eclipse.persistence.internal.libraries.asm.ByteVector;
import org.eclipse.persistence.internal.libraries.asm.ClassReader;
import org.eclipse.persistence.internal.libraries.asm.ClassVisitor;
import org.eclipse.persistence.internal.libraries.asm.FieldVisitor;
import org.eclipse.persistence.internal.libraries.asm.FieldWriter;
import org.eclipse.persistence.internal.libraries.asm.Handle;
import org.eclipse.persistence.internal.libraries.asm.MethodVisitor;
import org.eclipse.persistence.internal.libraries.asm.MethodWriter;
import org.eclipse.persistence.internal.libraries.asm.ModuleVisitor;
import org.eclipse.persistence.internal.libraries.asm.ModuleWriter;
import org.eclipse.persistence.internal.libraries.asm.Symbol;
import org.eclipse.persistence.internal.libraries.asm.SymbolTable;
import org.eclipse.persistence.internal.libraries.asm.TypePath;
import org.eclipse.persistence.internal.libraries.asm.TypeReference;

public class ClassWriter
extends ClassVisitor {
    public static final int COMPUTE_MAXS = 1;
    public static final int COMPUTE_FRAMES = 2;
    private int version;
    private final SymbolTable symbolTable;
    private int accessFlags;
    private int thisClass;
    private int superClass;
    private int interfaceCount;
    private int[] interfaces;
    private FieldWriter firstField;
    private FieldWriter lastField;
    private MethodWriter firstMethod;
    private MethodWriter lastMethod;
    private int numberOfClasses;
    private ByteVector classes;
    private int enclosingClassIndex;
    private int enclosingMethodIndex;
    private int signatureIndex;
    private int sourceFileIndex;
    private ByteVector debugExtension;
    private AnnotationWriter lastRuntimeVisibleAnnotation;
    private AnnotationWriter lastRuntimeInvisibleAnnotation;
    private AnnotationWriter lastRuntimeVisibleTypeAnnotation;
    private AnnotationWriter lastRuntimeInvisibleTypeAnnotation;
    private ModuleWriter moduleWriter;
    private Attribute firstAttribute;
    private int compute;

    public ClassWriter(int n) {
        this(null, n);
    }

    public ClassWriter(ClassReader classReader, int n) {
        super(393216);
        SymbolTable symbolTable = this.symbolTable = classReader == null ? new SymbolTable(this) : new SymbolTable(this, classReader);
        this.compute = (n & 2) != 0 ? 3 : ((n & 1) != 0 ? 1 : 0);
    }

    @Override
    public final void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
        this.version = n;
        this.accessFlags = n2;
        this.thisClass = this.symbolTable.setMajorVersionAndClassName(n & 0xFFFF, string);
        if (string2 != null) {
            this.signatureIndex = this.symbolTable.addConstantUtf8(string2);
        }
        int n3 = this.superClass = string3 == null ? 0 : this.symbolTable.addConstantClass((String)string3).index;
        if (stringArray != null && stringArray.length > 0) {
            this.interfaceCount = stringArray.length;
            this.interfaces = new int[this.interfaceCount];
            for (int i = 0; i < this.interfaceCount; ++i) {
                this.interfaces[i] = this.symbolTable.addConstantClass((String)stringArray[i]).index;
            }
        }
    }

    @Override
    public final void visitSource(String string, String string2) {
        if (string != null) {
            this.sourceFileIndex = this.symbolTable.addConstantUtf8(string);
        }
        if (string2 != null) {
            this.debugExtension = new ByteVector().encodeUTF8(string2, 0, Integer.MAX_VALUE);
        }
    }

    @Override
    public final ModuleVisitor visitModule(String string, int n, String string2) {
        this.moduleWriter = new ModuleWriter(this.symbolTable, this.symbolTable.addConstantModule((String)string).index, n, string2 == null ? 0 : this.symbolTable.addConstantUtf8(string2));
        return this.moduleWriter;
    }

    @Override
    public final void visitOuterClass(String string, String string2, String string3) {
        this.enclosingClassIndex = this.symbolTable.addConstantClass((String)string).index;
        if (string2 != null && string3 != null) {
            this.enclosingMethodIndex = this.symbolTable.addConstantNameAndType(string2, string3);
        }
    }

    @Override
    public final AnnotationVisitor visitAnnotation(String string, boolean bl) {
        ByteVector byteVector = new ByteVector();
        byteVector.putShort(this.symbolTable.addConstantUtf8(string)).putShort(0);
        if (bl) {
            this.lastRuntimeVisibleAnnotation = new AnnotationWriter(this.symbolTable, byteVector, this.lastRuntimeVisibleAnnotation);
            return this.lastRuntimeVisibleAnnotation;
        }
        this.lastRuntimeInvisibleAnnotation = new AnnotationWriter(this.symbolTable, byteVector, this.lastRuntimeInvisibleAnnotation);
        return this.lastRuntimeInvisibleAnnotation;
    }

    @Override
    public final AnnotationVisitor visitTypeAnnotation(int n, TypePath typePath, String string, boolean bl) {
        ByteVector byteVector = new ByteVector();
        TypeReference.putTarget(n, byteVector);
        TypePath.put(typePath, byteVector);
        byteVector.putShort(this.symbolTable.addConstantUtf8(string)).putShort(0);
        if (bl) {
            this.lastRuntimeVisibleTypeAnnotation = new AnnotationWriter(this.symbolTable, byteVector, this.lastRuntimeVisibleTypeAnnotation);
            return this.lastRuntimeVisibleTypeAnnotation;
        }
        this.lastRuntimeInvisibleTypeAnnotation = new AnnotationWriter(this.symbolTable, byteVector, this.lastRuntimeInvisibleTypeAnnotation);
        return this.lastRuntimeInvisibleTypeAnnotation;
    }

    @Override
    public final void visitAttribute(Attribute attribute) {
        attribute.nextAttribute = this.firstAttribute;
        this.firstAttribute = attribute;
    }

    @Override
    public final void visitInnerClass(String string, String string2, String string3, int n) {
        if (this.classes == null) {
            this.classes = new ByteVector();
        }
        Symbol symbol = this.symbolTable.addConstantClass(string);
        if (symbol.info == 0) {
            ++this.numberOfClasses;
            this.classes.putShort(symbol.index);
            this.classes.putShort(string2 == null ? 0 : this.symbolTable.addConstantClass((String)string2).index);
            this.classes.putShort(string3 == null ? 0 : this.symbolTable.addConstantUtf8(string3));
            this.classes.putShort(n);
            symbol.info = this.numberOfClasses;
        }
    }

    @Override
    public final FieldVisitor visitField(int n, String string, String string2, String string3, Object object) {
        FieldWriter fieldWriter = new FieldWriter(this.symbolTable, n, string, string2, string3, object);
        if (this.firstField == null) {
            this.firstField = fieldWriter;
        } else {
            this.lastField.fv = fieldWriter;
        }
        this.lastField = fieldWriter;
        return this.lastField;
    }

    @Override
    public final MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
        MethodWriter methodWriter = new MethodWriter(this.symbolTable, n, string, string2, string3, stringArray, this.compute);
        if (this.firstMethod == null) {
            this.firstMethod = methodWriter;
        } else {
            this.lastMethod.mv = methodWriter;
        }
        this.lastMethod = methodWriter;
        return this.lastMethod;
    }

    @Override
    public final void visitEnd() {
    }

    public byte[] toByteArray() {
        int n;
        int n2 = 24 + 2 * this.interfaceCount;
        int n3 = 0;
        FieldWriter fieldWriter = this.firstField;
        while (fieldWriter != null) {
            ++n3;
            n2 += fieldWriter.computeFieldInfoSize();
            fieldWriter = (FieldWriter)fieldWriter.fv;
        }
        int n4 = 0;
        MethodWriter methodWriter = this.firstMethod;
        while (methodWriter != null) {
            ++n4;
            n2 += methodWriter.computeMethodInfoSize();
            methodWriter = (MethodWriter)methodWriter.mv;
        }
        int n5 = 0;
        if (this.classes != null) {
            ++n5;
            n2 += 8 + this.classes.length;
            this.symbolTable.addConstantUtf8("InnerClasses");
        }
        if (this.enclosingClassIndex != 0) {
            ++n5;
            n2 += 10;
            this.symbolTable.addConstantUtf8("EnclosingMethod");
        }
        if ((this.accessFlags & 0x1000) != 0 && (this.version & 0xFFFF) < 49) {
            ++n5;
            n2 += 6;
            this.symbolTable.addConstantUtf8("Synthetic");
        }
        if (this.signatureIndex != 0) {
            ++n5;
            n2 += 8;
            this.symbolTable.addConstantUtf8("Signature");
        }
        if (this.sourceFileIndex != 0) {
            ++n5;
            n2 += 8;
            this.symbolTable.addConstantUtf8("SourceFile");
        }
        if (this.debugExtension != null) {
            ++n5;
            n2 += 6 + this.debugExtension.length;
            this.symbolTable.addConstantUtf8("SourceDebugExtension");
        }
        if ((this.accessFlags & 0x20000) != 0) {
            ++n5;
            n2 += 6;
            this.symbolTable.addConstantUtf8("Deprecated");
        }
        if (this.lastRuntimeVisibleAnnotation != null) {
            ++n5;
            n2 += this.lastRuntimeVisibleAnnotation.computeAnnotationsSize("RuntimeVisibleAnnotations");
        }
        if (this.lastRuntimeInvisibleAnnotation != null) {
            ++n5;
            n2 += this.lastRuntimeInvisibleAnnotation.computeAnnotationsSize("RuntimeInvisibleAnnotations");
        }
        if (this.lastRuntimeVisibleTypeAnnotation != null) {
            ++n5;
            n2 += this.lastRuntimeVisibleTypeAnnotation.computeAnnotationsSize("RuntimeVisibleTypeAnnotations");
        }
        if (this.lastRuntimeInvisibleTypeAnnotation != null) {
            ++n5;
            n2 += this.lastRuntimeInvisibleTypeAnnotation.computeAnnotationsSize("RuntimeInvisibleTypeAnnotations");
        }
        if (this.symbolTable.computeBootstrapMethodsSize() > 0) {
            ++n5;
            n2 += this.symbolTable.computeBootstrapMethodsSize();
        }
        if (this.moduleWriter != null) {
            n5 += this.moduleWriter.getAttributeCount();
            n2 += this.moduleWriter.computeAttributesSize();
        }
        if (this.firstAttribute != null) {
            n5 += this.firstAttribute.getAttributeCount();
            n2 += this.firstAttribute.computeAttributesSize(this.symbolTable);
        }
        n2 += this.symbolTable.getConstantPoolLength();
        if (this.symbolTable.getConstantPoolCount() > 65535) {
            throw new IndexOutOfBoundsException("Class file too large!");
        }
        ByteVector byteVector = new ByteVector(n2);
        byteVector.putInt(-889275714).putInt(this.version);
        this.symbolTable.putConstantPool(byteVector);
        int n6 = (this.version & 0xFFFF) < 49 ? 4096 : 0;
        byteVector.putShort(this.accessFlags & ~n6).putShort(this.thisClass).putShort(this.superClass);
        byteVector.putShort(this.interfaceCount);
        for (n = 0; n < this.interfaceCount; ++n) {
            byteVector.putShort(this.interfaces[n]);
        }
        byteVector.putShort(n3);
        fieldWriter = this.firstField;
        while (fieldWriter != null) {
            fieldWriter.putFieldInfo(byteVector);
            fieldWriter = (FieldWriter)fieldWriter.fv;
        }
        byteVector.putShort(n4);
        n = 0;
        boolean bl = false;
        methodWriter = this.firstMethod;
        while (methodWriter != null) {
            n |= methodWriter.hasFrames();
            bl |= methodWriter.hasAsmInstructions();
            methodWriter.putMethodInfo(byteVector);
            methodWriter = (MethodWriter)methodWriter.mv;
        }
        byteVector.putShort(n5);
        if (this.classes != null) {
            byteVector.putShort(this.symbolTable.addConstantUtf8("InnerClasses")).putInt(this.classes.length + 2).putShort(this.numberOfClasses).putByteArray(this.classes.data, 0, this.classes.length);
        }
        if (this.enclosingClassIndex != 0) {
            byteVector.putShort(this.symbolTable.addConstantUtf8("EnclosingMethod")).putInt(4).putShort(this.enclosingClassIndex).putShort(this.enclosingMethodIndex);
        }
        if ((this.accessFlags & 0x1000) != 0 && (this.version & 0xFFFF) < 49) {
            byteVector.putShort(this.symbolTable.addConstantUtf8("Synthetic")).putInt(0);
        }
        if (this.signatureIndex != 0) {
            byteVector.putShort(this.symbolTable.addConstantUtf8("Signature")).putInt(2).putShort(this.signatureIndex);
        }
        if (this.sourceFileIndex != 0) {
            byteVector.putShort(this.symbolTable.addConstantUtf8("SourceFile")).putInt(2).putShort(this.sourceFileIndex);
        }
        if (this.debugExtension != null) {
            int n7 = this.debugExtension.length;
            byteVector.putShort(this.symbolTable.addConstantUtf8("SourceDebugExtension")).putInt(n7).putByteArray(this.debugExtension.data, 0, n7);
        }
        if ((this.accessFlags & 0x20000) != 0) {
            byteVector.putShort(this.symbolTable.addConstantUtf8("Deprecated")).putInt(0);
        }
        if (this.lastRuntimeVisibleAnnotation != null) {
            this.lastRuntimeVisibleAnnotation.putAnnotations(this.symbolTable.addConstantUtf8("RuntimeVisibleAnnotations"), byteVector);
        }
        if (this.lastRuntimeInvisibleAnnotation != null) {
            this.lastRuntimeInvisibleAnnotation.putAnnotations(this.symbolTable.addConstantUtf8("RuntimeInvisibleAnnotations"), byteVector);
        }
        if (this.lastRuntimeVisibleTypeAnnotation != null) {
            this.lastRuntimeVisibleTypeAnnotation.putAnnotations(this.symbolTable.addConstantUtf8("RuntimeVisibleTypeAnnotations"), byteVector);
        }
        if (this.lastRuntimeInvisibleTypeAnnotation != null) {
            this.lastRuntimeInvisibleTypeAnnotation.putAnnotations(this.symbolTable.addConstantUtf8("RuntimeInvisibleTypeAnnotations"), byteVector);
        }
        this.symbolTable.putBootstrapMethods(byteVector);
        if (this.moduleWriter != null) {
            this.moduleWriter.putAttributes(byteVector);
        }
        if (this.firstAttribute != null) {
            this.firstAttribute.putAttributes(this.symbolTable, byteVector);
        }
        if (bl) {
            Attribute[] attributeArray = this.getAttributePrototypes();
            this.firstField = null;
            this.lastField = null;
            this.firstMethod = null;
            this.lastMethod = null;
            this.lastRuntimeVisibleAnnotation = null;
            this.lastRuntimeInvisibleAnnotation = null;
            this.lastRuntimeVisibleTypeAnnotation = null;
            this.lastRuntimeInvisibleTypeAnnotation = null;
            this.moduleWriter = null;
            this.firstAttribute = null;
            this.compute = n != 0 ? 2 : 0;
            new ClassReader(byteVector.data, 0, false).accept(this, attributeArray, (n != 0 ? 8 : 0) | 0x100);
            return this.toByteArray();
        }
        return byteVector.data;
    }

    private Attribute[] getAttributePrototypes() {
        Attribute.Set set = new Attribute.Set();
        set.addAttributes(this.firstAttribute);
        FieldWriter fieldWriter = this.firstField;
        while (fieldWriter != null) {
            fieldWriter.collectAttributePrototypes(set);
            fieldWriter = (FieldWriter)fieldWriter.fv;
        }
        MethodWriter methodWriter = this.firstMethod;
        while (methodWriter != null) {
            methodWriter.collectAttributePrototypes(set);
            methodWriter = (MethodWriter)methodWriter.mv;
        }
        return set.toArray();
    }

    public int newConst(Object object) {
        return this.symbolTable.addConstant((Object)object).index;
    }

    public int newUTF8(String string) {
        return this.symbolTable.addConstantUtf8(string);
    }

    public int newClass(String string) {
        return this.symbolTable.addConstantClass((String)string).index;
    }

    public int newMethodType(String string) {
        return this.symbolTable.addConstantMethodType((String)string).index;
    }

    public int newModule(String string) {
        return this.symbolTable.addConstantModule((String)string).index;
    }

    public int newPackage(String string) {
        return this.symbolTable.addConstantPackage((String)string).index;
    }

    @Deprecated
    public int newHandle(int n, String string, String string2, String string3) {
        return this.newHandle(n, string, string2, string3, n == 9);
    }

    public int newHandle(int n, String string, String string2, String string3, boolean bl) {
        return this.symbolTable.addConstantMethodHandle((int)n, (String)string, (String)string2, (String)string3, (boolean)bl).index;
    }

    public int newInvokeDynamic(String string, String string2, Handle handle, Object ... objectArray) {
        return this.symbolTable.addConstantInvokeDynamic((String)string, (String)string2, (Handle)handle, (Object[])objectArray).index;
    }

    public int newField(String string, String string2, String string3) {
        return this.symbolTable.addConstantFieldref((String)string, (String)string2, (String)string3).index;
    }

    public int newMethod(String string, String string2, String string3, boolean bl) {
        return this.symbolTable.addConstantMethodref((String)string, (String)string2, (String)string3, (boolean)bl).index;
    }

    public int newNameType(String string, String string2) {
        return this.symbolTable.addConstantNameAndType(string, string2);
    }

    protected String getCommonSuperClass(String string, String string2) {
        Class<?> clazz;
        Class<?> clazz2;
        ClassLoader classLoader = this.getClass().getClassLoader();
        try {
            clazz2 = Class.forName(string.replace('/', '.'), false, classLoader);
        }
        catch (Exception exception) {
            throw new TypeNotPresentException(string, exception);
        }
        try {
            clazz = Class.forName(string2.replace('/', '.'), false, classLoader);
        }
        catch (Exception exception) {
            throw new TypeNotPresentException(string2, exception);
        }
        if (clazz2.isAssignableFrom(clazz)) {
            return string;
        }
        if (clazz.isAssignableFrom(clazz2)) {
            return string2;
        }
        if (clazz2.isInterface() || clazz.isInterface()) {
            return "java/lang/Object";
        }
        while (!(clazz2 = clazz2.getSuperclass()).isAssignableFrom(clazz)) {
        }
        return clazz2.getName().replace('.', '/');
    }
}

