/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.MongoNamespace;
import com.mongodb.WriteConcern;
import com.mongodb.WriteConcernException;
import com.mongodb.WriteConcernResult;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.connection.ByteBufferBsonOutput;
import com.mongodb.connection.CommandMessage;
import com.mongodb.connection.InternalConnection;
import com.mongodb.connection.MessageSettings;
import com.mongodb.connection.Protocol;
import com.mongodb.connection.ProtocolHelper;
import com.mongodb.connection.ReplyMessage;
import com.mongodb.connection.RequestMessage;
import com.mongodb.connection.ResponseBuffers;
import com.mongodb.connection.SendMessageCallback;
import com.mongodb.connection.UnacknowledgedWriteResultCallback;
import com.mongodb.connection.WriteResultCallback;
import com.mongodb.diagnostics.logging.Logger;
import com.mongodb.event.CommandListener;
import java.util.Collections;
import org.bson.BsonArray;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.codecs.BsonDocumentCodec;

abstract class WriteProtocol
implements Protocol<WriteConcernResult> {
    private final MongoNamespace namespace;
    private final boolean ordered;
    private final WriteConcern writeConcern;
    private CommandListener commandListener;

    public WriteProtocol(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern) {
        this.namespace = namespace;
        this.ordered = ordered;
        this.writeConcern = writeConcern;
    }

    @Override
    public void setCommandListener(CommandListener commandListener) {
        this.commandListener = commandListener;
    }

    @Override
    public WriteConcernResult execute(InternalConnection connection) {
        RequestMessage.EncodingMetadata encodingMetadata;
        WriteConcernResult writeConcernResult = null;
        RequestMessage nextMessage = null;
        do {
            int messageId;
            long startTimeNanos = System.nanoTime();
            boolean sentCommandStartedEvent = false;
            ByteBufferBsonOutput bsonOutput = new ByteBufferBsonOutput(connection);
            try {
                if (nextMessage == null) {
                    nextMessage = this.createRequestMessage(ProtocolHelper.getMessageSettings(connection.getDescription()));
                }
                encodingMetadata = nextMessage.encodeWithMetadata(bsonOutput);
                if (this.commandListener != null) {
                    ProtocolHelper.sendCommandStartedEvent(nextMessage, this.namespace.getDatabaseName(), this.getCommandName(), this.getAsWriteCommand(bsonOutput, encodingMetadata.getFirstDocumentPosition()), connection.getDescription(), this.commandListener);
                    sentCommandStartedEvent = true;
                }
                messageId = nextMessage.getId();
                if (this.shouldAcknowledge(encodingMetadata)) {
                    CommandMessage getLastErrorMessage = new CommandMessage(new MongoNamespace(this.getNamespace().getDatabaseName(), "$cmd").getFullName(), this.createGetLastErrorCommandDocument(), false, ProtocolHelper.getMessageSettings(connection.getDescription()));
                    getLastErrorMessage.encode(bsonOutput);
                    messageId = getLastErrorMessage.getId();
                }
                connection.sendMessage(bsonOutput.getByteBuffers(), messageId);
            }
            catch (RuntimeException e) {
                if (this.commandListener != null && sentCommandStartedEvent) {
                    ProtocolHelper.sendCommandFailedEvent(nextMessage, this.getCommandName(), connection.getDescription(), 0L, e, this.commandListener);
                }
                throw e;
            }
            finally {
                bsonOutput.close();
            }
            if (this.shouldAcknowledge(encodingMetadata)) {
                ResponseBuffers responseBuffers = connection.receiveMessage(messageId);
                try {
                    ReplyMessage<BsonDocument> replyMessage = new ReplyMessage<BsonDocument>(responseBuffers, new BsonDocumentCodec(), messageId);
                    writeConcernResult = ProtocolHelper.getWriteResult(replyMessage.getDocuments().get(0), connection.getDescription().getServerAddress());
                }
                catch (WriteConcernException e) {
                    if (this.commandListener != null) {
                        ProtocolHelper.sendCommandSucceededEvent(nextMessage, this.getCommandName(), this.getResponseDocument(nextMessage, encodingMetadata.getNextMessage(), e.getWriteConcernResult(), e), connection.getDescription(), 0L, this.commandListener);
                    }
                    if (!this.writeConcern.isAcknowledged()) break;
                    throw e;
                }
                catch (RuntimeException e) {
                    if (this.commandListener != null) {
                        ProtocolHelper.sendCommandFailedEvent(nextMessage, this.getCommandName(), connection.getDescription(), 0L, e, this.commandListener);
                    }
                    throw e;
                }
                finally {
                    responseBuffers.close();
                }
            }
            if (this.commandListener == null) continue;
            ProtocolHelper.sendCommandSucceededEvent(nextMessage, this.getCommandName(), this.getResponseDocument(nextMessage, encodingMetadata.getNextMessage(), writeConcernResult, null), connection.getDescription(), startTimeNanos, this.commandListener);
        } while ((nextMessage = encodingMetadata.getNextMessage()) != null);
        return this.writeConcern.isAcknowledged() ? writeConcernResult : WriteConcernResult.unacknowledged();
    }

    private BsonDocument getResponseDocument(RequestMessage curMessage, RequestMessage nextMessage, WriteConcernResult writeConcernResult, WriteConcernException writeConcernException) {
        BsonDocument response = new BsonDocument("ok", new BsonInt32(1));
        if (this.writeConcern.isAcknowledged()) {
            if (writeConcernException == null) {
                this.appendToWriteCommandResponseDocument(curMessage, nextMessage, writeConcernResult, response);
            } else {
                response.put("n", new BsonInt32(0));
                BsonDocument writeErrorDocument = new BsonDocument("index", new BsonInt32(0)).append("code", new BsonInt32(writeConcernException.getErrorCode()));
                if (writeConcernException.getErrorMessage() != null) {
                    writeErrorDocument.append("errmsg", new BsonString(writeConcernException.getErrorMessage()));
                }
                response.put("writeErrors", new BsonArray(Collections.singletonList(writeErrorDocument)));
            }
        }
        return response;
    }

    protected abstract void appendToWriteCommandResponseDocument(RequestMessage var1, RequestMessage var2, WriteConcernResult var3, BsonDocument var4);

    @Override
    public void executeAsync(InternalConnection connection, SingleResultCallback<WriteConcernResult> callback) {
        try {
            ByteBufferBsonOutput bsonOutput = new ByteBufferBsonOutput(connection);
            RequestMessage requestMessage = this.createRequestMessage(ProtocolHelper.getMessageSettings(connection.getDescription()));
            RequestMessage nextMessage = ProtocolHelper.encodeMessage(requestMessage, bsonOutput);
            if (this.writeConcern.isAcknowledged()) {
                CommandMessage getLastErrorMessage = new CommandMessage(new MongoNamespace(this.getNamespace().getDatabaseName(), "$cmd").getFullName(), this.createGetLastErrorCommandDocument(), false, ProtocolHelper.getMessageSettings(connection.getDescription()));
                ProtocolHelper.encodeMessage(getLastErrorMessage, bsonOutput);
                WriteResultCallback recieveCallback = new WriteResultCallback(callback, new BsonDocumentCodec(), this.getNamespace(), nextMessage, this.ordered, this.writeConcern, getLastErrorMessage.getId(), connection);
                connection.sendMessageAsync(bsonOutput.getByteBuffers(), getLastErrorMessage.getId(), new SendMessageCallback<WriteConcernResult>(connection, bsonOutput, getLastErrorMessage.getId(), callback, recieveCallback));
            } else {
                connection.sendMessageAsync(bsonOutput.getByteBuffers(), requestMessage.getId(), new UnacknowledgedWriteResultCallback(callback, this.getNamespace(), nextMessage, this.ordered, bsonOutput, connection));
            }
        }
        catch (Throwable t) {
            callback.onResult(null, t);
        }
    }

    protected abstract BsonDocument getAsWriteCommand(ByteBufferBsonOutput var1, int var2);

    protected BsonDocument getBaseCommandDocument() {
        BsonDocument baseCommandDocument = new BsonDocument(this.getCommandName(), new BsonString(this.getNamespace().getCollectionName())).append("ordered", BsonBoolean.valueOf(this.isOrdered()));
        if (!this.writeConcern.isServerDefault()) {
            baseCommandDocument.append("writeConcern", this.writeConcern.asDocument());
        }
        return baseCommandDocument;
    }

    protected abstract String getCommandName();

    private boolean shouldAcknowledge(RequestMessage.EncodingMetadata encodingMetadata) {
        return this.writeConcern.isAcknowledged() || this.isOrdered() && encodingMetadata.getNextMessage() != null;
    }

    private BsonDocument createGetLastErrorCommandDocument() {
        BsonDocument command = new BsonDocument("getlasterror", new BsonInt32(1));
        command.putAll(this.writeConcern.asDocument());
        return command;
    }

    protected abstract RequestMessage createRequestMessage(MessageSettings var1);

    protected MongoNamespace getNamespace() {
        return this.namespace;
    }

    protected boolean isOrdered() {
        return this.ordered;
    }

    protected WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    protected abstract Logger getLogger();
}

