/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.sequencing;

import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestSystem;
import org.eclipse.persistence.testing.models.sequencing.SeqTestClass1;
import org.eclipse.persistence.testing.models.sequencing.SeqTestClass2;
import org.eclipse.persistence.testing.models.sequencing.SequenceTestData;
import org.eclipse.persistence.testing.models.sequencing.TestProjectForSequenceChecking;
import org.eclipse.persistence.tools.schemaframework.DatabaseObjectDefinition;
import org.eclipse.persistence.tools.schemaframework.PopulationManager;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;

public class SequenceTestSystem
extends TestSystem {
    Project project = new TestProjectForSequenceChecking();

    public void addDescriptors(DatabaseSession session) {
        if (this.project == null) {
            this.project = new TestProjectForSequenceChecking();
        }
        session.addDescriptors(this.project);
    }

    public void createTables(DatabaseSession session) {
        SchemaManager schemaManager = new SchemaManager(session);
        schemaManager.replaceObject((DatabaseObjectDefinition)SeqTestClass1.tableDefinition());
        schemaManager.replaceObject((DatabaseObjectDefinition)SeqTestClass2.tableDefinition());
        schemaManager.createSequences();
    }

    public void populate(DatabaseSession session) {
        boolean isOracle = session.getLogin().getPlatform().isOracle();
        boolean isSqlServer = session.getLogin().getPlatform().isSQLServer();
        if (isOracle || isSqlServer) {
            PopulationManager manager = PopulationManager.getDefaultManager();
            manager.registerObject(SequenceTestData.example1(), "SequenceTestDataExample1");
            manager.registerObject(SequenceTestData.example2(), "SequenceTestDataExample2");
            manager.registerObject(SequenceTestData.example3(), "SequenceTestDataExample3");
            manager.registerObject(SequenceTestData.example4(), "SequenceTestDataExample4");
            manager.registerObject(SequenceTestData.example5(), "SequenceTestDataExample5");
            manager.registerObject(SequenceTestData.example6(), "SequenceTestDataExample6");
            UnitOfWork uow = session.acquireUnitOfWork();
            uow.registerObject(SequenceTestData.example1());
            uow.registerObject(SequenceTestData.example2());
            uow.registerObject(SequenceTestData.example3());
            uow.registerObject(SequenceTestData.example4());
            uow.registerObject(SequenceTestData.example5());
            uow.registerObject(SequenceTestData.example6());
            uow.commit();
        }
    }
}

